/*
 * Decompiled with CFR 0.152.
 */
package jplot3d.draw;

import jplot3d.JSurface;
import jplot3d.SurfaceVertex;

public class DrawEmpty {
    public static final void run(JSurface sf) {
        float zx;
        float zi;
        boolean printing = sf.printing;
        boolean plotfunc1 = sf.plotfunc1;
        boolean plotfunc2 = sf.plotfunc2;
        boolean isBoxed = sf.isBoxed;
        try {
            zi = sf.model.getZMin();
            zx = sf.model.getZMax();
            if (zi >= zx) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            return;
        }
        int plot_density = sf.model.getDispDivisions();
        int multiple_factor = sf.calc_divisions / plot_density;
        Thread.yield();
        sf.zmin = zi;
        sf.zmax = zx;
        sf.color_factor = 1.0f / (sf.zmax - sf.zmin);
        if (!printing) {
            sf.graphics.setColor(sf.getSurfaceColor().getBackgroundColor());
            sf.graphics.fillRect(0, 0, sf.getBounds().width, sf.getBounds().height);
        }
        sf.drawBoxGridsTicksLabels(sf.graphics, false);
        if (!plotfunc1 && !plotfunc2) {
            if (isBoxed) {
                sf.drawBoundingBox();
            }
            return;
        }
        sf.projector.setZRange(sf.zmin, sf.zmax);
        float distance = sf.projector.getDistance() * sf.projector.getCosElevationAngle();
        sf.cop = new SurfaceVertex(distance * sf.projector.getSinRotationAngle(), distance * sf.projector.getCosRotationAngle(), sf.projector.getDistance() * sf.projector.getSinElevationAngle());
        sf.cop.transform(sf.projector);
        sf.projector = sf.cop.getProjector();
        if (isBoxed) {
            sf.drawBoundingBox();
        }
    }
}

