/*
 * Decompiled with CFR 0.152.
 */
package jplot3d;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jhplot.F2D;
import jplot3d.JColor;
import jplot3d.JSurfacePanel;
import jplot3d.SurfaceModel;
import jplot3d.SurfaceModelCanvas;
import jplot3d.Utils;

public class OptionsDialog
extends JDialog {
    protected JSurfacePanel parentFrame;
    protected SurfaceModelCanvas sm;
    private JButton btnFontsAxes;
    private JButton btnFontsLabel;
    private final Font fdefo = new Font("SansSerif", 1, 14);
    protected JSpinner spinStepsX;
    protected JSpinner spinStepsY;
    protected JSpinner spinSurfaceBins;
    protected JSpinner spinContourBins;
    protected JSpinner spinPenWidth;
    protected JSpinner spnLabelOffsetX;
    protected JSpinner spnLabelOffsetY;
    protected JSpinner spnLabelOffsetZ;
    protected JColor surfaceColor;
    protected JColor lineColor;
    private JTabbedPane jtpMain;
    protected JTextField jtObject1;
    protected JTextField jtObject2;
    protected JTextField jtfTitle;
    protected JTextField xLabel;
    protected JTextField yLabel;
    protected JTextField zLabel;
    protected JCheckBox chkShowDelay;
    protected JColor boxColor;
    protected JColor frameColor;
    protected JCheckBox chkSurface;
    protected JCheckBox chkFill;
    protected JCheckBox chkBoxed;
    protected JCheckBox chkGrids;
    protected JCheckBox chkMesh;
    protected JCheckBox chkScaleBox;
    protected JCheckBox chkDisplayXY;
    protected JCheckBox chkDisplayZ;
    private JSpinner spinFOV;
    protected JCheckBox[] axesRange;
    protected JSpinner[] spnAxesMin;
    protected JSpinner[] spnAxesMax;
    protected JColor axesColor;
    protected JSpinner spnAxesIncr;
    protected JSpinner spnAxesTicks;
    protected JSpinner spnAxesWidth;
    protected JSlider slider;
    private float zmin;
    private float zmax;
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;
    private boolean[] showRange = new boolean[3];
    protected boolean mustDataToRegenerate = false;
    String[] items = new String[]{"spectrum", "dualshade", "fog", "opaque", "graycolor", "wireframe"};
    protected JComboBox colorMode;
    String[] items1 = new String[]{"surface", "density", "contour", "bars"};
    protected JComboBox showMode;
    private static final long serialVersionUID = 1L;

    public OptionsDialog(JSurfacePanel parentFrame) {
        this.parentFrame = parentFrame;
        this.axesRange = new JCheckBox[3];
        this.spnAxesMin = new JSpinner[3];
        this.spnAxesMax = new JSpinner[3];
        this.mustDataToRegenerate = false;
        this.jtpMain = new JTabbedPane();
        this.jtpMain.add("Functions", this.createFunctionsPane());
        this.jtpMain.add("Style", this.createGlobalPane());
        this.jtpMain.add("Axes", this.createAxisPane());
        this.jtpMain.setSelectedIndex(0);
        Box box = new Box(1);
        box.add(this.jtpMain);
        box.add(Box.createVerticalStrut(3));
        box.add(this.createDialogButtons());
        this.getContentPane().add(box);
        this.setSize(500, 400);
        this.setLocationRelativeTo(parentFrame);
    }

    public JDialog getFrame() {
        return this;
    }

    private Container createFunctionEditor() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(0, 5, 3, 5);
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.gridwidth = 0;
        this.jtObject1 = new JTextField(20);
        jpanel.add((Component)Utils.labeledComponent("Object 1:", this.jtObject1, true), gridbagconstraints);
        gridbagconstraints.gridy = 1;
        gridbagconstraints.gridwidth = 0;
        this.jtObject2 = new JTextField(20);
        jpanel.add((Component)Utils.labeledComponent("Object 2:", this.jtObject2, true), gridbagconstraints);
        this.jtObject1.setFont(this.fdefo);
        this.jtObject2.setFont(this.fdefo);
        gridbagconstraints.gridy = 3;
        gridbagconstraints.gridwidth = 1;
        this.spinStepsX = new JSpinner(new SpinnerNumberModel(30, 1, 5000, 1));
        jpanel.add((Component)Utils.labeledComponent(" H2D  X Bins:", this.spinStepsX, true), gridbagconstraints);
        this.spinStepsX.setFont(this.fdefo);
        gridbagconstraints.gridy = 3;
        gridbagconstraints.gridwidth = 2;
        this.spinStepsY = new JSpinner(new SpinnerNumberModel(30, 1, 5000, 1));
        jpanel.add((Component)Utils.labeledComponent("  H2D  Y Bins:", this.spinStepsY, true), gridbagconstraints);
        this.spinStepsY.setFont(this.fdefo);
        gridbagconstraints.gridy = 2;
        gridbagconstraints.gridwidth = 1;
        this.spinSurfaceBins = new JSpinner(new SpinnerNumberModel(30, 1, 5000, 1));
        jpanel.add((Component)Utils.labeledComponent("Surface bins:", this.spinSurfaceBins, true), gridbagconstraints);
        this.spinStepsY.setFont(this.fdefo);
        this.spinSurfaceBins.setFont(this.fdefo);
        gridbagconstraints.gridy = 2;
        gridbagconstraints.gridwidth = 2;
        this.spinContourBins = new JSpinner(new SpinnerNumberModel(30, 1, 5000, 1));
        jpanel.add((Component)Utils.labeledComponent("Contour bins:", this.spinContourBins, true), gridbagconstraints);
        this.spinContourBins.setFont(this.fdefo);
        this.spinStepsX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                OptionsDialog.this.mustDataToRegenerate = true;
            }
        });
        this.spinStepsY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                OptionsDialog.this.mustDataToRegenerate = true;
            }
        });
        this.spinSurfaceBins.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                OptionsDialog.this.mustDataToRegenerate = true;
            }
        });
        this.spinContourBins.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                OptionsDialog.this.mustDataToRegenerate = true;
            }
        });
        return jpanel;
    }

    private Container createFunctionsPane() {
        Box box = new Box(1);
        box.add(Box.createVerticalStrut(2));
        box.add(this.createFunctionEditor());
        return box;
    }

    private Container createGlobalControls() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        this.slider = new JSlider(0, 5, 30, 11);
        this.slider.setMinorTickSpacing(1);
        this.slider.setMajorTickSpacing(5);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(0, 5, 3, 5);
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.gridy = 0;
        this.jtfTitle = new JTextField();
        jpanel.add((Component)Utils.labeledComponent("Title to display:", this.jtfTitle, true), gridbagconstraints);
        this.jtfTitle.setFont(this.fdefo);
        JPanel jpanel1 = new JPanel(new GridLayout(6, 0));
        this.boxColor = new JColor(65, 20);
        jpanel1.add((Component)Utils.labeledComponent("Box color:", this.boxColor, true), gridbagconstraints);
        this.frameColor = new JColor(65, 20);
        jpanel1.add((Component)Utils.labeledComponent("Backg. color:", this.frameColor, true), gridbagconstraints);
        this.chkSurface = new JCheckBox("Surface");
        jpanel1.add((Component)this.chkSurface, gridbagconstraints);
        this.chkShowDelay = new JCheckBox("Delay regeneration");
        jpanel1.add((Component)this.chkShowDelay, gridbagconstraints);
        this.chkBoxed = new JCheckBox("Draw box");
        jpanel1.add((Component)this.chkBoxed, gridbagconstraints);
        this.chkMesh = new JCheckBox("Mesh");
        jpanel1.add((Component)this.chkMesh, gridbagconstraints);
        this.chkGrids = new JCheckBox("Draw grids");
        jpanel1.add((Component)this.chkGrids, gridbagconstraints);
        this.chkScaleBox = new JCheckBox("Scale box");
        jpanel1.add((Component)this.chkScaleBox, gridbagconstraints);
        this.chkSurface.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
                ButtonModel buttonModel = abstractButton.getModel();
                boolean selected = buttonModel.isSelected();
                if (selected) {
                    OptionsDialog.this.colorMode.setEnabled(true);
                    OptionsDialog.this.chkFill.setEnabled(false);
                }
                if (!selected) {
                    OptionsDialog.this.colorMode.setEnabled(false);
                    OptionsDialog.this.chkFill.setEnabled(true);
                }
                OptionsDialog.this.mustDataToRegenerate = true;
            }
        });
        gridbagconstraints.gridy = 2;
        gridbagconstraints.gridwidth = 1;
        this.lineColor = new JColor(50, 20);
        jpanel1.add((Component)Utils.labeledComponent("Line color:", this.lineColor, true), gridbagconstraints);
        this.colorMode = new JComboBox<String>(this.items);
        jpanel1.add(this.colorMode, gridbagconstraints);
        this.showMode = new JComboBox<String>(this.items1);
        jpanel1.add(this.showMode, gridbagconstraints);
        gridbagconstraints.gridy = 1;
        gridbagconstraints.gridwidth = 0;
        jpanel.add((Component)jpanel1, gridbagconstraints);
        this.chkFill = new JCheckBox("Fill");
        jpanel1.add((Component)this.chkFill, gridbagconstraints);
        this.surfaceColor = new JColor(50, 20);
        jpanel1.add((Component)Utils.labeledComponent("Fill color:", this.surfaceColor, true), gridbagconstraints);
        gridbagconstraints.gridy = 2;
        gridbagconstraints.gridwidth = 0;
        JLabel sliderLabel = new JLabel("Scaling", 0);
        sliderLabel.setAlignmentX(0.5f);
        jpanel1.add((Component)sliderLabel, gridbagconstraints);
        jpanel1.add((Component)this.slider, gridbagconstraints);
        jpanel.add((Component)jpanel1, gridbagconstraints);
        jpanel.setBorder(BorderFactory.createTitledBorder("Global Settings"));
        return jpanel;
    }

    private Container createGlobalPane() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        jpanel.add(this.createGlobalControls());
        return jpanel;
    }

    public double getFov() {
        return (Double)this.spinFOV.getValue();
    }

    public void setFov(double d) {
    }

    private Container createAxisExtents() {
        Box box = new Box(1);
        String[] as = new String[]{"X", "Y", "Z"};
        for (int i = 0; i < 3; ++i) {
            Box box1 = new Box(0);
            box1.add(new JLabel(as[i]));
            this.axesRange[i] = new JCheckBox();
            box1.add(this.axesRange[i]);
            box1.add(Box.createHorizontalStrut(5));
            this.spnAxesMin[i] = new JSpinner(new SpinnerNumberModel(0.0, -5000.0, 5000.0, 0.1));
            box1.add(Utils.labeledComponent("Min:", this.spnAxesMin[i], true));
            box1.add(Box.createHorizontalStrut(5));
            this.spnAxesMax[i] = new JSpinner(new SpinnerNumberModel(1.0, -5000.0, 5000.0, 0.1));
            box1.add(Utils.labeledComponent("Max:", this.spnAxesMax[i], true));
            this.spnAxesMin[i].setFont(this.fdefo);
            this.spnAxesMax[i].setFont(this.fdefo);
            box1.setAlignmentX(1.0f);
            box.add(box1);
        }
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        return box;
    }

    private Container createAxisControls() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(0, 5, 3, 5);
        gridbagconstraints.gridwidth = 1;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.fill = 2;
        this.axesColor = new JColor(50, 20);
        jpanel.add((Component)Utils.labeledComponent("Axis label color:", this.axesColor, true), gridbagconstraints);
        this.spnAxesWidth = new JSpinner(new SpinnerNumberModel(2, 1, 10, 1));
        jpanel.add((Component)Utils.labeledComponent("Line width:", this.spnAxesWidth, true), gridbagconstraints);
        this.spnAxesWidth.setFont(this.fdefo);
        this.btnFontsAxes = new JButton("Axis Font");
        jpanel.add((Component)this.btnFontsAxes, gridbagconstraints);
        gridbagconstraints.gridy = 1;
        this.chkDisplayXY = new JCheckBox("Display XY");
        jpanel.add((Component)this.chkDisplayXY, gridbagconstraints);
        this.chkDisplayZ = new JCheckBox("DisplayZ");
        jpanel.add((Component)this.chkDisplayZ, gridbagconstraints);
        this.btnFontsLabel = new JButton("Label Font");
        jpanel.add((Component)this.btnFontsLabel, gridbagconstraints);
        gridbagconstraints.gridy = 2;
        gridbagconstraints.gridwidth = 0;
        jpanel.add((Component)this.createAxisExtents(), gridbagconstraints);
        gridbagconstraints.gridy = 3;
        gridbagconstraints.gridwidth = 0;
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = new JPanel();
        this.xLabel = new JTextField(20);
        p1.add(Utils.labeledComponent("X label:", this.xLabel, true));
        this.spnLabelOffsetX = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.01));
        p1.add(Utils.labeledComponent("Offset:", this.spnLabelOffsetX, true));
        this.yLabel = new JTextField(20);
        p2.add(Utils.labeledComponent("Y label:", this.yLabel, true));
        this.spnLabelOffsetY = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.01));
        p2.add(Utils.labeledComponent("Offset:", this.spnLabelOffsetY, true));
        this.zLabel = new JTextField(20);
        p3.add(Utils.labeledComponent("Z label:", this.zLabel, true));
        this.spnLabelOffsetZ = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.01));
        p3.add(Utils.labeledComponent("Offset:", this.spnLabelOffsetZ, true));
        gridbagconstraints.gridy = 3;
        gridbagconstraints.gridwidth = 0;
        jpanel.add((Component)p1, gridbagconstraints);
        gridbagconstraints.gridy = 4;
        gridbagconstraints.gridwidth = 0;
        jpanel.add((Component)p2, gridbagconstraints);
        gridbagconstraints.gridy = 5;
        gridbagconstraints.gridwidth = 0;
        jpanel.add((Component)p3, gridbagconstraints);
        this.xLabel.setFont(this.fdefo);
        this.yLabel.setFont(this.fdefo);
        this.zLabel.setFont(this.fdefo);
        this.spnLabelOffsetX.setFont(this.fdefo);
        this.spnLabelOffsetY.setFont(this.fdefo);
        this.spnLabelOffsetZ.setFont(this.fdefo);
        this.btnFontsAxes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
            }
        });
        this.btnFontsLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
            }
        });
        jpanel.setBorder(BorderFactory.createTitledBorder("Axis Settings"));
        return jpanel;
    }

    private Container createAxisPane() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        jpanel.add(this.createAxisControls());
        return jpanel;
    }

    private Container createDialogButtons() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.anchor = 22;
        gridbagconstraints.fill = 2;
        gridbagconstraints.weightx = 5.0;
        jpanel.add((Component)new JPanel(), gridbagconstraints);
        gridbagconstraints.weightx = 0.0;
        gridbagconstraints.insets = new Insets(0, 2, 0, 2);
        JButton jbutton = new JButton("Redraw");
        jpanel.add((Component)jbutton, gridbagconstraints);
        jbutton.setMnemonic('R');
        JButton jbutton1 = new JButton("Close");
        jpanel.add((Component)jbutton1, gridbagconstraints);
        jbutton1.setMnemonic('C');
        jbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.setAllFields();
                OptionsDialog.this.parentFrame.evaluate();
            }
        });
        jbutton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.setVisible(false);
                OptionsDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(jbutton1);
        jpanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, jbutton1.getHeight()));
        return jpanel;
    }

    private void setAllFields() {
        this.sm = this.parentFrame.getModel();
        if (this.chkSurface.isSelected()) {
            this.sm.setPlotType(SurfaceModel.PlotType.SURFACE);
        } else {
            this.sm.setPlotType(SurfaceModel.PlotType.CONTOUR);
        }
        int jj = (Integer)this.spinStepsX.getValue();
        this.sm.setCalcDivisions(jj);
        jj = (Integer)this.spinStepsY.getValue();
        this.sm.setCalcDivisions(jj);
        jj = (Integer)this.spinSurfaceBins.getValue();
        this.sm.setDispDivisions(jj);
        jj = (Integer)this.spinContourBins.getValue();
        this.sm.setContourLines(jj);
        if (this.chkGrids.isSelected()) {
            this.sm.setDisplayGrids(true);
        } else {
            this.sm.setDisplayGrids(false);
        }
        if (this.chkDisplayXY.isSelected()) {
            this.sm.setDisplayXY(true);
        } else {
            this.sm.setDisplayXY(false);
        }
        if (this.chkDisplayZ.isSelected()) {
            this.sm.setDisplayZ(true);
        } else {
            this.sm.setDisplayZ(false);
        }
        if (this.chkMesh.isSelected()) {
            this.sm.setMesh(true);
        } else {
            this.sm.setMesh(false);
        }
        if (this.chkBoxed.isSelected()) {
            this.sm.setBoxed(true);
        } else {
            this.sm.setBoxed(false);
        }
        if (this.xLabel.getText() != null && this.xLabel.getText().length() > 0) {
            this.sm.setXlabel(this.xLabel.getText());
        }
        if (this.yLabel.getText() != null && this.yLabel.getText().length() > 0) {
            this.sm.setYlabel(this.yLabel.getText());
        }
        if (this.zLabel.getText() != null && this.zLabel.getText().length() > 0) {
            this.sm.setYlabel(this.zLabel.getText());
        }
        if (this.chkShowDelay.isSelected()) {
            this.sm.setExpectDelay(true);
        } else {
            this.sm.setExpectDelay(false);
        }
        if (this.showMode.getSelectedIndex() == 0) {
            this.sm.setPlotType(SurfaceModel.PlotType.SURFACE);
        } else if (this.showMode.getSelectedIndex() == 1) {
            this.sm.setPlotType(SurfaceModel.PlotType.DENSITY);
        } else if (this.showMode.getSelectedIndex() == 2) {
            this.sm.setPlotType(SurfaceModel.PlotType.CONTOUR);
        } else if (this.showMode.getSelectedIndex() == 3) {
            this.sm.setPlotType(SurfaceModel.PlotType.BARS);
        }
        if (this.colorMode.getSelectedIndex() == 0) {
            this.sm.setPlotColor(SurfaceModel.PlotColor.SPECTRUM);
        } else if (this.colorMode.getSelectedIndex() == 1) {
            this.sm.setPlotColor(SurfaceModel.PlotColor.DUALSHADE);
        } else if (this.colorMode.getSelectedIndex() == 2) {
            this.sm.setPlotColor(SurfaceModel.PlotColor.FOG);
        } else if (this.colorMode.getSelectedIndex() == 3) {
            this.sm.setPlotColor(SurfaceModel.PlotColor.OPAQUE);
        } else if (this.colorMode.getSelectedIndex() == 4) {
            this.sm.setPlotColor(SurfaceModel.PlotColor.GRAYSCALE);
        } else if (this.colorMode.getSelectedIndex() == 5) {
            this.sm.setPlotType(SurfaceModel.PlotType.WIREFRAME);
        }
        this.getRangesFromGUI();
        this.sm.setXMax(this.xmax);
        this.sm.setXMin(this.xmin);
        this.sm.setYMax(this.ymax);
        this.sm.setYMin(this.ymin);
        this.sm.setZMax(this.zmax);
        this.sm.setZMin(this.zmin);
        this.sm.getColorModel().setBoxColor(this.boxColor.getColor());
        this.sm.getColorModel().setBackgroundColor(this.frameColor.getColor());
        this.sm.getColorModel().setLineBoxColor(this.axesColor.getColor());
        this.sm.getColorModel().setFillColor(this.surfaceColor.getColor());
        this.sm.getColorModel().setLineColor(this.lineColor.getColor());
        jj = (Integer)this.spinStepsX.getValue();
        this.sm.setCalcDivisions(jj);
        jj = (Integer)this.spinSurfaceBins.getValue();
        this.sm.setDispDivisions(jj);
        jj = (Integer)this.spinContourBins.getValue();
        this.sm.setContourLines(jj);
        this.sm.set2DScaling(this.slider.getValue());
        this.sm.setInitScaling(this.slider.getValue());
        this.getFunctions();
    }

    public void setGUI() {
        this.sm = this.parentFrame.getModel();
        ArrayList<F2D> func = this.parentFrame.getF2D();
        if (func.size() > 0) {
            this.jtObject1.setText(func.get(0).getName());
        }
        if (func.size() > 1) {
            this.jtObject2.setText(func.get(1).getName());
        }
        if (this.sm.isDisplayGrids()) {
            this.chkGrids.setSelected(true);
        } else {
            this.chkGrids.setSelected(false);
        }
        if (this.sm.getDisplayXY()) {
            this.chkDisplayXY.setSelected(true);
        } else {
            this.chkDisplayXY.setSelected(false);
        }
        if (this.sm.getDisplayZ()) {
            this.chkDisplayZ.setSelected(true);
        } else {
            this.chkDisplayZ.setSelected(false);
        }
        if (this.sm.getXlabel() != null) {
            this.xLabel.setText(this.sm.getXlabel());
        }
        if (this.sm.getYlabel() != null) {
            this.yLabel.setText(this.sm.getYlabel());
        }
        if (this.sm.getZlabel() != null) {
            this.zLabel.setText(this.sm.getZlabel());
        }
        if (this.sm.isMesh()) {
            this.chkMesh.setSelected(true);
        } else {
            this.chkMesh.setSelected(false);
        }
        if (this.sm.isBoxed()) {
            this.chkBoxed.setSelected(true);
        } else {
            this.chkBoxed.setSelected(false);
        }
        if (this.sm.isExpectDelay()) {
            this.chkShowDelay.setSelected(true);
        }
        if (!this.sm.isExpectDelay()) {
            this.chkShowDelay.setSelected(false);
        }
        this.showMode.setSelectedIndex(0);
        if (this.sm.isDensityType()) {
            this.showMode.setSelectedIndex(1);
        }
        if (this.sm.isContourType()) {
            this.showMode.setSelectedIndex(2);
        }
        if (this.sm.isBarsType()) {
            this.showMode.setSelectedIndex(3);
        }
        if (this.sm.isWireframeType()) {
            this.chkFill.setSelected(false);
        } else {
            this.chkFill.setSelected(true);
        }
        if (this.sm.getPlotColor() == SurfaceModel.PlotColor.SPECTRUM) {
            this.colorMode.setSelectedIndex(0);
        } else if (this.sm.getPlotColor() == SurfaceModel.PlotColor.DUALSHADE) {
            this.showMode.setSelectedIndex(1);
        } else if (this.sm.getPlotColor() == SurfaceModel.PlotColor.FOG) {
            this.showMode.setSelectedIndex(2);
        } else if (this.sm.getPlotColor() == SurfaceModel.PlotColor.OPAQUE) {
            this.showMode.setSelectedIndex(3);
        } else if (this.sm.getPlotColor() == SurfaceModel.PlotColor.GRAYSCALE) {
            this.showMode.setSelectedIndex(4);
        } else if (this.sm.getPlotType() == SurfaceModel.PlotType.WIREFRAME) {
            this.showMode.setSelectedIndex(5);
        }
        this.xmin = this.sm.getXMin();
        this.xmax = this.sm.getXMax();
        this.ymin = this.sm.getYMin();
        this.ymax = this.sm.getYMax();
        this.zmin = this.sm.getZMin();
        this.zmax = this.sm.getZMax();
        this.spnAxesMin[0].setValue(new Double(this.xmin));
        this.spnAxesMax[0].setValue(new Double(this.xmax));
        if (this.showRange[0]) {
            this.axesRange[0].setSelected(true);
        }
        if (!this.showRange[0]) {
            this.axesRange[0].setSelected(false);
        }
        this.spnAxesMin[1].setValue(new Double(this.ymin));
        this.spnAxesMax[1].setValue(new Double(this.ymax));
        if (this.showRange[1]) {
            this.axesRange[1].setSelected(true);
        }
        if (!this.showRange[1]) {
            this.axesRange[1].setSelected(false);
        }
        this.spnAxesMin[2].setValue(new Double(this.zmin));
        this.spnAxesMax[2].setValue(new Double(this.zmax));
        if (this.showRange[2]) {
            this.axesRange[2].setSelected(true);
        }
        if (!this.showRange[2]) {
            this.axesRange[2].setSelected(false);
        }
        this.frameColor.setColor(this.sm.getColorModel().getBackgroundColor());
        this.boxColor.setColor(this.sm.getColorModel().getBoxColor());
        this.surfaceColor.setColor(this.sm.getColorModel().getFirstPolygonColor(0.0f));
        this.lineColor.setColor(this.sm.getColorModel().getLineColor());
        this.axesColor.setColor(this.sm.getColorModel().getLineBoxColor());
        this.spinStepsX.setValue(new Integer(this.sm.getCalcDivisions()));
        this.spinStepsY.setValue(new Integer(this.sm.getCalcDivisions()));
        this.spinSurfaceBins.setValue(new Integer(this.sm.getDispDivisions()));
        this.spinContourBins.setValue(new Integer(this.sm.getContourLines()));
        this.slider.setValue((int)this.sm.get2DScaling());
    }

    private void getRangesFromGUI() {
        double d = 0.0;
        d = (Double)this.spnAxesMin[0].getValue();
        this.xmin = (float)d;
        d = (Double)this.spnAxesMax[0].getValue();
        this.xmax = (float)d;
        d = (Double)this.spnAxesMin[1].getValue();
        this.ymin = (float)d;
        d = (Double)this.spnAxesMax[1].getValue();
        this.ymax = (float)d;
        d = (Double)this.spnAxesMin[2].getValue();
        this.zmin = (float)d;
        d = (Double)this.spnAxesMax[2].getValue();
        this.zmax = (float)d;
    }

    public void getFunctions() {
        this.getRangesFromGUI();
        String name1 = this.jtObject1.getText();
        String name2 = this.jtObject2.getText();
        name1 = name1.trim();
        name2 = name2.trim();
        this.parentFrame.clearF2D();
        if (name1 != null && name1.length() > 1 && name1.indexOf("H2D") < 0 && name1.indexOf("P2D") < 0 && name1.indexOf("P3D") < 0) {
            F2D fu1 = new F2D(name1, (double)this.xmin, (double)this.xmax, (double)this.ymin, (double)this.ymax);
            this.parentFrame.setF2D(fu1);
            this.sm.setPlotFunction2(false);
        }
        if (name2 != null && name2.length() > 1 && name2.indexOf("H2D") < 0 && name2.indexOf("P2D") < 0 && name2.indexOf("P3D") < 0) {
            F2D fu2 = new F2D(name2, (double)this.xmin, (double)this.xmax, (double)this.ymin, (double)this.ymax);
            this.parentFrame.setF2D(fu2);
            this.sm.setPlotFunction2(true);
        }
    }
}

