/*
 * Decompiled with CFR 0.152.
 */
package jplot.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

class PanelSeeOption
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected Dimension soptionSize;
    protected Dimension numSOption;
    protected Dimension gap;
    protected int Ns;
    Color[] lowerLeftLineColor;
    Color[] upperRightLineColor;
    protected int width;
    protected int height;

    public PanelSeeOption(int selectedIndex) {
        this.initValues();
        this.Ns = this.numSOption.width * this.numSOption.height;
        this.setToolTipText("");
        this.setOpaque(true);
        this.gap = new Dimension(2, 2);
        this.lowerLeftLineColor = new Color[this.Ns];
        this.upperRightLineColor = new Color[this.Ns];
        this.setRequestFocusEnabled(false);
        this.resetBackgrounds();
        if (selectedIndex >= 0) {
            this.lowerLeftLineColor[selectedIndex] = Color.white;
            this.upperRightLineColor[selectedIndex] = Color.black;
        }
        this.width = this.numSOption.width * (this.soptionSize.width + this.gap.width) - 1;
        this.height = this.numSOption.height * (this.soptionSize.height + this.gap.height) - 1;
    }

    public PanelSeeOption() {
        this(0);
    }

    protected void initValues() {
        this.soptionSize = new Dimension(1, 1);
        this.numSOption = new Dimension(1, 1);
    }

    protected void resetBackgrounds() {
        for (int i = 0; i < this.Ns; ++i) {
            this.lowerLeftLineColor[i] = Color.black;
            this.upperRightLineColor[i] = Color.white;
        }
    }

    protected void setSelectedSwatch(int index) {
        for (int i = 0; i < this.Ns; ++i) {
            this.lowerLeftLineColor[i] = Color.black;
            this.upperRightLineColor[i] = Color.white;
        }
        if (index >= 0) {
            this.lowerLeftLineColor[index] = Color.white;
            this.upperRightLineColor[index] = Color.black;
        }
        this.repaint();
    }

    protected void paintIt(Graphics2D g2, int column, int row, int x, int y) {
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.Ns == 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int row = 0; row < this.numSOption.height; ++row) {
            for (int column = 0; column < this.numSOption.width; ++column) {
                int x = column * (this.soptionSize.width + this.gap.width);
                int y = row * (this.soptionSize.height + this.gap.height);
                int index = row * this.numSOption.width + column;
                this.paintIt(g2, column, row, x, y);
                g2.setColor(this.lowerLeftLineColor[index]);
                g2.drawLine(x + this.soptionSize.width - 1, y, x + this.soptionSize.width - 1, y + this.soptionSize.height - 1);
                g2.drawLine(x, y + this.soptionSize.height - 1, x + this.soptionSize.width - 1, y + this.soptionSize.height - 1);
                g2.setColor(this.upperRightLineColor[index]);
                g2.drawLine(x, y, x + this.soptionSize.width - 1, y);
                g2.drawLine(x, y, x, y + this.soptionSize.height - 1);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getIndex(int x, int y) {
        return this.getRow(y) * this.numSOption.width + this.getColumn(x);
    }

    public int getColumn(int x) {
        return x / (this.soptionSize.width + this.gap.width);
    }

    public int getRow(int y) {
        return y / (this.soptionSize.height + this.gap.height);
    }
}

