/*
 * Decompiled with CFR 0.152.
 */
package jplot.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jplot.GraphSettings;
import jplot.JPlot;
import jplot.LinePars;
import jplot.LineStyle;
import jplot.panels.PanelColor;
import jplot.panels.PanelGridUI;

public class PanelGrid
extends PanelGridUI {
    private static final long serialVersionUID = 1L;
    private JDialog dialog;
    private JCheckBox cb_hg;
    private JCheckBox cb_vg;
    private JButton b_color;
    private Color actualColor;
    private PanelColor colorPanel;
    private LineStyle lineStyle;
    private JPanel stylePanel;
    private GraphSettings gs;
    private JPlot jplot;

    public PanelGrid(JPlot jp, GraphSettings gs) {
        this.gs = gs;
        this.dialog = null;
        this.colorPanel = new PanelColor(this.jplot.frame);
        this.actualColor = gs.getGridColor();
        this.jplot = jp;
        EmptyBorder border = new EmptyBorder(new Insets(0, 0, 0, 10));
        Dimension cbField = new Dimension(110, 24);
        this.cb_hg = new JCheckBox("Horizontal", gs.drawGrid(1));
        this.cb_vg = new JCheckBox("Vertical", gs.drawGrid(0));
        this.lineStyle = new LineStyle(new LinePars());
        this.lineStyle.setColor(this.actualColor);
        this.b_color = new JButton(new ImageIcon("color.jpg"));
        this.b_color.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = PanelGrid.this.colorPanel.show(((PanelGrid)PanelGrid.this).jplot.frame, PanelGrid.this.actualColor, 100, 100);
                if (color != null) {
                    PanelGrid.this.actualColor = color;
                    PanelGrid.this.lineStyle.setColor(PanelGrid.this.actualColor);
                    PanelGrid.this.lineStyle.repaint();
                }
            }
        });
        this.b_color.setMargin(new Insets(0, 0, 0, 0));
        this.b_color.setToolTipText("Gridline color");
        this.stylePanel = new JPanel(new FlowLayout());
        this.stylePanel.add(this.lineStyle);
        this.stylePanel.add(this.b_color);
        JLabel label = new JLabel("Gridlines:");
        label.setBorder(border);
        this.addComponent(label, 1, 1);
        this.addComponent(this.cb_hg, 1, 2);
        this.addComponent(this.cb_vg, 1, 3);
        label = new JLabel("Gridcolor:");
        label.setBorder(border);
        this.addComponent(label, 2, 1);
        this.addComponent(this.stylePanel, 2, 2);
    }

    public void refresh(GraphSettings gp) {
        this.cb_hg.setSelected(this.gs.drawGrid(1));
        this.cb_vg.setSelected(this.gs.drawGrid(0));
    }

    public void setValues(GraphSettings gp) {
        this.gs.setGridColor(this.actualColor);
        this.gs.setDrawGrid(0, this.cb_vg.isSelected());
        this.gs.setDrawGrid(1, this.cb_hg.isSelected());
    }

    public void show(Frame parent, int x, int y) {
        if (this.dialog == null) {
            this.dialog = new JDialog(parent, "Labels", true);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PanelGrid.this.dialog.dispose();
                }
            });
            this.dialog.getContentPane().add(this);
            this.dialog.setLocation(x, y);
            this.dialog.pack();
        }
        this.dialog.setVisible(true);
    }
}

