/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Enumeration;
import java.util.Vector;
import jplot.Utils;

public class PrintTextPainter
implements Printable {
    private String text;
    private Font fnt = new Font("Monospaced", 0, 10);
    private Color color = Color.black;
    private int rememberedPageIndex = -1;
    private boolean endOfText = false;
    private Vector<String> lines;
    private int size = 12;
    private Enumeration e;

    public PrintTextPainter(String txt) {
        this.text = txt;
        this.lines = new Vector();
        if (this.text != null && !this.text.equals("")) {
            this.makeLines();
        } else {
            this.endOfText = true;
        }
    }

    public void setFont(Font f) {
        this.fnt = f;
        this.size = this.fnt.getSize() + 2;
    }

    public void setForeground(Color c) {
        this.color = c;
    }

    private void makeLines() {
        char lf = Utils.lf.charAt(0);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == lf) {
                this.lines.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            sb.append(c);
        }
        this.e = this.lines.elements();
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        try {
            if (pageIndex != this.rememberedPageIndex) {
                this.rememberedPageIndex = pageIndex;
                if (this.endOfText) {
                    return 1;
                }
            } else {
                this.e = this.lines.elements();
            }
            g.setColor(this.color);
            g.setFont(this.fnt);
            int x = (int)pf.getImageableX();
            int y = (int)pf.getImageableY();
            y += 36;
            while ((double)(y + this.size) < pf.getImageableY() + pf.getImageableHeight()) {
                if (!this.e.hasMoreElements()) {
                    this.endOfText = true;
                    break;
                }
                String line = (String)this.e.nextElement();
                g.drawString(line, x, y);
                y += this.size;
            }
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }
}

