/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import jhplot.JHPlot;
import jplot.DataArray;
import jplot.GraphLabel;
import jplot.GraphSettings;
import jplot.JPlot;
import jplot.LinePars;
import jplot.Utils;
import jplot.XMLRead;
import jplot.XMLWrite;

public class DataFile {
    private File file;
    private DataArray data;
    private Vector items;
    private Vector columns;
    private int xColumn;
    private Vector styles;
    private String abbreviatedFilename;
    private String filenameWithoutPath;
    private final int maxLen = 45;
    private int index;
    private int graphType;
    private long lastModified;
    private GraphSettings gs;

    DataFile(File file, int index, GraphSettings gs) {
        this.file = file;
        this.index = index;
        this.gs = gs;
        this.lastModified = 0L;
        if (JHPlot.ReadFile) {
            this.lastModified = file.lastModified();
        }
        this.columns = new Vector();
        this.styles = new Vector();
        this.items = new Vector();
        this.graphType = 0;
        int len = 0;
        this.abbreviatedFilename = this.data.getName();
        this.filenameWithoutPath = this.data.getName();
        if (JHPlot.ReadFile) {
            len = file.toString().length();
            this.abbreviatedFilename = len > 45 ? "..." + file.toString().substring(len - 45, len) : file.toString();
            int i = this.abbreviatedFilename.lastIndexOf(JPlot.FS, 0);
            len = this.abbreviatedFilename.length();
            this.filenameWithoutPath = i > -1 ? this.abbreviatedFilename.substring(i, len) : this.abbreviatedFilename;
        }
        this.loadColumnNames(gs.getLabels());
    }

    DataFile(DataArray data, int index, GraphSettings gs) {
        this.data = data;
        this.index = index;
        this.gs = gs;
        this.lastModified = 0L;
        this.columns = new Vector();
        this.styles = new Vector();
        this.items = new Vector();
        this.graphType = 0;
        int len = 0;
        this.abbreviatedFilename = data.getName();
        this.filenameWithoutPath = data.getName();
        int i = this.abbreviatedFilename.lastIndexOf(JPlot.FS, 0);
        len = this.abbreviatedFilename.length();
        if (i > -1) {
            this.filenameWithoutPath = this.abbreviatedFilename.substring(i, len);
        }
        this.loadColumnNames(gs.getLabels());
    }

    public boolean loadColumnNamesData(Vector labels) {
        boolean res = true;
        Vector newItems = new Vector();
        this.graphType = 0;
        DataArray lp = this.data;
        this.addItem(this.data.getName());
        this.addColumn(0, lp);
        this.addColumn(1, lp);
        this.setLinePars(0, lp);
        this.setLinePars(1, lp);
        this.setXColumn(0);
        Vector<GraphLabel> newLabels = new Vector<GraphLabel>();
        Enumeration e = labels.elements();
        while (e.hasMoreElements()) {
            GraphLabel g = (GraphLabel)e.nextElement();
            if (g.equals(9)) {
                g.setID(11);
            }
            newLabels.add(g);
        }
        GraphLabel gl1 = new GraphLabel(0, "X");
        this.addLabel(gl1, newLabels);
        GraphLabel gl2 = new GraphLabel(1, this.data.getName());
        gl2.setRotation(4.71238898038469);
        this.addLabel(gl2, newLabels);
        return res;
    }

    public boolean loadColumnNames(Vector labels) {
        GraphLabel g;
        boolean res = false;
        Vector<String> newItems = new Vector<String>();
        Vector<GraphLabel> newLabels = new Vector<GraphLabel>();
        Enumeration e = labels.elements();
        while (e.hasMoreElements()) {
            g = (GraphLabel)e.nextElement();
            if (g.equals(9) && g.getFile() == this.file) {
                g.setID(11);
            }
            newLabels.add(g);
        }
        try {
            String s;
            String mess = "# column 1: " + this.data.getNameX() + "\n# column 2: " + this.data.getNameY();
            mess = mess + "\n dataset : " + this.data.getName();
            mess = mess + "\n xlabel : " + this.data.getNameX();
            mess = mess + "\n ylabel : " + this.data.getNameY();
            mess = mess + "\n";
            StringReader fakefile = new StringReader(mess);
            BufferedReader in = new BufferedReader(fakefile);
            if (JHPlot.ReadFile) {
                in = new BufferedReader(new FileReader(this.file));
            }
            int k = 1;
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).length() == 0) continue;
                StringTokenizer st = new StringTokenizer(s, " \t,:");
                String token = st.nextToken();
                if (token.startsWith("#")) {
                    GraphLabel gl;
                    if (!st.hasMoreTokens()) continue;
                    String nextToken = st.nextToken();
                    if (!st.hasMoreTokens()) continue;
                    if (nextToken.startsWith("graph")) {
                        token = st.nextToken();
                        if (token.startsWith("piper")) {
                            this.graphType = 1;
                            continue;
                        }
                        if (token.startsWith("multi")) {
                            this.graphType = 2;
                            this.gs.setDrawLegend(false);
                            continue;
                        }
                        this.graphType = 0;
                        continue;
                    }
                    if (nextToken.equals("column") || nextToken.equals("row")) {
                        st.nextToken();
                        token = st.nextToken();
                        while (st.hasMoreTokens()) {
                            token = token + " " + st.nextToken();
                        }
                        newItems.addElement(token);
                        continue;
                    }
                    if (nextToken.equals("dataset")) {
                        st.nextToken();
                        token = this.getLabel(st);
                        newItems.addElement(token);
                        continue;
                    }
                    if (nextToken.startsWith("xlabel") && st.hasMoreTokens()) {
                        gl = new GraphLabel(0, this.getLabel(st));
                        this.addLabel(gl, newLabels);
                        continue;
                    }
                    if (nextToken.startsWith("ylabel") && st.hasMoreTokens()) {
                        gl = new GraphLabel(1, this.getLabel(st));
                        gl.setRotation(4.71238898038469);
                        this.addLabel(gl, newLabels);
                        continue;
                    }
                    if (!nextToken.startsWith("label") || !st.hasMoreTokens()) continue;
                    gl = new GraphLabel(9, this.getLabel(st));
                    gl.setFile(this.file);
                    if (st.hasMoreTokens()) {
                        double xx = Double.parseDouble(st.nextToken());
                        if (st.hasMoreTokens()) {
                            double yy = Double.parseDouble(st.nextToken());
                            gl.setDataLocation(xx, yy);
                            if (st.hasMoreTokens()) {
                                gl.setDataRotation(Math.PI * Double.parseDouble(st.nextToken()) / 180.0);
                            }
                        } else {
                            gl.setRotation(Math.PI * xx / 180.0);
                        }
                    }
                    this.addLabel(gl, newLabels);
                    continue;
                }
                if (newItems.size() != 0) continue;
                newItems.addElement("column " + Integer.toString(k++));
                while (st.hasMoreTokens() && !(token = st.nextToken()).startsWith("*")) {
                    newItems.addElement("column " + Integer.toString(k++));
                }
                break block3;
            }
            in.close();
        }
        catch (Exception e3) {
            Utils.oops(null, "Something's wrong with file '" + this.getName() + "'!");
            return false;
        }
        if (this.items.size() > 0) {
            if (this.items.size() == newItems.size()) {
                res = true;
                Enumeration e1 = this.items.elements();
                Enumeration e2 = newItems.elements();
                while (e1.hasMoreElements()) {
                    if (((String)e1.nextElement()).equals((String)e2.nextElement())) continue;
                    res = false;
                    break;
                }
            } else {
                res = false;
            }
        }
        this.items = newItems;
        if (!res) {
            if (this.columns.size() > 0) {
                this.columns.removeAllElements();
            }
            if (this.styles.size() > 0) {
                this.styles.removeAllElements();
            }
        }
        if (labels.size() > 0) {
            labels.removeAllElements();
        }
        if (newLabels.size() > 0) {
            e = newLabels.elements();
            while (e.hasMoreElements()) {
                g = (GraphLabel)e.nextElement();
                if (g.equals(11)) continue;
                labels.add(g);
            }
            newLabels.removeAllElements();
            newLabels = null;
        }
        return res;
    }

    private String getLabel(StringTokenizer st) {
        String token = st.nextToken();
        if (token.startsWith("\"")) {
            while (!token.endsWith("\"")) {
                token = token + " " + st.nextToken();
            }
            token = token.substring(1, token.length() - 1);
        }
        return token;
    }

    private void addLabel(GraphLabel gl, Vector labels) {
        boolean labelFound = false;
        Enumeration e = labels.elements();
        while (e.hasMoreElements()) {
            GraphLabel g = (GraphLabel)e.nextElement();
            if (!gl.equals(g.getText()) || !g.equals(11)) continue;
            g.setUsePosition(false);
            g.setDataLocation(gl.getXPos(), gl.getYPos());
            g.setID(gl.getID());
            labelFound = true;
            break;
        }
        if (!labelFound) {
            labels.add(gl);
        }
    }

    public int getNumberOfItems() {
        return this.items.size();
    }

    public String getItem(int i) {
        return (String)this.items.get(i);
    }

    public void addItem(String item) {
        this.items.add(item);
    }

    private void delCol(Integer index) {
        Integer i;
        int k = 0;
        Enumeration e = this.columns.elements();
        while (e.hasMoreElements() && !(i = (Integer)e.nextElement()).equals(index)) {
            ++k;
        }
        if (k < this.columns.size()) {
            this.columns.remove(k);
            this.styles.remove(k);
        }
    }

    public void addColumn(int columnIndex, LinePars lp) {
        Integer index = new Integer(columnIndex);
        this.columns.add(index);
        this.styles.add(lp);
    }

    public void setXColumn(int columnIndex) {
        this.xColumn = columnIndex;
    }

    public int getXColumn() {
        return this.xColumn;
    }

    public int getYColumn(int i) {
        return (Integer)this.columns.get(i);
    }

    public LinePars getLinePars(int index) {
        if (this.styles.size() == 0) {
            return new LinePars();
        }
        if (index < this.styles.size()) {
            return (LinePars)this.styles.get(index);
        }
        return (LinePars)this.styles.get(0);
    }

    public void setLinePars(int index, LinePars lp) {
        this.styles.set(index, lp);
    }

    public void setLinePars(LinePars lp) {
        if (this.styles.size() > 0) {
            this.styles.removeAllElements();
        }
        for (int k = 0; k < this.columns.size(); ++k) {
            lp = new LinePars(lp);
            if (lp.slideColor) {
                lp.nextColor(this.columns.size());
            }
            this.styles.add(lp);
        }
    }

    public String getLegend(int index) {
        return this.getLinePars(index).getName();
    }

    public void removeColumn(int columnIndex) {
        if (columnIndex < this.columns.size()) {
            this.columns.remove(columnIndex);
            this.styles.remove(columnIndex);
        }
    }

    public int getNumberOfColumns() {
        return this.columns.size();
    }

    public File getFile() {
        return this.file;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long date) {
        this.lastModified = date;
    }

    public String getAbbreviatedFilename() {
        return this.abbreviatedFilename;
    }

    public String getFilenameWithoutPath() {
        return this.filenameWithoutPath;
    }

    public String getName() {
        String s = this.data.getName();
        if (JHPlot.ReadFile) {
            s = this.file.toString();
        }
        return s;
    }

    public int isSelected(int index) {
        int k = 0;
        Enumeration e = this.columns.elements();
        while (e.hasMoreElements()) {
            if ((Integer)e.nextElement() == index) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public String getColumnName(int i) {
        int index = (Integer)this.columns.get(i);
        return (String)this.items.get(index);
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public int getGraphType() {
        return this.graphType;
    }

    public boolean fillDataArrays(Vector dataArrays, int type, int fileIndex) {
        int nCol = this.getNumberOfColumns();
        int nIts = this.getNumberOfItems();
        double x = 0.0;
        int nY = type == 1 ? nIts : nCol;
        double[] y = new double[nY];
        boolean newDataSet = true;
        boolean isFirstLabel = true;
        int currentDataset = 0;
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(this.getFile()));
            DataArray[] data = new DataArray[2 * nY];
            boolean col = false;
            int k = 0;
            block2: while ((s = in.readLine()) != null) {
                int i;
                StringTokenizer st;
                if ((s = s.trim()).length() == 0 || s.startsWith("#") || (st = new StringTokenizer(s, " \t,")).countTokens() < 2) continue;
                if (type == 0) {
                    if (newDataSet) {
                        for (i = 0; i < nCol; ++i) {
                            data[i] = new DataArray(fileIndex, i, 101, this.getLinePars(i));
                        }
                        newDataSet = false;
                    }
                    boolean liftPen = false;
                    int i2 = 0;
                    while (st.hasMoreTokens()) {
                        String t = st.nextToken();
                        if (t.startsWith("*")) {
                            liftPen = true;
                        }
                        if (i2 == this.getXColumn()) {
                            x = Double.parseDouble(t);
                        }
                        for (k = 0; k < nCol; ++k) {
                            if (this.getYColumn(k) != i2) continue;
                            y[k] = Double.parseDouble(t);
                        }
                        ++i2;
                    }
                    for (i2 = 0; i2 < nCol; ++i2) {
                        data[i2].addPoint(x, y[i2], liftPen);
                    }
                    continue;
                }
                if (type == 1) {
                    data[0] = new DataArray(fileIndex, 1, 3, this.getLinePars(k++));
                    if (st.countTokens() < 4) {
                        Utils.oops(null, "Incorrect format of Piper diagram datafile '" + this.getAbbreviatedFilename() + "'!");
                        return false;
                    }
                    data[0].addPoint(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                    data[0].addPoint(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                    if (st.hasMoreTokens()) {
                        data[0].addPoint(Double.parseDouble(st.nextToken()), 0.0);
                    }
                    dataArrays.add(data[0]);
                    continue;
                }
                if (newDataSet) {
                    data[0] = new DataArray(fileIndex, 1, 10, this.getLinePars(k));
                    newDataSet = false;
                }
                data[0].addPoint(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                while (st.hasMoreTokens()) {
                    if (!st.nextToken().equals("**")) continue;
                    for (i = 0; i < nCol; ++i) {
                        if (this.getYColumn(i) != currentDataset) continue;
                        ++k;
                        dataArrays.add(data[0]);
                    }
                    ++currentDataset;
                    newDataSet = true;
                    continue block2;
                }
            }
            if (type == 0) {
                for (int i = 0; i < nCol; ++i) {
                    dataArrays.add(data[i]);
                }
            }
            in.close();
        }
        catch (Exception exception) {
            Utils.oops(null, "Something's wrong with file '" + this.getAbbreviatedFilename() + "'.\nCheck the file's format and its content.");
            return false;
        }
        return true;
    }

    public void getSettings(XMLWrite xw, String fileName) {
        xw.add("name", fileName);
        xw.open("datafile");
        int N = this.columns.size();
        xw.add("index", String.valueOf(this.xColumn));
        xw.set("x-column");
        xw.add("number", String.valueOf(N));
        xw.set("y-columns");
        for (int i = 0; i < N; ++i) {
            xw.add("index", String.valueOf(this.columns.get(i)));
            xw.open("y" + (i + 1) + "-column");
            this.getLinePars(i).getSettings(xw);
            xw.close();
        }
        xw.close();
    }

    public void updateSettings(XMLRead xr) {
        if (this.columns.size() > 0) {
            this.columns.removeAllElements();
        }
        if (this.styles.size() > 0) {
            this.styles.removeAllElements();
        }
        this.xColumn = xr.getInt("x-column/index", this.xColumn);
        int N = xr.getInt("y-columns/number", 0);
        for (int i = 0; i < N; ++i) {
            if (!xr.open("y" + (i + 1) + "-column")) continue;
            int col = xr.getInt("index", 1);
            LinePars lp = new LinePars();
            lp.updateSettings(xr);
            this.addColumn(col, lp);
            xr.close();
        }
    }
}

