/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import graph.ParseFunction;
import graph.RTextLine;
import graph.TextLine;
import hep.aida.ref.histogram.Histogram2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import jhplot.H2D;
import jplot.PlotPoint;
import jplot.Utils;

public class Contour {
    static final int MINCELLS = 30;
    static final int NLEVELS = 12;
    protected Color GraphBackground = Color.white;
    protected Color DataBackground = Color.white;
    protected int nx;
    protected int ny;
    protected Vector[] curves;
    protected boolean autoLevels;
    protected boolean logLevels;
    protected boolean gridLimits;
    protected double[] levels;
    protected TextLine[] labels;
    protected Font labelfont;
    protected Color labelcolor;
    protected int labelStyle;
    protected int labelPrecision;
    protected int labelSignificant;
    protected int labelLevels;
    protected boolean drawlabels;
    protected boolean autoLabels;
    protected Color contourColor;
    protected Color labelledColor;
    protected double[] grid = null;
    protected double xmin = 0.0;
    protected double xmax = 0.0;
    protected double ymin = 0.0;
    protected double ymax = 0.0;
    protected double zmin = 0.0;
    protected double zmax = 0.0;
    public boolean noContours = false;
    private Histogram2D h2d = null;
    protected int n_levels;
    protected Color[] contour_color;
    protected double binWidthX;
    protected double binWidthY;
    protected double binHight;
    protected boolean showBar;
    protected boolean showGray;
    private int barWidth = 15;
    private int fullBarWidth = 2 * this.barWidth;
    public double dx;
    public double dy;
    public double dz;

    public Contour(boolean bar, int nx, int ny, boolean gray, int n_levels) {
        this.nx = nx;
        this.ny = ny;
        this.showBar = bar;
        this.showGray = gray;
        this.n_levels = n_levels;
        this.calculateColors();
        this.autoLevels = true;
        this.logLevels = false;
        this.gridLimits = false;
        this.autoLabels = true;
        this.labelfont = new Font("Helvetica", 0, 12);
        this.labelcolor = Color.blue;
        this.labelLevels = 1;
        this.labelStyle = 2;
        this.labelPrecision = 1;
        this.labelSignificant = 2;
        this.drawlabels = true;
        this.contourColor = Color.blue;
        this.labelledColor = Color.black;
        this.curves = null;
        if (this.nx <= 0 || this.ny <= 0) {
            System.out.println("Error while defining the grid!");
        }
    }

    public void setHistogram(H2D h) {
        this.h2d = h.get();
        this.nx = this.h2d.xAxis().bins();
        this.ny = this.h2d.yAxis().bins();
        this.binWidthX = this.h2d.xAxis().binWidth(0);
        this.binWidthY = this.h2d.yAxis().binWidth(0);
        this.binHight = this.h2d.maxBinHeight();
    }

    public Color findGrayColors(double zlevel) {
        int scaleValue;
        int red = scaleValue = (int)(255.0 * (1.0 - zlevel));
        int green = scaleValue;
        int blue = scaleValue;
        return new Color(red, green, blue);
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(int barWidth) {
        this.barWidth = barWidth;
    }

    public int getFullBarWidth() {
        return this.fullBarWidth;
    }

    public Color findSpectrumColors(double zlevel) {
        int n = (int)((double)this.n_levels * zlevel) - 1;
        if (n >= this.n_levels) {
            n = this.n_levels - 1;
        }
        if (n < 0) {
            n = 0;
        }
        return this.contour_color[n];
    }

    public void calculateColors() {
        this.contour_color = new Color[this.n_levels];
        for (int i = 0; i < this.n_levels; ++i) {
            float z = (float)i / (float)this.n_levels;
            if ((double)z > 1.0) {
                z = 0.999f;
            }
            if ((double)z < 0.0) {
                z = 0.0f;
            }
            this.contour_color[i] = Color.getHSBColor(z, 1.0f, 1.0f);
        }
        this.contour_color[0] = Color.white;
    }

    public double[] getGrid() {
        return this.grid;
    }

    public int[] getDim() {
        int[] i = new int[]{this.nx, this.ny};
        return i;
    }

    public void drawColorBar(Graphics2D g2, Font f, int righmargin) {
        double dyy = (this.ymax - this.ymin) / (double)this.n_levels;
        double dz = (this.zmax - this.zmin) / (double)this.n_levels;
        int bwid = this.barWidth;
        int bww = (int)(0.25 * (double)bwid);
        int hwid = (int)(Math.abs(this.ymax - this.ymin) / (double)this.n_levels) + 1;
        FontMetrics fm = g2.getFontMetrics();
        int wtext = 0;
        for (int m = 0; m < this.n_levels; ++m) {
            Rectangle r = new Rectangle((int)this.xmax + bww, (int)(this.ymin - 1.0 + dyy * (double)m + dyy), bwid, hwid);
            g2.setColor(this.contour_color[m]);
            g2.fill(r);
            g2.setColor(Color.black);
            g2.draw(r);
            String xlab = Utils.FormLin(this.zmin + dz * (double)m);
            RTextLine text = new RTextLine();
            text.setFont(f);
            text.setColor(Color.black);
            text.setText(xlab);
            text.draw(g2, (int)this.xmax + (int)(1.6 * (double)bwid), (int)(this.ymin - 1.0 + dyy * (double)m + (double)((int)(0.5 * dyy))));
            int text_width = fm.stringWidth(xlab);
            if (text_width <= wtext) continue;
            wtext = text_width;
        }
        this.fullBarWidth = wtext + bww + this.barWidth + 1;
    }

    public void drawColor(Graphics2D g2, double xmin, double xmax, double ymin, double ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        int cout = 0;
        this.dx = Math.abs(xmax - xmin) / (double)this.nx;
        this.dy = Math.abs(ymax - ymin) / (double)this.ny;
        this.dz = Math.abs(this.zmax - this.zmin);
        Rectangle r = new Rectangle();
        r.width = (int)this.dx + 1;
        r.height = (int)this.dy + 1;
        Color cold = g2.getColor();
        for (int j = 0; j < this.ny; ++j) {
            double y1 = ymin - (double)j * this.dy - (double)r.height;
            double y2 = ymin - (double)(j + 1) * this.dy - (double)r.height;
            for (int i = 0; i < this.nx; ++i) {
                double x1 = xmin + (double)i * this.dx;
                double x2 = xmin + (double)(i + 1) * this.dx;
                double z = this.grid[cout] / this.dz;
                ++cout;
                if (this.showGray) {
                    g2.setColor(this.findGrayColors(z));
                } else {
                    g2.setColor(this.findSpectrumColors(z));
                }
                r.x = (int)x1;
                r.y = (int)y1;
                g2.fillRect(r.x, r.y, r.width, r.height);
            }
        }
        g2.setColor(cold);
    }

    private void zrangeH2D() {
        if (this.h2d == null) {
            return;
        }
        this.zmin = 0.0;
        this.zmax = this.h2d.maxBinHeight();
        if (this.zmin == this.zmax) {
            System.out.println("Cannot produce contours of a constant surface!");
        }
        this.dz = this.zmax - this.zmin;
    }

    private void zrange() {
        this.zmin = this.grid[0];
        this.zmax = this.grid[1];
        for (int i = 0; i < this.grid.length; ++i) {
            this.zmin = Math.min(this.zmin, this.grid[i]);
            this.zmax = Math.max(this.zmax, this.grid[i]);
        }
        if (this.zmin == this.zmax) {
            // empty if block
        }
        this.dz = this.zmax - this.zmin;
    }

    public void createGrid(String f, double xmin, double xmax, double ymin, double ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymax = ymax;
        this.ymin = ymin;
        this.dx = Math.abs(xmax - xmin) / (double)(this.nx - 1);
        this.dy = Math.abs(ymax - ymin) / (double)(this.ny - 1);
        ParseFunction function = new ParseFunction(f);
        if (!function.parse()) {
            System.out.println("Failed to parse function!");
            return;
        }
        this.grid = new double[this.nx * this.ny];
        boolean error = false;
        int count = 0;
        for (int j = 0; j < this.ny; ++j) {
            double y = ymin + (double)j * this.dy;
            for (int i = 0; i < this.nx; ++i) {
                double x = xmin + (double)i * this.dx;
                try {
                    this.grid[count++] = function.getResult(x, y);
                    continue;
                }
                catch (Exception e) {
                    this.grid[count++] = 0.0;
                    error = true;
                }
            }
        }
        if (error) {
            System.out.println("Error while calculating points!");
            return;
        }
        this.zrange();
        this.setRange(xmin, xmax, ymin, ymax);
        this.setLimitsToGrid(true);
        this.setLabelLevels(3);
    }

    public void createGrid(Vector<PlotPoint> points, double xmin, double xmax, double ymin, double ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymax = ymax;
        this.ymin = ymin;
        this.grid = new double[this.nx * this.ny];
        int count = 0;
        this.dx = Math.abs(xmax - xmin) / (double)this.nx;
        this.dy = Math.abs(ymax - ymin) / (double)this.ny;
        ymin = Math.min(ymin, ymax);
        xmin = Math.min(xmin, xmax);
        for (int j = 0; j < this.ny; ++j) {
            double y1 = ymin + (double)j * this.dy;
            double y2 = ymin + (double)(j + 1) * this.dy;
            for (int i = 0; i < this.nx; ++i) {
                double x1 = xmin + (double)i * this.dx;
                double x2 = xmin + (double)(i + 1) * this.dx;
                int con = 0;
                int k = 0;
                Enumeration<PlotPoint> e2 = points.elements();
                while (e2.hasMoreElements()) {
                    PlotPoint pp = e2.nextElement();
                    if (pp.getX() > x1 && pp.getX() < x2 && pp.getY() > y1 && pp.getY() < y2) {
                        ++con;
                    }
                    ++k;
                }
                this.grid[count] = con;
                ++count;
            }
        }
        this.zrange();
    }

    public void createGrid(double xmi, double xma, double ymi, double yma) {
        if (this.h2d == null) {
            return;
        }
        double Xmin = xmi;
        double Xmax = xma;
        double Ymax = yma;
        double Ymin = ymi;
        this.grid = new double[this.nx * this.ny];
        int count = 0;
        this.dx = Math.abs(Xmax - Xmin) / (double)this.nx;
        this.dy = Math.abs(Ymax - Ymin) / (double)this.ny;
        Ymin = Math.min(Ymin, Ymax);
        Xmin = Math.min(Xmin, Xmax);
        for (int j = 0; j < this.ny; ++j) {
            double y1 = Ymin + (double)j * this.dy;
            double y2 = Ymin + (double)(j + 1) * this.dy;
            double yb = this.h2d.yAxis().binCenter(j);
            for (int i = 0; i < this.nx; ++i) {
                double x1 = Xmin + (double)i * this.dx;
                double x2 = Xmin + (double)(i + 1) * this.dx;
                double xb = this.h2d.xAxis().binCenter(i);
                this.grid[count] = yb > y1 && yb < y2 && xb > x1 && xb < x2 ? this.h2d.binHeight(i + 1, j + 1) : 0.0;
                ++count;
            }
        }
        this.zrange();
    }

    public void setGraphBackground(Color c) {
        if (c == null) {
            return;
        }
        this.GraphBackground = c;
    }

    public void setDataBackground(Color c) {
        if (c == null) {
            return;
        }
        this.DataBackground = c;
    }

    public void setNLevels(int l) {
        if (l <= 0) {
            return;
        }
        this.n_levels = l;
        this.calculateColors();
        this.levels = new double[l];
        this.calcLevels();
        this.curves = null;
    }

    public void setLimitsToGrid(boolean b) {
        this.gridLimits = b;
    }

    public void setLabelLevels(int i) {
        this.labelLevels = i <= 0 ? 0 : i;
    }

    private void calcLevels() {
        if (!this.autoLevels) {
            return;
        }
        if (this.levels == null) {
            this.levels = new double[12];
        }
        this.labels = new TextLine[this.levels.length];
        if (this.logLevels) {
            double inc = Math.log(this.zmax - this.zmin) / (double)(this.levels.length + 1);
            try {
                for (int i = 0; i < this.levels.length; ++i) {
                    this.levels[i] = this.zmin + Math.pow(Math.E, (double)(i + 1) * inc);
                }
            }
            catch (Exception e) {
                System.out.println("Error calculateing Log levels!");
                System.out.println("... calculating linear levels instead");
                this.logLevels = false;
                this.calcLevels();
            }
        } else {
            double inc = (this.zmax - this.zmin) / (double)(this.levels.length + 1);
            for (int i = 0; i < this.levels.length; ++i) {
                this.levels[i] = this.zmin + (double)(i + 1) * inc;
            }
        }
    }

    private void setRange(double xmin, double xmax, double ymin, double ymax) {
        if (xmin >= xmax || ymin >= ymax) {
            return;
        }
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public double[] getRange() {
        double[] d = new double[]{this.xmin, this.xmax, this.ymin, this.ymax};
        return d;
    }

    public void setLabelFont(Font f) {
        this.labelfont = f;
    }

    public void setLabelColor(Color c) {
        this.labelcolor = c;
    }

    public void setContourColor(Color c) {
        this.contourColor = c;
    }

    public void setLabelledContourColor(Color c) {
        this.labelledColor = c;
    }

    public double[] getLevels() {
        return this.levels;
    }
}

