/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import java.util.HashMap;

public class ProbabilityState {
    public final HashMap<Integer, Double> probMap = new HashMap();
    public final int maxState;

    public ProbabilityState(double[] dataVector) {
        int vectorLength = dataVector.length;
        double doubleLength = dataVector.length;
        int[] normalisedVector = new int[vectorLength];
        this.maxState = ProbabilityState.normaliseArray(dataVector, normalisedVector);
        HashMap<Integer, Integer> countMap = new HashMap<Integer, Integer>();
        for (int value : normalisedVector) {
            Integer tmpKey = value;
            Integer tmpValue = (Integer)countMap.remove(tmpKey);
            if (tmpValue == null) {
                countMap.put(tmpKey, 1);
                continue;
            }
            countMap.put(tmpKey, tmpValue + 1);
        }
        Object object = countMap.keySet().iterator();
        while (object.hasNext()) {
            Integer key = (Integer)object.next();
            this.probMap.put(key, (double)((Integer)countMap.get(key)).intValue() / doubleLength);
        }
    }

    public static final int normaliseArray(double[] inputVector, int[] outputVector) {
        int minVal = 0;
        int maxVal = 0;
        int vectorLength = inputVector.length;
        if (vectorLength > 0) {
            int i;
            minVal = (int)Math.floor(inputVector[0]);
            maxVal = (int)Math.floor(inputVector[0]);
            for (i = 0; i < vectorLength; ++i) {
                int currentValue;
                outputVector[i] = currentValue = (int)Math.floor(inputVector[i]);
                if (currentValue < minVal) {
                    minVal = currentValue;
                }
                if (currentValue <= maxVal) continue;
                maxVal = currentValue;
            }
            for (i = 0; i < vectorLength; ++i) {
                outputVector[i] = outputVector[i] - minVal;
            }
            maxVal = maxVal - minVal + 1;
        }
        return maxVal;
    }

    public static final int mergeArrays(double[] firstVector, double[] secondVector, double[] outputVector) {
        int vectorLength = firstVector.length;
        int[] firstNormalisedVector = new int[vectorLength];
        int[] secondNormalisedVector = new int[vectorLength];
        int firstNumStates = ProbabilityState.normaliseArray(firstVector, firstNormalisedVector);
        int secondNumStates = ProbabilityState.normaliseArray(secondVector, secondNormalisedVector);
        int[] stateMap = new int[firstNumStates * secondNumStates];
        int stateCount = 1;
        for (int i = 0; i < vectorLength; ++i) {
            int curIndex = firstNormalisedVector[i] + secondNormalisedVector[i] * firstNumStates;
            if (stateMap[curIndex] == 0) {
                stateMap[curIndex] = stateCount++;
            }
            outputVector[i] = stateMap[curIndex];
        }
        return stateCount;
    }

    public static void printIntVector(int[] vector) {
        for (int i = 0; i < vector.length; ++i) {
            if (vector[i] <= 0) continue;
            System.out.println("Val at i=" + i + ", is " + vector[i]);
        }
    }

    public static void printDoubleVector(double[] vector) {
        for (int i = 0; i < vector.length; ++i) {
            if (!(vector[i] > 0.0)) continue;
            System.out.println("Val at i=" + i + ", is " + vector[i]);
        }
    }
}

