/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import hep.aida.IAxis;
import hep.aida.ref.histogram.Histogram1D;
import jhplot.H1D;
import jhplot.P1D;
import jhplot.stat.Spline;
import jhplot.utils.SHisto;
import jhplot.utils.Util;
import org.apache.commons.math3.analysis.interpolation.LoessInterpolator;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import umontreal.iro.lecuyer.functionfit.SmoothingCubicSpline;

public class Interpolator {
    private double[] x;
    private double[] y;
    private double[] eY;
    private double[] eX;
    private long dataLength;

    public Interpolator(double[] aX, double[] aY) {
        this.x = aX;
        this.y = aY;
        if (this.x.length != this.y.length) {
            Util.ErrorMessage("Arrays have different length!");
        } else {
            this.dataLength = this.x.length;
        }
    }

    public Interpolator(P1D p1d) {
        this.x = p1d.getArrayX();
        this.y = p1d.getArrayY();
        this.eY = p1d.getArrayYlower();
        this.eY = p1d.getArrayXleft();
        if (this.x.length != this.y.length) {
            Util.ErrorMessage("Arrays have different length!");
        } else {
            this.dataLength = this.x.length;
        }
    }

    public Interpolator(H1D h1) {
        Histogram1D h = h1.get();
        IAxis axis = h.axis();
        this.x = new double[axis.bins()];
        this.y = new double[axis.bins()];
        this.eY = new double[axis.bins()];
        for (int i = 0; i < axis.bins(); ++i) {
            this.x[i] = h1.binMean(i);
            this.y[i] = h1.binHeight(i);
            this.eY[i] = h1.binError(i);
        }
        if (this.x.length != this.y.length) {
            Util.ErrorMessage("Arrays have different length!");
        } else {
            this.dataLength = this.x.length;
        }
    }

    public void setRange(double xMin, double xMax) {
        int i;
        double[] x1 = new double[this.x.length];
        double[] y1 = new double[this.x.length];
        double[] eY1 = new double[this.x.length];
        int n = 0;
        for (i = 0; i < this.x.length; ++i) {
            if (!(this.x[i] > xMin) || !(this.x[i] < xMax)) continue;
            x1[n] = this.x[i];
            y1[n] = this.y[i];
            eY1[n] = this.eY[i];
            ++n;
        }
        this.x = new double[n];
        this.y = new double[n];
        this.eY = new double[n];
        for (i = 0; i < n; ++i) {
            this.x[i] = x1[i];
            this.y[i] = y1[i];
            this.eY[i] = eY1[i];
        }
    }

    public PolynomialSplineFunction interpolateLoess(double bandwidth, int robustnessIters, double accuracy, int option) {
        PolynomialSplineFunction c = null;
        LoessInterpolator L = null;
        L = new LoessInterpolator(bandwidth, robustnessIters, accuracy);
        c = L.interpolate(this.x, this.y);
        return c;
    }

    public P1D smoothLoess(double bandwidth, int robustnessIters, double accuracy, int option) {
        P1D p = new P1D("Loess interpolation");
        LoessInterpolator L = new LoessInterpolator(bandwidth, robustnessIters, accuracy);
        double[] w = new double[this.x.length];
        for (int i = 0; i < this.x.length; ++i) {
            w[i] = 1.0;
            if (option == 0) {
                w[i] = 1.0;
                continue;
            }
            if (option != 1) continue;
            if (this.eY[i] > 0.0) {
                w[i] = 1.0 / this.eY[i];
                continue;
            }
            if (option != 2) continue;
            if (this.eY[i] > 0.0) {
                w[i] = 1.0 / (this.eY[i] * this.eY[i]);
                continue;
            }
            if (option != 3) continue;
            if (this.eY[i] > 0.0 && this.eX[i] > 0.0) {
                w[i] = 1.0 / (this.eY[i] * this.eX[i]);
                continue;
            }
            if (option != 4) continue;
            if (this.eY[i] > 0.0 && this.eX[i] > 0.0) {
                w[i] = 1.0 / (this.eY[i] * this.eX[i] * this.eY[i] * this.eX[i]);
                continue;
            }
            if (option == 5) {
                w[i] = this.eY[i];
                continue;
            }
            if (option == 6) {
                w[i] = this.eY[i] * this.eX[i];
                continue;
            }
            Util.ErrorMessage("Wrong option value");
        }
        double[] yy = L.smooth(this.x, this.y, w);
        for (int i = 0; i < yy.length; ++i) {
            p.add(this.x[i], yy[i]);
        }
        return p;
    }

    public SmoothingCubicSpline interpolateCubicSpline(double rho, int option) {
        double[] w = new double[this.x.length];
        for (int i = 0; i < this.x.length; ++i) {
            w[i] = 1.0;
            if (option == 0) {
                w[i] = 1.0;
                continue;
            }
            if (option != 1) continue;
            if (this.eY[i] > 0.0) {
                w[i] = 1.0 / this.eY[i];
                continue;
            }
            if (option != 2) continue;
            if (this.eY[i] > 0.0) {
                w[i] = 1.0 / (this.eY[i] * this.eY[i]);
                continue;
            }
            if (option != 3) continue;
            if (this.eY[i] > 0.0 && this.eX[i] > 0.0) {
                w[i] = 1.0 / (this.eY[i] * this.eX[i]);
                continue;
            }
            if (option != 4) continue;
            if (this.eY[i] > 0.0 && this.eX[i] > 0.0) {
                w[i] = 1.0 / (this.eY[i] * this.eX[i] * this.eY[i] * this.eX[i]);
                continue;
            }
            if (option == 5) {
                w[i] = this.eY[i];
                continue;
            }
            if (option == 6) {
                w[i] = this.eY[i] * this.eX[i];
                continue;
            }
            Util.ErrorMessage("Wrong option value");
        }
        return new SmoothingCubicSpline(this.x, this.y, w, rho);
    }

    public P1D smoothLoess(double bandwidth, int robustnessIters, double accuracy) {
        return this.smoothLoess(bandwidth, robustnessIters, accuracy, 2);
    }

    public P1D smoothSpline() {
        P1D p = new P1D("Spline interpolation");
        SplineInterpolator L = new SplineInterpolator();
        PolynomialSplineFunction c = L.interpolate(this.x, this.y);
        for (int i = 0; i < this.x.length; ++i) {
            p.add(this.x[i], c.value(this.x[i]));
        }
        return p;
    }

    public P1D smoothCubicSpline() {
        P1D p = new P1D("Cubic spline interpolation");
        Spline sp = new Spline(this.x, this.y);
        for (int i = 0; i < this.x.length; ++i) {
            p.add(this.x[i], sp.spline_value(this.x[i]));
        }
        return p;
    }

    public P1D smoothGauss(double standardDeviation) {
        P1D p = new P1D("Gaussian interpolation");
        SHisto sh = new SHisto(this.x.length, this.getMinValue(), this.getMaxValue(), 1);
        sh.setBins(this.y);
        sh = sh.getGaussianSmoothed(standardDeviation);
        for (int i = 0; i < this.x.length; ++i) {
            p.add(this.x[i], sh.getBinsFirstBand(i));
        }
        return p;
    }

    public P1D smoothAverage(boolean isWeighted, int k) {
        P1D p = new P1D("Moving window interpolation");
        SHisto sh = new SHisto(this.x.length, this.getMinValue(), this.getMaxValue(), 1);
        sh.setBins(this.y);
        sh = sh.getSmoothed(isWeighted, k);
        for (int i = 0; i < this.x.length; ++i) {
            p.add(this.x[i], sh.getBinsFirstBand(i));
        }
        return p;
    }

    public double getMaxValue() {
        double maxValue = this.x[0];
        for (int i = 1; i < this.x.length; ++i) {
            if (!(this.x[i] > maxValue)) continue;
            maxValue = this.x[i];
        }
        return maxValue;
    }

    public double getMinValue() {
        double minValue = this.x[0];
        for (int i = 1; i < this.x.length; ++i) {
            if (!(this.x[i] < minValue)) continue;
            minValue = this.x[i];
        }
        return minValue;
    }

    public Cubic[] interpolateNatuarlCubicSpline() {
        Cubic[] s = this.calcNaturalCubic(this.y.length, this.y);
        return s;
    }

    private Cubic[] calcNaturalCubic(int n, double[] x) {
        int i;
        double[] gamma = new double[n + 1];
        double[] delta = new double[n + 1];
        double[] D = new double[n + 1];
        gamma[0] = 0.5;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[n] = 1.0 / (2.0 - gamma[n - 1]);
        delta[0] = 3.0 * (x[1] - x[0]) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = (3.0 * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
        }
        delta[n] = (3.0 * (x[n] - x[n - 1]) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], 3.0 * (x[i + 1] - x[i]) - 2.0 * D[i] - D[i + 1], 2.0 * (x[i] - x[i + 1]) + D[i] + D[i + 1]);
        }
        return C;
    }

    public class Cubic {
        double a;
        double b;
        double c;
        double d;

        public Cubic(double a, double b, double c, double d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public double eval(float u) {
            return ((this.d * (double)u + this.c) * (double)u + this.b) * (double)u + this.a;
        }
    }
}

