/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.pca;

import Jama.Matrix;
import jhplot.math.pca.Assume;
import jhplot.math.pca.EVDWithThreshold;
import jhplot.math.pca.covmatrixevd.CovarianceMatrixEVDCalculator;
import jhplot.math.pca.covmatrixevd.EVDBased;
import jhplot.math.pca.covmatrixevd.EVDResult;
import jhplot.math.pca.covmatrixevd.SVDBased;

public final class PCA {
    private final boolean centerMatrix;
    private final int inputDim;
    private final Matrix whiteningTransformation;
    private final Matrix pcaRotationTransformation;
    private final Matrix v;
    private final Matrix zerosRotationTransformation;
    private final Matrix d;
    private final double[] means;
    private final double threshold;

    public PCA(Matrix data) {
        this(data, new SVDBased(), true);
    }

    public PCA(Matrix data, boolean center) {
        this(data, new SVDBased(), center);
    }

    public PCA(Matrix data, CovarianceMatrixEVDCalculator evdCalc) {
        this(data, evdCalc, true);
    }

    public PCA(Matrix data, CovarianceMatrixEVDCalculator evdCalc, boolean center) {
        this.centerMatrix = center;
        this.inputDim = data.getColumnDimension();
        this.means = PCA.getColumnsMeans(data);
        Matrix centeredData = data;
        if (this.centerMatrix) {
            centeredData = PCA.shiftColumns(data, this.means);
        }
        EVDResult evd = evdCalc.run(centeredData);
        EVDWithThreshold evdT = new EVDWithThreshold(evd);
        this.d = evdT.getDAboveThreshold();
        this.v = evdT.getVAboveThreshold();
        this.zerosRotationTransformation = evdT.getVBelowThreshold();
        this.threshold = 3.0 * evdT.getThreshold();
        Matrix sqrtD = PCA.sqrtDiagonalMatrix(this.d);
        Matrix scaling = PCA.inverseDiagonalMatrix(sqrtD);
        this.pcaRotationTransformation = this.v;
        this.whiteningTransformation = this.pcaRotationTransformation.times(scaling);
    }

    public Matrix getEigenvectorsMatrix() {
        return this.v;
    }

    public double getEigenvalue(int dimNo) {
        return this.d.get(dimNo, dimNo);
    }

    public int getInputDimsNo() {
        return this.inputDim;
    }

    public int getOutputDimsNo() {
        return this.v.getColumnDimension();
    }

    public Matrix transform(Matrix data, TransformationType type) {
        Matrix centeredData = data;
        if (this.centerMatrix) {
            centeredData = PCA.shiftColumns(data, this.means);
        }
        Matrix transformation = this.getTransformation(type);
        return centeredData.times(transformation);
    }

    public boolean belongsToGeneratedSubspace(Matrix pt) {
        Assume.assume(pt.getRowDimension() == 1);
        Matrix centeredPt = pt;
        if (this.centerMatrix) {
            centeredPt = PCA.shiftColumns(pt, this.means);
        }
        Matrix zerosTransformedPt = centeredPt.times(this.zerosRotationTransformation);
        assert (zerosTransformedPt.getRowDimension() == 1);
        for (int c = 0; c < zerosTransformedPt.getColumnDimension(); ++c) {
            if (!(Math.abs(zerosTransformedPt.get(0, c)) > this.threshold)) continue;
            return false;
        }
        return true;
    }

    public static Matrix calculateCovarianceMatrix(Matrix data) {
        double[] means = PCA.getColumnsMeans(data);
        Matrix centeredData = PCA.shiftColumns(data, means);
        return EVDBased.calculateCovarianceMatrixOfCenteredData(centeredData);
    }

    private Matrix getTransformation(TransformationType type) {
        switch (type) {
            case ROTATION: {
                return this.pcaRotationTransformation;
            }
            case WHITENING: {
                return this.whiteningTransformation;
            }
        }
        throw new RuntimeException("Unknown enum type: " + (Object)((Object)type));
    }

    private static Matrix shiftColumns(Matrix data, double[] shifts) {
        Assume.assume(shifts.length == data.getColumnDimension());
        Matrix m = new Matrix(data.getRowDimension(), data.getColumnDimension());
        for (int c = 0; c < data.getColumnDimension(); ++c) {
            for (int r = 0; r < data.getRowDimension(); ++r) {
                m.set(r, c, data.get(r, c) - shifts[c]);
            }
        }
        return m;
    }

    private static double[] getColumnsMeans(Matrix m) {
        double[] means = new double[m.getColumnDimension()];
        for (int c = 0; c < m.getColumnDimension(); ++c) {
            double sum = 0.0;
            for (int r = 0; r < m.getRowDimension(); ++r) {
                sum += m.get(r, c);
            }
            means[c] = sum / (double)m.getRowDimension();
        }
        return means;
    }

    private static Matrix sqrtDiagonalMatrix(Matrix m) {
        assert (m.getRowDimension() == m.getColumnDimension());
        Matrix newM = new Matrix(m.getRowDimension(), m.getRowDimension());
        for (int i = 0; i < m.getRowDimension(); ++i) {
            newM.set(i, i, Math.sqrt(m.get(i, i)));
        }
        return newM;
    }

    private static Matrix inverseDiagonalMatrix(Matrix m) {
        assert (m.getRowDimension() == m.getColumnDimension());
        Matrix newM = new Matrix(m.getRowDimension(), m.getRowDimension());
        for (int i = 0; i < m.getRowDimension(); ++i) {
            newM.set(i, i, 1.0 / m.get(i, i));
        }
        return newM;
    }

    public static enum TransformationType {
        ROTATION,
        WHITENING;

    }
}

