/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.random;

import jhplot.math.num.random.AbstractContinuousRandomVariable;
import jhplot.math.num.random.RNG;
import jhplot.math.num.random.RandomRNG;

public class RayleighRandomVariable
extends AbstractContinuousRandomVariable {
    private double scale;

    public RayleighRandomVariable() {
        this(1.0);
    }

    public RayleighRandomVariable(double s) {
        this(s, new RandomRNG());
    }

    public RayleighRandomVariable(double s, RNG source) {
        super(source);
        this.setScale(s);
    }

    public static double nextRandomVariable(double s, RNG source) {
        double u;
        while ((u = source.nextRandomNumber()) <= 0.0) {
        }
        return Math.sqrt(-2.0 * Math.log(u)) * s;
    }

    private double getScale() {
        return this.scale;
    }

    @Override
    public double nextRandomVariable() {
        return RayleighRandomVariable.nextRandomVariable(this.getScale(), this.getSource());
    }

    private void setScale(double b) {
        if (b <= 0.0 || Double.isNaN(b)) {
            throw new IllegalArgumentException("scale must be positive.");
        }
        this.scale = b;
    }
}

