/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.random;

import jhplot.math.num.random.AbstractContinuousRandomVariable;
import jhplot.math.num.random.RNG;
import jhplot.math.num.random.RandomRNG;

public class CauchyRandomVariable
extends AbstractContinuousRandomVariable {
    private double median;
    private double scale;

    public CauchyRandomVariable() {
        this(0.0, 1.0);
    }

    public CauchyRandomVariable(double m, double s) {
        this(m, s, new RandomRNG());
    }

    public CauchyRandomVariable(double m, double s, RNG source) {
        super(source);
        this.setMedian(m);
        this.setScale(s);
    }

    public static double nextRandomVariable(double m, double s, RNG source) {
        double u2;
        double v;
        double u1;
        while ((u1 = source.nextRandomNumber()) * u1 + (v = 2.0 * (u2 = source.nextRandomNumber()) - 1.0) * v >= 1.0) {
        }
        return v / u1 * s + m;
    }

    private double getMedian() {
        return this.median;
    }

    private double getScale() {
        return this.scale;
    }

    @Override
    public double nextRandomVariable() {
        return CauchyRandomVariable.nextRandomVariable(this.getMedian(), this.getScale(), this.getSource());
    }

    private void setMedian(double m) {
        if (Double.isNaN(m)) {
            throw new IllegalArgumentException("location parameter must be a valid number.");
        }
        this.median = m;
    }

    private void setScale(double s) {
        if (s <= 0.0 || Double.isNaN(s)) {
            throw new IllegalArgumentException("scale parameter must be positive.");
        }
        this.scale = s;
    }
}

