/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.integration;

import jhplot.math.num.ConvergenceException;
import jhplot.math.num.DoubleArray;
import jhplot.math.num.Function;
import jhplot.math.num.IterativeMethod;
import jhplot.math.num.NumericException;
import jhplot.math.num.integration.TrapezoidalIntegrator;

public class RombergIntegrator
extends IterativeMethod {
    private Function function;

    public RombergIntegrator(Function f) {
        this(f, 100, 1.0E-10);
    }

    public RombergIntegrator(Function f, int iterations, double error) {
        super(iterations, error);
        this.setFunction(f);
    }

    public Function getFunction() {
        return this.function;
    }

    public double integrate(double a, double b) throws NumericException {
        int n;
        TrapezoidalIntegrator.IterativeState state = new TrapezoidalIntegrator.IterativeState(this.function, a, b);
        DoubleArray r0 = new DoubleArray();
        DoubleArray r1 = new DoubleArray();
        double error = Double.MAX_VALUE;
        r0.add(state.getResult());
        do {
            state.iterate();
            n = state.getIterations();
            r1.clear();
            r1.add(state.getResult());
            double d = 4.0;
            for (int i = 0; i < n; ++i) {
                r1.add(r1.get(i) + (r1.get(i) - r0.get(i)) / (d - 1.0));
                d *= 4.0;
            }
            error = Math.abs(r1.get(n) / r0.get(n - 1) - 1.0);
            r0 = r1;
            r1 = new DoubleArray();
        } while (n < this.getMaximumIterations() && error > this.getMaximumRelativeError());
        if (n >= this.getMaximumIterations()) {
            throw new ConvergenceException("Romberg integration failed to converge.");
        }
        return r0.get(r0.getSize() - 1);
    }

    public void setFunction(Function f) {
        if (f == null) {
            throw new IllegalArgumentException("Function can not be null.");
        }
        this.function = f;
    }
}

