/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LEDataInputStream
implements DataInput {
    protected DataInputStream d;
    protected InputStream in;
    byte[] w;

    public LEDataInputStream(InputStream in) {
        this.in = in;
        this.d = new DataInputStream(in);
        this.w = new byte[8];
    }

    @Override
    public short readShort() throws IOException {
        this.d.readFully(this.w, 0, 2);
        return (short)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.d.readFully(this.w, 0, 2);
        return (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
    }

    @Override
    public char readChar() throws IOException {
        this.d.readFully(this.w, 0, 2);
        return (char)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
    }

    @Override
    public int readInt() throws IOException {
        this.d.readFully(this.w, 0, 4);
        return this.w[3] << 24 | (this.w[2] & 0xFF) << 16 | (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
    }

    @Override
    public long readLong() throws IOException {
        this.d.readFully(this.w, 0, 8);
        return (long)this.w[7] << 56 | (long)(this.w[6] & 0xFF) << 48 | (long)(this.w[5] & 0xFF) << 40 | (long)(this.w[4] & 0xFF) << 32 | (long)(this.w[3] & 0xFF) << 24 | (long)(this.w[2] & 0xFF) << 16 | (long)(this.w[1] & 0xFF) << 8 | (long)(this.w[0] & 0xFF);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.d.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.d.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.d.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.d.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.d.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.d.readUnsignedByte();
    }

    @Override
    public String readLine() throws IOException {
        return null;
    }

    @Override
    public String readUTF() throws IOException {
        return this.d.readUTF();
    }

    public static String readUTF(DataInput in) throws IOException {
        return DataInputStream.readUTF(in);
    }

    public void close() throws IOException {
        this.d.close();
    }
}

