/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math;

import java.util.Vector;
import jhplot.math.DoubleArray;
import jhplot.math.LinearAlgebra;
import jhplot.math.Sorting;

public class Slicing {
    public static final String AUTO_BOUNDS = "AUTO";
    public static final String UNIFORM_BOUNDS = "UNIFORM";
    public static double epsilon = 1.0E-6;
    private double[][] M;
    private int numDimensions;
    private Slice[] slice;

    public Slicing(double[][] m, int[] n, String bounds) {
        DoubleArray.checkColumnDimension(m, n.length);
        this.M = m;
        this.numDimensions = this.M[0].length;
        if (bounds == UNIFORM_BOUNDS) {
            this.setSlicesUniformBounds(n);
        } else if (bounds == AUTO_BOUNDS) {
            this.setSlicesAutoBounds(n);
        } else {
            throw new IllegalArgumentException("The bounds type : " + bounds + "is unknown. You must specify AUTO or UNIFORM.");
        }
    }

    public Slicing(double[][] m, double[][] bounds) {
        DoubleArray.checkColumnDimension(m, bounds.length);
        this.M = m;
        this.numDimensions = this.M[0].length;
        this.setSlicesBounds(bounds);
    }

    public Slicing(double[][] m, double[][] centers, double[][] widths) {
        DoubleArray.checkColumnDimension(m, centers.length);
        this.M = m;
        this.numDimensions = this.M[0].length;
        this.setSlicesCentersnWidths(centers, widths);
    }

    public Slicing(double[][] m, int[][] n) {
        this.M = m;
        this.numDimensions = this.M[0].length;
        this.setSlices(n);
    }

    public double[][] getSlicingMatrix() {
        double[][] X = new double[this.slice.length][this.numDimensions * 2 + 1];
        for (int i = 0; i < this.slice.length; ++i) {
            System.arraycopy(this.slice[i].center, 0, X[i], 0, this.numDimensions);
            X[i][this.numDimensions] = this.slice[i].cardinal;
            System.arraycopy(this.slice[i].width, 0, X[i], this.numDimensions + 1, this.numDimensions);
        }
        return X;
    }

    public double[] getSlicesCardinals() {
        double[] cards = new double[this.slice.length];
        for (int i = 0; i < this.slice.length; ++i) {
            cards[i] = this.slice[i].cardinal;
        }
        return cards;
    }

    public double[][] getSlicesWidths() {
        double[][] w = new double[this.slice.length][this.numDimensions];
        for (int i = 0; i < this.slice.length; ++i) {
            System.arraycopy(this.slice[i].width, 0, w[i], 0, this.numDimensions);
        }
        return w;
    }

    public double[][] getSlicesCenters() {
        double[][] c = new double[this.slice.length][this.numDimensions];
        for (int i = 0; i < this.slice.length; ++i) {
            System.arraycopy(this.slice[i].center, 0, c[i], 0, this.numDimensions);
        }
        return c;
    }

    public int findSlice(double[] x) {
        DoubleArray.checkLength(x, this.numDimensions);
        int s = -1;
        for (int i = 0; i < this.slice.length; ++i) {
            if (!this.slice[i].isIn(x)) continue;
            s = i;
        }
        return s;
    }

    public int[][] getSlicesIndexes() {
        int[][] s = new int[this.slice.length][0];
        for (int i = 0; i < this.slice.length; ++i) {
            s[i] = this.slice[i].getIndexesArray();
        }
        return s;
    }

    private void setSlicesBounds(double[][] bounds) {
        DoubleArray.checkRowDimension(bounds, this.numDimensions);
        int[] numberSlicesPerDimension = new int[this.numDimensions];
        for (int i = 0; i < this.numDimensions; ++i) {
            numberSlicesPerDimension[i] = bounds[i].length - 1;
        }
        this.slice = new Slice[Slicing.cumProd(numberSlicesPerDimension)];
        int[] counter = new int[this.numDimensions];
        double[] sliceWidth = new double[this.numDimensions];
        double[] sliceCenter = new double[this.numDimensions];
        for (int i = 0; i < this.slice.length; ++i) {
            for (int j = 0; j < this.numDimensions; ++j) {
                sliceWidth[j] = bounds[j][counter[j] + 1] - bounds[j][counter[j]];
                sliceCenter[j] = (bounds[j][counter[j] + 1] + bounds[j][counter[j]]) / 2.0;
            }
            this.slice[i] = new Slice(sliceCenter, sliceWidth);
            if (i >= this.slice.length - 1) continue;
            this.incCounter(counter, numberSlicesPerDimension);
        }
        this.countFromBounds();
    }

    private void setSlicesCentersnWidths(double[][] centers, double[][] widths) {
        DoubleArray.checkRowDimension(centers, this.numDimensions);
        DoubleArray.checkRowDimension(widths, this.numDimensions);
        int[] numberSlicesPerDimension = new int[this.numDimensions];
        for (int i = 0; i < this.numDimensions; ++i) {
            numberSlicesPerDimension[i] = centers[i].length;
        }
        this.slice = new Slice[Slicing.cumProd(numberSlicesPerDimension)];
        int[] counter = new int[this.numDimensions];
        double[] sliceWidth = new double[this.numDimensions];
        double[] sliceCenter = new double[this.numDimensions];
        for (int i = 0; i < this.slice.length; ++i) {
            for (int j = 0; j < this.numDimensions; ++j) {
                sliceWidth[j] = widths[j][counter[j]];
                sliceCenter[j] = centers[j][counter[j]];
            }
            this.slice[i] = new Slice(sliceCenter, sliceWidth);
            if (i >= this.slice.length - 1) continue;
            this.incCounter(counter, numberSlicesPerDimension);
        }
        this.countFromBounds();
    }

    private void setSlicesUniformBounds(int[] numberSlicesPerDimension) {
        this.slice = new Slice[Slicing.cumProd(numberSlicesPerDimension)];
        int[] counter = new int[this.numDimensions];
        double[] sliceWidth = new double[this.numDimensions];
        double[] sliceCenter = new double[this.numDimensions];
        double[] Mmin = DoubleArray.min(this.M);
        double[] Mmax = DoubleArray.max(this.M);
        double[] pitch = new double[this.numDimensions];
        for (int j = 0; j < this.numDimensions; ++j) {
            pitch[j] = (Mmax[j] - Mmin[j]) / (double)numberSlicesPerDimension[j];
        }
        for (int i = 0; i < this.slice.length; ++i) {
            for (int j = 0; j < this.numDimensions; ++j) {
                sliceWidth[j] = pitch[j];
                sliceCenter[j] = Mmin[j] + ((double)counter[j] + 0.5) * pitch[j];
            }
            this.slice[i] = new Slice(sliceCenter, sliceWidth);
            if (i >= this.slice.length - 1) continue;
            this.incCounter(counter, numberSlicesPerDimension);
        }
        this.countFromBounds();
    }

    private void setSlicesAutoBounds(int[] numberSlicesPerDimension) {
        this.slice = new Slice[Slicing.cumProd(numberSlicesPerDimension)];
        int[] counter = new int[this.numDimensions];
        double[] sliceWidth = new double[this.numDimensions];
        double[] sliceCenter = new double[this.numDimensions];
        int[] numberOfElement = new int[this.numDimensions];
        double[][] centers = new double[this.numDimensions][];
        double[][] widths = new double[this.numDimensions][];
        for (int j = 0; j < this.numDimensions; ++j) {
            int i_min;
            int i;
            double[] column = DoubleArray.getColumnCopy(this.M, j);
            numberOfElement[j] = column.length / numberSlicesPerDimension[j];
            new Sorting(column, false);
            centers[j] = new double[numberSlicesPerDimension[j]];
            widths[j] = new double[numberSlicesPerDimension[j]];
            int i_max = -1;
            for (i = 0; i < numberSlicesPerDimension[j] - 1; ++i) {
                i_min = i_max + 1;
                i_max = Math.max((i + 1) * numberOfElement[j] - 1, i_min);
                try {
                    while (column[i_max] == column[i_max + 1]) {
                        ++i_max;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("Too much slices defined for the values to slice... you should try to reduce the nyumber of slices !");
                }
                centers[j][i] = (column[i_min] + column[i_max]) / 2.0;
                widths[j][i] = column[i_max] - column[i_min];
            }
            i = numberSlicesPerDimension[j] - 1;
            i_min = i_max + 1;
            if (i_min > (i_max = column.length - 1)) {
                throw new IllegalArgumentException("Too much slices defined for the values to slice... you should try to reduce the nyumber of slices !");
            }
            centers[j][i] = (column[i_min] + column[i_max]) / 2.0;
            widths[j][i] = column[i_max] - column[i_min];
        }
        for (int i = 0; i < this.slice.length; ++i) {
            for (int j = 0; j < this.numDimensions; ++j) {
                sliceWidth[j] = widths[j][counter[j]];
                sliceCenter[j] = centers[j][counter[j]];
            }
            this.slice[i] = new Slice(sliceCenter, sliceWidth);
            if (i >= this.slice.length - 1) continue;
            this.incCounter(counter, numberSlicesPerDimension);
        }
        this.countFromBounds();
    }

    private void setSlices(int[][] s) {
        this.slice = new Slice[s.length];
        double[] sliceWidth = new double[this.numDimensions];
        double[] sliceCenter = new double[this.numDimensions];
        for (int i = 0; i < this.slice.length; ++i) {
            double[][] tmp = DoubleArray.getRowsCopy(this.M, s[i]);
            double[] tmpMax = DoubleArray.max(tmp);
            double[] tmpMin = DoubleArray.min(tmp);
            sliceWidth = LinearAlgebra.minus(tmpMax, tmpMin);
            sliceCenter = LinearAlgebra.times(LinearAlgebra.plus((double[][])new double[][]{tmpMax, tmpMin}), 0.5);
            this.slice[i] = new Slice(sliceCenter, sliceWidth);
            for (int j = 0; j < tmp.length; ++j) {
                this.slice[i].add(DoubleArray.getRowCopy(tmp, j), s[i][j]);
            }
        }
    }

    private void countFromBounds() {
        int numOE = this.M.length;
        for (int i = 0; i < numOE; ++i) {
            Vector<Integer> inv = new Vector<Integer>(0);
            for (int j = 0; j < this.slice.length; ++j) {
                if (!this.slice[j].isIn(DoubleArray.getRowCopy(this.M, i))) continue;
                if (inv.size() == 0) {
                    this.slice[j].add(DoubleArray.getRowCopy(this.M, i), i);
                }
                inv.add(new Integer(j));
            }
            if (inv.size() != 0) continue;
            String S = "";
            for (int j = 0; j < this.slice.length; ++j) {
                S = S + this.slice[j].toString("slice[" + j + "]");
            }
            throw new IllegalArgumentException("The element = " + DoubleArray.toString(DoubleArray.getRowsCopy(this.M, i, i)) + " is in 0 slices :" + S);
        }
    }

    private static int cumProd(int[] a) {
        int res = 1;
        for (int i = 0; i < a.length; ++i) {
            res *= a[i];
        }
        return res;
    }

    private void incCounter(int[] counter, int[] counterMaxs) {
        int i;
        int decToInc = 0;
        for (i = 0; i < counter.length; ++i) {
            if (counter[i] < counterMaxs[i] - 1) {
                decToInc = i;
                break;
            }
            ++decToInc;
        }
        int n = decToInc;
        counter[n] = counter[n] + 1;
        for (i = 0; i < decToInc; ++i) {
            counter[i] = 0;
        }
    }

    public void toCommandLine(String title) {
        System.out.println("\nSlicing " + title + " :");
        for (int i = 0; i < this.slice.length; ++i) {
            this.slice[i].toCommandLine("Slice " + i);
        }
    }

    public static void main(String[] args) {
    }

    private class Slice {
        public Vector<Integer> indexes;
        public int cardinal;
        public double[] center;
        public double[] width;

        public Slice(double[] c, double[] w) {
            this.center = DoubleArray.copy(c);
            this.width = DoubleArray.copy(w);
            this.indexes = new Vector();
        }

        public boolean isIn(double[] x) {
            boolean in = true;
            for (int j = 0; j < x.length; ++j) {
                boolean inj = Math.abs(x[j] - this.center[j]) - this.width[j] / 2.0 <= epsilon;
                in = in && inj;
            }
            return in;
        }

        public void add(double[] x, int i) {
            ++this.cardinal;
            this.indexes.add(new Integer(i));
        }

        public int[] getIndexesArray() {
            int[] array = new int[this.indexes.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.indexes.get(i);
            }
            return array;
        }

        public String toString(String s) {
            StringBuffer st = new StringBuffer("\n" + s);
            st.append("  contains " + this.cardinal + " elements\n");
            st.append("  min = " + DoubleArray.toString(new double[][]{LinearAlgebra.minus(this.center, LinearAlgebra.times(this.width, 0.5))}) + "  max = " + DoubleArray.toString(new double[][]{LinearAlgebra.plus((double[][])new double[][]{this.center, LinearAlgebra.times(this.width, 0.5)})}) + "\n");
            st.append("  elements indices : \n");
            for (int i = 0; i < this.indexes.size(); ++i) {
                st.append(" " + this.indexes.get(i));
            }
            return st.toString();
        }

        public void toCommandLine(String s) {
            System.out.println(this.toString(s));
        }
    }
}

