/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io.images;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.fop.render.ps.EPSTranscoder;
import org.apache.fop.render.ps.PSTranscoder;
import org.apache.fop.svg.PDFTranscoder;

public class ConvertSVG {
    public static void SVGTo(String in, String out, boolean isSourceRemove) {
        int dot = out.lastIndexOf(46);
        String base = dot == -1 ? out : out.substring(0, dot);
        String extension = dot == -1 ? "" : out.substring(dot + 1);
        extension = extension.trim();
        if (!((extension = extension.toLowerCase()).equals("eps") || extension.equals("ps") || extension.equals("pdf") || extension.equals("png") || extension.equals("jpg") || extension.equals("jpeg") || extension.equals("svgz"))) {
            System.out.println("Error: Unsupported format=" + extension);
            return;
        }
        PDFTranscoder trans = null;
        switch (extension) {
            case "pdf": {
                trans = new PDFTranscoder();
                break;
            }
            case "ps": {
                trans = new PSTranscoder();
                break;
            }
            case "eps": {
                trans = new EPSTranscoder();
            }
        }
        if (trans != null) {
            try {
                File f;
                TranscoderInput input = new TranscoderInput((InputStream)new FileInputStream(in));
                FileOutputStream os = new FileOutputStream(out);
                TranscoderOutput output = new TranscoderOutput((OutputStream)os);
                trans.transcode(input, output);
                os.flush();
                os.close();
                os = null;
                if (isSourceRemove && (f = new File(in)).exists()) {
                    f.delete();
                }
                return;
            }
            catch (Exception e) {
                System.err.println("Error while converting from SVG: " + e.getLocalizedMessage());
            }
        }
        JPEGTranscoder trans1 = null;
        switch (extension) {
            case "jpeg": {
                trans1 = new JPEGTranscoder();
                trans1.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(1.0f));
                trans1.addTranscodingHint(JPEGTranscoder.KEY_WIDTH, (Object)new Float(1000.0f));
                trans1.addTranscodingHint(JPEGTranscoder.KEY_ALLOWED_SCRIPT_TYPES, (Object)"*");
                trans1.addTranscodingHint(JPEGTranscoder.KEY_CONSTRAIN_SCRIPT_ORIGIN, (Object)new Boolean(true));
                trans1.addTranscodingHint(JPEGTranscoder.KEY_EXECUTE_ONLOAD, (Object)new Boolean(true));
                break;
            }
            case "jpg": {
                trans1 = new JPEGTranscoder();
                trans1.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(1.0f));
                trans1.addTranscodingHint(JPEGTranscoder.KEY_WIDTH, (Object)new Float(1000.0f));
                trans1.addTranscodingHint(JPEGTranscoder.KEY_ALLOWED_SCRIPT_TYPES, (Object)"*");
                trans1.addTranscodingHint(JPEGTranscoder.KEY_CONSTRAIN_SCRIPT_ORIGIN, (Object)new Boolean(true));
                trans1.addTranscodingHint(JPEGTranscoder.KEY_EXECUTE_ONLOAD, (Object)new Boolean(true));
                break;
            }
            case "png": {
                trans1 = new PNGTranscoder();
            }
        }
        if (trans1 != null) {
            try {
                File f;
                TranscoderInput input = new TranscoderInput((InputStream)new FileInputStream(in));
                FileOutputStream os = new FileOutputStream(out);
                TranscoderOutput output = new TranscoderOutput((OutputStream)os);
                trans1.transcode(input, output);
                os.flush();
                os.close();
                os = null;
                if (isSourceRemove && (f = new File(in)).exists()) {
                    f.delete();
                }
                return;
            }
            catch (IOException | TranscoderException e) {
                System.err.println("Error while converting from SVG: " + e.getLocalizedMessage());
            }
        }
        if (extension.equalsIgnoreCase("svgz")) {
            File f;
            ConvertSVG.gzipFile(in, out);
            if (isSourceRemove && (f = new File(in)).exists()) {
                f.delete();
            }
            return;
        }
        System.err.println("Error: Cannot find output format=" + extension);
    }

    public static void SVGTo(String in, String out) {
        ConvertSVG.SVGTo(in, out, false);
    }

    private static void gzipFile(String source_filepath, String destinaton_zip_filepath) {
        byte[] buffer = new byte[1024];
        try {
            int bytes_read;
            FileOutputStream fileOutputStream = new FileOutputStream(destinaton_zip_filepath);
            GZIPOutputStream gzipOuputStream = new GZIPOutputStream(fileOutputStream);
            FileInputStream fileInput = new FileInputStream(source_filepath);
            while ((bytes_read = fileInput.read(buffer)) > 0) {
                gzipOuputStream.write(buffer, 0, bytes_read);
            }
            fileInput.close();
            gzipOuputStream.finish();
            gzipOuputStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

