/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io.db;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import jhplot.io.db.BaseRecordsFile;
import jhplot.io.db.RecordHeader;
import jhplot.io.db.RecordsFileException;

public class RecordsFile
extends BaseRecordsFile {
    protected Hashtable memIndex;

    public RecordsFile(String dbPath, int initialSize) throws IOException, RecordsFileException {
        super(dbPath, initialSize);
        this.memIndex = new Hashtable(initialSize);
    }

    public RecordsFile(String dbPath, String accessFlags) throws IOException, RecordsFileException {
        super(dbPath, accessFlags);
        int numRecords = this.readNumRecordsHeader();
        this.memIndex = new Hashtable(numRecords);
        for (int i = 0; i < numRecords; ++i) {
            String key = this.readKeyFromIndex(i);
            RecordHeader header = this.readRecordHeaderFromIndex(i);
            header.setIndexPosition(i);
            this.memIndex.put(key, header);
        }
    }

    @Override
    public synchronized Enumeration enumerateKeys() {
        return this.memIndex.keys();
    }

    @Override
    public synchronized int getNumRecords() {
        return this.memIndex.size();
    }

    @Override
    public synchronized boolean recordExists(String key) {
        return this.memIndex.containsKey(key);
    }

    @Override
    protected RecordHeader keyToRecordHeader(String key) throws RecordsFileException {
        RecordHeader h = (RecordHeader)this.memIndex.get(key);
        if (h == null) {
            throw new RecordsFileException("Key not found: " + key);
        }
        return h;
    }

    @Override
    protected RecordHeader allocateRecord(String key, int dataLength) throws RecordsFileException, IOException {
        RecordHeader newRecord = null;
        Enumeration e = this.memIndex.elements();
        while (e.hasMoreElements()) {
            RecordHeader next = (RecordHeader)e.nextElement();
            int free = next.getFreeSpace();
            if (dataLength > next.getFreeSpace()) continue;
            newRecord = next.split();
            this.writeRecordHeaderToIndex(next);
            break;
        }
        if (newRecord == null) {
            long fp = this.getFileLength();
            this.setFileLength(fp + (long)dataLength);
            newRecord = new RecordHeader(fp, dataLength);
        }
        return newRecord;
    }

    @Override
    protected RecordHeader getRecordAt(long targetFp) throws RecordsFileException {
        Enumeration e = this.memIndex.elements();
        while (e.hasMoreElements()) {
            RecordHeader next = (RecordHeader)e.nextElement();
            if (targetFp < next.dataPointer || targetFp >= next.dataPointer + (long)next.dataCapacity) continue;
            return next;
        }
        return null;
    }

    @Override
    public synchronized void close() throws IOException, RecordsFileException {
        try {
            super.close();
        }
        finally {
            this.memIndex.clear();
            this.memIndex = null;
        }
    }

    @Override
    protected void addEntryToIndex(String key, RecordHeader newRecord, int currentNumRecords) throws IOException, RecordsFileException {
        super.addEntryToIndex(key, newRecord, currentNumRecords);
        this.memIndex.put(key, newRecord);
    }

    @Override
    protected void deleteEntryFromIndex(String key, RecordHeader header, int currentNumRecords) throws IOException, RecordsFileException {
        super.deleteEntryFromIndex(key, header, currentNumRecords);
        RecordHeader deleted = (RecordHeader)this.memIndex.remove(key);
    }
}

