/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jhplot.io.db.RecordsFileException;

public class RecordHeader {
    protected long dataPointer;
    protected int dataCount;
    protected int dataCapacity;
    protected int indexPosition;

    protected RecordHeader() {
    }

    protected RecordHeader(long dataPointer, int dataCapacity) {
        if (dataCapacity < 1) {
            throw new IllegalArgumentException("Bad record size: " + dataCapacity);
        }
        this.dataPointer = dataPointer;
        this.dataCapacity = dataCapacity;
        this.dataCount = 0;
    }

    protected int getIndexPosition() {
        return this.indexPosition;
    }

    protected void setIndexPosition(int indexPosition) {
        this.indexPosition = indexPosition;
    }

    protected int getDataCapacity() {
        return this.dataCapacity;
    }

    protected int getFreeSpace() {
        return this.dataCapacity - this.dataCount;
    }

    protected void read(DataInput in) throws IOException {
        this.dataPointer = in.readLong();
        this.dataCapacity = in.readInt();
        this.dataCount = in.readInt();
    }

    protected void write(DataOutput out) throws IOException {
        out.writeLong(this.dataPointer);
        out.writeInt(this.dataCapacity);
        out.writeInt(this.dataCount);
    }

    protected static RecordHeader readHeader(DataInput in) throws IOException {
        RecordHeader r = new RecordHeader();
        r.read(in);
        return r;
    }

    protected RecordHeader split() throws RecordsFileException {
        long newFp = this.dataPointer + (long)this.dataCount;
        RecordHeader newRecord = new RecordHeader(newFp, this.getFreeSpace());
        this.dataCapacity = this.dataCount;
        return newRecord;
    }
}

