/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io.db;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import jhplot.io.db.DbByteArrayOutputStream;
import jhplot.io.db.RecordHeader;
import jhplot.io.db.RecordReader;
import jhplot.io.db.RecordWriter;
import jhplot.io.db.RecordsFileException;

public abstract class BaseRecordsFile {
    private RandomAccessFile file;
    protected long dataStartPtr;
    protected static final int FILE_HEADERS_REGION_LENGTH = 16;
    protected static final int RECORD_HEADER_LENGTH = 16;
    protected static final int MAX_KEY_LENGTH = 64;
    protected static final int INDEX_ENTRY_LENGTH = 80;
    protected static final long NUM_RECORDS_HEADER_LOCATION = 0L;
    protected static final long DATA_START_HEADER_LOCATION = 4L;

    protected BaseRecordsFile(String dbPath, int initialSize) throws IOException, RecordsFileException {
        File f = new File(dbPath);
        if (f.exists()) {
            throw new RecordsFileException("Database already exits: " + dbPath);
        }
        this.file = new RandomAccessFile(f, "rw");
        this.dataStartPtr = this.indexPositionToKeyFp(initialSize);
        this.setFileLength(this.dataStartPtr);
        this.writeNumRecordsHeader(0);
        this.writeDataStartPtrHeader(this.dataStartPtr);
    }

    protected BaseRecordsFile(String dbPath, String accessFlags) throws IOException, RecordsFileException {
        File f = new File(dbPath);
        if (!f.exists()) {
            throw new RecordsFileException("Database not found: " + dbPath);
        }
        this.file = new RandomAccessFile(f, accessFlags);
        this.dataStartPtr = this.readDataStartHeader();
    }

    public abstract Enumeration enumerateKeys();

    public abstract int getNumRecords();

    public abstract boolean recordExists(String var1);

    protected abstract RecordHeader keyToRecordHeader(String var1) throws RecordsFileException;

    protected abstract RecordHeader allocateRecord(String var1, int var2) throws RecordsFileException, IOException;

    protected abstract RecordHeader getRecordAt(long var1) throws RecordsFileException;

    protected long getFileLength() throws IOException {
        return this.file.length();
    }

    protected void setFileLength(long l) throws IOException {
        this.file.setLength(l);
    }

    protected int readNumRecordsHeader() throws IOException {
        this.file.seek(0L);
        return this.file.readInt();
    }

    protected void writeNumRecordsHeader(int numRecords) throws IOException {
        this.file.seek(0L);
        this.file.writeInt(numRecords);
    }

    protected long readDataStartHeader() throws IOException {
        this.file.seek(4L);
        return this.file.readLong();
    }

    protected void writeDataStartPtrHeader(long dataStartPtr) throws IOException {
        this.file.seek(4L);
        this.file.writeLong(dataStartPtr);
    }

    protected long indexPositionToKeyFp(int pos) {
        return 16 + 80 * pos;
    }

    long indexPositionToRecordHeaderFp(int pos) {
        return this.indexPositionToKeyFp(pos) + 64L;
    }

    String readKeyFromIndex(int position) throws IOException {
        this.file.seek(this.indexPositionToKeyFp(position));
        return this.file.readUTF();
    }

    RecordHeader readRecordHeaderFromIndex(int position) throws IOException {
        this.file.seek(this.indexPositionToRecordHeaderFp(position));
        return RecordHeader.readHeader(this.file);
    }

    protected void writeRecordHeaderToIndex(RecordHeader header) throws IOException {
        this.file.seek(this.indexPositionToRecordHeaderFp(header.indexPosition));
        header.write(this.file);
    }

    protected void addEntryToIndex(String key, RecordHeader newRecord, int currentNumRecords) throws IOException, RecordsFileException {
        DbByteArrayOutputStream temp = new DbByteArrayOutputStream(64);
        new DataOutputStream(temp).writeUTF(key);
        if (temp.size() > 64) {
            throw new RecordsFileException("Key is larger than permitted size of 64 bytes");
        }
        this.file.seek(this.indexPositionToKeyFp(currentNumRecords));
        temp.writeTo(this.file);
        this.file.seek(this.indexPositionToRecordHeaderFp(currentNumRecords));
        newRecord.write(this.file);
        newRecord.setIndexPosition(currentNumRecords);
        this.writeNumRecordsHeader(currentNumRecords + 1);
    }

    protected void deleteEntryFromIndex(String key, RecordHeader header, int currentNumRecords) throws IOException, RecordsFileException {
        if (header.indexPosition != currentNumRecords - 1) {
            String lastKey = this.readKeyFromIndex(currentNumRecords - 1);
            RecordHeader last = this.keyToRecordHeader(lastKey);
            last.setIndexPosition(header.indexPosition);
            this.file.seek(this.indexPositionToKeyFp(last.indexPosition));
            this.file.writeUTF(lastKey);
            this.file.seek(this.indexPositionToRecordHeaderFp(last.indexPosition));
            last.write(this.file);
        }
        this.writeNumRecordsHeader(currentNumRecords - 1);
    }

    public synchronized void insertRecord(RecordWriter rw) throws RecordsFileException, IOException {
        String key = rw.getKey();
        if (this.recordExists(key)) {
            throw new RecordsFileException("Key exists: " + key);
        }
        this.insureIndexSpace(this.getNumRecords() + 1);
        RecordHeader newRecord = this.allocateRecord(key, rw.getDataLength());
        this.writeRecordData(newRecord, rw);
        this.addEntryToIndex(key, newRecord, this.getNumRecords());
    }

    public synchronized void updateRecord(RecordWriter rw) throws RecordsFileException, IOException {
        RecordHeader header = this.keyToRecordHeader(rw.getKey());
        if (rw.getDataLength() > header.dataCapacity) {
            this.deleteRecord(rw.getKey());
            this.insertRecord(rw);
        } else {
            this.writeRecordData(header, rw);
            this.writeRecordHeaderToIndex(header);
        }
    }

    public synchronized RecordReader readRecord(String key) throws RecordsFileException, IOException {
        byte[] data = this.readRecordData(key);
        return new RecordReader(key, data);
    }

    protected byte[] readRecordData(String key) throws IOException, RecordsFileException {
        return this.readRecordData(this.keyToRecordHeader(key));
    }

    protected byte[] readRecordData(RecordHeader header) throws IOException {
        byte[] buf = new byte[header.dataCount];
        this.file.seek(header.dataPointer);
        this.file.readFully(buf);
        return buf;
    }

    protected void writeRecordData(RecordHeader header, RecordWriter rw) throws IOException, RecordsFileException {
        if (rw.getDataLength() > header.dataCapacity) {
            throw new RecordsFileException("Record data does not fit");
        }
        header.dataCount = rw.getDataLength();
        this.file.seek(header.dataPointer);
        rw.writeTo(this.file);
    }

    protected void writeRecordData(RecordHeader header, byte[] data) throws IOException, RecordsFileException {
        if (data.length > header.dataCapacity) {
            throw new RecordsFileException("Record data does not fit");
        }
        header.dataCount = data.length;
        this.file.seek(header.dataPointer);
        this.file.write(data, 0, data.length);
    }

    public synchronized void deleteRecord(String key) throws RecordsFileException, IOException {
        RecordHeader delRec = this.keyToRecordHeader(key);
        int currentNumRecords = this.getNumRecords();
        if (this.getFileLength() == delRec.dataPointer + (long)delRec.dataCapacity) {
            this.setFileLength(delRec.dataPointer);
        } else {
            RecordHeader previous = this.getRecordAt(delRec.dataPointer - 1L);
            if (previous != null) {
                previous.dataCapacity += delRec.dataCapacity;
                this.writeRecordHeaderToIndex(previous);
            } else {
                RecordHeader secondRecord = this.getRecordAt(delRec.dataPointer + (long)delRec.dataCapacity);
                byte[] data = this.readRecordData(secondRecord);
                secondRecord.dataPointer = delRec.dataPointer;
                secondRecord.dataCapacity += delRec.dataCapacity;
                this.writeRecordData(secondRecord, data);
                this.writeRecordHeaderToIndex(secondRecord);
            }
        }
        this.deleteEntryFromIndex(key, delRec, currentNumRecords);
    }

    protected void insureIndexSpace(int requiredNumRecords) throws RecordsFileException, IOException {
        int currentNumRecords = this.getNumRecords();
        long endIndexPtr = this.indexPositionToKeyFp(requiredNumRecords);
        if (endIndexPtr > this.getFileLength() && currentNumRecords == 0) {
            this.setFileLength(endIndexPtr);
            this.dataStartPtr = endIndexPtr;
            this.writeDataStartPtrHeader(this.dataStartPtr);
            return;
        }
        while (endIndexPtr > this.dataStartPtr) {
            RecordHeader first = this.getRecordAt(this.dataStartPtr);
            byte[] data = this.readRecordData(first);
            first.dataPointer = this.getFileLength();
            int originalFirstDataCapacity = first.dataCapacity;
            first.dataCapacity = data.length;
            this.setFileLength(first.dataPointer + (long)data.length);
            this.writeRecordData(first, data);
            this.writeRecordHeaderToIndex(first);
            this.dataStartPtr += (long)originalFirstDataCapacity;
            this.writeDataStartPtrHeader(this.dataStartPtr);
        }
    }

    public synchronized void close() throws IOException, RecordsFileException {
        try {
            this.file.close();
        }
        finally {
            this.file = null;
        }
    }
}

