/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import jhplot.io.db.RecordReader;
import jhplot.io.db.RecordWriter;
import jhplot.io.db.RecordsFile;
import jhplot.io.db.RecordsFileException;
import jhplot.utils.Util;

public class HDataBase {
    public RecordsFile recordsFile;
    public RecordWriter rw;
    public RecordReader rr;

    public HDataBase(String file, String option) {
        if (option.equalsIgnoreCase("w")) {
            try {
                new File(file).delete();
                this.recordsFile = new RecordsFile(file, 128);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RecordsFileException e) {
                e.printStackTrace();
            }
        } else if (option.equalsIgnoreCase("r")) {
            try {
                this.recordsFile = new RecordsFile(file, "r");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RecordsFileException e) {
                e.printStackTrace();
            }
        } else if (option.equalsIgnoreCase("rw")) {
            try {
                this.recordsFile = new RecordsFile(file, 128);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RecordsFileException e) {
                e.printStackTrace();
            }
        } else {
            this.ErrorMessage("Wrong option!. Only \"r\" or \"w\" or \"rw\" is allowed");
        }
    }

    public synchronized Enumeration getKeys() {
        return this.recordsFile.enumerateKeys();
    }

    public synchronized int getRecords() {
        return this.recordsFile.getNumRecords();
    }

    public synchronized boolean isExists(String key) {
        return this.recordsFile.recordExists(key);
    }

    public HDataBase(String file) {
        try {
            this.recordsFile = new RecordsFile(file, "r");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RecordsFileException e) {
            e.printStackTrace();
        }
    }

    public boolean insert(String key, Object obj) {
        boolean success = true;
        this.rw = new RecordWriter(key);
        try {
            this.rw.writeObject(obj);
            this.recordsFile.insertRecord(this.rw);
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
        }
        catch (RecordsFileException e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    public Object get(String key) {
        Object ob = null;
        try {
            this.rr = this.recordsFile.readRecord(key);
            ob = this.rr.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RecordsFileException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return ob;
    }

    public boolean update(Object ob, String key) {
        boolean success = true;
        this.rw = new RecordWriter(key);
        try {
            this.rw.writeObject(ob);
            this.recordsFile.updateRecord(this.rw);
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
        }
        catch (RecordsFileException e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    public boolean remove(String key) {
        boolean success = true;
        try {
            this.recordsFile.deleteRecord(key);
        }
        catch (RecordsFileException e) {
            success = false;
            e.printStackTrace();
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    public boolean close() {
        boolean success = true;
        try {
            this.recordsFile.close();
        }
        catch (RecordsFileException e) {
            success = false;
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    private void ErrorMessage(String a) {
        Util.ErrorMessage(a);
    }
}

