/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import hep.aida.IAxis;
import hep.aida.ref.histogram.VariableAxis;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import jhplot.F1D;
import jhplot.F2D;
import jhplot.FND;
import jhplot.FPR;
import jhplot.H1D;
import jhplot.H2D;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;
import jhplot.P2D;
import jhplot.PND;
import jhplot.PNI;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;
import jplot.XMLRead;

public class HBook {
    private BufferedReader reader = null;
    private Map<String, Object> map;
    private String description = "JDAT file format";
    private String createdBy = "(jWork) @S.Chekanov";
    private int version = 2;
    private String time = "";
    private final String sep = " ";
    private String file;
    private String option = "r";
    private static int count = 0;
    private DecimalFormat dfb = new DecimalFormat("##.#####E00");

    public HBook(String file, String option) {
        this.file = file;
        this.option = option;
        this.map = new HashMap<String, Object>();
        if (option.equalsIgnoreCase("r")) {
            this.read(file);
        }
    }

    public void setFormat(DecimalFormat dfb) {
        this.dfb = dfb;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public HBook(String file) {
        this(file, "r");
    }

    private void write(String file) {
        Date dat = new Date();
        String today = String.valueOf(dat);
        try {
            FileOutputStream f1 = new FileOutputStream(new File(file));
            PrintStream tx = new PrintStream(f1);
            tx.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            tx.println("<jhepwork>");
            this.setString("created-by", this.createdBy, tx);
            this.setString("created-on", today, tx);
            this.setString("description", this.description, tx);
            this.setInt("version", this.version, tx);
            tx.println("");
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                Object p1;
                String key = entry.getKey();
                Object ob = entry.getValue();
                if (ob instanceof H1D) {
                    H1D h1 = (H1D)ob;
                    this.writeH1D(tx, key, h1);
                    continue;
                }
                if (ob instanceof H2D) {
                    H2D h2 = (H2D)ob;
                    this.writeH2D(tx, key, h2);
                    continue;
                }
                if (ob instanceof P1D) {
                    p1 = (P1D)ob;
                    this.writeP1D(tx, key, (P1D)p1);
                    continue;
                }
                if (ob instanceof P0D) {
                    p1 = (P0D)ob;
                    this.writeP0D(tx, key, (P0D)p1);
                    continue;
                }
                if (ob instanceof P0I) {
                    p1 = (P0I)ob;
                    this.writeP0I(tx, key, (P0I)p1);
                    continue;
                }
                if (ob instanceof PND) {
                    p1 = (PND)ob;
                    this.writePND(tx, key, (PND)p1);
                    continue;
                }
                if (ob instanceof PNI) {
                    p1 = (PNI)ob;
                    this.writePNI(tx, key, (PNI)p1);
                    continue;
                }
                if (ob instanceof F1D) {
                    p1 = (F1D)ob;
                    this.writeF1D(tx, key, (F1D)p1);
                    continue;
                }
                if (ob instanceof F2D) {
                    p1 = (F2D)ob;
                    this.writeF2D(tx, key, (F2D)p1);
                    continue;
                }
                if (ob instanceof FPR) {
                    p1 = (FPR)ob;
                    this.writeFPR(tx, key, (FPR)p1);
                    continue;
                }
                if (ob instanceof FND) {
                    p1 = (FND)ob;
                    this.writeFND(tx, key, (FND)p1);
                    continue;
                }
                if (ob instanceof P2D) {
                    p1 = (P2D)ob;
                    this.writeP2D(tx, key, (P2D)p1);
                    continue;
                }
                if (ob instanceof double[]) {
                    p1 = (double[])ob;
                    this.writeArrayD(tx, key, (double[])p1);
                    continue;
                }
                if (ob instanceof int[]) {
                    p1 = (int[])ob;
                    this.writeArrayI(tx, key, (int[])p1);
                    continue;
                }
                if (ob instanceof double[][]) {
                    p1 = (double[][])ob;
                    this.writeArrayDD(tx, key, (double[][])p1);
                    continue;
                }
                if (!(ob instanceof int[][])) continue;
                p1 = (int[][])ob;
                this.writeArrayII(tx, key, (int[][])p1);
            }
            tx.println("</jhepwork>");
            tx.close();
            f1.close();
        }
        catch (IOException e) {
            Util.ErrorMessage("Error in the output file");
            e.printStackTrace();
        }
    }

    public int getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(String file) {
        if (file.startsWith("http") || file.startsWith("ftp")) {
            URL url = null;
            try {
                url = new URL(file);
                this.reader = new BufferedReader(new InputStreamReader(url.openStream()));
            }
            catch (IOException e) {
                Util.ErrorMessage(e.toString());
            }
        } else {
            try {
                this.reader = new BufferedReader(new FileReader(file));
            }
            catch (FileNotFoundException e) {
                Util.ErrorMessage(e.toString());
            }
        }
        try {
            Object[] snum;
            String line;
            String labely;
            String labelx;
            String line2;
            XMLRead xr = new XMLRead();
            if (!xr.parse(this.reader, "jhepwork")) {
                Util.ErrorMessage("This is not valid jhepwork XML file");
                return;
            }
            this.createdBy = xr.getString("created-by", "NOT SET");
            this.time = xr.getString("created-on", "NOT SET");
            this.description = xr.getString("description", "NOT SET");
            this.version = xr.getInt("version", -1);
            String id = "0";
            int bins = 0;
            int k1 = 0;
            while (xr.open("h1d")) {
                id = xr.getString("id", Integer.toString(k1));
                String stitle = xr.getString("title", "");
                String labelx2 = xr.getString("labelx", "");
                String labely2 = xr.getString("labely", "");
                int isWeighted = xr.getInt("weighted", 0);
                xr.open("x-axis");
                double min = xr.getDouble("min", 0.0);
                double max = xr.getDouble("max", 0.0);
                bins = xr.getInt("bins", 0);
                double underflow = xr.getDouble("underflow", 0.0);
                double overflow = xr.getDouble("overflow", 0.0);
                String sline = xr.getString("variable-bins", " ");
                H1D h1 = null;
                double[] edges = this.getDoubles(sline);
                h1 = edges != null && edges.length > 0 ? new H1D(stitle, edges) : new H1D(stitle, bins, min, max);
                if (labelx2.length() > 0) {
                    h1.setLabelX(labelx2);
                }
                if (labely2.length() > 0) {
                    h1.setLabelY(labely2);
                }
                xr.close();
                xr.hide("x-axis");
                xr.open("stat");
                h1.setNEntries((int)xr.getDouble("all-entries", 0.0));
                h1.setValidEntries((int)xr.getDouble("in-range-entries", 0.0));
                double out_of_range = xr.getDouble("out-of-range-entries", 0.0);
                h1.setMeanAndRms(xr.getDouble("mean", 0.0), xr.getDouble("rms", 0.0));
                xr.close();
                xr.hide("stat");
                xr.open("data");
                Vector<String> data = xr.getData();
                int nn = data.size();
                if (nn != bins) {
                    System.out.println("Not valid H1D histogram definition in XML file");
                    System.out.println("data block has the size=" + nn);
                    System.out.println("but the number of expected bins=" + bins);
                }
                double[] hight = new double[nn + 2];
                double[] errors = new double[nn + 2];
                hight[0] = underflow;
                hight[nn + 1] = overflow;
                errors[0] = underflow;
                errors[nn + 1] = overflow;
                if (isWeighted == 0) {
                    for (int i = 0; i < nn; ++i) {
                        String line3 = data.elementAt(i);
                        double[] d = this.getDoubles(line3);
                        hight[i + 1] = d[0];
                        errors[i + 1] = d[1];
                    }
                    h1.setContents(hight, errors);
                }
                if (isWeighted == 1) {
                    double[] means = new double[nn + 2];
                    double[] rms = new double[nn + 2];
                    int[] entries = new int[nn + 2];
                    entries[0] = 0;
                    entries[nn + 1] = 0;
                    for (int i = 0; i < nn; ++i) {
                        line2 = data.elementAt(i);
                        double[] d = this.getDoubles(line2);
                        hight[i + 1] = d[0];
                        errors[i + 1] = d[1];
                        entries[i + 1] = (int)d[2];
                    }
                    h1.setContents(hight, errors, entries, means, rms);
                }
                xr.close();
                xr.hide("data");
                this.map.put(id, h1);
                xr.close();
                xr.hide("h1d");
            }
            while (xr.open("h2d")) {
                String stitle = xr.getString("title", "NOT SET");
                id = xr.getString("id", Integer.toString(k1));
                labelx = xr.getString("labelx", "");
                labely = xr.getString("labely", "");
                String labelz = xr.getString("labely", "");
                xr.open("x-axis");
                int binsx = xr.getInt("bins", 0);
                double minx = xr.getDouble("min", 0.0);
                double maxx = xr.getDouble("max", 0.0);
                String sline = xr.getString("variable-bins", " ");
                double[] edgesX = null;
                if (sline != null) {
                    edgesX = this.getDoubles(sline);
                }
                xr.hide("x-axis");
                xr.close();
                xr.open("y-axis");
                int binsy = xr.getInt("bins", 0);
                double miny = xr.getDouble("min", 0.0);
                double maxy = xr.getDouble("max", 0.0);
                sline = xr.getString("variable-bins", " ");
                double[] edgesY = null;
                if (sline != null) {
                    edgesY = this.getDoubles(sline);
                }
                xr.hide("y-axis");
                xr.close();
                H2D h2 = null;
                h2 = edgesX != null && edgesX.length > 0 && edgesY != null && edgesY.length > 0 ? new H2D(stitle, edgesX, edgesY) : new H2D(stitle, binsx, minx, maxx, binsy, miny, maxy);
                if (labelx.length() > 0) {
                    h2.setLabelX(labelx);
                }
                if (labely.length() > 0) {
                    h2.setLabelY(labely);
                }
                if (labelz.length() > 0) {
                    h2.setLabelY(labelz);
                }
                xr.open("stat");
                h2.setNEntries((int)xr.getDouble("all-entries", 0.0));
                h2.setValidEntries((int)xr.getDouble("in-range-entries", 0.0));
                h2.setMeanX(xr.getDouble("x-mean", 0.0));
                h2.setRmsX(xr.getDouble("x-rms", 0.0));
                h2.setMeanY(xr.getDouble("y-mean", 0.0));
                h2.setRmsY(xr.getDouble("y-rms", 0.0));
                xr.close();
                xr.hide("stat");
                double[][] hight = new double[binsx + 2][binsy + 2];
                double[][] errors = new double[binsx + 2][binsy + 2];
                xr.open("out-of-range-data");
                Vector<String> outR = xr.getData();
                double[] outr = new double[outR.size()];
                for (int i = 0; i < outR.size(); ++i) {
                    String line4 = outR.elementAt(i);
                    outr[i] = 0.0;
                    try {
                        outr[i] = Double.parseDouble(line4);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                xr.close();
                xr.hide("out-of-range-data");
                hight[0][0] = outr[0];
                hight[binsx + 1][0] = outr[2];
                hight[0][binsy + 1] = outr[6];
                hight[binsx + 1][binsy + 1] = outr[8];
                xr.open("data");
                Vector<String> data = xr.getData();
                for (int i = 0; i < data.size(); ++i) {
                    String line5 = data.elementAt(i);
                    double[] d = this.getDoubles(line5);
                    int j1 = (int)d[0] + 1;
                    int j2 = (int)d[1] + 1;
                    hight[j1][j2] = d[2];
                    errors[j1][j2] = d[3];
                }
                xr.hide("data");
                xr.close();
                h2.setContents(hight, errors);
                this.map.put(id, h2);
                xr.close();
                xr.hide("h2d");
                ++k1;
            }
            while (xr.open("p1d")) {
                String stitle = xr.getString("title", "NONE");
                id = xr.getString("id", Integer.toString(k1));
                labelx = xr.getString("labelx", "");
                labely = xr.getString("labely", "");
                int dim = xr.getInt("dimen", 10);
                P1D p1 = new P1D(stitle, dim);
                if (labelx.length() > 0) {
                    p1.setLabelX(labelx);
                }
                if (labely.length() > 0) {
                    p1.setLabelY(labely);
                }
                xr.open("data");
                Vector<String> pdata = xr.getData();
                for (int i = 0; i < pdata.size(); ++i) {
                    line2 = pdata.elementAt(i);
                    double[] snum2 = this.getDoubles(line2);
                    int ncount = snum2.length;
                    if (ncount == 2) {
                        p1.add(snum2[0], snum2[1]);
                    }
                    if (ncount == 3) {
                        p1.add(snum2[0], snum2[1], snum2[2]);
                    }
                    if (ncount == 4) {
                        p1.add(snum2[0], snum2[1], snum2[2], snum2[3]);
                    }
                    if (ncount == 6) {
                        p1.add(snum2[0], snum2[1], snum2[2], snum2[3], snum2[4], snum2[5]);
                    }
                    if (ncount != 10) continue;
                    p1.add(snum2[0], snum2[1], snum2[2], snum2[3], snum2[4], snum2[5], snum2[6], snum2[7], snum2[8], snum2[9]);
                }
                xr.close();
                xr.hide("data");
                this.map.put(id, p1);
                xr.close();
                xr.hide("p1d");
                ++k1;
            }
            while (xr.open("p0d")) {
                String stitle = xr.getString("title", "NOT SET");
                id = xr.getString("id", Integer.toString(k1));
                int dim = xr.getInt("size", 10);
                P0D p0d = new P0D(stitle);
                xr.open("data");
                Vector<String> pdata = xr.getData();
                for (int i = 0; i < pdata.size(); ++i) {
                    line = pdata.elementAt(i);
                    double[] snum3 = this.getDoubles(line);
                    p0d.setArray(snum3);
                }
                xr.close();
                xr.hide("data");
                this.map.put(id, p0d);
                xr.close();
                xr.hide("p0d");
                ++k1;
            }
            while (xr.open("p0i")) {
                String stitle = xr.getString("title", "NOT SET");
                id = xr.getString("id", Integer.toString(k1));
                int dim = xr.getInt("size", 10);
                P0I p0i = new P0I(stitle);
                xr.open("data");
                Vector<String> pdata = xr.getData();
                for (int i = 0; i < pdata.size(); ++i) {
                    line = pdata.elementAt(i);
                    int[] snum4 = this.getIntegers(line);
                    p0i.setArray(snum4);
                }
                xr.close();
                xr.hide("data");
                this.map.put(id, p0i);
                xr.close();
                xr.hide("p0i");
                ++k1;
            }
            while (xr.open("pnd")) {
                String stitle = xr.getString("title", "NOT SET");
                id = xr.getString("id", Integer.toString(k1));
                int size = xr.getInt("size", 10);
                int dim = xr.getInt("dimen", 10);
                PND pnd = new PND(stitle);
                xr.open("data");
                Vector<String> pdata = xr.getData();
                for (int i = 0; i < pdata.size(); ++i) {
                    String line6 = pdata.elementAt(i);
                    snum = this.getDoubles(line6);
                    pnd.add((double[])snum);
                }
                xr.close();
                xr.hide("data");
                this.map.put(id, pnd);
                xr.close();
                xr.hide("pnd");
                ++k1;
            }
            while (xr.open("p2d")) {
                String stitle = xr.getString("title", "NOT SET");
                id = xr.getString("id", Integer.toString(k1));
                int size = xr.getInt("size", 10);
                int dim = xr.getInt("dimen", 10);
                String labelx3 = xr.getString("labelx", "");
                String labely3 = xr.getString("labely", "");
                String labelz = xr.getString("labelz", "");
                P2D pnd = new P2D(stitle);
                if (labelx3.length() > 0) {
                    pnd.setLabelX(labelx3);
                }
                if (labely3.length() > 0) {
                    pnd.setLabelY(labely3);
                }
                if (labelz.length() > 0) {
                    pnd.setLabelZ(labelz);
                }
                xr.open("data");
                Vector<String> pdata = xr.getData();
                for (int i = 0; i < pdata.size(); ++i) {
                    String line7 = pdata.elementAt(i);
                    double[] snum5 = this.getDoubles(line7);
                    pnd.add(snum5[0], snum5[1], snum5[2]);
                }
                xr.close();
                xr.hide("data");
                this.map.put(id, pnd);
                xr.close();
                xr.hide("p2d");
                ++k1;
            }
            while (xr.open("pni")) {
                String stitle = xr.getString("title", "NOT SET");
                id = xr.getString("id", Integer.toString(k1));
                int size = xr.getInt("size", 10);
                int dim = xr.getInt("dimen", 10);
                PNI pni = new PNI(stitle);
                xr.open("data");
                Vector<String> pdata = xr.getData();
                for (int i = 0; i < pdata.size(); ++i) {
                    String line8 = pdata.elementAt(i);
                    snum = this.getIntegers(line8);
                    pni.add((int[])snum);
                }
                xr.close();
                xr.hide("data");
                this.map.put(id, pni);
                xr.close();
                xr.hide("pni");
                ++k1;
            }
            while (xr.open("array1D")) {
                id = xr.getString("id", Integer.toString(k1));
                xr.open("data");
                Vector<String> pdata = xr.getData();
                double[] d = new double[pdata.size()];
                for (int i = 0; i < pdata.size(); ++i) {
                    String line9 = pdata.elementAt(i);
                    d[i] = Double.parseDouble(line9);
                }
                xr.close();
                xr.hide("data");
                this.map.put(id, d);
                xr.close();
                xr.hide("array1D");
                ++k1;
            }
            while (xr.open("array1I")) {
                id = xr.getString("id", Integer.toString(k1));
                xr.open("data");
                Vector<String> pdata = xr.getData();
                int[] d = new int[pdata.size()];
                for (int i = 0; i < pdata.size(); ++i) {
                    String line10 = pdata.elementAt(i);
                    d[i] = Integer.parseInt(line10);
                }
                xr.close();
                xr.hide("data");
                this.map.put(id, d);
                xr.close();
                xr.hide("array1I");
                ++k1;
            }
            while (xr.open("array2D")) {
                id = xr.getString("id", Integer.toString(k1));
                PND pnd = new PND("array");
                xr.open("data");
                Vector<String> pdata = xr.getData();
                for (int i = 0; i < pdata.size(); ++i) {
                    String line11 = pdata.elementAt(i);
                    double[] snum6 = this.getDoubles(line11);
                    pnd.add(snum6);
                }
                xr.close();
                xr.hide("data");
                this.map.put(id, pnd.getArray());
                xr.close();
                xr.hide("array2D");
                ++k1;
            }
            while (xr.open("array2I")) {
                id = xr.getString("id", Integer.toString(k1));
                PNI pnd = new PNI("array");
                xr.open("data");
                Vector<String> pdata = xr.getData();
                for (int i = 0; i < pdata.size(); ++i) {
                    String line12 = pdata.elementAt(i);
                    int[] snum7 = this.getIntegers(line12);
                    pnd.add(snum7);
                }
                xr.close();
                xr.hide("data");
                this.map.put(id, pnd.getArray());
                xr.close();
                xr.hide("array2I");
                ++k1;
            }
            while (xr.open("f1d")) {
                id = xr.getString("id", Integer.toString(k1));
                String stitle = xr.getString("title", "none");
                String name = xr.getString("name", "none");
                double Xmin = xr.getDouble("min", 0.0);
                double Xmax = xr.getDouble("max", 1.0);
                this.map.put(id, new F1D(stitle, name, Xmin, Xmax));
                xr.close();
                xr.hide("f1d");
                ++k1;
            }
            while (xr.open("f2d")) {
                String stitle = xr.getString("title", "NOT SET");
                id = xr.getString("id", Integer.toString(k1));
                String name = xr.getString("name", "none");
                double minX = xr.getDouble("Xmin", 0.0);
                double maxX = xr.getDouble("Xmax", 1.0);
                double minY = xr.getDouble("Ymin", 0.0);
                double maxY = xr.getDouble("Ymax", 1.0);
                this.map.put(id, new F2D(stitle, name, minX, maxX, minY, maxY));
                xr.close();
                xr.hide("f2d");
                ++k1;
            }
            while (xr.open("fnd")) {
                String stitle = xr.getString("title", "NOT SET");
                id = xr.getString("id", Integer.toString(k1));
                String options = xr.getString("vars", "x");
                this.map.put(id, new FND(stitle, options));
                xr.close();
                xr.hide("fnd");
                ++k1;
            }
            while (xr.open("fpr")) {
                id = xr.getString("id", Integer.toString(k1));
                String stitle = xr.getString("title", "NOT SET");
                String name = xr.getString("name", "x");
                int n1 = xr.getInt("divX", 40);
                int n2 = xr.getInt("divY", 40);
                this.map.put(id, new FPR(stitle, name, n1, n2));
                xr.close();
                xr.hide("fpr");
                ++k1;
            }
            xr.close();
        }
        finally {
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Object get(String id) {
        if (!this.map.containsKey(id)) {
            Util.ErrorMessage("The key = " + id + " was not found!");
            return null;
        }
        return this.map.get(id);
    }

    public String[] getKeys() {
        Iterator<Map.Entry<String, Object>> entries = this.map.entrySet().iterator();
        ArrayList<String> a = new ArrayList<String>();
        while (entries.hasNext()) {
            Map.Entry<String, Object> entry = entries.next();
            String key = entry.getKey();
            a.add(key);
        }
        String[] tmp = a.toArray(new String[a.size()]);
        return tmp;
    }

    public void write(String id, H1D h1d) {
        this.map.put(id, h1d);
    }

    public void write(String id, H2D h2d) {
        this.map.put(id, h2d);
    }

    public void write(String id, P1D p1d) {
        this.map.put(id, p1d);
    }

    public void write(String id, PND pnd) {
        this.map.put(id, pnd);
    }

    public void write(String id, PNI pnd) {
        this.map.put(id, pnd);
    }

    public void write(String id, P0D pnd) {
        this.map.put(id, pnd);
    }

    public void write(String id, P0I pnd) {
        this.map.put(id, pnd);
    }

    public void write(String id, P2D pnd) {
        this.map.put(id, pnd);
    }

    public void write(Object ob) {
        this.write(++count, ob);
    }

    public void write(int id, Object ob) {
        String key = Integer.toString(id);
        if (ob instanceof H1D) {
            this.write(key, (H1D)ob);
        } else if (ob instanceof H2D) {
            this.write(key, (H2D)ob);
        } else if (ob instanceof P1D) {
            this.write(key, (P1D)ob);
        } else if (ob instanceof P0D) {
            this.write(key, (P0D)ob);
        } else if (ob instanceof P0I) {
            this.write(key, (P0I)ob);
        } else if (ob instanceof PND) {
            this.write(key, (PND)ob);
        } else if (ob instanceof P2D) {
            this.write(key, (P2D)ob);
        } else if (ob instanceof PNI) {
            this.write(key, (PNI)ob);
        } else if (ob instanceof F1D) {
            this.write(key, (F1D)ob);
        } else if (ob instanceof FPR) {
            this.write(key, (FPR)ob);
        } else if (ob instanceof F2D) {
            this.write(key, (F2D)ob);
        } else if (ob instanceof FND) {
            this.write(key, (FND)ob);
        } else if (ob instanceof double[]) {
            this.write(key, (double[])ob);
        } else if (ob instanceof int[]) {
            this.write(key, (int[])ob);
        } else if (ob instanceof double[][]) {
            this.write(key, (double[][])ob);
        } else if (ob instanceof int[][]) {
            this.write(key, (int[][])ob);
        } else {
            Util.ErrorMessage("Not supported object!");
        }
    }

    public void write(String id, F1D f1) {
        this.map.put(id, f1);
    }

    public void write(String id, FPR f1) {
        this.map.put(id, f1);
    }

    public void write(String id, F2D f2) {
        this.map.put(id, f2);
    }

    public void write(String id, double[] a) {
        this.map.put(id, a);
    }

    public void write(String id, int[] a) {
        this.map.put(id, a);
    }

    public void write(String id, double[][] a) {
        this.map.put(id, a);
    }

    public void write(String id, int[][] a) {
        this.map.put(id, a);
    }

    public void write(String id, FND a) {
        this.map.put(id, a);
    }

    public void close() {
        if (this.option.equalsIgnoreCase("w")) {
            this.write(this.file);
        }
        this.map.clear();
        this.map = null;
        this.reader = null;
    }

    private double[] getDoubles(String a) {
        a = a.trim();
        StringTokenizer st = new StringTokenizer(a, " ");
        int ncount = st.countTokens();
        double[] d = new double[ncount];
        int m = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            try {
                d[m] = Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++m;
        }
        return d;
    }

    private int[] getIntegers(String a) {
        a = a.trim();
        StringTokenizer st = new StringTokenizer(a, " ");
        int ncount = st.countTokens();
        int[] d = new int[ncount];
        int m = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            try {
                d[m] = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++m;
        }
        return d;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    private void writeH1D(PrintStream tx, String key, H1D h1) {
        int i;
        IAxis axis = h1.getAxis();
        tx.println("<h1d>");
        this.setString("id", key, tx);
        this.setString("title", h1.getTitle(), tx);
        if (h1.getLabelX().length() > 0) {
            this.setString("labelx", h1.getLabelX(), tx);
        }
        if (h1.getLabelY().length() > 0) {
            this.setString("labely", h1.getLabelY(), tx);
        }
        if (h1.getLabelZ().length() > 0) {
            this.setString("labelz", h1.getLabelZ(), tx);
        }
        double w1 = h1.sumAllBinHeights();
        double w2 = h1.allEntries();
        boolean isWeighted = false;
        if (w1 != w2) {
            isWeighted = true;
        }
        this.setBoolean("weighted", isWeighted, tx);
        tx.println("<x-axis>");
        String tmp = " ";
        if (!h1.isFixedBinning()) {
            for (int j = 0; j < h1.getBins(); ++j) {
                tmp = tmp + " " + this.DoubleS(axis.binLowerEdge(j));
            }
            tmp = tmp + " " + axis.binUpperEdge(h1.getBins() - 1);
            this.setString("variable-bins", tmp, tx);
        }
        this.setInt("bins", h1.getBins(), tx);
        this.setDouble("min", h1.getMin(), tx);
        this.setDouble("max", h1.getMax(), tx);
        this.setInt("underflow", h1.getUnderflow(), tx);
        this.setInt("overflow", h1.getOverflow(), tx);
        tx.println("</x-axis>");
        tx.println("<stat>");
        this.setInt("all-entries", h1.allEntries(), tx);
        this.setInt("in-range-entries", h1.entries(), tx);
        this.setInt("out-of-range-entries", h1.extraEntries(), tx);
        this.setDouble("mean", h1.mean(), tx);
        this.setDouble("rms", h1.rms(), tx);
        tx.println("</stat>");
        tx.println("<data>");
        if (isWeighted) {
            for (i = 0; i < h1.getBins(); ++i) {
                tx.println(" " + this.DoubleS(h1.binHeight(i)) + " " + this.DoubleS(h1.binError(i)) + " " + this.IntS(h1.binEntries(i)));
            }
        } else {
            for (i = 0; i < h1.getBins(); ++i) {
                tx.println(" " + this.DoubleS(h1.binHeight(i)) + " " + this.DoubleS(h1.binError(i)));
            }
        }
        tx.println("</data>");
        tx.println("</h1d>");
        tx.println("");
    }

    private void writeH2D(PrintStream tx, String key, H2D h2) {
        int j;
        String tmp;
        tx.println("<h2d>");
        this.setString("id", key, tx);
        this.setString("title", h2.getTitle(), tx);
        if (h2.getLabelX().length() > 0) {
            this.setString("labelx", h2.getLabelX(), tx);
        }
        if (h2.getLabelY().length() > 0) {
            this.setString("labely", h2.getLabelY(), tx);
        }
        if (h2.getLabelZ().length() > 0) {
            this.setString("labelz", h2.getLabelZ(), tx);
        }
        tx.println("<x-axis>");
        this.setInt("bins", h2.getBinsX(), tx);
        this.setDouble("min", h2.getMinX(), tx);
        this.setDouble("max", h2.getMaxX(), tx);
        this.setDouble("underflow", h2.getUnderflowHeightX(), tx);
        this.setDouble("overflow", h2.getOverflowHeightX(), tx);
        if (h2.getAxisX() instanceof VariableAxis) {
            tmp = " ";
            for (j = 0; j < h2.getBinsX(); ++j) {
                tmp = tmp + " " + this.DoubleS(h2.getLowerEdgeX(j));
            }
            tmp = tmp + " " + h2.getUpperEdgeY(h2.getBinsX() - 1);
            this.setString("variable-bins", tmp, tx);
        }
        tx.println("</x-axis>");
        tx.println("<y-axis>");
        this.setInt("bins", h2.getBinsY(), tx);
        this.setDouble("min", h2.getMinY(), tx);
        this.setDouble("max", h2.getMaxY(), tx);
        this.setDouble("underflow", h2.getUnderflowHeightY(), tx);
        this.setDouble("overflow", h2.getOverflowHeightY(), tx);
        if (h2.getAxisY() instanceof VariableAxis) {
            tx.println("<variable-width-bins>");
            tmp = " ";
            for (j = 0; j < h2.getBinsY(); ++j) {
                tmp = tmp + " " + this.DoubleS(h2.getLowerEdgeY(j));
            }
            tmp = tmp + " " + h2.getUpperEdgeY(h2.getBinsY() - 1);
            this.setString("variable-bins", tmp, tx);
        }
        tx.println("</y-axis>");
        double[] outr = new double[9];
        outr[0] = h2.getUnderflowEntriesX() + h2.getUnderflowEntriesY();
        outr[3] = h2.getUnderflowEntriesX();
        outr[6] = h2.getUnderflowEntriesX() + h2.getUnderflowEntriesY();
        outr[0] = h2.getUnderflowEntriesY();
        outr[1] = h2.getUnderflowEntriesY();
        outr[2] = h2.getUnderflowEntriesY() + h2.getOverflowEntriesY();
        outr[6] = h2.getOverflowEntriesY();
        outr[7] = h2.getOverflowEntriesY();
        outr[8] = h2.getOverflowEntriesY() + h2.getOverflowEntriesX();
        outr[4] = h2.getOverflowEntriesX();
        outr[8] = h2.getOverflowEntriesX() + h2.getOverflowEntriesY();
        outr[5] = h2.getOverflowEntriesX();
        tx.println("<out-of-range-data>");
        for (int i = 0; i < 9; ++i) {
            tx.println(" " + this.DoubleS(outr[i]));
        }
        tx.println("</out-of-range-data>");
        tx.println("<stat>");
        this.setInt("all-entries", h2.allEntries(), tx);
        this.setInt("in-range-entries", h2.entries(), tx);
        this.setInt("out-of-range-entries", h2.extraEntries(), tx);
        this.setDouble("all-hights", h2.sumAllBinHeights(), tx);
        this.setDouble("in-range-hights", h2.sumExtraBinHeights() - h2.sumExtraBinHeights(), tx);
        this.setDouble("out-of-range-hights", h2.sumExtraBinHeights(), tx);
        this.setDouble("x-mean", h2.getMeanX(), tx);
        this.setDouble("x-rms", h2.getRmsX(), tx);
        this.setDouble("y-mean", h2.getMeanY(), tx);
        this.setDouble("y-rms", h2.getRmsY(), tx);
        tx.println("</stat>");
        tx.println("<bincontents order=\"xy\">");
        tx.println("  bin,height,error,entries");
        tx.println("</bincontents>");
        tx.println("<data>");
        for (int j1 = 0; j1 < h2.getBinsX(); ++j1) {
            for (int j2 = 0; j2 < h2.getBinsY(); ++j2) {
                tx.println(j1 + " " + j2 + " " + this.DoubleS(h2.binHeight(j1, j2)) + " " + this.DoubleS(h2.binError(j1, j2)) + " " + this.IntS(h2.binEntries(j1, j2)));
            }
        }
        tx.println("</data>");
        tx.println("</h2d>");
        tx.println("");
    }

    private void writeP1D(PrintStream tx, String key, P1D p1) {
        tx.println("<p1d>");
        this.setString("id", key, tx);
        this.setString("title", p1.getTitle(), tx);
        if (p1.getLabelX().length() > 0) {
            this.setString("labelx", p1.getLabelX(), tx);
        }
        if (p1.getLabelY().length() > 0) {
            this.setString("labely", p1.getLabelY(), tx);
        }
        this.setInt("size", p1.size(), tx);
        this.setInt("dimen", p1.dimension(), tx);
        tx.println("<data>");
        for (int i = 0; i < p1.size(); ++i) {
            if (p1.dimension() == 2) {
                tx.println(this.DoubleS(p1.getX(i)) + " " + this.DoubleS(p1.getY(i)));
            }
            if (p1.dimension() == 3) {
                tx.println(this.DoubleS(p1.getX(i)) + " " + this.DoubleS(p1.getY(i)) + " " + this.DoubleS(p1.getYupper(i)));
            }
            if (p1.dimension() == 4) {
                tx.println(p1.getX(i) + " " + p1.getY(i) + " " + p1.getYupper(i) + " " + p1.getYlower(i));
            }
            if (p1.dimension() == 6) {
                tx.println(this.DoubleS(p1.getX(i)) + " " + this.DoubleS(p1.getY(i)) + " " + this.DoubleS(p1.getXleft(i)) + " " + this.DoubleS(p1.getXright(i)) + " " + this.DoubleS(p1.getYupper(i)) + " " + this.DoubleS(p1.getYlower(i)));
            }
            if (p1.dimension() != 10) continue;
            tx.println(this.DoubleS(p1.getX(i)) + " " + this.DoubleS(p1.getY(i)) + " " + this.DoubleS(p1.getXleft(i)) + " " + this.DoubleS(p1.getXright(i)) + " " + this.DoubleS(p1.getYupper(i)) + " " + this.DoubleS(p1.getYlower(i)) + " " + this.DoubleS(p1.getXleftSys(i)) + " " + this.DoubleS(p1.getXrightSys(i)) + " " + this.DoubleS(p1.getYupperSys(i)) + " " + this.DoubleS(p1.getYlowerSys(i)));
        }
        tx.println("</data>");
        tx.println("</p1d>");
        tx.println("");
    }

    private void writeP0D(PrintStream tx, String key, P0D p0d) {
        tx.println("<p0d>");
        this.setString("id", key, tx);
        this.setString("title", p0d.getTitle(), tx);
        this.setInt("size", p0d.size(), tx);
        tx.println("<data>");
        if (p0d.size() > 0) {
            if (p0d.size() > 1) {
                for (int i = 0; i < p0d.size() - 1; ++i) {
                    tx.print(this.DoubleS(p0d.get(i)) + " ");
                }
            }
            tx.println(this.DoubleS(p0d.get(p0d.size() - 1)));
        }
        tx.println("</data>");
        tx.println("</p0d>");
        tx.println("");
    }

    private void writeP0I(PrintStream tx, String key, P0I p0i) {
        tx.println("<p0i>");
        this.setString("id", key, tx);
        this.setString("title", p0i.getTitle(), tx);
        this.setInt("size", p0i.size(), tx);
        tx.println("<data>");
        if (p0i.size() > 0) {
            if (p0i.size() > 1) {
                for (int i = 0; i < p0i.size() - 1; ++i) {
                    tx.print(this.DoubleS(p0i.get(i)) + " ");
                }
            }
            tx.println(this.DoubleS(p0i.get(p0i.size() - 1)));
        }
        tx.println("</data>");
        tx.println("</p0i>");
        tx.println("");
    }

    private void writePND(PrintStream tx, String key, PND pnd) {
        tx.println("<pnd>");
        this.setString("id", key, tx);
        this.setString("title", pnd.getTitle(), tx);
        this.setInt("size", pnd.size(), tx);
        this.setInt("dimen", pnd.getDimension(), tx);
        tx.println("<data>");
        ArrayList<double[]> data = pnd.getArrayList();
        if (data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                double[] tt = data.get(i);
                for (int j = 0; j < tt.length; ++j) {
                    tx.print(this.DoubleS(tt[j]) + " ");
                }
                tx.println("");
            }
        }
        tx.println("</data>");
        tx.println("</pnd>");
        tx.println("");
    }

    private void writePNI(PrintStream tx, String key, PNI pni) {
        tx.println("<pni>");
        this.setString("id", key, tx);
        this.setString("title", pni.getTitle(), tx);
        this.setInt("size", pni.size(), tx);
        this.setInt("dimen", pni.getDimension(), tx);
        tx.println("<data>");
        ArrayList<int[]> data = pni.getArrayList();
        if (data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                int[] tt = data.get(i);
                for (int j = 0; j < tt.length; ++j) {
                    tx.print(this.DoubleS(tt[j]) + " ");
                }
                tx.println("");
            }
        }
        tx.println("</data>");
        tx.println("</pni>");
        tx.println("");
    }

    private void writeF1D(PrintStream tx, String key, F1D p) {
        tx.println("<f1d>");
        this.setString("id", key, tx);
        this.setString("title", p.getTitle(), tx);
        if (p.getLabelX().length() > 0) {
            this.setString("labelx", p.getLabelX(), tx);
        }
        if (p.getLabelY().length() > 0) {
            this.setString("labely", p.getLabelY(), tx);
        }
        this.setString("name", p.getName(), tx);
        this.setDouble("min", p.getMin(), tx);
        this.setDouble("max", p.getMax(), tx);
        tx.println("</f1d>");
        tx.println("");
    }

    private void writeFPR(PrintStream tx, String key, FPR p) {
        tx.println("<fpr>");
        this.setString("id", key, tx);
        this.setString("title", p.getTitle(), tx);
        if (p.getLabelX().length() > 0) {
            this.setString("labelx", p.getLabelX(), tx);
        }
        if (p.getLabelY().length() > 0) {
            this.setString("labely", p.getLabelY(), tx);
        }
        if (p.getLabelZ().length() > 0) {
            this.setString("labelz", p.getLabelZ(), tx);
        }
        this.setString("name", p.getName(), tx);
        this.setInt("divX", p.getDivU(), tx);
        this.setInt("divY", p.getDivV(), tx);
        tx.println("</fpr>");
        tx.println("");
    }

    private void writeF2D(PrintStream tx, String key, F2D p) {
        tx.println("<f2d>");
        this.setString("id", key, tx);
        this.setString("title", p.getTitle(), tx);
        if (p.getLabelX().length() > 0) {
            this.setString("labelx", p.getLabelX(), tx);
        }
        if (p.getLabelY().length() > 0) {
            this.setString("labely", p.getLabelY(), tx);
        }
        if (p.getLabelZ().length() > 0) {
            this.setString("labelz", p.getLabelZ(), tx);
        }
        this.setString("name", p.getName(), tx);
        this.setString("Xmin", this.DoubleS(p.getMinX()), tx);
        this.setString("Xmax", this.DoubleS(p.getMaxX()), tx);
        this.setString("Ymin", this.DoubleS(p.getMinY()), tx);
        this.setString("Ymax", this.DoubleS(p.getMaxY()), tx);
        tx.println("</f2d>");
        tx.println("");
    }

    private void writeFND(PrintStream tx, String key, FND p) {
        tx.println("<fnd>");
        this.setString("id", key, tx);
        this.setString("title", p.getTitle(), tx);
        this.setString("name", p.getName(), tx);
        this.setString("vars", p.getVarString(), tx);
        tx.println("</fnd>");
        tx.println("");
    }

    private void writeP2D(PrintStream tx, String key, P2D pni) {
        tx.println("<p2d>");
        this.setString("id", key, tx);
        this.setString("title", pni.getTitle(), tx);
        if (pni.getLabelX().length() > 0) {
            this.setString("labelx", pni.getLabelX(), tx);
        }
        if (pni.getLabelY().length() > 0) {
            this.setString("labely", pni.getLabelY(), tx);
        }
        if (pni.getLabelZ().length() > 0) {
            this.setString("labelz", pni.getLabelZ(), tx);
        }
        this.setInt("size", pni.size(), tx);
        tx.println("<data>");
        for (int i = 0; i < pni.size(); ++i) {
            tx.println(" " + this.DoubleS(pni.getX(i)) + " " + this.DoubleS(pni.getY(i)) + " " + this.DoubleS(pni.getZ(i)));
        }
        tx.println("</data>");
        tx.println("</p2d>");
        tx.println("");
    }

    private void writeArrayD(PrintStream tx, String key, double[] pni) {
        tx.println("<array1D>");
        this.setString("id", key, tx);
        tx.println("<data>");
        for (int i = 0; i < pni.length; ++i) {
            tx.println(" " + this.DoubleS(pni[i]));
        }
        tx.println("</data>");
        tx.println("</array1D>");
        tx.println("");
    }

    private void writeArrayI(PrintStream tx, String key, int[] pni) {
        tx.println("<array1I>");
        this.setString("id", key, tx);
        tx.println("<data>");
        for (int i = 0; i < pni.length; ++i) {
            tx.println(" " + this.DoubleS(pni[i]));
        }
        tx.println("</data>");
        tx.println("</array1I>");
        tx.println("");
    }

    private void writeArrayDD(PrintStream tx, String key, double[][] array) {
        tx.println("<array2D>");
        this.setString("id", key, tx);
        tx.println("<data>");
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                tx.print(" " + this.DoubleS(array[i][j]));
            }
            tx.println("");
        }
        tx.println("</data>");
        tx.println("</array2D>");
        tx.println("");
    }

    public Map<String, Object> getAll() {
        return this.map;
    }

    public String getTimeCreation() {
        return this.time;
    }

    private void writeArrayII(PrintStream tx, String key, int[][] array) {
        tx.println("<array2I>");
        this.setString("id", key, tx);
        tx.println("<data>");
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                tx.print(" " + this.DoubleS(array[i][j]));
            }
            tx.println("");
        }
        tx.println("</data>");
        tx.println("</array2I>");
        tx.println("");
    }

    private void setString(String key, String data, PrintStream tx) {
        tx.println("<" + key + ">" + data.trim() + "</" + key + ">");
    }

    private void setInt(String key, int data, PrintStream tx) {
        tx.println("<" + key + ">" + this.IntS(data) + "</" + key + ">");
    }

    private void setDouble(String key, Double data, PrintStream tx) {
        tx.println("<" + key + ">" + this.DoubleS(data) + "</" + key + ">");
    }

    private void setBoolean(String key, boolean data, PrintStream tx) {
        tx.println("<" + key + ">" + Boolean.toString(data) + "</" + key + ">");
    }

    private String DoubleS(double d) {
        if (d % 1.0 > 0.0) {
            return this.dfb.format(d);
        }
        return Integer.toString((int)d);
    }

    private String IntS(int d) {
        return Integer.toString(d);
    }
}

