/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import jhplot.H1D;
import jhplot.H2D;
import jhplot.P1D;
import jplot.XMLRead;

public class CFBook {
    private static CFBook instance = null;
    private BufferedReader reader = null;
    private Map<Integer, H1D> mapH1D;
    private Map<Integer, H2D> mapH2D;
    private Map<Integer, P1D> mapP1D;
    private P1D p1;
    private H1D h1;
    private H2D h2;
    private String description;
    private String createdBy = "none";

    public CFBook(String description) {
        this.description = description;
        this.mapH1D = new HashMap<Integer, H1D>();
        this.mapH2D = new HashMap<Integer, H2D>();
        this.mapP1D = new HashMap<Integer, P1D>();
    }

    public CFBook() {
        this("NOT SET");
    }

    public void write(String file) {
        Date dat = new Date();
        String today = String.valueOf(dat);
        try {
            FileOutputStream f1 = new FileOutputStream(new File(file));
            PrintStream tx = new PrintStream(f1);
            tx.println("<jhepwork>");
            tx.println("<created-by>DataMelt. Class CFBook</created-by>");
            tx.println("<created-on>" + today + "</created-on>");
            tx.println("<description>" + this.description + "</description>");
            tx.println("");
            for (Integer key : this.mapH1D.keySet()) {
                this.h1 = this.mapH1D.get(key);
                tx.println("<histogram-h1d>");
                tx.println("<title=\"" + this.h1.getTitle() + "\" id=\"" + ((Object)key).toString() + "\"/>");
                tx.println("<x-axis>");
                tx.println("  <range bins=\"" + this.h1.getBins() + "\" min=\"" + this.h1.getMin() + "\" max=\"" + this.h1.getMax() + "\"/>");
                tx.println("  <out-of-range underflow=\"" + this.h1.getUnderflow() + "\" overflow=\"" + this.h1.getOverflow() + "\"/>");
                tx.println("</x-axis>");
                tx.println("<statistics>");
                tx.println("  <all-entries>" + this.h1.allEntries() + "  </all-entries>");
                tx.println("  <in-range-entries>" + this.h1.entries() + "  </in-range-entries>");
                tx.println("  <out-of-range-entries>" + this.h1.extraEntries() + "  </out-of-range-entries>");
                tx.println("  <mean>" + this.h1.mean() + "  </mean>");
                tx.println("  <rms>" + this.h1.rms() + "  </rms>");
                tx.println("</statistics>");
                tx.println("<bincontents order=\"xLow,xHigh,y\">");
                tx.println("  binLower,binHigh,hight,error,entries");
                tx.println("</bincontents>");
                tx.println("<data>");
                for (int i = 0; i < this.h1.getBins(); ++i) {
                    tx.println(this.h1.binLowerEdge(i) + "," + this.h1.binUpperEdge(i) + "," + this.h1.binHeight(i) + "," + this.h1.binError(i) + "," + this.h1.binEntries(i));
                }
                tx.println("</data>");
                tx.println("</histogram-h1d>");
                tx.println("");
            }
            for (Integer key : this.mapH2D.keySet()) {
                int j;
                this.h2 = this.mapH2D.get(key);
                tx.println("<histogram-h2d>");
                tx.println("<title=\"" + this.h1.getTitle() + "\" id=\"" + ((Object)key).toString() + "\"/>");
                tx.println("<x-axis>");
                tx.println("  <range bins=\"" + this.h2.getBinsX() + "\" min=\"" + this.h2.getMinX() + "\" max=\"" + this.h2.getMaxX() + "\"/>");
                tx.println("  <out-of-range underflow=\"" + this.h2.getUnderflowHeightX() + "\" overflow=\"" + this.h2.getOverflowHeightX() + "\"/>");
                tx.println("<variable-width-bins>");
                for (j = 0; j < this.h2.getBinsX(); ++j) {
                    tx.println(this.h2.getLowerEdgeX(j) + "," + this.h2.getUpperEdgeX(j));
                }
                tx.println("</variable-width-bins>");
                tx.println("</x-axis>");
                tx.println("<y-axis>");
                tx.println("  <range bins=\"" + this.h2.getBinsY() + "\" min=\"" + this.h2.getMinY() + "\" max=\"" + this.h2.getMaxY() + "\"/>");
                tx.println("  <out-of-range underflow=\"" + this.h2.getUnderflowHeightY() + "\" overflow=\"" + this.h2.getOverflowHeightY() + "\"/>");
                tx.println("<variable-width-bins>");
                for (j = 0; j < this.h2.getBinsY(); ++j) {
                    tx.println(this.h2.getLowerEdgeY(j) + "," + this.h2.getUpperEdgeY(j));
                }
                tx.println("</variable-width-bins>");
                tx.println("</y-axis>");
                double[] outr = new double[9];
                outr[0] = this.h2.getUnderflowEntriesX() + this.h2.getUnderflowEntriesY();
                outr[3] = this.h2.getUnderflowEntriesX();
                outr[6] = this.h2.getUnderflowEntriesX() + this.h2.getUnderflowEntriesY();
                outr[0] = this.h2.getUnderflowEntriesY();
                outr[1] = this.h2.getUnderflowEntriesY();
                outr[2] = this.h2.getUnderflowEntriesY() + this.h2.getOverflowEntriesY();
                outr[6] = this.h2.getOverflowEntriesY();
                outr[7] = this.h2.getOverflowEntriesY();
                outr[8] = this.h2.getOverflowEntriesY() + this.h2.getOverflowEntriesX();
                outr[2] = this.h2.getOverflowEntriesX();
                outr[8] = this.h2.getOverflowEntriesX() + this.h2.getOverflowEntriesY();
                outr[5] = this.h2.getOverflowEntriesX();
                tx.println("<out-of-range-data>");
                for (int i = 0; i < 9; ++i) {
                    tx.println(" " + outr[i]);
                }
                tx.println("</out-of-range-data>");
                tx.println("<statistics>");
                tx.println("  <all-entries>" + this.h2.allEntries() + "  </all-entries>");
                tx.println("  <in-range-entries>" + this.h2.entries() + "  </in-range-entries>");
                tx.println("  <out-of-range-entries>" + this.h2.extraEntries() + "  </out-of-range-entries>");
                tx.println("  <all-hights>" + this.h2.sumAllBinHeights() + "  </all-hights>");
                tx.println("  <in-range-hights>" + (this.h2.sumExtraBinHeights() - this.h2.sumExtraBinHeights()) + "  </in-range-hights>");
                tx.println("  <out-of-range-hights>" + this.h2.sumExtraBinHeights() + "  </out-of-range-hights>");
                tx.println("  <x-mean>" + this.h2.getMeanX() + "  </x-mean>");
                tx.println("  <x-rms>" + this.h2.getRmsX() + "  </x-rms>");
                tx.println("  <y-mean>" + this.h2.getMeanY() + "  </y-mean>");
                tx.println("  <y-rms>" + this.h2.getRmsY() + "  </y-rms>");
                tx.println("</statistics>");
                tx.println("<bincontents order=\"xy\">");
                tx.println("  bin,height,error,entries");
                tx.println("</bincontents>");
                tx.println("<data>");
                for (int j1 = 0; j1 < this.h2.getBinsX(); ++j1) {
                    for (int j2 = 0; j2 < this.h2.getBinsY(); ++j2) {
                        tx.println(j1 + "," + j2 + "," + this.h2.binHeight(j1, j2) + "," + this.h2.binError(j1, j2) + "," + this.h2.binEntries(j1, j2));
                    }
                }
                tx.println("</data>");
                tx.println("</histogram-h2d>");
                tx.println("");
            }
            for (Integer key : this.mapP1D.keySet()) {
                this.p1 = this.mapP1D.get(key);
                tx.println("<container-p1d>");
                tx.println("<title=\"" + this.p1.getTitle() + "\" id=\"" + ((Object)key).toString() + "\"/>");
                tx.println("<dimension-p1d>" + this.p1.dimension() + "</dimension-p1d>");
                tx.println("<data>");
                for (int i = 0; i < this.p1.size(); ++i) {
                    if (this.p1.dimension() == 2) {
                        tx.println(this.p1.getX(i) + "," + this.p1.getY(i));
                    }
                    if (this.p1.dimension() == 4) {
                        tx.println(this.p1.getX(i) + "," + this.p1.getY(i) + "," + this.p1.getYupper(i) + "," + this.p1.getYlower(i));
                    }
                    if (this.p1.dimension() == 6) {
                        tx.println(this.p1.getX(i) + "," + this.p1.getY(i) + "," + this.p1.getXleft(i) + "," + this.p1.getXright(i) + "," + this.p1.getYupper(i) + "," + this.p1.getYlower(i));
                    }
                    if (this.p1.dimension() != 10) continue;
                    tx.println(this.p1.getX(i) + "," + this.p1.getY(i) + "," + this.p1.getXleft(i) + "," + this.p1.getXright(i) + "," + this.p1.getYupper(i) + "," + this.p1.getYlower(i) + "," + this.p1.getXleftSys(i) + "," + this.p1.getXrightSys(i) + "," + this.p1.getYupperSys(i) + "," + this.p1.getYlowerSys(i));
                }
                tx.println("</data>");
                tx.println("</container-p1d>");
                tx.println("");
            }
            tx.println("</jhepwork>");
            f1.close();
        }
        catch (IOException e) {
            this.ErrorMessage("Error in the output file");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String file) {
        try {
            String stitle;
            int id;
            this.reader = new BufferedReader(new FileReader(file));
            XMLRead xr = new XMLRead();
            if (!xr.parse(this.reader, "jhepwork")) {
                this.ErrorMessage("This is not valid jhepwork XML file");
                return;
            }
            this.createdBy = xr.getString("created-by", "NOT SET");
            String time_maker = xr.getString("created-on", "NOT SET");
            this.description = xr.getString("description", "NOT SET");
            int bins = 0;
            int k1 = 0;
            while (xr.open("histogram-h1d")) {
                String stitle2 = xr.getString("title", "NOT SET");
                id = xr.getInt("id", 0);
                xr.open("x-axis");
                double min = xr.getDouble("range/min", 0.0);
                double max = xr.getDouble("range/max", 0.0);
                bins = xr.getInt("range/bins", 0);
                double underflow = xr.getDouble("out-of-range/underflow", 0.0);
                double overflow = xr.getDouble("out-of-range/overflow", 0.0);
                this.h1 = new H1D(stitle2, bins, min, max);
                xr.close();
                xr.open("statistic");
                this.h1.setNEntries((int)xr.getDouble("all-entries", 0.0));
                this.h1.setValidEntries((int)xr.getDouble("in-range-entries", 0.0));
                double out_of_range = xr.getDouble("out-of-range-entries", 0.0);
                this.h1.setMeanAndRms(xr.getDouble("mean", 0.0), xr.getDouble("rms", 0.0));
                xr.close();
                xr.open("data");
                Vector<String> data = xr.getData();
                int nn = data.size();
                if (nn != bins) {
                    System.out.println("Not valid H1D histogram definition in XML file");
                    System.out.println("data block has the size=" + nn);
                    System.out.println("but the number of expected bins=" + bins);
                }
                double[] hight = new double[nn + 2];
                double[] errors = new double[nn + 2];
                hight[0] = underflow;
                hight[nn + 1] = overflow;
                for (int i = 0; i < nn; ++i) {
                    String line = data.elementAt(i);
                    double[] d = this.getDoubles(line, ",");
                    hight[i + 1] = d[2];
                    errors[i + 1] = d[3];
                }
                xr.close();
                xr.hide("data");
                this.h1.setContents(hight, errors);
                this.mapH1D.put(id, this.h1);
                xr.close();
                xr.hide("histogram-h1d");
                ++k1;
            }
            int k2 = 0;
            while (xr.open("histogram-h2d")) {
                stitle = xr.getString("title", "NOT SET");
                id = xr.getInt("id", 0);
                xr.open("x-axis");
                int binsx = xr.getInt("range/bins", 0);
                double minx = xr.getDouble("range/min", 0.0);
                double maxx = xr.getDouble("range/max", 0.0);
                xr.open("variable-width-bins");
                Vector<String> dX = xr.getData();
                int nn = dX.size();
                if (nn != binsx) {
                    System.out.println("Not valid 2D histogram definition in XML");
                    System.out.println("data block has the size in X=" + nn);
                    System.out.println("but the number of expected X bins=" + bins);
                }
                double[] xbins1 = new double[nn];
                double[] xbins2 = new double[nn];
                for (int i = 0; i < nn; ++i) {
                    String line = dX.elementAt(i);
                    double[] d = this.getDoubles(line, ",");
                    xbins1[i] = d[0];
                    xbins2[i] = d[1];
                }
                xr.close();
                xr.hide("variable-width-bins");
                xr.close();
                xr.open("y-axis");
                double miny = xr.getDouble("range/min", 0.0);
                double maxy = xr.getDouble("range/max", 0.0);
                int binsy = xr.getInt("range/bins", 0);
                xr.open("variable-width-bins");
                Vector<String> dY = xr.getData();
                nn = dY.size();
                if (nn != binsy) {
                    System.out.println("Not valid 2D histogram definition in XML");
                    System.out.println("data block has the size in Y=" + nn);
                    System.out.println("but the number of expected Y bins=" + bins);
                }
                double[] ybins1 = new double[nn];
                double[] ybins2 = new double[nn];
                for (int i = 0; i < nn; ++i) {
                    String line = dY.elementAt(i);
                    double[] d = this.getDoubles(line, ",");
                    ybins1[i] = d[0];
                    ybins2[i] = d[1];
                }
                xr.close();
                xr.hide("variable-width-bins");
                xr.close();
                this.h2 = new H2D(stitle, binsx, minx, maxx, binsy, miny, maxy);
                xr.open("statistic");
                this.h2.setNEntries((int)xr.getDouble("all-entries", 0.0));
                this.h2.setValidEntries((int)xr.getDouble("in-range-entries", 0.0));
                this.h2.setMeanX(xr.getDouble("x-mean", 0.0));
                this.h2.setRmsX(xr.getDouble("x-rms", 0.0));
                this.h2.setMeanY(xr.getDouble("y-mean", 0.0));
                this.h2.setRmsY(xr.getDouble("y-rms", 0.0));
                xr.close();
                double[][] hight = new double[binsx + 2][binsy + 2];
                double[][] errors = new double[binsx + 2][binsy + 2];
                xr.open("out-of-range-data");
                Vector<String> outR = xr.getData();
                double[] outr = new double[outR.size()];
                for (int i = 0; i < outR.size(); ++i) {
                    String line = outR.elementAt(i);
                    outr[i] = 0.0;
                    try {
                        outr[i] = Double.parseDouble(line);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                xr.close();
                xr.hide("out-of-range-data");
                hight[0][0] = outr[0];
                hight[binsx + 1][0] = outr[2];
                hight[0][binsy + 1] = outr[6];
                hight[binsx + 1][binsy + 1] = outr[8];
                xr.open("data");
                Vector<String> data = xr.getData();
                for (int i = 0; i < data.size(); ++i) {
                    String line = data.elementAt(i);
                    double[] d = this.getDoubles(line, ",");
                    int j1 = (int)d[0] + 1;
                    int j2 = (int)d[1] + 1;
                    hight[j1][j2] = d[2];
                    errors[j1][j2] = d[3];
                }
                xr.hide("data");
                xr.close();
                this.h2.setContents(hight, errors);
                this.mapH2D.put(id, this.h2);
                xr.close();
                xr.hide("histogram-h2d");
                ++k2;
            }
            while (xr.open("container-p1d")) {
                stitle = xr.getString("title", "NOT SET");
                int idd = xr.getInt("id", 0);
                int dim = xr.getInt("dimension-p1d", 10);
                this.p1 = new P1D(stitle, dim);
                xr.open("data");
                Vector<String> pdata = xr.getData();
                for (int i = 0; i < pdata.size(); ++i) {
                    String line = pdata.elementAt(i);
                    double[] snum = this.getDoubles(line, ",");
                    int ncount = snum.length;
                    if (ncount == 2) {
                        this.p1.add(snum[0], snum[1]);
                    }
                    if (ncount == 4) {
                        this.p1.add(snum[0], snum[1], snum[2], snum[3]);
                    }
                    if (ncount == 6) {
                        this.p1.add(snum[0], snum[1], snum[2], snum[3], snum[4], snum[5]);
                    }
                    if (ncount != 10) continue;
                    this.p1.add(snum[0], snum[1], snum[2], snum[3], snum[4], snum[5], snum[6], snum[7], snum[8], snum[9]);
                }
                xr.close();
                xr.hide("data");
                this.mapP1D.put(idd, this.p1);
                xr.close();
                xr.hide("container-p1d");
            }
            xr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public H1D getH1D(int id) {
        if (!this.mapH1D.containsKey(id)) {
            this.ErrorMessage("CFBook: No such H1D key!");
            return null;
        }
        return this.mapH1D.get(id);
    }

    public P1D getP1D(int id) {
        if (!this.mapP1D.containsKey(id)) {
            this.ErrorMessage("CFBook: No such P1D key!");
            return null;
        }
        return this.mapP1D.get(id);
    }

    public String listH1D() {
        String tmp = "";
        if (this.mapH1D.size() > 0) {
            tmp = "\n\nList of all known H1D histograms:\n";
            for (Integer key : this.mapH1D.keySet()) {
                this.h1 = this.mapH1D.get(key);
                tmp = tmp + ((Object)key).toString() + ":  " + this.h1.getTitle() + "\n";
            }
        }
        return tmp;
    }

    public String listP1D() {
        String tmp = "";
        if (this.mapP1D.size() > 0) {
            tmp = "\n\nList of all known P1D containers:\n";
            for (Integer key : this.mapP1D.keySet()) {
                this.p1 = this.mapP1D.get(key);
                tmp = tmp + ((Object)key).toString() + ":  " + this.p1.getTitle() + "\n";
            }
        }
        return tmp;
    }

    public int[] getKeysH1D() {
        Iterator<Integer> keysIt = this.mapH1D.keySet().iterator();
        int[] array = new int[this.mapH1D.size()];
        int jj = 0;
        while (keysIt.hasNext()) {
            Integer key = keysIt.next();
            String skey = ((Object)key).toString();
            array[jj] = this.getInt(skey);
            ++jj;
        }
        return array;
    }

    public int[] getKeysP1D() {
        Iterator<Integer> keysIt = this.mapP1D.keySet().iterator();
        int[] array = new int[this.mapP1D.size()];
        int jj = 0;
        while (keysIt.hasNext()) {
            Integer key = keysIt.next();
            String skey = ((Object)key).toString();
            array[jj] = this.getInt(skey);
            ++jj;
        }
        return array;
    }

    public H1D[] getAllH1D() {
        Iterator<Integer> keysIt = this.mapH1D.keySet().iterator();
        H1D[] array = new H1D[this.mapH1D.size()];
        int jj = 0;
        while (keysIt.hasNext()) {
            Integer key = keysIt.next();
            array[jj] = this.mapH1D.get(key);
            ++jj;
        }
        return array;
    }

    public P1D[] getAllP1D() {
        Iterator<Integer> keysIt = this.mapP1D.keySet().iterator();
        P1D[] array = new P1D[this.mapP1D.size()];
        int jj = 0;
        while (keysIt.hasNext()) {
            Integer key = keysIt.next();
            array[jj] = this.mapP1D.get(key);
            ++jj;
        }
        return array;
    }

    public H2D[] getAllH2D() {
        Iterator<Integer> keysIt = this.mapH2D.keySet().iterator();
        H2D[] array = new H2D[this.mapH2D.size()];
        int jj = 0;
        while (keysIt.hasNext()) {
            Integer key = keysIt.next();
            array[jj] = this.mapH2D.get(key);
            ++jj;
        }
        return array;
    }

    public int[] getKeysH2D() {
        Iterator<Integer> keysIt = this.mapH2D.keySet().iterator();
        int[] array = new int[this.mapH2D.size()];
        int jj = 0;
        while (keysIt.hasNext()) {
            Integer key = keysIt.next();
            String skey = ((Object)key).toString();
            array[jj] = this.getInt(skey);
            ++jj;
        }
        return array;
    }

    public String listH2D() {
        String tmp = "";
        if (this.mapH2D.size() > 0) {
            tmp = "\n\nList of all known H2D histograms:\n";
            for (Integer key : this.mapH2D.keySet()) {
                this.h2 = this.mapH2D.get(key);
                tmp = tmp + ((Object)key).toString() + ":  " + this.h2.getTitle() + "\n";
            }
        }
        return tmp;
    }

    public String listAll() {
        String tmp = "\n\nList of all known H1D histograms:\n";
        tmp = tmp + this.listP1D() + "\n" + this.listH1D() + "\n" + this.listH2D();
        return tmp;
    }

    public H2D getH2D(int id) {
        if (!this.mapH2D.containsKey(id)) {
            this.ErrorMessage("CFBook: No such H2D key!");
            return null;
        }
        return this.mapH2D.get(id);
    }

    public void add(int id, H1D h1d) {
        this.mapH1D.put(id, h1d);
    }

    public void add(int id, H2D h2d) {
        this.mapH2D.put(id, h2d);
    }

    public void add(int id, P1D p1d) {
        this.mapP1D.put(id, p1d);
    }

    private void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }

    private double getValue(String a) {
        double x = 0.0;
        int i1 = (a = a.trim()).lastIndexOf("=");
        if (i1 > -1) {
            String s = a.substring(i1 + 1, a.length());
            try {
                x = Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return x;
    }

    private double getDouble(String a) {
        double d1 = 0.0;
        try {
            d1 = Double.parseDouble(a);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d1;
    }

    private int getInt(String a) {
        int id = 0;
        try {
            id = Integer.parseInt(a);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return id;
    }

    public void clear() {
        this.mapH2D.clear();
        this.mapP1D.clear();
        this.mapH1D.clear();
    }

    private double[] getDoubles(String a, String tok) {
        a = a.trim();
        StringTokenizer st = new StringTokenizer(a, tok);
        int ncount = st.countTokens();
        double[] d = new double[ncount];
        String[] sword = new String[ncount];
        int m = 0;
        while (st.hasMoreTokens()) {
            sword[m] = st.nextToken();
            ++m;
        }
        for (int i = 0; i < m; ++i) {
            try {
                d[i] = Double.parseDouble(sword[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }
}

