/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import hep.aida.IAnalysisFactory;
import hep.aida.IAxis;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.ITree;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.Histogram1D;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jhplot.DrawOptions;
import jhplot.F1D;
import jhplot.H1D;
import jhplot.HTable;
import jhplot.P0D;
import jhplot.VHolder;
import jhplot.gui.HelpBrowser;
import jhplot.io.PReader;
import jhplot.io.Serialized;
import jhplot.math.DoubleArray;
import jhplot.math.ValueErr;
import jhplot.utils.SHisto;
import jhplot.utils.Util;
import jminhep.cluster.DataHolder;
import jminhep.cluster.DataPoint;
import jplot.DataArray;
import jplot.LinePars;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;

public class P1D
extends DrawOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DoubleArrayList X;
    private DoubleArrayList Y;
    private DoubleArrayList XE1left;
    private DoubleArrayList XE1right;
    private DoubleArrayList XE2left;
    private DoubleArrayList XE2right;
    private DoubleArrayList YE1upper;
    private DoubleArrayList YE1down;
    private DoubleArrayList YE2upper;
    private DoubleArrayList YE2down;
    private int dimen;

    public P1D() {
        this("No title");
    }

    public P1D(String title) {
        this.X = new DoubleArrayList();
        this.Y = new DoubleArrayList();
        this.title = title;
        this.lpp.setColor(Color.black);
        this.lpp.setPenWidth(2.0f);
        this.lpp.setType(103);
        this.lpp.setGraphStyle(0);
        this.lpp.setDrawLegend(true);
        this.lpp.setColorErrorsY(Color.black);
        this.lpp.setColorErrorsX(Color.black);
        this.lpp.errorsY(true);
        this.lpp.errorsX(true);
        this.lpp.setGraphStyle(0);
        this.lpp.setSymbol(4);
        this.lpp.setDrawSymbol(true);
        this.lpp.setDrawLine(false);
        this.dimen = 2;
    }

    public P1D(String title, DoubleArrayList Xval, DoubleArrayList Yval) {
        this.X = Xval;
        this.Y = Yval;
        this.title = title;
        this.lpp.setColor(Color.black);
        this.lpp.setPenWidth(2.0f);
        this.lpp.setType(103);
        this.lpp.setGraphStyle(0);
        this.lpp.setDrawLegend(true);
        this.lpp.setColorErrorsY(Color.black);
        this.lpp.setColorErrorsX(Color.black);
        this.lpp.errorsY(true);
        this.lpp.errorsX(true);
        this.lpp.setGraphStyle(0);
        this.lpp.setSymbol(4);
        this.lpp.setDrawSymbol(true);
        this.lpp.setDrawLine(false);
        this.dimen = 2;
    }

    public P1D(String title, int dimension) {
        this(title);
        this.setDimension(dimension);
    }

    public P1D(String title, Color color) {
        this(title);
        this.lpp.setColor(color);
    }

    public P1D(String title, Color color, int symbolstyle) {
        this(title);
        this.lpp.setColor(color);
        this.lpp.setSymbol(symbolstyle);
    }

    public P1D(P0D p1, P0D p2) {
        this(p1.getTitle() + "+" + p2.getTitle());
        this.fill(p1, p2);
    }

    public P1D(String title, P0D p1, P0D p2) {
        this(title);
        this.fill(p1, p2);
    }

    public P1D(Cloud2D c2d) {
        this(c2d.title());
        this.fill(c2d);
    }

    public P1D(String title, double[] p1, double[] p2) {
        this(title);
        this.fill(p1, p2);
    }

    public P1D(String title, int[] p1, int[] p2) {
        this(title);
        this.fill(p1, p2);
    }

    public P1D(String title, P1D p1d) {
        LinePars lnew = this.copyLinePars(p1d.getLineParm());
        this.setDrawOption(lnew);
        this.title = title;
        this.dimen = p1d.dimension();
        this.X = p1d.getXval();
        this.Y = p1d.getYval();
        if (this.dimen == 2) {
            return;
        }
        if (this.dimen == 3) {
            this.YE1upper = p1d.getYE1upper();
            return;
        }
        if (this.dimen == 4) {
            this.YE1upper = p1d.getYE1upper();
            this.YE1down = p1d.getYE1down();
            return;
        }
        if (this.dimen == 6) {
            this.YE1upper = p1d.getYE1upper();
            this.XE1left = p1d.getXE1left();
            this.XE1right = p1d.getXE1right();
            this.YE1down = p1d.getYE1down();
            return;
        }
        if (this.dimen == 10) {
            this.YE1upper = p1d.getYE1upper();
            this.XE1left = p1d.getXE1left();
            this.XE1right = p1d.getXE1right();
            this.YE1down = p1d.getYE1down();
            this.YE2upper = p1d.getYE2upper();
            this.XE2left = p1d.getXE2left();
            this.XE2right = p1d.getXE2right();
            this.YE2down = p1d.getYE2down();
            return;
        }
    }

    public void setDimension(int dimension) {
        if (dimension < 0 || dimension > 10) {
            this.dimen = 2;
        }
        this.YE1upper = null;
        this.YE1down = null;
        this.XE1left = null;
        this.XE2left = null;
        this.XE1right = null;
        this.XE2right = null;
        this.YE2upper = null;
        this.YE2down = null;
        if (dimension == 2) {
            return;
        }
        if (dimension == 3) {
            this.YE1upper = new DoubleArrayList();
            return;
        }
        if (dimension == 4) {
            this.YE1upper = new DoubleArrayList();
            this.YE1down = new DoubleArrayList();
            return;
        }
        if (dimension == 6) {
            this.YE1upper = new DoubleArrayList();
            this.YE1down = new DoubleArrayList();
            this.XE1left = new DoubleArrayList();
            this.XE1right = new DoubleArrayList();
            return;
        }
        if (dimension == 8) {
            this.YE1upper = new DoubleArrayList();
            this.YE1down = new DoubleArrayList();
            this.XE1left = new DoubleArrayList();
            this.XE1right = new DoubleArrayList();
            this.YE2upper = new DoubleArrayList();
            this.YE2down = new DoubleArrayList();
            return;
        }
        if (dimension == 10) {
            this.YE1upper = new DoubleArrayList();
            this.YE1down = new DoubleArrayList();
            this.XE1left = new DoubleArrayList();
            this.XE1right = new DoubleArrayList();
            this.XE2left = new DoubleArrayList();
            this.XE2right = new DoubleArrayList();
            this.YE2upper = new DoubleArrayList();
            this.YE2down = new DoubleArrayList();
            return;
        }
    }

    public LinePars getLinePars() {
        return this.lpp;
    }

    public void setLinePars(LinePars pnew) {
        this.lpp = pnew;
    }

    public P1D(DataHolder dh, String title, int i1, int i2) {
        this(title);
        int dim = dh.getDimention();
        if (i1 > dim || i2 > dim) {
            this.ErrorMessage("index is larger than dimension " + Integer.toString(dim));
            return;
        }
        this.setDimension(2);
        for (int i = 0; i < dh.getSize(); ++i) {
            DataPoint dp = dh.getRow(i);
            double x = dp.getAttribute(i1);
            double y = dp.getAttribute(i2);
            this.X.add(x);
            this.Y.add(y);
        }
    }

    public P1D(DataHolder dh, int i1, int i2) {
        this(dh, dh.getRelation(), i1, i2);
    }

    public P1D(String title, String sfile) {
        this(title);
        this.read(sfile);
    }

    public void toFileAsLatex(String name, DecimalFormat dx, DecimalFormat dy) {
        Date dat = new Date();
        String today = String.valueOf(dat);
        try {
            FileOutputStream f1 = new FileOutputStream(new File(name));
            PrintStream tx = new PrintStream(f1);
            tx.println("% DataMelt: output from P1D " + this.title);
            tx.println("% DataMelt: created at " + today);
            VHolder vh = new VHolder(this);
            String[] names = vh.getNames();
            Double[][] data = vh.getData();
            if (names.length == 3) {
                tx.println("\\begin{tabular}{|c|c|} \\hline");
            }
            if (names.length == 4) {
                tx.println("\\begin{tabular}{|c|c|c|} \\hline");
            }
            if (names.length == 5) {
                tx.println("\\begin{tabular}{|c|c|c|c|c|} \\hline");
            }
            if (names.length == 7) {
                tx.println("\\begin{tabular}{|c|c|c|c|c|c|c|} \\hline");
            }
            if (names.length == 11) {
                tx.println("\\begin{tabular}{|c|c|c|c|c|c|c|c|c|} \\hline");
            }
            for (int i = 0; i < vh.size(); ++i) {
                double yy;
                double[] dd = new double[vh.dimen()];
                for (int k = 0; k < vh.dimen(); ++k) {
                    dd[k] = data[i][k];
                }
                if (names.length == 3) {
                    double xx = dd[1];
                    yy = dd[2];
                    String x = dx.format(xx);
                    String y = dy.format(yy);
                    tx.println(x + " & " + y + "  \\\\ \\hline");
                }
                if (names.length == 4) {
                    double xx = dd[1];
                    yy = dd[2];
                    double ey = dd[3];
                    String x = dx.format(xx);
                    String y = dy.format(yy);
                    String e = dy.format(ey);
                    tx.println(x + " & " + y + " & " + e + "  \\\\ \\hline");
                }
                if (names.length == 5) {
                    double xx = dd[1];
                    yy = dd[2];
                    double yy1 = dd[3];
                    double yy2 = dd[4];
                    String x = dx.format(xx);
                    String y = dy.format(yy);
                    String y1 = dy.format(yy1);
                    String y2 = dy.format(yy2);
                    tx.println("$" + x + "$   &   $" + y + "^{" + y1 + "}_{" + y2 + "}$ \\\\ \\hline");
                }
                if (names.length == 7) {
                    double xx = dd[1];
                    yy = dd[2];
                    double xx1 = dd[3];
                    double xx2 = dd[4];
                    double yy1 = dd[5];
                    double yy2 = dd[6];
                    String x = dx.format(xx);
                    String x1 = dx.format(xx1);
                    String x2 = dx.format(xx2);
                    String y = dy.format(yy);
                    String y1 = dy.format(yy1);
                    String y2 = dy.format(yy2);
                    tx.println("$" + x + "^{" + x1 + "}_{" + x2 + "}$  &  $" + y + "^{" + y1 + "}_{" + y2 + "}$  \\\\ \\hline");
                }
                if (names.length == 9) {
                    double xx = dd[1];
                    yy = dd[2];
                    double xx1 = dd[3];
                    double xx2 = dd[4];
                    double yy1 = dd[5];
                    double yy2 = dd[6];
                    double ys1 = dd[7];
                    double ys2 = dd[8];
                    String x = dx.format(xx);
                    String x1 = dx.format(xx1);
                    String x2 = dx.format(xx2);
                    String y = dy.format(yy);
                    String y1 = dy.format(yy1);
                    String y2 = dy.format(yy2);
                    String y1s = dy.format(ys1);
                    String y2s = dy.format(ys2);
                    tx.println("$" + x + "^{" + x1 + "}_{" + x2 + "}$  &  $" + y + "^{" + y1 + "}_{" + y2 + "}$ (stat.)  $^{" + y1s + "}_{" + y2s + "}$ (syst.)  \\\\ \\hline");
                }
                if (names.length != 11) continue;
                double xx = dd[1];
                yy = dd[2];
                double xx1 = dd[3];
                double xx2 = dd[4];
                double ex1 = dd[5];
                double ex2 = dd[6];
                double yy1 = dd[7];
                double yy2 = dd[8];
                double ys1 = dd[9];
                double ys2 = dd[10];
                String x = dx.format(xx);
                String x1 = dx.format(xx1);
                String x2 = dx.format(xx2);
                String sx1 = dx.format(ex1);
                String sx2 = dx.format(ex2);
                String y = dy.format(yy);
                String y1 = dy.format(yy1);
                String y2 = dy.format(yy2);
                String y1s = dy.format(ys1);
                String y2s = dy.format(ys2);
                tx.println("$" + x + "^{" + x1 + "}_{" + x2 + "}$ (stat.)  $^{" + sx1 + "}_{" + sx2 + "}$ (syst.) &  $" + y + "^{" + y1 + "}_{" + y2 + "}$ (stat.)  $^{" + y1s + "}_{" + y2s + "}$ (syst.)  \\\\ \\hline");
            }
            tx.println("\\end{tabular}");
        }
        catch (IOException e) {
            this.ErrorMessage("Error in the output file");
            e.printStackTrace();
        }
    }

    public void toFile(String name) {
        DecimalFormat dfb = new DecimalFormat("##.#####E00");
        Date dat = new Date();
        String today = String.valueOf(dat);
        try {
            FileOutputStream f1 = new FileOutputStream(new File(name));
            PrintStream tx = new PrintStream(f1);
            tx.println("# DataMelt: output from P1D " + this.title);
            tx.println("# DataMelt: created at " + today);
            tx.println("# x,y,x(left),x(right),y(upper),y(lower),x(leftSys),x(rightSys),y(upperSys),y(lowerSys)");
            tx.println("#");
            for (int i = 0; i < this.size(); ++i) {
                String x = dfb.format(this.X.getQuick(i));
                String y = dfb.format(this.Y.getQuick(i));
                if (this.dimen == 2) {
                    tx.println(x + " " + y);
                    continue;
                }
                String y1 = dfb.format(this.YE1upper.getQuick(i));
                String y2 = dfb.format(this.YE1down.getQuick(i));
                if (this.dimen == 3) {
                    tx.println(x + " " + y + " " + y1);
                    continue;
                }
                if (this.dimen == 4) {
                    tx.println(x + " " + y + " " + y1 + " " + y2);
                    continue;
                }
                String x1 = dfb.format(this.XE1left.getQuick(i));
                String x2 = dfb.format(this.XE1right.getQuick(i));
                if (this.dimen == 6) {
                    tx.println(x + " " + y + " " + x1 + " " + x2 + " " + y1 + " " + y2);
                    continue;
                }
                String x3 = dfb.format(this.getXleftSys(i));
                String x4 = dfb.format(this.getXrightSys(i));
                String y3 = dfb.format(this.getYupperSys(i));
                String y4 = dfb.format(this.getYlowerSys(i));
                tx.println(x + "  " + y + "  " + x1 + "  " + x2 + "  " + y1 + "  " + y2 + "  " + x3 + "  " + x4 + "  " + y3 + "  " + y4);
            }
            f1.close();
        }
        catch (IOException e) {
            this.ErrorMessage("Error in the output file");
            e.printStackTrace();
        }
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        String tmp = "# title=" + this.getTitle() + "  dimension=" + Integer.toString(this.dimension()) + "\n";
        if (this.dimen == 2) {
            tmp = tmp + "#  X       Y \n";
            for (int i = 0; i < this.size(); ++i) {
                tmp = tmp + Double.toString(this.X.getQuick(i)) + "  " + Double.toString(this.Y.getQuick(i)) + "\n";
            }
            return tmp;
        }
        if (this.dimen == 3) {
            tmp = tmp + "#  X       Y     ErrorY (symmetric)\n";
            for (int i = 0; i < this.size(); ++i) {
                tmp = tmp + Double.toString(this.X.getQuick(i)) + " " + Double.toString(this.Y.getQuick(i)) + " " + Double.toString(this.YE1upper.getQuick(i)) + "\n";
            }
            return tmp;
        }
        if (this.dimen == 4) {
            tmp = tmp + "#  X       Y     ErrorY-      ErrorY+ \n";
            for (int i = 0; i < this.size(); ++i) {
                tmp = tmp + Double.toString(this.X.getQuick(i)) + " " + Double.toString(this.Y.getQuick(i)) + " " + Double.toString(this.YE1down.getQuick(i)) + " " + Double.toString(this.YE1upper.getQuick(i)) + "\n";
            }
            return tmp;
        }
        if (this.dimen == 6) {
            tmp = tmp + "#  X       Y     ErrorX-      ErrorY+       ErrorY-      ErrorY+ \n";
            for (int i = 0; i < this.size(); ++i) {
                tmp = tmp + Double.toString(this.X.getQuick(i)) + " " + Double.toString(this.Y.getQuick(i)) + " " + Double.toString(this.XE1left.getQuick(i)) + " " + Double.toString(this.XE1right.getQuick(i)) + " " + Double.toString(this.YE1down.getQuick(i)) + " " + Double.toString(this.YE1upper.getQuick(i)) + "\n";
            }
            return tmp;
        }
        if (this.dimen == 10) {
            tmp = tmp + "#  X       Y     ErrorX-      ErrorY+       ErrorY+      ErrorY-    ErrorSysX-      ErrorSysY+       ErrorSysY-      ErrorSysY+\n";
            for (int i = 0; i < this.size(); ++i) {
                tmp = tmp + Double.toString(this.X.getQuick(i)) + " " + Double.toString(this.Y.getQuick(i)) + " " + Double.toString(this.XE1left.getQuick(i)) + " " + Double.toString(this.XE1right.getQuick(i)) + " " + Double.toString(this.YE1down.getQuick(i)) + " " + Double.toString(this.YE1upper.getQuick(i)) + " " + Double.toString(this.XE2left.getQuick(i)) + " " + Double.toString(this.XE2right.getQuick(i)) + " " + Double.toString(this.YE2down.getQuick(i)) + " " + Double.toString(this.YE2upper.getQuick(i)) + "\n";
            }
            return tmp;
        }
        return tmp;
    }

    public P1D(IDataPointSet pd) {
        this(pd.title());
        this.setDimension(6);
        for (int i = 0; i < pd.size(); ++i) {
            IDataPoint p = pd.point(i);
            double x = p.coordinate(0).value();
            double y = p.coordinate(1).value();
            double x1 = p.coordinate(0).errorPlus();
            double x2 = p.coordinate(0).errorMinus();
            double y1 = p.coordinate(1).errorPlus();
            double y2 = p.coordinate(1).errorMinus();
            this.addQuick(x, y, x2, x1, y2, y1);
        }
    }

    public P1D(String title, H1D histo, boolean binMean, boolean fillXerrors) {
        this(title);
        Histogram1D h1 = histo.get();
        IAxis axis = h1.axis();
        int bins = axis.bins();
        this.clear();
        this.setDimension(6);
        for (int i = 0; i < bins; ++i) {
            double x = axis.binCenter(i);
            double y = h1.binHeight(i);
            if (binMean) {
                y = h1.binMean(i);
            }
            double y1 = h1.binError(i);
            double w = 0.0;
            if (fillXerrors) {
                w = axis.binWidth(i);
            }
            this.add(x, y, 0.5 * w, 0.5 * w, y1, y1);
        }
    }

    public P1D(H1D histo, boolean binMean, boolean fillXerrors) {
        this(histo.getTitle(), histo, binMean, fillXerrors);
        this.dimen = 4;
    }

    public P1D(String title, H1D histo, boolean binMean) {
        this(title, histo, binMean, true);
        this.dimen = 4;
    }

    public P1D(H1D histo, boolean binMean) {
        this(histo.getTitle(), histo, binMean, true);
    }

    public P1D(H1D histo) {
        this(histo.getTitle(), histo, false, true);
    }

    public P1D(String title, H1D histo) {
        this(title, histo, true, true);
    }

    public P1D merge(P1D p1d) {
        this.X.addAllOf(p1d.getXval());
        this.Y.addAllOf(p1d.getYval());
        if (this.dimen == 2) {
            return this;
        }
        if (this.dimen == 3) {
            this.YE1upper.addAllOf(p1d.getYE1upper());
            return this;
        }
        if (this.dimen == 4) {
            this.YE1upper.addAllOf(p1d.getYE1upper());
            this.YE1down.addAllOf(p1d.getYE1down());
            return this;
        }
        if (this.dimen == 6) {
            this.YE1upper.addAllOf(p1d.getYE1upper());
            this.YE1down.addAllOf(p1d.getYE1down());
            this.XE1left.addAllOf(p1d.getXE1left());
            this.XE1right.addAllOf(p1d.getXE1right());
            return this;
        }
        if (this.dimen == 10) {
            this.YE1upper.addAllOf(p1d.getYE1upper());
            this.YE1down.addAllOf(p1d.getYE1down());
            this.XE1left.addAllOf(p1d.getXE1left());
            this.XE1right.addAllOf(p1d.getXE1right());
            this.YE2upper.addAllOf(p1d.getYE2upper());
            this.YE2down.addAllOf(p1d.getYE2down());
            this.XE2left.addAllOf(p1d.getXE2left());
            this.XE2right.addAllOf(p1d.getXE2right());
            return this;
        }
        return this;
    }

    public P1D remove(int position) {
        this.X.remove(position);
        this.Y.remove(position);
        if (this.dimen == 2) {
            return this;
        }
        if (this.dimen == 3) {
            this.YE1upper.remove(position);
            return this;
        }
        if (this.dimen == 4) {
            this.YE1upper.remove(position);
            this.YE1down.remove(position);
            return this;
        }
        if (this.dimen == 6) {
            this.YE1upper.remove(position);
            this.YE1down.remove(position);
            this.XE1left.remove(position);
            this.XE1right.remove(position);
            return this;
        }
        if (this.dimen == 10) {
            this.YE1upper.remove(position);
            this.YE1down.remove(position);
            this.XE1left.remove(position);
            this.XE1right.remove(position);
            this.YE2upper.remove(position);
            this.YE2down.remove(position);
            this.XE2left.remove(position);
            this.XE2right.remove(position);
            return this;
        }
        return this;
    }

    public int hashCode() {
        return this.X.hashCode() + this.Y.hashCode();
    }

    public int indexOf(double valueX, double valueY) {
        int i1 = this.X.indexOf(valueX);
        int i2 = this.Y.indexOf(valueY);
        if (i1 > -1 && i2 > -1 && i1 == i2) {
            return i1;
        }
        return -1;
    }

    public int lastIndexOf(double valueX, double valueY) {
        int i1 = this.X.lastIndexOf(valueX);
        int i2 = this.Y.lastIndexOf(valueY);
        if (i1 > -1 && i2 > -1 && i1 == i2) {
            return i1;
        }
        return -1;
    }

    public int indexOfX(double valueX) {
        return this.X.indexOf(valueX);
    }

    public int lastIndexOfX(double valueX) {
        return this.X.lastIndexOf(valueX);
    }

    public int indexOfY(double valueY) {
        return this.Y.indexOf(valueY);
    }

    public int lastIndexOfY(double valueY) {
        return this.Y.indexOf(valueY);
    }

    public void setDataArray(DataArray data) {
        this.setDimension(10);
        for (int i = 0; i < data.size(); ++i) {
            this.X.add(data.getX(i));
            this.Y.add(data.getY(i));
            this.XE1left.add(data.getX(i));
            this.XE1right.add(data.getY(i));
            this.XE2left.add(data.getXleft(i));
            this.XE2right.add(data.getXright(i));
            this.YE1upper.add(data.getYupper(i));
            this.YE1down.add(data.getYlower(i));
            this.YE2upper.add(data.getYupperSys(i));
            this.YE2down.add(data.getYlowerSys(i));
        }
    }

    public void operScale(int axis, double scale) {
        int i;
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
            return;
        }
        if (axis == 0) {
            for (i = 0; i < this.size(); ++i) {
                this.X.setQuick(i, this.getQuickX(i) * scale);
            }
            if (this.dimen == 6) {
                for (i = 0; i < this.size(); ++i) {
                    this.XE1left.setQuick(i, this.getXleft(i) * scale);
                    this.XE1right.setQuick(i, this.getXright(i) * scale);
                }
            }
            if (this.dimen == 10) {
                for (i = 0; i < this.size(); ++i) {
                    this.XE1left.setQuick(i, this.getXleft(i) * scale);
                    this.XE1right.setQuick(i, this.getXright(i) * scale);
                    this.XE2left.setQuick(i, this.getXleftSys(i) * scale);
                    this.XE2right.setQuick(i, this.getXrightSys(i) * scale);
                }
            }
        }
        if (axis == 1) {
            for (i = 0; i < this.size(); ++i) {
                this.Y.setQuick(i, this.getQuickY(i) * scale);
            }
            if (this.dimen == 3) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, this.getYupper(i) * scale);
                }
            }
            if (this.dimen == 6 || this.dimen == 4) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, this.getYupper(i) * scale);
                    this.YE1down.setQuick(i, this.getYlower(i) * scale);
                }
            }
            if (this.dimen == 10) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, this.getYupper(i) * scale);
                    this.YE1down.setQuick(i, this.getYlower(i) * scale);
                    this.YE2upper.setQuick(i, this.getYupperSys(i) * scale);
                    this.YE2down.setQuick(i, this.getYlowerSys(i) * scale);
                }
            }
        }
    }

    public void setErrToZero(int axis) {
        int i;
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
            return;
        }
        if (axis == 0) {
            if (this.dimen == 6) {
                for (i = 0; i < this.size(); ++i) {
                    this.XE1left.setQuick(i, 0.0);
                    this.XE1right.setQuick(i, 0.0);
                }
            }
            if (this.dimen == 10) {
                for (i = 0; i < this.size(); ++i) {
                    this.XE1left.setQuick(i, 0.0);
                    this.XE1right.setQuick(i, 0.0);
                }
            }
        }
        if (axis == 1) {
            if (this.dimen == 3) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, 0.0);
                }
            }
            if (this.dimen == 6 || this.dimen == 4) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, 0.0);
                    this.YE1down.setQuick(i, 0.0);
                }
            }
            if (this.dimen == 10) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, 0.0);
                    this.YE1down.setQuick(i, 0.0);
                }
            }
        }
    }

    public void setErrAllToZero(String title, int axis) {
        int i;
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
            return;
        }
        if (axis == 0) {
            if (this.dimen == 6) {
                for (i = 0; i < this.size(); ++i) {
                    this.XE1left.setQuick(i, 0.0);
                    this.XE1right.setQuick(i, 0.0);
                }
            }
            if (this.dimen == 10) {
                for (i = 0; i < this.size(); ++i) {
                    this.XE1left.setQuick(i, 0.0);
                    this.XE1right.setQuick(i, 0.0);
                    this.XE2left.setQuick(i, 0.0);
                    this.XE2right.setQuick(i, 0.0);
                }
            }
        }
        if (axis == 1) {
            if (this.dimen == 3) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, 0.0);
                }
            }
            if (this.dimen == 6 || this.dimen == 4) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, 0.0);
                    this.YE1down.setQuick(i, 0.0);
                }
            }
            if (this.dimen == 10) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, 0.0);
                    this.YE1down.setQuick(i, 0.0);
                    this.YE2upper.setQuick(i, 0.0);
                    this.YE2down.setQuick(i, 0.0);
                }
            }
        }
    }

    public void setErrSysToZero(int axis) {
        int i;
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
            return;
        }
        if (axis == 0 && this.dimen == 10) {
            for (i = 0; i < this.size(); ++i) {
                this.XE2left.setQuick(i, 0.0);
                this.XE2right.setQuick(i, 0.0);
            }
        }
        if (axis == 1 && this.dimen == 10) {
            for (i = 0; i < this.size(); ++i) {
                this.YE2upper.setQuick(i, 0.0);
                this.YE2down.setQuick(i, 0.0);
            }
        }
    }

    public void setErrSqrt(int axis) {
        int i;
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
            return;
        }
        if (axis == 0 && this.dimen > 5) {
            for (i = 0; i < this.size(); ++i) {
                this.XE1left.setQuick(i, Math.sqrt(this.X.getQuick(i)));
                this.XE1right.setQuick(i, Math.sqrt(this.X.getQuick(i)));
            }
        }
        if (axis == 1) {
            if (this.dimen == 3) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, Math.sqrt(this.Y.getQuick(i)));
                }
            }
            if (this.dimen > 3) {
                for (i = 0; i < this.size(); ++i) {
                    double e = Math.sqrt(this.Y.getQuick(i));
                    this.YE1upper.setQuick(i, e);
                    this.YE1down.setQuick(i, e);
                }
            }
        }
    }

    public void operScaleErrSys(int axis, double scale) {
        int i;
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
            return;
        }
        if (axis == 0 && this.dimen > 6) {
            for (i = 0; i < this.size(); ++i) {
                this.XE2left.setQuick(i, this.getXleftSys(i) * scale);
                this.XE2right.setQuick(i, this.getXrightSys(i) * scale);
            }
        }
        if (axis == 1 && this.dimen > 6) {
            for (i = 0; i < this.size(); ++i) {
                this.YE1upper.setQuick(i, this.getYupper(i) * scale);
                this.YE1down.setQuick(i, this.getYlower(i) * scale);
                this.YE2upper.setQuick(i, this.getYupperSys(i) * scale);
                this.YE2down.setQuick(i, this.getYlowerSys(i) * scale);
            }
        }
    }

    public void operPlusY(P1D p1) {
        if (this.dimen != p1.getDimension()) {
            this.ErrorMessage("Different dimensions for operPlusY() operation!");
            return;
        }
        if (this.size() != p1.size()) {
            this.ErrorMessage("Different object sizes for operPlusY() operation!");
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            double ylow;
            double yup;
            this.Y.setQuick(i, this.getY(i) + p1.getY(i));
            if (this.dimen == 3) {
                yup = this.getYupper(i) * this.getYupper(i) + p1.getYupper(i) * p1.getYupper(i);
                this.YE1upper.setQuick(i, Math.sqrt(yup));
            }
            if (this.dimen == 4 || this.dimen == 6) {
                yup = this.getYupper(i) * this.getYupper(i) + p1.getYupper(i) * p1.getYupper(i);
                ylow = this.getYlower(i) * this.getYlower(i) + p1.getYlower(i) * p1.getYlower(i);
                this.YE1upper.setQuick(i, Math.sqrt(yup));
                this.YE1down.setQuick(i, Math.sqrt(ylow));
            }
            if (this.dimen <= 6) continue;
            yup = this.getYupper(i) * this.getYupper(i) + p1.getYupper(i) * p1.getYupper(i);
            ylow = this.getYlower(i) * this.getYlower(i) + p1.getYlower(i) * p1.getYlower(i);
            double yupS = this.getYupperSys(i) * this.getYupperSys(i) + p1.getYupperSys(i) * p1.getYupperSys(i);
            double ylowS = this.getYlowerSys(i) * this.getYlowerSys(i) + p1.getYlowerSys(i) * p1.getYlowerSys(i);
            this.YE1upper.setQuick(i, Math.sqrt(yup));
            this.YE1down.setQuick(i, Math.sqrt(ylow));
            this.YE2upper.setQuick(i, Math.sqrt(yupS));
            this.YE2down.setQuick(i, Math.sqrt(ylowS));
        }
    }

    public void operScaleErr(int axis, double scale) {
        int i;
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
            return;
        }
        if (axis == 0) {
            if (this.dimen == 6) {
                for (i = 0; i < this.size(); ++i) {
                    this.XE1left.setQuick(i, this.getXleft(i) * scale);
                    this.XE1right.setQuick(i, this.getXright(i) * scale);
                }
            }
            if (this.dimen == 10) {
                for (i = 0; i < this.size(); ++i) {
                    this.XE1left.setQuick(i, this.getXleft(i) * scale);
                    this.XE1right.setQuick(i, this.getXright(i) * scale);
                    this.XE2left.setQuick(i, this.getXleftSys(i) * scale);
                    this.XE2right.setQuick(i, this.getXrightSys(i) * scale);
                }
            }
        }
        if (axis == 1) {
            if (this.dimen == 3) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, this.getYupper(i) * scale);
                }
            }
            if (this.dimen == 4 || this.dimen == 6) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, this.getYupper(i) * scale);
                    this.YE1down.setQuick(i, this.getYlower(i) * scale);
                }
            }
            if (this.dimen == 10) {
                for (i = 0; i < this.size(); ++i) {
                    this.YE1upper.setQuick(i, this.getYupper(i) * scale);
                    this.YE1down.setQuick(i, this.getYlower(i) * scale);
                    this.YE2upper.setQuick(i, this.getYupperSys(i) * scale);
                    this.YE2down.setQuick(i, this.getYlowerSys(i) * scale);
                }
            }
        }
    }

    public P1D operErrSys(String title, int axis, P1D left, P1D right) {
        this.title = title;
        if (this.size() != left.size() || this.size() != right.size()) {
            this.ErrorMessage("Wrong size!");
            return this;
        }
        return this;
    }

    public int oper(P1D a, String what) {
        return this.oper(a, this.getTitle(), what);
    }

    public int oper(P1D a, String title, String what) {
        what = what.trim();
        if (this.size() != a.size()) {
            this.ErrorMessage("Sizes of the P1Ds are different!");
            return 1;
        }
        if (!what.equals("+") && !what.equals("-") && !what.equals("/") && what.equals("/")) {
            this.ErrorMessage("Operation \"" + what + "\" is not implemented");
            return 1;
        }
        if (this.dimen == 2) {
            if (what.equals("+")) {
                for (int i = 0; i < this.size(); ++i) {
                    this.Y.setQuick(i, this.Y.getQuick(i) + a.getY(i));
                }
                return 0;
            }
            if (what.equals("-")) {
                for (int i = 0; i < this.size(); ++i) {
                    this.Y.setQuick(i, this.Y.getQuick(i) - a.getY(i));
                }
                return 0;
            }
            if (what.equals("*")) {
                for (int i = 0; i < this.size(); ++i) {
                    this.Y.setQuick(i, this.Y.getQuick(i) * a.getY(i));
                }
                return 0;
            }
            if (what.equals("/")) {
                for (int i = 0; i < this.size(); ++i) {
                    if (a.getY(i) == 0.0) {
                        return 1;
                    }
                    this.Y.setQuick(i, this.Y.getQuick(i) / a.getY(i));
                }
                return 0;
            }
        }
        if (this.dimen == 3) {
            if (what.equals("+")) {
                for (int i = 0; i < this.size(); ++i) {
                    this.Y.setQuick(i, this.Y.getQuick(i) + a.getY(i));
                    double y = Math.sqrt(a.getYupper(i) * a.getYupper(i) + a.getYupper(i) * a.getYupper(i));
                    this.YE1upper.setQuick(i, y);
                }
                return 0;
            }
            if (what.equals("-")) {
                for (int i = 0; i < this.size(); ++i) {
                    this.Y.setQuick(i, this.Y.getQuick(i) - a.getY(i));
                    double y = Math.sqrt(a.getYupper(i) * a.getYupper(i) + a.getYupper(i) * a.getYupper(i));
                    this.YE1upper.setQuick(i, y);
                }
                return 0;
            }
            if (what.equals("*")) {
                for (int i = 0; i < this.size(); ++i) {
                    double y = this.Y.getQuick(i) * a.getY(i);
                    this.Y.setQuick(i, y);
                    double ad1 = a.getY(i);
                    double d1 = this.getY(i);
                    double ax1 = ad1 != 0.0 ? a.getYupper(i) / ad1 : 0.0;
                    double x1 = d1 != 0.0 ? this.getYupper(i) / d1 : 0.0;
                    double e = y * Math.sqrt(ax1 * ax1 + x1 * x1);
                    this.YE1upper.setQuick(i, e);
                }
                return 0;
            }
            if (what.equals("/")) {
                for (int i = 0; i < this.size(); ++i) {
                    double y = this.Y.getQuick(i) / a.getY(i);
                    this.Y.setQuick(i, y);
                    double ad1 = a.getY(i);
                    double d1 = this.getY(i);
                    double ax1 = ad1 != 0.0 ? a.getYupper(i) / ad1 : 0.0;
                    double x1 = d1 != 0.0 ? this.getYupper(i) / d1 : 0.0;
                    double e = y * Math.sqrt(ax1 * ax1 + x1 * x1);
                    this.YE1upper.setQuick(i, e);
                }
                return 0;
            }
        }
        if (this.dimen > 3) {
            if (what.equals("+")) {
                for (int i = 0; i < this.size(); ++i) {
                    this.Y.setQuick(i, this.Y.getQuick(i) + a.getY(i));
                    double yU = Math.sqrt(a.getYupper(i) * a.getYupper(i) + a.getYupper(i) * a.getYupper(i));
                    double yD = Math.sqrt(a.getYlower(i) * a.getYlower(i) + a.getYlower(i) * a.getYlower(i));
                    this.YE1upper.setQuick(i, yU);
                    this.YE1down.setQuick(i, yD);
                }
                return 0;
            }
            if (what.equals("-")) {
                for (int i = 0; i < this.size(); ++i) {
                    this.Y.setQuick(i, this.Y.getQuick(i) - a.getY(i));
                    double yU = Math.sqrt(a.getYupper(i) * a.getYupper(i) + a.getYupper(i) * a.getYupper(i));
                    double yD = Math.sqrt(a.getYlower(i) * a.getYlower(i) + a.getYlower(i) * a.getYlower(i));
                    this.YE1upper.setQuick(i, yU);
                    this.YE1down.setQuick(i, yD);
                }
                return 0;
            }
            if (what.equals("*")) {
                for (int i = 0; i < this.size(); ++i) {
                    double y = this.Y.getQuick(i) * a.getY(i);
                    this.Y.setQuick(i, y);
                    double ad1 = a.getY(i);
                    double d1 = this.getY(i);
                    double ax1 = ad1 != 0.0 ? a.getYupper(i) / ad1 : 0.0;
                    double x1 = d1 != 0.0 ? this.getYupper(i) / d1 : 0.0;
                    double e1 = y * Math.sqrt(ax1 * ax1 + x1 * x1);
                    this.YE1upper.setQuick(i, e1);
                    double ad2 = a.getY(i);
                    double d2 = this.getY(i);
                    double ax2 = ad2 != 0.0 ? a.getYlower(i) / ad2 : 0.0;
                    double x2 = d2 != 0.0 ? this.getYlower(i) / d2 : 0.0;
                    double e2 = y * Math.sqrt(ax2 * ax2 + x2 * x2);
                    this.YE1down.setQuick(i, e2);
                }
                return 0;
            }
            if (what.equals("/")) {
                for (int i = 0; i < this.size(); ++i) {
                    double y = this.Y.getQuick(i) / a.getY(i);
                    this.Y.setQuick(i, y);
                    double ad1 = a.getY(i);
                    double d1 = this.getY(i);
                    double ax1 = ad1 != 0.0 ? a.getYupper(i) / ad1 : 0.0;
                    double x1 = d1 != 0.0 ? this.getYupper(i) / d1 : 0.0;
                    double e1 = y * Math.sqrt(ax1 * ax1 + x1 * x1);
                    this.YE1upper.setQuick(i, e1);
                    double ad2 = a.getY(i);
                    double d2 = this.getY(i);
                    double ax2 = 0.0;
                    if (ad2 != 0.0) {
                        ax2 = a.getYlower(i) / ad2;
                    } else {
                        ax1 = 0.0;
                    }
                    double x2 = d2 != 0.0 ? this.getYlower(i) / d2 : 0.0;
                    double e2 = y * Math.sqrt(ax2 * ax2 + x2 * x2);
                    this.YE1down.setQuick(i, e2);
                }
                return 0;
            }
        }
        return 1;
    }

    public P1D oper(P1D a, String title, String what, String how, P1D corr) {
        double yls;
        double yus;
        double yls2;
        double yus2;
        double yl;
        double yu;
        double y;
        double xrs;
        double xls;
        double xr;
        double xl;
        double yl2;
        double[] cc;
        ValueErr[] erros2;
        double yu2;
        double yu3;
        double y2;
        int i;
        double[] cc2;
        ValueErr[] erros22;
        ValueErr[] erros1;
        int NT;
        ValueErr tmp;
        what = what.trim();
        if (this.size() != a.size()) {
            this.ErrorMessage("Sizes of the P1Ds are different!");
            return this;
        }
        if (this.size() != corr.size()) {
            this.ErrorMessage("Sizes of the P1D and P1D with correlations are different!");
            return this;
        }
        if (!(what.equals("+") || what.equals("-") || what.equals("*") || what.equals("*"))) {
            this.ErrorMessage("Operation \"" + what + "\" is not implemented");
            return this;
        }
        if (this.dimension() == 3) {
            tmp = new ValueErr();
            NT = 8;
            erros1 = new ValueErr[8];
            erros22 = new ValueErr[8];
            cc2 = new double[8];
            for (i = 0; i < this.size(); ++i) {
                int j;
                erros1[0] = new ValueErr(this.getX(i), 0.0);
                erros1[1] = new ValueErr(this.getX(i), 0.0);
                erros1[2] = new ValueErr(this.getX(i), 0.0);
                erros1[3] = new ValueErr(this.getX(i), 0.0);
                erros1[4] = new ValueErr(this.getY(i), this.getYupper(i));
                erros1[5] = new ValueErr(this.getY(i), 0.0);
                erros1[6] = new ValueErr(this.getY(i), 0.0);
                erros1[7] = new ValueErr(this.getY(i), 0.0);
                erros22[0] = new ValueErr(a.getX(i), 0.0);
                erros22[1] = new ValueErr(a.getX(i), 0.0);
                erros22[2] = new ValueErr(a.getX(i), 0.0);
                erros22[3] = new ValueErr(a.getX(i), 0.0);
                erros22[4] = new ValueErr(a.getY(i), a.getYupper(i));
                erros22[5] = new ValueErr(a.getY(i), 0.0);
                erros22[6] = new ValueErr(a.getY(i), 0.0);
                erros22[7] = new ValueErr(a.getY(i), 0.0);
                cc2[0] = 0.0;
                cc2[1] = 0.0;
                cc2[2] = 0.0;
                cc2[3] = 0.0;
                cc2[4] = corr.getYupper(i);
                cc2[5] = 0.0;
                cc2[6] = 0.0;
                cc2[7] = 0.0;
                if (what.equals("+")) {
                    for (j = 0; j < 8; ++j) {
                        erros1[j] = tmp.plus(erros1[j], erros22[j], cc2[j]);
                    }
                }
                if (what.equals("-")) {
                    for (j = 0; j < 8; ++j) {
                        erros1[j] = tmp.minus(erros1[j], erros22[j], cc2[j]);
                    }
                }
                if (what.equals("*")) {
                    for (j = 0; j < 8; ++j) {
                        erros1[j] = tmp.times(erros1[j], erros22[j], cc2[j]);
                    }
                }
                if (what.equals("/")) {
                    for (j = 0; j < 8; ++j) {
                        erros1[j] = tmp.divide(erros1[j], erros22[j], cc2[j]);
                    }
                }
                if (how.equalsIgnoreCase("XY") || how.equalsIgnoreCase("YX")) {
                    double x = erros1[0].getVal();
                    y2 = erros1[4].getVal();
                    yu3 = erros1[4].getErr();
                    this.setQuick(i, x, y2, yu3);
                }
                if (!how.equalsIgnoreCase("Y")) continue;
                double y3 = erros1[4].getVal();
                yu2 = erros1[4].getErr();
                this.setQuick(i, this.getX(i), y3, yu2);
            }
        }
        if (this.dimension() == 4) {
            int NT2 = 8;
            ValueErr[] erros12 = new ValueErr[8];
            erros2 = new ValueErr[8];
            cc = new double[8];
            for (int i2 = 0; i2 < this.size(); ++i2) {
                erros12[0] = new ValueErr(this.getX(i2), 0.0);
                erros12[1] = new ValueErr(this.getX(i2), 0.0);
                erros12[2] = new ValueErr(this.getX(i2), 0.0);
                erros12[3] = new ValueErr(this.getX(i2), 0.0);
                erros12[4] = new ValueErr(this.getY(i2), this.getYupper(i2));
                erros12[5] = new ValueErr(this.getY(i2), this.getYlower(i2));
                erros12[6] = new ValueErr(this.getY(i2), 0.0);
                erros12[7] = new ValueErr(this.getY(i2), 0.0);
                erros2[0] = new ValueErr(a.getX(i2), 0.0);
                erros2[1] = new ValueErr(a.getX(i2), 0.0);
                erros2[2] = new ValueErr(a.getX(i2), 0.0);
                erros2[3] = new ValueErr(a.getX(i2), 0.0);
                erros2[4] = new ValueErr(a.getY(i2), a.getYupper(i2));
                erros2[5] = new ValueErr(a.getY(i2), a.getYlower(i2));
                erros2[6] = new ValueErr(a.getY(i2), 0.0);
                erros2[7] = new ValueErr(a.getY(i2), 0.0);
                cc[0] = 0.0;
                cc[1] = 0.0;
                cc[2] = 0.0;
                cc[3] = 0.0;
                cc[4] = corr.getYupper(i2);
                cc[5] = corr.getYlower(i2);
                cc[6] = 0.0;
                cc[7] = 0.0;
                ValueErr tmp2 = new ValueErr();
                if (what.equals("+")) {
                    for (int j = 0; j < 8; ++j) {
                        erros12[j] = tmp2.plus(erros12[j], erros2[j], cc[j]);
                    }
                }
                if (what.equals("-")) {
                    for (int j = 0; j < 8; ++j) {
                        erros12[j] = tmp2.minus(erros12[j], erros2[j], cc[j]);
                    }
                }
                if (what.equals("*")) {
                    for (int j = 0; j < 8; ++j) {
                        erros12[j] = tmp2.times(erros12[j], erros2[j], cc[j]);
                    }
                }
                if (what.equals("/")) {
                    for (int j = 0; j < 8; ++j) {
                        erros12[j] = tmp2.divide(erros12[j], erros2[j], cc[j]);
                    }
                }
                if (how.equalsIgnoreCase("XY") || how.equalsIgnoreCase("YX")) {
                    double x = erros12[0].getVal();
                    y2 = erros12[4].getVal();
                    yu3 = erros12[4].getErr();
                    double yl3 = erros12[5].getErr();
                    this.setQuick(i2, x, y2, yu3, yl3);
                }
                if (!how.equalsIgnoreCase("Y")) continue;
                double y4 = erros12[4].getVal();
                yu2 = erros12[4].getErr();
                yl2 = erros12[5].getErr();
                this.setQuick(i2, this.getX(i2), y4, yu2, yl2);
            }
        }
        if (this.dimension() == 6) {
            int NT3 = 8;
            ValueErr[] erros13 = new ValueErr[8];
            erros2 = new ValueErr[8];
            cc = new double[8];
            for (int i3 = 0; i3 < this.size(); ++i3) {
                erros13[0] = new ValueErr(this.getX(i3), this.getXleft(i3));
                erros13[1] = new ValueErr(this.getX(i3), this.getXright(i3));
                erros13[2] = new ValueErr(this.getX(i3), 0.0);
                erros13[3] = new ValueErr(this.getX(i3), 0.0);
                erros13[4] = new ValueErr(this.getY(i3), this.getYupper(i3));
                erros13[5] = new ValueErr(this.getY(i3), this.getYlower(i3));
                erros13[6] = new ValueErr(this.getY(i3), 0.0);
                erros13[7] = new ValueErr(this.getY(i3), 0.0);
                erros2[0] = new ValueErr(a.getX(i3), a.getXleft(i3));
                erros2[1] = new ValueErr(a.getX(i3), a.getXright(i3));
                erros2[2] = new ValueErr(a.getX(i3), 0.0);
                erros2[3] = new ValueErr(a.getX(i3), 0.0);
                erros2[4] = new ValueErr(a.getY(i3), a.getYupper(i3));
                erros2[5] = new ValueErr(a.getY(i3), a.getYlower(i3));
                erros2[6] = new ValueErr(a.getY(i3), 0.0);
                erros2[7] = new ValueErr(a.getY(i3), 0.0);
                cc[0] = corr.getXleft(i3);
                cc[1] = corr.getXright(i3);
                cc[2] = 0.0;
                cc[3] = 0.0;
                cc[4] = corr.getYupper(i3);
                cc[5] = corr.getYlower(i3);
                cc[6] = 0.0;
                cc[7] = 0.0;
                ValueErr tmp3 = new ValueErr();
                if (what.equals("+")) {
                    for (int j = 0; j < 8; ++j) {
                        erros13[j] = tmp3.plus(erros13[j], erros2[j], cc[j]);
                    }
                }
                if (what.equals("-")) {
                    for (int j = 0; j < 8; ++j) {
                        erros13[j] = tmp3.minus(erros13[j], erros2[j], cc[j]);
                    }
                }
                if (what.equals("*")) {
                    for (int j = 0; j < 8; ++j) {
                        erros13[j] = tmp3.times(erros13[j], erros2[j], cc[j]);
                    }
                }
                if (what.equals("/")) {
                    for (int j = 0; j < 8; ++j) {
                        erros13[j] = tmp3.divide(erros13[j], erros2[j], cc[j]);
                    }
                }
                if (how.equalsIgnoreCase("XY") || how.equalsIgnoreCase("YX")) {
                    double x = erros13[0].getVal();
                    xl = erros13[0].getErr();
                    xr = erros13[1].getErr();
                    xls = erros13[2].getErr();
                    xrs = erros13[3].getErr();
                    y = erros13[4].getVal();
                    yu = erros13[4].getErr();
                    yl = erros13[5].getErr();
                    yus2 = erros13[6].getErr();
                    yls2 = erros13[7].getErr();
                    this.setQuick(i3, x, y, xl, xr, yu, yl);
                }
                if (how.equalsIgnoreCase("X")) {
                    double x = erros13[0].getVal();
                    xl = erros13[0].getErr();
                    xr = erros13[1].getErr();
                    xls = erros13[2].getErr();
                    xrs = erros13[3].getErr();
                    this.setQuick(i3, x, this.getY(i3), xl, xr, this.getYupper(i3), this.getYlower(i3), xls, xrs, this.getYupperSys(i3), this.getYlowerSys(i3));
                }
                if (!how.equalsIgnoreCase("Y")) continue;
                double y5 = erros13[4].getVal();
                yu2 = erros13[4].getErr();
                yl2 = erros13[5].getErr();
                yus = erros13[6].getErr();
                yls = erros13[7].getErr();
                this.setQuick(i3, this.getX(i3), y5, this.getXleft(i3), this.getXright(i3), yu2, yl2);
            }
        }
        if (this.dimension() == 10) {
            tmp = new ValueErr();
            NT = 8;
            erros1 = new ValueErr[8];
            erros22 = new ValueErr[8];
            cc2 = new double[8];
            for (i = 0; i < this.size(); ++i) {
                erros1[0] = new ValueErr(this.getX(i), this.getXleft(i));
                erros1[1] = new ValueErr(this.getX(i), this.getXright(i));
                erros1[2] = new ValueErr(this.getX(i), this.getXleftSys(i));
                erros1[3] = new ValueErr(this.getX(i), this.getXrightSys(i));
                erros1[4] = new ValueErr(this.getY(i), this.getYupper(i));
                erros1[5] = new ValueErr(this.getY(i), this.getYlower(i));
                erros1[6] = new ValueErr(this.getY(i), this.getYupperSys(i));
                erros1[7] = new ValueErr(this.getY(i), this.getYlowerSys(i));
                erros22[0] = new ValueErr(a.getX(i), a.getXleft(i));
                erros22[1] = new ValueErr(a.getX(i), a.getXright(i));
                erros22[2] = new ValueErr(a.getX(i), a.getXleftSys(i));
                erros22[3] = new ValueErr(a.getX(i), a.getXrightSys(i));
                erros22[4] = new ValueErr(a.getY(i), a.getYupper(i));
                erros22[5] = new ValueErr(a.getY(i), a.getYlower(i));
                erros22[6] = new ValueErr(a.getY(i), a.getYupperSys(i));
                erros22[7] = new ValueErr(a.getY(i), a.getYlowerSys(i));
                cc2[0] = corr.getXleft(i);
                cc2[1] = corr.getXright(i);
                cc2[2] = corr.getXleftSys(i);
                cc2[3] = corr.getXrightSys(i);
                cc2[4] = corr.getYupper(i);
                cc2[5] = corr.getYlower(i);
                cc2[6] = corr.getYupperSys(i);
                cc2[7] = corr.getYlowerSys(i);
                if (what.equals("+")) {
                    for (int j = 0; j < 8; ++j) {
                        erros1[j] = tmp.plus(erros1[j], erros22[j], cc2[j]);
                    }
                }
                if (what.equals("-")) {
                    for (int j = 0; j < 8; ++j) {
                        erros1[j] = tmp.minus(erros1[j], erros22[j], cc2[j]);
                    }
                }
                if (what.equals("*")) {
                    for (int j = 0; j < 8; ++j) {
                        erros1[j] = tmp.times(erros1[j], erros22[j], cc2[j]);
                    }
                }
                if (what.equals("/")) {
                    for (int j = 0; j < 8; ++j) {
                        erros1[j] = tmp.divide(erros1[j], erros22[j], cc2[j]);
                    }
                }
                if (how.equalsIgnoreCase("XY") || how.equalsIgnoreCase("YX")) {
                    double x = erros1[0].getVal();
                    xl = erros1[0].getErr();
                    xr = erros1[1].getErr();
                    xls = erros1[2].getErr();
                    xrs = erros1[3].getErr();
                    y = erros1[4].getVal();
                    yu = erros1[4].getErr();
                    yl = erros1[5].getErr();
                    yus2 = erros1[6].getErr();
                    yls2 = erros1[7].getErr();
                    this.setQuick(i, x, y, xl, xr, yu, yl, xls, xrs, yus2, yls2);
                }
                if (how.equalsIgnoreCase("X")) {
                    double x = erros1[0].getVal();
                    xl = erros1[0].getErr();
                    xr = erros1[1].getErr();
                    xls = erros1[2].getErr();
                    xrs = erros1[3].getErr();
                    this.setQuick(i, x, this.getY(i), xl, xr, this.getYupper(i), this.getYlower(i), xls, xrs, this.getYupperSys(i), this.getYlowerSys(i));
                }
                if (!how.equalsIgnoreCase("Y")) continue;
                double y6 = erros1[4].getVal();
                yu2 = erros1[4].getErr();
                yl2 = erros1[5].getErr();
                yus = erros1[6].getErr();
                yls = erros1[7].getErr();
                this.setQuick(i, this.getX(i), y6, this.getXleft(i), this.getXright(i), yu2, yl2, this.getXleftSys(i), this.getXrightSys(i), yus, yls);
            }
        }
        return this;
    }

    public P1D move(String what, String how) {
        double xr;
        double xl;
        double yl;
        double yu;
        double yu2;
        double y;
        int i;
        ValueErr tmp;
        int NT = 8;
        ValueErr[] erros = new ValueErr[8];
        if (this.dimension() == 2) {
            tmp = new ValueErr();
            for (i = 0; i < this.size(); ++i) {
                int j;
                erros[0] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[1] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[2] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[3] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[4] = new ValueErr(this.Y.getQuick(i), 0.0);
                erros[5] = new ValueErr(this.Y.getQuick(i), 0.0);
                erros[6] = new ValueErr(this.Y.getQuick(i), 0.0);
                erros[7] = new ValueErr(this.Y.getQuick(i), 0.0);
                if (what.equalsIgnoreCase("inverse")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.inverse(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("exp")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.exp(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("log")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.log(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sqrt")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.sqrt(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("square")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.square(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sin")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.sin(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("cos")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.cos(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("tan")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.tan(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sinh")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.sinh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("cosh")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.cosh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("tanh")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.tanh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("asin")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.asin(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("acos")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.acos(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("atan")) {
                    for (j = 0; j < 8; ++j) {
                        erros[j] = tmp.atan(erros[j]);
                    }
                }
                if (how.equalsIgnoreCase("XY") || how.equalsIgnoreCase("YX")) {
                    double x = erros[0].getVal();
                    y = erros[4].getVal();
                    this.X.setQuick(i, x);
                    this.Y.setQuick(i, y);
                }
                if (how.equalsIgnoreCase("X")) {
                    double x = erros[0].getVal();
                    this.X.setQuick(i, x);
                }
                if (!how.equalsIgnoreCase("Y")) continue;
                double y2 = erros[4].getVal();
                this.Y.setQuick(i, y2);
            }
        }
        if (this.dimension() == 3) {
            tmp = new ValueErr();
            for (i = 0; i < this.size(); ++i) {
                erros[0] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[1] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[2] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[3] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[4] = new ValueErr(this.Y.getQuick(i), this.YE1upper.getQuick(i));
                erros[5] = new ValueErr(this.Y.getQuick(i), 0.0);
                erros[6] = new ValueErr(this.Y.getQuick(i), 0.0);
                erros[7] = new ValueErr(this.Y.getQuick(i), 0.0);
                if (what.equalsIgnoreCase("inverse")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.inverse(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("exp")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.exp(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("log")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.log(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sqrt")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.sqrt(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("square")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.square(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sin")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.sin(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("cos")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.cos(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("tan")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.tan(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sinh")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.sinh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("cosh")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.cosh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("tanh")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.tanh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("asin")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.asin(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("acos")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.acos(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("atan")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.atan(erros[j]);
                    }
                }
                if (how.equalsIgnoreCase("XY") || how.equalsIgnoreCase("YX")) {
                    double x = erros[0].getVal();
                    y = erros[4].getVal();
                    yu2 = erros[4].getErr();
                    this.X.setQuick(i, x);
                    this.Y.setQuick(i, y);
                    this.YE1upper.setQuick(i, yu2);
                }
                if (!how.equalsIgnoreCase("Y")) continue;
                double y3 = erros[4].getVal();
                yu = erros[4].getErr();
                this.Y.set(i, y3);
                this.YE1upper.setQuick(i, yu);
            }
        }
        if (this.dimension() == 4) {
            tmp = new ValueErr();
            for (i = 0; i < this.size(); ++i) {
                erros[0] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[1] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[2] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[3] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[4] = new ValueErr(this.Y.getQuick(i), this.YE1upper.getQuick(i));
                erros[5] = new ValueErr(this.Y.getQuick(i), this.YE1down.getQuick(i));
                erros[6] = new ValueErr(this.Y.getQuick(i), 0.0);
                erros[7] = new ValueErr(this.Y.getQuick(i), 0.0);
                if (what.equalsIgnoreCase("inverse")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.inverse(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("exp")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.exp(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("log")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.log(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sqrt")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.sqrt(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("square")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.square(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sin")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.sin(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("cos")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.cos(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("tan")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.tan(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sinh")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.sinh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("cosh")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.cosh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("tanh")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.tanh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("asin")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.asin(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("acos")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.acos(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("atan")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.atan(erros[j]);
                    }
                }
                if (how.equalsIgnoreCase("XY") || how.equalsIgnoreCase("YX")) {
                    double x = erros[0].getVal();
                    y = erros[4].getVal();
                    yu2 = erros[4].getErr();
                    double yl2 = erros[5].getErr();
                    this.X.setQuick(i, x);
                    this.Y.setQuick(i, y);
                    this.YE1upper.setQuick(i, yu2);
                    this.YE1down.setQuick(i, yl2);
                }
                if (!how.equalsIgnoreCase("Y")) continue;
                double y4 = erros[4].getVal();
                yu = erros[4].getErr();
                yl = erros[5].getErr();
                this.Y.set(i, y4);
                this.YE1upper.setQuick(i, yu);
                this.YE1down.setQuick(i, yl);
            }
        }
        if (this.dimension() == 6) {
            tmp = new ValueErr();
            for (i = 0; i < this.size(); ++i) {
                erros[0] = new ValueErr(this.X.getQuick(i), this.XE1left.getQuick(i));
                erros[1] = new ValueErr(this.X.getQuick(i), this.XE1right.getQuick(i));
                erros[2] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[3] = new ValueErr(this.X.getQuick(i), 0.0);
                erros[4] = new ValueErr(this.Y.getQuick(i), this.YE1upper.getQuick(i));
                erros[5] = new ValueErr(this.Y.getQuick(i), this.YE1down.getQuick(i));
                erros[6] = new ValueErr(this.Y.getQuick(i), 0.0);
                erros[7] = new ValueErr(this.Y.getQuick(i), 0.0);
                if (what.equalsIgnoreCase("inverse")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.inverse(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("exp")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.exp(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("log")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.log(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sqrt")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.sqrt(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("square")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.square(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sin")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.sin(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("cos")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.cos(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("tan")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.tan(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sinh")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.sinh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("cosh")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.cosh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("tanh")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.tanh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("asin")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.asin(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("acos")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.acos(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("atan")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.atan(erros[j]);
                    }
                }
                if (how.equalsIgnoreCase("XY") || how.equalsIgnoreCase("YX")) {
                    double x = erros[0].getVal();
                    xl = erros[0].getErr();
                    xr = erros[1].getErr();
                    double y5 = erros[4].getVal();
                    double yu3 = erros[4].getErr();
                    double yl3 = erros[5].getErr();
                    this.X.set(i, x);
                    this.Y.set(i, y5);
                    this.XE1left.set(i, xl);
                    this.XE1right.set(i, xr);
                    this.YE1upper.set(i, yu3);
                    this.YE1down.set(i, yl3);
                }
                if (how.equalsIgnoreCase("X")) {
                    double x = erros[0].getVal();
                    xl = erros[0].getErr();
                    xr = erros[1].getErr();
                    this.X.setQuick(i, x);
                    this.XE1left.setQuick(i, xl);
                    this.XE1right.setQuick(i, xr);
                }
                if (!how.equalsIgnoreCase("Y")) continue;
                double y6 = erros[4].getVal();
                yu = erros[4].getErr();
                yl = erros[5].getErr();
                this.Y.set(i, y6);
                this.YE1upper.setQuick(i, yu);
                this.YE1down.setQuick(i, yl);
            }
        }
        if (this.dimension() == 10) {
            tmp = new ValueErr();
            for (i = 0; i < this.size(); ++i) {
                double xrs;
                double xls;
                erros[0] = new ValueErr(this.X.getQuick(i), this.XE1left.getQuick(i));
                erros[1] = new ValueErr(this.X.getQuick(i), this.XE1right.getQuick(i));
                erros[2] = new ValueErr(this.X.getQuick(i), this.XE2left.getQuick(i));
                erros[3] = new ValueErr(this.X.getQuick(i), this.XE2right.getQuick(i));
                erros[4] = new ValueErr(this.Y.getQuick(i), this.YE1upper.getQuick(i));
                erros[5] = new ValueErr(this.Y.getQuick(i), this.YE1down.getQuick(i));
                erros[6] = new ValueErr(this.Y.getQuick(i), this.YE2upper.getQuick(i));
                erros[7] = new ValueErr(this.Y.getQuick(i), this.YE2down.getQuick(i));
                if (what.equalsIgnoreCase("inverse")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.inverse(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("exp")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.exp(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("log")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.log(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sqrt")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.sqrt(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("square")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.square(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sin")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.sin(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("cos")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.cos(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("tan")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.tan(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("sinh")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.sinh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("cosh")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.cosh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("tanh")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.tanh(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("asin")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.asin(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("acos")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.acos(erros[j]);
                    }
                }
                if (what.equalsIgnoreCase("atan")) {
                    for (int j = 0; j < 8; ++j) {
                        erros[j] = tmp.atan(erros[j]);
                    }
                }
                if (how.equalsIgnoreCase("XY") || how.equalsIgnoreCase("YX")) {
                    double x = erros[0].getVal();
                    xl = erros[0].getErr();
                    xr = erros[1].getErr();
                    xls = erros[2].getErr();
                    xrs = erros[3].getErr();
                    double y7 = erros[4].getVal();
                    double yu4 = erros[4].getErr();
                    double yl4 = erros[5].getErr();
                    double yus = erros[6].getErr();
                    double yls = erros[7].getErr();
                    this.X.set(i, x);
                    this.Y.set(i, y7);
                    this.XE1left.set(i, xl);
                    this.XE1right.set(i, xr);
                    this.XE2left.set(i, xls);
                    this.XE2right.set(i, xrs);
                    this.YE1upper.set(i, yu4);
                    this.YE1down.set(i, yl4);
                    this.YE2upper.set(i, yus);
                    this.YE2down.set(i, yls);
                }
                if (how.equalsIgnoreCase("X")) {
                    double x = erros[0].getVal();
                    xl = erros[0].getErr();
                    xr = erros[1].getErr();
                    xls = erros[2].getErr();
                    xrs = erros[3].getErr();
                    this.X.setQuick(i, x);
                    this.XE1left.setQuick(i, xl);
                    this.XE1right.setQuick(i, xr);
                    this.XE2left.setQuick(i, xls);
                    this.XE2right.setQuick(i, xrs);
                }
                if (!how.equalsIgnoreCase("Y")) continue;
                double y8 = erros[4].getVal();
                yu = erros[4].getErr();
                yl = erros[5].getErr();
                double yus = erros[6].getErr();
                double yls = erros[7].getErr();
                this.Y.set(i, y8);
                this.YE1upper.setQuick(i, yu);
                this.YE1down.setQuick(i, yl);
                this.YE2upper.setQuick(i, yus);
                this.YE2down.setQuick(i, yls);
            }
        }
        return this;
    }

    public DataArray getDataArray() {
        DataArray data;
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            data = new DataArray();
                            data.allocate(this.X.size());
                            if (this.dimen != 2) break block5;
                            for (int i = 0; i < this.X.size(); ++i) {
                                data.addPoint(this.X.getQuick(i), this.Y.getQuick(i), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                            }
                            break block6;
                        }
                        if (this.dimen != 3) break block7;
                        for (int i = 0; i < this.X.size(); ++i) {
                            data.addPoint(this.X.getQuick(i), this.Y.getQuick(i), 0.0, 0.0, this.YE1upper.getQuick(i), this.YE1upper.getQuick(i), 0.0, 0.0, 0.0, 0.0);
                        }
                        break block6;
                    }
                    if (this.dimen != 4) break block8;
                    for (int i = 0; i < this.X.size(); ++i) {
                        data.addPoint(this.X.getQuick(i), this.Y.getQuick(i), 0.0, 0.0, this.YE1upper.getQuick(i), this.YE1down.getQuick(i), 0.0, 0.0, 0.0, 0.0);
                    }
                    break block6;
                }
                if (this.dimen != 6) break block9;
                for (int i = 0; i < this.X.size(); ++i) {
                    data.addPoint(this.X.getQuick(i), this.Y.getQuick(i), this.XE1left.getQuick(i), this.XE1right.getQuick(i), this.YE1upper.getQuick(i), this.YE1down.getQuick(i), 0.0, 0.0, 0.0, 0.0);
                }
                break block6;
            }
            if (this.dimen != 10) break block6;
            for (int i = 0; i < this.X.size(); ++i) {
                data.addPoint(this.X.getQuick(i), this.Y.getQuick(i), this.XE1left.getQuick(i), this.XE1right.getQuick(i), this.YE1upper.getQuick(i), this.YE1down.getQuick(i), this.XE2left.getQuick(i), this.XE2right.getQuick(i), this.YE2upper.getQuick(i), this.YE2down.getQuick(i));
            }
        }
        return data;
    }

    public void add(double x, double y) {
        this.X.add(x);
        this.Y.add(y);
    }

    public void addQuick(double x, double y, double err) {
        this.X.add(x);
        this.Y.add(y);
        this.YE1upper.add(err);
    }

    public void add(double x, double y, double err) {
        if (this.X.size() == 0 && this.YE1upper == null) {
            this.YE1upper = new DoubleArrayList();
            this.dimen = 3;
        }
        this.X.add(x);
        this.Y.add(y);
        this.YE1upper.add(err);
    }

    public void addQuick(double x, double y, double upper, double lower) {
        this.X.add(x);
        this.Y.add(y);
        this.YE1upper.add(upper);
        this.YE1down.add(lower);
    }

    public void add(double x, double y, double upper, double lower) {
        if (this.X.size() == 0) {
            this.YE1upper = new DoubleArrayList();
            this.YE1down = new DoubleArrayList();
            this.dimen = 4;
        }
        this.X.add(x);
        this.Y.add(y);
        this.YE1upper.add(upper);
        this.YE1down.add(lower);
    }

    public void add(double x, double y, double left, double right, double upper, double lower) {
        if (this.X.size() == 0) {
            this.YE1upper = new DoubleArrayList();
            this.YE1down = new DoubleArrayList();
            this.XE1left = new DoubleArrayList();
            this.XE1right = new DoubleArrayList();
            this.dimen = 6;
        }
        this.X.add(x);
        this.Y.add(y);
        this.YE1upper.add(upper);
        this.YE1down.add(lower);
        this.XE1left.add(left);
        this.XE1right.add(right);
    }

    public void addQuick(double x, double y, double left, double right, double upper, double lower) {
        this.X.add(x);
        this.Y.add(y);
        this.YE1upper.add(upper);
        this.YE1down.add(lower);
        this.XE1left.add(left);
        this.XE1right.add(right);
    }

    public void add(double x, double y, double left, double right, double upper, double lower, double left_sys, double right_sys, double upper_sys, double lower_sys) {
        if (this.X.size() == 0) {
            this.YE1upper = new DoubleArrayList();
            this.YE1down = new DoubleArrayList();
            this.XE1left = new DoubleArrayList();
            this.XE1right = new DoubleArrayList();
            this.YE2upper = new DoubleArrayList();
            this.YE2down = new DoubleArrayList();
            this.XE2left = new DoubleArrayList();
            this.XE2right = new DoubleArrayList();
            this.dimen = 10;
        }
        this.X.add(x);
        this.Y.add(y);
        this.YE1upper.add(upper);
        this.YE1down.add(lower);
        this.XE1left.add(left);
        this.XE1right.add(right);
        this.YE2upper.add(upper_sys);
        this.YE2down.add(lower_sys);
        this.XE2left.add(left_sys);
        this.XE2right.add(right_sys);
    }

    public void addQuick(double x, double y, double left, double right, double upper, double lower, double left_sys, double right_sys, double upper_sys, double lower_sys) {
        this.X.add(x);
        this.Y.add(y);
        this.YE1upper.add(upper);
        this.YE1down.add(lower);
        this.XE1left.add(left);
        this.XE1right.add(right);
        this.YE2upper.add(upper_sys);
        this.YE2down.add(lower_sys);
        this.XE2left.add(left_sys);
        this.XE2right.add(right_sys);
    }

    public void set(int i, double x, double y) {
        this.X.set(i, x);
        this.Y.set(i, y);
    }

    public void set(int i, double x, double y, double upper, double lower) {
        this.X.set(i, x);
        this.Y.set(i, y);
        this.YE1upper.set(i, upper);
        this.YE1down.set(i, lower);
    }

    public void set(int i, double x, double y, double err) {
        if (this.X.size() == 0 && this.dimen == 2) {
            this.ErrorMessage("The dimension is nor 3!");
            return;
        }
        this.X.set(i, x);
        this.Y.set(i, y);
        this.YE1upper.set(i, err);
    }

    public void set(int i, double x, double y, double left, double right, double upper, double lower) {
        this.X.set(i, x);
        this.Y.set(i, y);
        this.YE1upper.set(i, upper);
        this.YE1down.set(i, lower);
        this.XE1left.set(i, left);
        this.XE1right.set(i, right);
    }

    public void set(int i, double x, double y, double left, double right, double upper, double lower, double left_sys, double right_sys, double upper_sys, double lower_sys) {
        this.X.set(i, x);
        this.Y.set(i, y);
        this.YE1upper.set(i, upper);
        this.YE1down.set(i, lower);
        this.XE1left.set(i, left);
        this.XE1right.set(i, right);
        this.YE2upper.set(i, upper_sys);
        this.YE2down.set(i, lower_sys);
        this.XE2left.set(i, left_sys);
        this.XE2right.set(i, right_sys);
    }

    public void updateSummary() {
        this.ErrorMessage("updateSummary is Debricarted ");
    }

    public void setQuick(int i, double x, double y, double left, double right, double upper, double lower, double left_sys, double right_sys, double upper_sys, double lower_sys) {
        this.X.setQuick(i, x);
        this.Y.setQuick(i, y);
        this.YE1upper.setQuick(i, upper);
        this.YE1down.setQuick(i, lower);
        this.XE1left.setQuick(i, left);
        this.XE1right.setQuick(i, right);
        this.YE2upper.setQuick(i, upper_sys);
        this.YE2down.setQuick(i, lower_sys);
        this.XE2left.setQuick(i, left_sys);
        this.XE2right.setQuick(i, right_sys);
    }

    public void setQuick(int i, double x, double y, double left, double right, double upper, double lower) {
        this.X.setQuick(i, x);
        this.Y.setQuick(i, y);
        this.YE1upper.setQuick(i, upper);
        this.YE1down.setQuick(i, lower);
        this.XE1left.setQuick(i, left);
        this.XE1right.setQuick(i, right);
    }

    public void setQuick(int i, double x, double y, double upper, double lower) {
        this.X.setQuick(i, x);
        this.Y.setQuick(i, y);
        this.YE1upper.setQuick(i, upper);
        this.YE1down.setQuick(i, lower);
    }

    public void setQuick(int i, double x, double y, double err) {
        this.X.setQuick(i, x);
        this.Y.setQuick(i, y);
        this.YE1upper.setQuick(i, err);
    }

    public void setQuick(int i, double x, double y) {
        this.X.setQuick(i, x);
        this.Y.setQuick(i, y);
    }

    public Map<String, Double> compareChi2(F1D f1) {
        HashMap<String, Double> tmp = new HashMap<String, Double>();
        double sum1 = 0.0;
        double nDf = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double x = this.getX(i);
            double bin1 = this.getY(i);
            double e1 = this.getYupper(i);
            double ff = f1.eval(x);
            if (e1 == 0.0) continue;
            sum1 += (ff - bin1) * (ff - bin1) / (e1 * e1);
            nDf += 1.0;
        }
        double chi2 = sum1;
        tmp.put("chi2", chi2);
        tmp.put("ndf", nDf);
        ChiSquaredDistribution chi2Distribution = new ChiSquaredDistribution(nDf);
        double prob = chi2Distribution.cumulativeProbability(chi2);
        tmp.put("p-value", 1.0 - prob);
        return tmp;
    }

    public Map<String, Double> compareChi2(P1D h2) {
        double e2;
        double e1;
        double bin2;
        double bin1;
        int i;
        int bins2x;
        HashMap<String, Double> tmp = new HashMap<String, Double>();
        int bins1x = this.size();
        if (bins1x != (bins2x = h2.size())) {
            System.out.println("Different histograms! Please use histograms with the same bin numbers in X");
            return tmp;
        }
        double chi2 = 0.0;
        int nDf = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sumw1 = 0.0;
        double sumw2 = 0.0;
        for (i = 0; i < bins1x; ++i) {
            bin1 = this.getY(i);
            bin2 = h2.getY(i);
            e1 = this.getYupper(i);
            e2 = h2.getYupper(i);
            bin1 = e1 > 0.0 ? (bin1 *= bin1 / (e1 * e1)) : 0.0;
            bin2 = e2 > 0.0 ? (bin2 *= bin2 / (e2 * e2)) : 0.0;
            sum1 += bin1;
            sum2 += bin2;
            sumw1 += e1 * e1;
            sumw2 += e2 * e2;
        }
        if (sumw1 <= 0.0 || sumw2 <= 0.0) {
            System.out.println("Cannot compare histograms with all zero errors");
            return tmp;
        }
        if (sum1 == 0.0 || sum2 == 0.0) {
            System.out.println("One histogram is empty!");
            return tmp;
        }
        for (i = 0; i < bins1x; ++i) {
            bin1 = this.getY(i);
            bin2 = h2.getY(i);
            e1 = this.getYupper(i);
            e2 = h2.getYupper(i);
            bin1 = e1 > 0.0 ? (bin1 *= bin1 / (e1 * e1)) : 0.0;
            bin2 = e2 > 0.0 ? (bin2 *= bin2 / (e2 * e2)) : 0.0;
            double binsum = bin1 + bin2;
            double delta = sum2 * bin1 - sum1 * bin2;
            if (!(binsum > 0.0)) continue;
            System.out.println(chi2 += delta * delta / binsum);
            ++nDf;
        }
        tmp.put("chi2", chi2 /= sum1 * sum2);
        tmp.put("ndf", Double.valueOf(nDf));
        ChiSquaredDistribution chi2Distribution = new ChiSquaredDistribution((double)nDf);
        double prob = chi2Distribution.cumulativeProbability(chi2);
        tmp.put("p-value", 1.0 - prob);
        return tmp;
    }

    public int size() {
        return this.X.size();
    }

    public double[] getArrayX() {
        this.X.trimToSize();
        return this.X.elements();
    }

    public P1D copy(String newtitle) {
        P1D tmp = new P1D(newtitle);
        LinePars lppp = this.copyLinePars(this.lpp);
        tmp.setLinePars(lppp);
        tmp.setDimension(this.dimen);
        tmp.setXval(this.X.copy());
        tmp.setYval(this.Y.copy());
        if (this.dimen == 3) {
            tmp.setYE1upper(this.YE1upper.copy());
            return tmp;
        }
        if (this.dimen == 4) {
            tmp.setYE1upper(this.YE1upper.copy());
            tmp.setYE1down(this.YE1down.copy());
            return tmp;
        }
        if (this.dimen == 6) {
            tmp.setYE1upper(this.YE1upper.copy());
            tmp.setYE1down(this.YE1down.copy());
            tmp.setXE1left(this.XE1left.copy());
            tmp.setXE1right(this.XE1right.copy());
            return tmp;
        }
        if (this.dimen == 10) {
            tmp.setYE1upper(this.YE1upper.copy());
            tmp.setYE1down(this.YE1down.copy());
            tmp.setXE1left(this.XE1left.copy());
            tmp.setXE1right(this.XE1right.copy());
            tmp.setYE2upper(this.YE2upper.copy());
            tmp.setYE2down(this.YE2down.copy());
            tmp.setXE2left(this.XE2left.copy());
            tmp.setXE2right(this.XE2right.copy());
            return tmp;
        }
        return tmp;
    }

    public void setXE2left(DoubleArrayList xE2left) {
        this.XE2left = xE2left;
    }

    public void setXE2right(DoubleArrayList xE2right) {
        this.XE2right = xE2right;
    }

    public int writeSerialized(String name) {
        return Serialized.write(this, name);
    }

    public P1D readSerialized(String name) {
        return (P1D)Serialized.read(name);
    }

    public P1D(String title, URL url) {
        this(title);
        this.read(url);
    }

    public P1D(URL url) {
        this("None");
        this.read(url);
    }

    public int read(BufferedReader br) {
        this.clear();
        int ncount = 0;
        boolean first = true;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.startsWith("*") || line.length() <= 1) continue;
                String[] currentLine = line.split("\\s+");
                if (first) {
                    this.setDimension(ncount);
                    first = false;
                    ncount = currentLine.length;
                }
                double[] snum = new double[ncount];
                if (ncount != 2 && ncount != 4 && ncount != 6 && ncount != 10) {
                    this.ErrorMessage("Error in reading the file:\n" + Integer.toString(ncount) + " entries per line is found!");
                }
                for (int k = 0; k < ncount; ++k) {
                    double dd = 0.0;
                    try {
                        dd = Double.parseDouble(currentLine[k]);
                    }
                    catch (NumberFormatException e) {
                        this.ErrorMessage("Error in reading the line " + Integer.toString(k + 1));
                        return 3;
                    }
                    snum[k] = dd;
                }
                if (ncount == 2) {
                    this.add(snum[0], snum[1]);
                }
                if (ncount == 3) {
                    this.add(snum[0], snum[1], snum[2], snum[2]);
                }
                if (ncount == 4) {
                    this.add(snum[0], snum[1], snum[2], snum[3]);
                }
                if (ncount == 6) {
                    this.add(snum[0], snum[1], snum[2], snum[3], snum[4], snum[5]);
                }
                if (ncount != 10) continue;
                this.add(snum[0], snum[1], snum[2], snum[3], snum[4], snum[5], snum[6], snum[7], snum[8], snum[9]);
            }
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    public int read(URL url) {
        BufferedReader is = PReader.read(url);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int readGZip(String sfile) {
        BufferedReader is = PReader.readGZip(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int read(String sfile) {
        BufferedReader is = PReader.read(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int readZip(String sfile) {
        this.clear();
        try {
            ZipFile zf = new ZipFile(sfile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            while (entries.hasMoreElements()) {
                long size;
                ZipEntry ze = entries.nextElement();
                String inputLine = input.readLine();
                if (!inputLine.equalsIgnoreCase("yes") || (size = ze.getSize()) <= 0L) continue;
                BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                this.read(br);
                br.close();
            }
        }
        catch (FileNotFoundException e) {
            this.ErrorMessage("File not found:" + sfile);
            e.printStackTrace();
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 2;
        }
        return 0;
    }

    public P1D copy() {
        return this.copy(this.title);
    }

    public P1D operSmooth(int axis, boolean isWeighted, int k) {
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
            return this;
        }
        SHisto sh = new SHisto(this.size(), this.getMin(axis), this.getMax(axis), 1);
        double[] hh = null;
        if (axis == 0) {
            hh = this.getArrayX();
        }
        if (axis == 1) {
            hh = this.getArrayY();
        }
        sh.setBins(hh);
        sh = sh.getSmoothed(isWeighted, k);
        for (int i = 0; i < this.size(); ++i) {
            if (axis == 0) {
                this.setQuick(i, sh.getBinsFirstBand(i), this.getQuickY(i));
            }
            if (axis != 1) continue;
            this.setQuick(i, this.getQuickX(i), sh.getBinsFirstBand(i));
        }
        return this;
    }

    public P1D operSmoothGauss(int axis, double standardDeviation) {
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
            return this;
        }
        SHisto sh = new SHisto(this.size(), this.getMin(axis), this.getMax(axis), 1);
        double[] hh = null;
        if (axis == 0) {
            hh = this.getArrayX();
        }
        if (axis == 1) {
            hh = this.getArrayY();
        }
        sh.setBins(hh);
        sh = sh.getGaussianSmoothed(standardDeviation);
        for (int i = 0; i < this.size(); ++i) {
            if (axis == 0) {
                this.setQuick(i, sh.getBinsFirstBand(i), this.getY(i));
            }
            if (axis != 1) continue;
            this.setQuick(i, this.getX(i), sh.getBinsFirstBand(i));
        }
        return this;
    }

    public P1D getSys(P1D[] p1darray) {
        P1D tmp = new P1D("systematics");
        tmp.setDimension(10);
        for (int i = 0; i < this.size(); ++i) {
            double d = 0.0;
            double up = 0.0;
            double down = 0.0;
            for (int m = 0; m < p1darray.length; ++m) {
                d = p1darray[m].getQuickY(i) - this.getQuickY(i);
                if (d > 0.0) {
                    up += d * d;
                }
                if (!(d < 0.0)) continue;
                down += d * d;
            }
            up = Math.sqrt(up);
            down = Math.sqrt(down);
            if (p1darray[0].dimension() == 2) {
                tmp.add(this.getX(i), this.getY(i), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, up, down);
            }
            if (p1darray[0].dimension() == 3) {
                tmp.add(this.getX(i), this.getY(i), 0.0, 0.0, this.getYupper(i), 0.0, 0.0, 0.0, up, down);
            }
            if (p1darray[0].dimension() == 4) {
                tmp.add(this.getX(i), this.getY(i), 0.0, 0.0, this.getYupper(i), this.getYlower(i), 0.0, 0.0, up, down);
            }
            if (p1darray[0].dimension() == 6) {
                tmp.add(this.getX(i), this.getY(i), this.getXleft(i), this.getXright(i), this.getYupper(i), this.getYlower(i), 0.0, 0.0, up, down);
            }
            if (p1darray[0].dimension() != 10) continue;
            tmp.add(this.getX(i), this.getY(i), this.getXleft(i), this.getXright(i), this.getYupper(i), this.getYlower(i), this.getXleftSys(i), this.getXrightSys(i), up, down);
        }
        return tmp;
    }

    public void combineErr(int axis) {
        if (this.dimension() != 10) {
            this.ErrorMessage("The dimension for this operation must be 10. Exit now.");
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (axis == 0) {
                double eLeft = Math.sqrt(this.getXleft(i) * this.getXleft(i) + this.getXleftSys(i) * this.getXleftSys(i));
                double eRight = Math.sqrt(this.getXright(i) * this.getXright(i) + this.getXrightSys(i) * this.getXrightSys(i));
                this.setQuick(i, this.getX(i), this.getY(i), eLeft, eRight, this.getYupper(i), this.getYlower(i), 0.0, 0.0, this.getYupperSys(i), this.getYlowerSys(i));
            }
            if (axis != 1) continue;
            double eUpper = Math.sqrt(this.getYupper(i) * this.getYupper(i) + this.getYupperSys(i) * this.getYupperSys(i));
            double eLower = Math.sqrt(this.getYlower(i) * this.getYlower(i) + this.getYlowerSys(i) * this.getYlowerSys(i));
            this.setQuick(i, this.getQuickX(i), this.getQuickY(i), this.getXleft(i), this.getXright(i), eUpper, eLower, this.getXleftSys(i), this.getXrightSys(i), 0.0, 0.0);
        }
    }

    public P1D addAndAverage(P1D[] p1darray) {
        if (this.dimen == 2) {
            return this;
        }
        P1D tmp = new P1D("Average");
        tmp.setDimension(10);
        for (int i = 0; i < this.size(); ++i) {
            double wa1 = 1.0;
            if (this.dimen == 3 && this.getYupper(i) != 0.0) {
                wa1 = 1.0 / (this.getYupper(i) * this.getYupper(i));
            }
            double wa2 = 1.0;
            if (this.dimen > 3 && this.getYlower(i) != 0.0) {
                wa2 = 1.0 / (this.getYlower(i) * this.getYlower(i));
            }
            double wsa1 = 1.0;
            double wsa2 = 1.0;
            if (this.dimen > 9) {
                if (this.getYupperSys(i) != 0.0) {
                    wsa1 = 1.0 / (this.getYupperSys(i) * this.getYupperSys(i));
                }
                if (this.getYlowerSys(i) != 0.0) {
                    wsa2 = 1.0 / (this.getYlowerSys(i) * this.getYlowerSys(i));
                }
            }
            if (this.dimen > 3 && this.getYupper(i) != this.getYlower(i)) {
                System.out.println("Check! Upper and Lower error for Y should be the same!");
                System.out.println("Now I'm averaging them..");
                wa1 = 0.5 * (wa1 + wa2);
            }
            double ynew = wa1 * this.getY(i);
            double wsum = wa1;
            double wsum1 = wsa1;
            double wsum2 = wsa2;
            for (int m = 0; m < p1darray.length; ++m) {
                if (this.size() != p1darray[m].size()) {
                    System.out.println("input P1D arrays have diferent size!");
                    return this;
                }
                double w1 = 1.0;
                if (this.dimen > 2 && p1darray[m].getYupper(i) != 0.0) {
                    w1 = 1.0 / (p1darray[m].getYupper(i) * p1darray[m].getYupper(i));
                }
                double w2 = 1.0;
                if (this.dimen > 3 && p1darray[m].getYlower(i) != 0.0) {
                    w2 = 1.0 / (p1darray[m].getYlower(i) * p1darray[m].getYlower(i));
                }
                double ws1 = 1.0;
                if (this.dimen > 9 && p1darray[m].getYupperSys(i) != 0.0) {
                    ws1 = 1.0 / (p1darray[m].getYupperSys(i) * p1darray[m].getYupperSys(i));
                }
                double ws2 = 1.0;
                if (this.dimen > 9 && p1darray[m].getYlowerSys(i) != 0.0) {
                    ws2 = 1.0 / (p1darray[m].getYlowerSys(i) * p1darray[m].getYlowerSys(i));
                }
                if (this.dimen > 3 && p1darray[m].getYupper(i) != p1darray[m].getYlower(i)) {
                    System.out.println("Check! Upper and Lower error for Y should be the same!");
                    System.out.println("Now I'm averaging them..");
                    w1 = 0.5 * (w1 + w2);
                }
                ynew += w1 * p1darray[m].getY(i);
                wsum += w1;
                wsum1 += ws1;
                wsum2 += ws2;
            }
            ynew /= wsum;
            wsum = 1.0 / Math.sqrt(wsum);
            wsum1 = 1.0 / Math.sqrt(wsum1);
            wsum2 = 1.0 / Math.sqrt(wsum2);
            if (this.dimen > 9) {
                tmp.add(this.getX(i), ynew, this.getXleft(i), this.getXright(i), wsum, wsum, this.getXleftSys(i), this.getXrightSys(i), wsum1, wsum2);
            }
            if (this.dimen != 2 && this.dimen != 3 && this.dimen != 4) continue;
            tmp.add(this.getX(i), ynew, 0.0, 0.0, wsum, wsum, 0.0, 0.0, wsum1, wsum2);
        }
        return tmp;
    }

    public double[] getArrayXleft() {
        this.XE1left.trimToSize();
        return this.XE1left.elements();
    }

    public double[] getArrayXright() {
        this.XE1right.trimToSize();
        return this.XE1right.elements();
    }

    public double[] getArrayXrightSys() {
        this.XE2right.trimToSize();
        return this.XE2right.elements();
    }

    public double[] getArrayXleftSys() {
        this.XE2left.trimToSize();
        return this.XE2left.elements();
    }

    public double[] getArrayY() {
        this.Y.trimToSize();
        return this.Y.elements();
    }

    public double getX(int i) {
        return this.X.get(i);
    }

    public double getXleft(int i) {
        return this.XE1left.get(i);
    }

    public double getXright(int i) {
        return this.XE1right.get(i);
    }

    public double getXleftSys(int i) {
        return this.XE2left.get(i);
    }

    public double getXrightSys(int i) {
        return this.XE2right.get(i);
    }

    public double getY(int i) {
        return this.Y.get(i);
    }

    public double getErr(int i) {
        return this.getYupper(i);
    }

    public double getQuickY(int i) {
        return this.Y.getQuick(i);
    }

    public double getQuickX(int i) {
        return this.X.getQuick(i);
    }

    public double getYupper(int i) {
        return this.YE1upper.get(i);
    }

    public double getError(int i) {
        return this.YE1upper.get(i);
    }

    public double getYlower(int i) {
        return this.YE1down.get(i);
    }

    public double[] getArrayYlower() {
        this.YE1down.trimToSize();
        if (this.YE1down == null) {
            this.ErrorMessage("This container was not initialized with >6 dimensions!");
        }
        return this.YE1down.elements();
    }

    public double[] getArrayYlowerSys() {
        this.YE2down.trimToSize();
        if (this.YE2down == null) {
            this.ErrorMessage("This container was not initialized with >6 dimensions!");
        }
        return this.YE2down.elements();
    }

    public double getYupperSys(int i) {
        return this.YE2upper.get(i);
    }

    public double[] getArrayYupper() {
        this.YE1upper.trimToSize();
        if (this.YE1upper == null) {
            this.ErrorMessage("This container was not initialized with >6 dimensions!");
        }
        return this.YE1upper.elements();
    }

    public double[] getArrayErr() {
        return this.getArrayYupper();
    }

    public int dimension() {
        return this.dimen;
    }

    public int getDimension() {
        return this.dimen;
    }

    public double getYlowerSys(int i) {
        return this.YE2down.get(i);
    }

    public double[] getArrayYupperSys() {
        this.YE2upper.trimToSize();
        if (this.YE2upper == null) {
            this.ErrorMessage("This container was not initialized with 10 dimensions!");
        }
        return this.YE2upper.elements();
    }

    public IDataPointSet getIDataPointSet() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IDataPointSetFactory dpsf = af.createDataPointSetFactory(tree);
        IDataPointSet fDps2D = dpsf.create(this.getTitle(), this.getTitle(), 2);
        this.fillIDataPointSet(fDps2D);
        return fDps2D;
    }

    public void fillIDataPointSet(IDataPointSet fDps2D) {
        int i;
        if (this.dimen == 2) {
            for (i = 0; i < this.size(); ++i) {
                fDps2D.addPoint();
                fDps2D.point(i).coordinate(0).setValue(this.X.getQuick(i));
                fDps2D.point(i).coordinate(1).setValue(this.Y.getQuick(i));
            }
        }
        if (this.dimen == 3) {
            for (i = 0; i < this.size(); ++i) {
                fDps2D.addPoint();
                fDps2D.point(i).coordinate(0).setValue(this.X.getQuick(i));
                fDps2D.point(i).coordinate(1).setValue(this.Y.getQuick(i));
                fDps2D.point(i).coordinate(1).setErrorPlus(this.YE1upper.getQuick(i));
                fDps2D.point(i).coordinate(1).setErrorMinus(this.YE1upper.getQuick(i));
            }
        }
        if (this.dimen == 4) {
            for (i = 0; i < this.size(); ++i) {
                fDps2D.addPoint();
                fDps2D.point(i).coordinate(0).setValue(this.X.getQuick(i));
                fDps2D.point(i).coordinate(1).setValue(this.Y.getQuick(i));
                fDps2D.point(i).coordinate(1).setErrorPlus(this.YE1upper.getQuick(i));
                fDps2D.point(i).coordinate(1).setErrorMinus(this.YE1down.getQuick(i));
            }
        }
        if (this.dimen == 6) {
            for (i = 0; i < this.size(); ++i) {
                fDps2D.addPoint();
                fDps2D.point(i).coordinate(0).setValue(this.X.getQuick(i));
                fDps2D.point(i).coordinate(0).setErrorPlus(this.XE1right.getQuick(i));
                fDps2D.point(i).coordinate(0).setErrorMinus(this.XE1left.getQuick(i));
                fDps2D.point(i).coordinate(1).setValue(this.Y.getQuick(i));
                fDps2D.point(i).coordinate(1).setErrorPlus(this.YE1upper.getQuick(i));
                fDps2D.point(i).coordinate(1).setErrorMinus(this.YE1down.getQuick(i));
            }
        }
        if (this.dimen == 10) {
            for (i = 0; i < this.size(); ++i) {
                fDps2D.addPoint();
                fDps2D.point(i).coordinate(0).setValue(this.X.getQuick(i));
                fDps2D.point(i).coordinate(1).setValue(this.Y.getQuick(i));
                double sup = Math.sqrt(this.getYupperSys(i) * this.getYupperSys(i) + this.getYupper(i) * this.getYupper(i));
                double slow = Math.sqrt(this.getYlowerSys(i) * this.getYlowerSys(i) + this.getYlower(i) * this.getYlower(i));
                fDps2D.point(i).coordinate(1).setErrorPlus(sup);
                fDps2D.point(i).coordinate(1).setErrorMinus(slow);
                if (this.getXleft(i) != 0.0 && this.getXleftSys(i) != 0.0) {
                    double xleft = Math.sqrt(this.getXleftSys(i) * this.getXleft(i) + this.getXright(i) * this.getXright(i));
                    fDps2D.point(i).coordinate(0).setErrorMinus(xleft);
                }
                if (this.getXright(i) == 0.0 || this.getXrightSys(i) == 0.0) continue;
                double xright = Math.sqrt(this.getXleftSys(i) * this.getXleft(i) + this.getXright(i) * this.getXright(i));
                fDps2D.point(i).coordinate(0).setErrorPlus(xright);
            }
        }
    }

    public double getMax(int axis) {
        if (axis == 0) {
            return Descriptive.max(this.X);
        }
        if (axis == 1) {
            return Descriptive.max(this.Y);
        }
        return 0.0;
    }

    public int getMaxIndex(int axis) {
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
        }
        double[] values = null;
        if (axis == 0) {
            values = this.getArrayX();
        }
        if (axis == 1) {
            values = this.getArrayY();
        }
        int index = DoubleArray.maxIndex(values);
        return index;
    }

    public double getMin(int axis) {
        if (axis == 0 && this.X.size() > 0) {
            return Descriptive.min(this.X);
        }
        if (axis == 1 && this.Y.size() > 0) {
            return Descriptive.min(this.Y);
        }
        return 0.0;
    }

    public int getMinIndex(int axis) {
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
        }
        double[] values = null;
        if (axis == 0) {
            values = this.getArrayX();
        }
        if (axis == 1) {
            values = this.getArrayY();
        }
        int index = DoubleArray.minIndex(values);
        return index;
    }

    public void removeAt(int index) {
        this.X.remove(index);
        this.Y.remove(index);
        if (this.dimen == 3) {
            this.YE1upper.remove(index);
            return;
        }
        if (this.dimen == 4) {
            this.YE1upper.remove(index);
            this.YE1down.remove(index);
            return;
        }
        if (this.dimen == 6) {
            this.YE1upper.remove(index);
            this.YE1down.remove(index);
            this.XE1left.remove(index);
            this.XE1right.remove(index);
            return;
        }
        if (this.dimen == 10) {
            this.YE1upper.remove(index);
            this.YE1down.remove(index);
            this.XE1left.remove(index);
            this.XE1right.remove(index);
            this.YE2upper.remove(index);
            this.YE2down.remove(index);
            this.YE2upper.remove(index);
            this.YE2down.remove(index);
            return;
        }
    }

    public P1D range(int IndexMin, int IndexMax) {
        P1D tmp = new P1D(this.getTitle());
        LinePars lppp = this.copyLinePars(this.lpp);
        tmp.setLinePars(lppp);
        tmp.setDimension(this.dimen);
        tmp.setXval((DoubleArrayList)this.X.partFromTo(IndexMin, IndexMax));
        tmp.setYval((DoubleArrayList)this.Y.partFromTo(IndexMin, IndexMax));
        if (this.dimen == 2) {
            return tmp;
        }
        if (this.dimen == 3) {
            tmp.setYE1upper((DoubleArrayList)this.YE1upper.partFromTo(IndexMin, IndexMax));
            return tmp;
        }
        if (this.dimen == 4) {
            tmp.setYE1upper((DoubleArrayList)this.YE1upper.partFromTo(IndexMin, IndexMax));
            tmp.setYE1down((DoubleArrayList)this.YE1down.partFromTo(IndexMin, IndexMax));
            return tmp;
        }
        if (this.dimen == 6) {
            tmp.setYE1upper((DoubleArrayList)this.YE1upper.partFromTo(IndexMin, IndexMax));
            tmp.setYE1down((DoubleArrayList)this.YE1down.partFromTo(IndexMin, IndexMax));
            tmp.setXE1left((DoubleArrayList)this.XE1left.partFromTo(IndexMin, IndexMax));
            tmp.setXE1right((DoubleArrayList)this.XE1right.partFromTo(IndexMin, IndexMax));
            return tmp;
        }
        if (this.dimen == 10) {
            tmp.setYE1upper((DoubleArrayList)this.YE1upper.partFromTo(IndexMin, IndexMax));
            tmp.setYE1down((DoubleArrayList)this.YE1down.partFromTo(IndexMin, IndexMax));
            tmp.setXE1left((DoubleArrayList)this.XE1left.partFromTo(IndexMin, IndexMax));
            tmp.setXE1right((DoubleArrayList)this.XE1right.partFromTo(IndexMin, IndexMax));
            tmp.setYE2upper((DoubleArrayList)this.YE2upper.partFromTo(IndexMin, IndexMax));
            tmp.setYE2down((DoubleArrayList)this.YE2down.partFromTo(IndexMin, IndexMax));
            tmp.setXE2left((DoubleArrayList)this.XE2left.partFromTo(IndexMin, IndexMax));
            tmp.setXE2right((DoubleArrayList)this.XE2right.partFromTo(IndexMin, IndexMax));
            return tmp;
        }
        return tmp;
    }

    public P1D derivative() {
        double dy;
        double dx;
        int i;
        P1D tmp = new P1D("Derivative of " + this.title);
        if (this.dimen == 4) {
            for (i = 0; i < this.size() - 1; ++i) {
                dx = this.getQuickX(i + 1) - this.getQuickX(i);
                dy = this.getQuickY(i + 1) - this.getQuickY(i);
                double dyUP = this.getQuickY(i + 1) + this.getYupper(i + 1) - this.getQuickY(i);
                double dyDW = this.getQuickY(i + 1) - this.getYlower(i + 1) - this.getQuickY(i);
                double slope = 0.0;
                double slopeUP = 0.0;
                double slopeDW = 0.0;
                if (dx != 0.0) {
                    slope = dy / dx;
                    slopeUP = dyUP / dx;
                    slopeDW = dyDW / dx;
                }
                tmp.add(this.getX(i), slope, 0.0, 0.0, slopeUP, slopeDW, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.dimen != 4) {
            for (i = 0; i < this.size() - 1; ++i) {
                dx = this.getQuickX(i + 1) - this.getQuickX(i);
                dy = this.getQuickY(i + 1) - this.getQuickY(i);
                double slope = 0.0;
                if (dx != 0.0) {
                    slope = dy / dx;
                }
                tmp.add(this.getX(i), slope);
            }
        }
        return tmp;
    }

    public P1D rangeCut(int axis, double Min, double Max) {
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
        }
        P1D tmp = new P1D(this.title);
        tmp.setLinePars(this.lpp);
        for (int i = 0; i < this.size(); ++i) {
            if (axis == 0 && (this.getX(i) < Min || this.getX(i) > Max)) {
                if (this.dimen == 2) {
                    tmp.add(this.getX(i), this.getY(i));
                } else if (this.dimen == 3) {
                    tmp.add(this.getX(i), this.getY(i), this.getYupper(i));
                } else if (this.dimen == 4) {
                    tmp.add(this.getX(i), this.getY(i), this.getYupper(i), this.getYlower(i));
                } else if (this.dimen > 4) {
                    tmp.add(this.getX(i), this.getY(i), this.getXleft(i), this.getXright(i), this.getYupper(i), this.getYlower(i), this.getXleftSys(i), this.getXrightSys(i), this.getYupperSys(i), this.getYlowerSys(i));
                }
            }
            if (axis != 1 || !(this.getY(i) < Min) && !(this.getY(i) > Max)) continue;
            if (this.dimen == 2) {
                tmp.add(this.getX(i), this.getY(i));
                continue;
            }
            if (this.dimen == 3) {
                tmp.add(this.getX(i), this.getY(i), this.getYupper(i));
                continue;
            }
            if (this.dimen == 4) {
                tmp.add(this.getX(i), this.getY(i), this.getYupper(i), this.getYlower(i));
                continue;
            }
            tmp.add(this.getX(i), this.getY(i), this.getXleft(i), this.getXright(i), this.getYupper(i), this.getYlower(i), this.getXleftSys(i), this.getXrightSys(i), this.getYupperSys(i), this.getYlowerSys(i));
        }
        return tmp;
    }

    public void sort(int axis) {
        int j;
        int i;
        int j2;
        int i2;
        double tempY;
        double tempX;
        int j3;
        int i3;
        if (axis != 0 && axis != 1) {
            this.ErrorMessage("Axis variable should be 0 or 1!");
        }
        if (axis == 0) {
            if (this.dimen == 2) {
                for (i3 = 0; i3 < this.size() - 1; ++i3) {
                    for (j3 = i3 + 1; j3 < this.size(); ++j3) {
                        if (!(this.X.getQuick(i3) > this.X.getQuick(j3))) continue;
                        tempX = this.X.getQuick(i3);
                        tempY = this.Y.getQuick(i3);
                        this.X.setQuick(i3, this.getQuickX(j3));
                        this.Y.setQuick(i3, this.getQuickY(j3));
                        this.X.setQuick(j3, tempX);
                        this.Y.setQuick(j3, tempY);
                    }
                }
            }
            if (this.dimen == 3) {
                for (i2 = 0; i2 < this.size() - 1; ++i2) {
                    for (j2 = i2 + 1; j2 < this.size(); ++j2) {
                        if (!(this.X.getQuick(i2) > this.X.getQuick(j2))) continue;
                        tempX = this.X.getQuick(i2);
                        tempY = this.Y.getQuick(i2);
                        double tempEY = this.YE1upper.getQuick(i2);
                        this.X.setQuick(i2, this.getQuickX(j2));
                        this.Y.setQuick(i2, this.getQuickY(j2));
                        this.YE1upper.setQuick(i2, this.YE1upper.getQuick(j2));
                        this.X.setQuick(j2, tempX);
                        this.Y.setQuick(j2, tempY);
                        this.YE1upper.setQuick(j2, tempEY);
                    }
                }
            }
            if (this.dimen == 4) {
                for (i = 0; i < this.size() - 1; ++i) {
                    for (j = i + 1; j < this.size(); ++j) {
                        if (!(this.X.getQuick(i) > this.X.getQuick(j))) continue;
                        tempX = this.X.getQuick(i);
                        tempY = this.Y.getQuick(i);
                        double tempEYu = this.YE1upper.getQuick(i);
                        double tempEYd = this.YE1down.getQuick(i);
                        this.X.setQuick(i, this.getQuickX(j));
                        this.Y.setQuick(i, this.getQuickY(j));
                        this.YE1upper.setQuick(i, this.YE1upper.getQuick(j));
                        this.YE1down.setQuick(i, this.YE1down.getQuick(j));
                        this.X.setQuick(j, tempX);
                        this.Y.setQuick(j, tempY);
                        this.YE1upper.setQuick(j, tempEYu);
                        this.YE1down.setQuick(j, tempEYd);
                    }
                }
            }
        }
        if (axis == 1) {
            if (this.dimen == 2) {
                for (i3 = 0; i3 < this.size() - 1; ++i3) {
                    for (j3 = i3 + 1; j3 < this.size(); ++j3) {
                        if (!(this.Y.getQuick(i3) > this.Y.getQuick(j3))) continue;
                        tempX = this.X.getQuick(i3);
                        tempY = this.Y.getQuick(i3);
                        this.X.setQuick(i3, this.getQuickX(j3));
                        this.Y.setQuick(i3, this.getQuickY(j3));
                        this.X.setQuick(j3, tempX);
                        this.Y.setQuick(j3, tempY);
                    }
                }
            }
            if (this.dimen == 3) {
                for (i2 = 0; i2 < this.size() - 1; ++i2) {
                    for (j2 = i2 + 1; j2 < this.size(); ++j2) {
                        if (!(this.Y.getQuick(i2) > this.Y.getQuick(j2))) continue;
                        tempX = this.X.getQuick(i2);
                        tempY = this.Y.getQuick(i2);
                        double tempEY = this.YE1upper.getQuick(i2);
                        this.X.setQuick(i2, this.getQuickX(j2));
                        this.Y.setQuick(i2, this.getQuickY(j2));
                        this.YE1upper.setQuick(i2, this.YE1upper.getQuick(j2));
                        this.X.setQuick(j2, tempX);
                        this.Y.setQuick(j2, tempY);
                        this.YE1upper.setQuick(j2, tempEY);
                    }
                }
            }
            if (this.dimen == 4) {
                for (i = 0; i < this.size() - 1; ++i) {
                    for (j = i + 1; j < this.size(); ++j) {
                        if (!(this.Y.getQuick(i) > this.Y.getQuick(j))) continue;
                        tempX = this.X.getQuick(i);
                        tempY = this.Y.getQuick(i);
                        double tempEYu = this.YE1upper.getQuick(i);
                        double tempEYd = this.YE1down.getQuick(i);
                        this.X.setQuick(i, this.getQuickX(j));
                        this.Y.setQuick(i, this.getQuickY(j));
                        this.YE1upper.setQuick(i, this.YE1upper.getQuick(j));
                        this.YE1down.setQuick(i, this.YE1down.getQuick(j));
                        this.X.setQuick(j, tempX);
                        this.Y.setQuick(j, tempY);
                        this.YE1upper.setQuick(j, tempEYu);
                        this.YE1down.setQuick(j, tempEYd);
                    }
                }
            }
        }
    }

    public double integral(int IndexMin, int IndexMax) {
        int Nbins = this.size();
        if (IndexMin > IndexMax) {
            this.ErrorMessage("Wrong index!");
            return -1.0;
        }
        if (IndexMin < 1 || IndexMax > Nbins) {
            this.ErrorMessage("Wrong index!");
            return -1.0;
        }
        double sum = 0.0;
        for (int i = IndexMin - 1; i < IndexMax; ++i) {
            sum += this.getQuickY(i);
        }
        return sum;
    }

    public double integral() {
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            sum += this.getQuickY(i);
        }
        return sum;
    }

    public double varianceX() {
        int k;
        int degrees = this.size() - 1;
        int m = this.size();
        double c = 0.0;
        double s = 0.0;
        for (k = 0; k < m; ++k) {
            s += this.getQuickX(k);
        }
        s /= (double)m;
        for (k = 0; k < m; ++k) {
            c += (this.getQuickX(k) - s) * (this.getQuickX(k) - s);
        }
        double var = c / (double)degrees;
        return var;
    }

    public double stddeviationX() {
        return Math.sqrt(this.varianceX());
    }

    public double stddeviationY() {
        return Math.sqrt(this.varianceY());
    }

    public double varianceY() {
        int k;
        int degrees = this.size() - 1;
        int m = this.size();
        double c = 0.0;
        double s = 0.0;
        for (k = 0; k < m; ++k) {
            s += this.getQuickY(k);
        }
        s /= (double)m;
        for (k = 0; k < m; ++k) {
            c += (this.getQuickY(k) - s) * (this.getQuickY(k) - s);
        }
        double var = c / (double)degrees;
        return var;
    }

    public double rmsX() {
        double mx = 0.0;
        for (int i = 0; i < this.X.size(); ++i) {
            mx += this.X.getQuick(i) * this.X.getQuick(i);
        }
        mx /= (double)this.X.size();
        mx = Math.sqrt(mx);
        return mx;
    }

    public double rmsY() {
        double mx = 0.0;
        for (int i = 0; i < this.Y.size(); ++i) {
            mx += this.Y.getQuick(i) * this.Y.getQuick(i);
        }
        mx /= (double)this.Y.size();
        mx = Math.sqrt(mx);
        return mx;
    }

    public double meanX() {
        double mx = 0.0;
        for (int i = 0; i < this.X.size(); ++i) {
            mx += this.X.getQuick(i);
        }
        return mx /= (double)this.X.size();
    }

    public double meanXerror() {
        return this.stddeviationX() / Math.sqrt(this.size());
    }

    public double meanYerror() {
        return this.stddeviationY() / Math.sqrt(this.size());
    }

    public Map<String, Double> getStat(int axis) {
        HashMap<String, Double> tmp = new HashMap<String, Double>();
        if (axis == 0) {
            tmp.put("mean", this.meanX());
            tmp.put("mean_error", this.meanXerror());
            tmp.put("rms", this.rmsX());
            tmp.put("variance", this.varianceX());
            tmp.put("standardDeviation", this.stddeviationX());
        }
        if (axis == 1) {
            tmp.put("mean", this.meanY());
            tmp.put("mean_error", this.meanYerror());
            tmp.put("rms", this.rmsY());
            tmp.put("variance", this.varianceY());
            tmp.put("standardDeviation", this.stddeviationY());
        }
        return tmp;
    }

    public double meanY() {
        double mx = 0.0;
        for (int i = 0; i < this.Y.size(); ++i) {
            mx += this.Y.getQuick(i);
        }
        return mx /= (double)this.Y.size();
    }

    public void clear() {
        if (this.dimen == 2) {
            this.X.clear();
            this.Y.clear();
        } else if (this.dimen == 3) {
            this.X.clear();
            this.Y.clear();
            this.YE1upper.clear();
        } else if (this.dimen == 4) {
            this.X.clear();
            this.Y.clear();
            this.YE1upper.clear();
            this.YE1down.clear();
        } else if (this.dimen == 6) {
            this.X.clear();
            this.Y.clear();
            this.XE1left.clear();
            this.XE1right.clear();
            this.YE1upper.clear();
            this.YE1down.clear();
        } else if (this.dimen == 10) {
            this.X.clear();
            this.Y.clear();
            this.XE1left.clear();
            this.XE1right.clear();
            this.YE1upper.clear();
            this.YE1down.clear();
            this.XE2left.clear();
            this.XE2right.clear();
            this.YE2upper.clear();
            this.YE2down.clear();
        }
    }

    public void toTable() {
        new HTable(this);
    }

    public void fill(double[] xa, double[] ya) {
        if (xa.length != ya.length) {
            System.out.println("Different dimensions of arrays!");
            return;
        }
        this.setDimension(2);
        for (int i = 0; i < xa.length; ++i) {
            this.X.add(xa[i]);
            this.Y.add(ya[i]);
        }
    }

    public void fill(int[] xa, int[] ya) {
        if (xa.length != ya.length) {
            System.out.println("Different dimensions of arrays!");
            return;
        }
        this.setDimension(2);
        for (int i = 0; i < xa.length; ++i) {
            this.X.add(xa[i]);
            this.Y.add(ya[i]);
        }
    }

    public void fill(P0D xa, P0D ya) {
        if (xa.size() != ya.size()) {
            System.out.println("Different dimensions of arrays!");
            return;
        }
        this.setDimension(2);
        for (int i = 0; i < xa.size(); ++i) {
            this.X.add(xa.getQuick(i));
            this.Y.add(ya.getQuick(i));
        }
    }

    public void fill(Cloud2D c2d) {
        this.setDimension(2);
        for (int i = 0; i < c2d.entries(); ++i) {
            this.X.add(c2d.valueX(i));
            this.Y.add(c2d.valueY(i));
        }
    }

    public DoubleArrayList getXval() {
        return this.X;
    }

    public DoubleArrayList getYval() {
        return this.Y;
    }

    public DoubleArrayList getXE1left() {
        return this.XE1left;
    }

    public DoubleArrayList getXE2left() {
        return this.XE2left;
    }

    public DoubleArrayList getXE1right() {
        return this.XE1right;
    }

    public DoubleArrayList getXE2right() {
        return this.XE2right;
    }

    public DoubleArrayList getYE1down() {
        return this.YE1down;
    }

    public DoubleArrayList getYE1upper() {
        return this.YE1upper;
    }

    public DoubleArrayList getYE2down() {
        return this.YE2down;
    }

    public DoubleArrayList getYE2upper() {
        return this.YE2upper;
    }

    public void setXE1left(DoubleArrayList xE1left) {
        this.XE1left = xE1left;
    }

    public void setXval(DoubleArrayList X) {
        this.X = X;
    }

    public void setXE1right(DoubleArrayList xE1right) {
        this.XE1right = xE1right;
    }

    public void setYE1down(DoubleArrayList yE1down) {
        this.YE1down = yE1down;
    }

    public void setYE1upper(DoubleArrayList yE1upper) {
        this.YE1upper = yE1upper;
    }

    public void setYE2down(DoubleArrayList yE2down) {
        this.YE2down = yE2down;
    }

    public void setYE2upper(DoubleArrayList yE2upper) {
        this.YE2upper = yE2upper;
    }

    public void setYval(DoubleArrayList yval) {
        this.Y = yval;
    }

    public void fill(double[] xa, double[] ya, double[] yerror) {
        if (xa.length != ya.length) {
            System.out.println("Different dimensions of arrays!");
            return;
        }
        if (xa.length != yerror.length) {
            System.out.println("Different dimensions of arrays!");
            return;
        }
        this.setDimension(3);
        this.X.elements(xa);
        this.Y.elements(ya);
        this.YE1upper.elements(yerror);
    }

    public void fill(P0D xa, P0D ya, P0D yerror) {
        if (xa.size() != ya.size()) {
            System.out.println("Different dimensions of arrays!");
            return;
        }
        if (xa.size() != yerror.size()) {
            System.out.println("Different dimensions of arrays!");
            return;
        }
        this.setDimension(3);
        for (int i = 0; i < xa.size(); ++i) {
            this.X.add(xa.getQuick(i));
            this.Y.add(ya.getQuick(i));
            this.YE1upper.add(yerror.getQuick(i));
        }
    }

    public void fill(double[] xa, double[] ya, double[] yupper, double[] ylower) {
        if (xa.length != ya.length) {
            System.out.println("Different dimensions of arrays!");
            return;
        }
        if (xa.length != yupper.length) {
            System.out.println("Different dimensions of arrays!");
            return;
        }
        if (xa.length != ylower.length) {
            System.out.println("Different dimensions of arrays!");
            return;
        }
        this.setDimension(4);
        this.X.elements(xa);
        this.Y.elements(ya);
        this.YE1upper.elements(yupper);
        this.YE1down.elements(ylower);
    }

    public void fill(double[] x, double[] y, double[] left, double[] right, double[] upper, double[] lower, double[] left_sys, double[] right_sys, double[] upper_sys, double[] lower_sys) {
        this.setDimension(10);
        this.X.elements(x);
        this.Y.elements(y);
        this.XE1left.elements(left);
        this.XE1right.elements(right);
        this.XE2left.elements(left_sys);
        this.XE2right.elements(right_sys);
        this.YE1upper.elements(upper);
        this.YE1down.elements(lower);
        this.YE2upper.elements(upper_sys);
        this.YE2down.elements(lower_sys);
    }

    public void setArrayX(double[] x) {
        this.X.clear();
        this.X.elements(x);
    }

    public void setArrayY(double[] y) {
        this.Y.clear();
        this.Y.elements(y);
    }

    private void ErrorMessage(String a) {
        Util.ErrorMessage(a);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

