/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import cern.colt.list.DoubleArrayList;
import cern.hep.aida.bin.DynamicBin1D;
import cern.jet.random.AbstractDistribution;
import cern.jet.stat.Descriptive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jhplot.F1D;
import jhplot.H1D;
import jhplot.HTable;
import jhplot.gui.HelpBrowser;
import jhplot.io.PReader;
import jhplot.io.Serialized;
import jhplot.math.Random;
import jhplot.math.SortUtils;
import jhplot.math.StatisticSample;
import jhplot.math.io.BinaryFile;
import jhplot.utils.Util;

public class P0D
extends DoubleArrayList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DynamicBin1D bin = null;
    private String title = "title undefined";
    private transient Comparator cmp = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };

    public P0D(String title) {
        this.title = title;
    }

    public P0D(double[] d) {
        this.setArray(d);
        this.title = "undefined";
    }

    public P0D(String title, double[] d) {
        this.title = title;
        this.setArray(d);
    }

    public P0D(String title, P0D p0d) {
        this.title = title;
        for (int i = 0; i < p0d.size(); ++i) {
            this.add(p0d.getQuick(i));
        }
    }

    public P0D() {
        this("undefined title");
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public P0D(String title, String sfile) {
        this(title);
        this.read(sfile);
    }

    public int read(BufferedReader br) {
        this.clear();
        try {
            String line;
            long mm = 0L;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.startsWith("*")) continue;
                double dd = 0.0;
                try {
                    dd = Double.parseDouble(line);
                }
                catch (NumberFormatException e) {
                    Util.ErrorMessage("Error in reading the line " + Long.toString(mm + 1L));
                    return 3;
                }
                ++mm;
                this.add(dd);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            Util.ErrorMessage(e.toString());
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 2;
        }
        return 0;
    }

    public int read(File sfile) {
        BufferedReader is = PReader.read(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int read(URL url) {
        BufferedReader is = PReader.read(url);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int readGZip(String sfile) {
        BufferedReader is = PReader.readGZip(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int read(String sfile) {
        BufferedReader is = PReader.read(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int readGZip(File sfile) {
        BufferedReader is = PReader.readGZip(sfile);
        if (is == null) {
            return 1;
        }
        return this.read(is);
    }

    public int readZip(String sfile) {
        this.clear();
        try {
            ZipFile zf = new ZipFile(sfile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            while (entries.hasMoreElements()) {
                String line;
                long size;
                ZipEntry ze = entries.nextElement();
                String inputLine = input.readLine();
                if (!inputLine.equalsIgnoreCase("yes") || (size = ze.getSize()) <= 0L) continue;
                BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.startsWith("*")) continue;
                    double dd = 0.0;
                    long mm = 0L;
                    try {
                        dd = Double.parseDouble(line);
                    }
                    catch (NumberFormatException e) {
                        Util.ErrorMessage("Error in reading the line " + Long.toString(mm + 1L));
                        return 3;
                    }
                    ++mm;
                    this.add(new Double(dd));
                }
                br.close();
            }
        }
        catch (FileNotFoundException e) {
            Util.ErrorMessage("File not found:" + sfile);
            e.printStackTrace();
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 2;
        }
        return 0;
    }

    public void toFile(String name) {
        Date dat = new Date();
        String today = String.valueOf(dat);
        try {
            FileOutputStream f1 = new FileOutputStream(new File(name));
            PrintStream tx = new PrintStream(f1);
            tx.println("# DataMelt: output from P0D " + this.title);
            tx.println("# DataMelt: created at " + today);
            tx.println("#");
            for (int i = 0; i < this.size(); ++i) {
                String x = Double.valueOf(this.get(i)).toString();
                tx.println(x);
            }
            f1.close();
        }
        catch (IOException e) {
            Util.ErrorMessage("Error in the output file");
            e.printStackTrace();
        }
    }

    public void writeBinary(String name) {
        BinaryFile.writeDoubleArray(new File(name), this.getArray(), "BIG_ENDIAN");
    }

    public int writeSerialized(String name) {
        return Serialized.write(this, name);
    }

    public P0D readSerialized(String name) {
        return (P0D)Serialized.read(name);
    }

    public int readBinary(String name) {
        this.clear();
        double[] tmp = BinaryFile.readDoubleArray(new File(name), "BIG_ENDIAN");
        for (int i = 0; i < tmp.length; ++i) {
            this.add(new Double(tmp[i]));
        }
        return 0;
    }

    @Override
    public String toString() {
        String tmp = "P0D " + this.title + "\n";
        for (int i = 0; i < this.size(); ++i) {
            String x = Double.valueOf(this.getQuick(i)).toString();
            tmp = tmp + x + "\n";
        }
        return tmp;
    }

    public void randomNormal(int TotNumber, double mu, double sigma) {
        this.clear();
        for (int i = 0; i < TotNumber; ++i) {
            this.add(Random.normal(mu, sigma));
        }
    }

    public void fill(int TotNumber, double min, double max) {
        if (min > max) {
            Util.ErrorMessage("Min is larger than Max");
            return;
        }
        if (TotNumber < 2) {
            Util.ErrorMessage("Number of points is too small");
            return;
        }
        this.clear();
        double step = (max - min) / (double)(TotNumber - 1);
        for (int i = 0; i < TotNumber; ++i) {
            this.add(min + (double)i * step);
        }
    }

    public void randomUniform(int TotNumber, double min, double max) {
        this.clear();
        for (int i = 0; i < TotNumber; ++i) {
            this.add(Random.uniform(min, max));
        }
    }

    public void random(int TotNumber, AbstractDistribution dist) {
        this.clear();
        for (int i = 0; i < TotNumber; ++i) {
            this.add(dist.nextDouble());
        }
    }

    public H1D getH1D(int bins) {
        double xmax;
        double xmin = this.getMin();
        if (xmin >= (xmax = this.getMax())) {
            xmin = 0.0;
            xmax = 1.0;
            Util.ErrorMessage("Array was not filled?. Using the default max value 1 for the histogram");
        }
        H1D h1d = new H1D(this.title, bins, xmin, xmax);
        for (int i = 0; i < this.size(); ++i) {
            h1d.fill(this.getQuick(i));
        }
        return h1d;
    }

    public H1D getH1D(int bins, double min, double max) {
        H1D h1d = new H1D(this.title, bins, min, max);
        for (int i = 0; i < this.size(); ++i) {
            h1d.fill(this.getQuick(i));
        }
        return h1d;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public P0D merge(P0D a) {
        for (int i = 0; i < a.size(); ++i) {
            this.add(a.getQuick(i));
        }
        return this;
    }

    public void fill(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.add(values[i]);
        }
    }

    public void fill(int[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.add(values[i]);
        }
    }

    @Override
    public P0D copy() {
        return this.copy(this.title);
    }

    public ArrayList<Double> getArrayList() {
        ArrayList<Double> a = new ArrayList<Double>();
        for (int i = 0; i < this.size(); ++i) {
            a.add(new Double(this.getQuick(i)));
        }
        return a;
    }

    public String getStringValues() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            sb.append((Object)this.getQuick(i));
            sb.append(" ");
        }
        return sb.toString();
    }

    public void sort(int fromIndex, int toIndex) {
        this.sortFromTo(fromIndex, toIndex);
    }

    public int hashCode() {
        return this.hashCode();
    }

    public int lastIndexOf(int offset, int value) {
        return this.lastIndexOf(offset, value);
    }

    public boolean containsAll(double[] array) {
        return this.containsAll(array);
    }

    public void removeAll(int min, int max) {
        this.removeFromTo(min, max);
    }

    public void setArrayList(ArrayList<Double> array) {
        this.clear();
        for (int i = 0; i < array.size(); ++i) {
            this.add(array.get(i));
        }
    }

    public void setArray(double[] array) {
        this.clear();
        this.elements(array);
    }

    public void setArray(int[] array) {
        this.clear();
        for (int i = 0; i < array.length; ++i) {
            this.add(array[i]);
        }
    }

    public P0D copy(String newtitle) {
        P0D tmp = new P0D(newtitle);
        for (int i = 0; i < this.size(); ++i) {
            tmp.add(this.getQuick(i));
        }
        return tmp;
    }

    public P0D get(int d, String opi) {
        P0D tmp = new P0D(this.title);
        int op = 0;
        if (opi.equals("=")) {
            op = 1;
        }
        if (opi.equals(">")) {
            op = 2;
        }
        if (opi.equals("<")) {
            op = 3;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (op == 1 && this.getQuick(i) == (double)d) {
                tmp.add(this.getQuick(i));
                continue;
            }
            if (op == 2 && this.getQuick(i) > (double)d) {
                tmp.add(this.getQuick(i));
                continue;
            }
            if (op != 3 || !(this.getQuick(i) < (double)d)) continue;
            tmp.add(this.getQuick(i));
        }
        return tmp;
    }

    public int find(double d) {
        return this.indexOf(d);
    }

    public double[] getArray() {
        this.trimToSize();
        return this.elements();
    }

    public int[] getArrayInt() {
        int[] tmp = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            double tt = this.getQuick(i);
            tmp[i] = (int)tt;
        }
        return tmp;
    }

    public int search(double value) {
        return this.indexOf(value);
    }

    public double getMax() {
        if (this.size() > 0) {
            return Descriptive.max(this);
        }
        return 0.0;
    }

    public int getMaxIndex() {
        if (this.size() == 0) {
            return -1;
        }
        int maxI = 0;
        for (int i = 1; i < this.size(); ++i) {
            if (!(this.get(i) > this.getQuick(maxI))) continue;
            maxI = i;
        }
        return maxI;
    }

    public int getMinIndex() {
        if (this.size() == 0) {
            return -1;
        }
        int minI = 0;
        for (int i = 1; i < this.size(); ++i) {
            if (!(this.get(i) < this.getQuick(minI))) continue;
            minI = i;
        }
        return minI;
    }

    public double getMin() {
        if (this.size() > 0) {
            Descriptive.min(this);
        }
        return 0.0;
    }

    public P0D range(int min, int max) {
        this.partFromTo(min, max);
        return this;
    }

    public P0D oper(P0D p0d, String what) {
        return this.oper(p0d, this.title, what);
    }

    public P0D operScale(double scale) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, this.getQuick(i) * scale);
        }
        return this;
    }

    public P0D operShift(double shift) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, this.getQuick(i) + shift);
        }
        return this;
    }

    public P0D operShiftAndScale(double shift, double scale) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, (this.getQuick(i) + shift) * scale);
        }
        return this;
    }

    public double getSum() {
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            d += this.getQuick(i);
        }
        return d;
    }

    public P0D oper(P0D p0d, String title, String what) {
        what = what.trim();
        if (this.size() != p0d.size()) {
            Util.ErrorMessage("Sizes of the P0Ds are different!");
            return this;
        }
        if (what.equals("+")) {
            for (int i = 0; i < this.size(); ++i) {
                this.set(i, p0d.getQuick(i) + this.getQuick(i));
            }
            return this;
        }
        if (what.equals("-")) {
            for (int i = 0; i < this.size(); ++i) {
                this.set(i, this.getQuick(i) - p0d.getQuick(i));
            }
            return this;
        }
        if (what.equals("*")) {
            for (int i = 0; i < this.size(); ++i) {
                this.set(i, this.getQuick(i) * p0d.getQuick(i));
            }
            return this;
        }
        if (what.equals("/")) {
            for (int i = 0; i < this.size(); ++i) {
                this.set(i, this.getQuick(i) / p0d.getQuick(i));
            }
            return this;
        }
        return this;
    }

    public double mean() {
        double mean = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            mean += this.getQuick(i);
        }
        return mean /= (double)this.size();
    }

    public double kurtosis() {
        if (this.bin == null) {
            System.out.println("Run first getStat() to evaluate sampling!");
            return -9999.0;
        }
        return this.bin.kurtosis();
    }

    public double median() {
        if (this.bin == null) {
            System.out.println("Run first getStat() to evaluate sampling!");
            return -9999.0;
        }
        return this.bin.median();
    }

    public String getStatString() {
        this.bin = new DynamicBin1D();
        DoubleArrayList a = new DoubleArrayList(this.elements());
        this.bin.addAllOf(a);
        return this.bin.toString();
    }

    public Map<String, Double> getStat() {
        this.bin = new DynamicBin1D();
        DoubleArrayList a = new DoubleArrayList(this.elements());
        this.bin.addAllOf(a);
        HashMap<String, Double> tmp = new HashMap<String, Double>();
        double m = this.bin.mean();
        tmp.put("size", Double.valueOf(this.size()));
        tmp.put("sum", this.bin.sum());
        tmp.put("mean", m);
        tmp.put("kurtosis", this.bin.kurtosis());
        tmp.put("median", this.bin.median());
        tmp.put("rms", this.bin.rms());
        tmp.put("skew", this.bin.skew());
        tmp.put("standardDeviation", this.bin.standardDeviation());
        tmp.put("mean_error", this.bin.standardError());
        tmp.put("sumOfInversions", this.bin.sumOfInversions());
        tmp.put("variance", this.bin.variance());
        tmp.put("geometricMean", this.bin.geometricMean());
        tmp.put("harmonicMean", this.bin.harmonicMean());
        tmp.put("moment_1", this.bin.moment(0, 0.0));
        tmp.put("moment_2", this.bin.moment(2, 0.0));
        tmp.put("moment_3", this.bin.moment(3, 0.0));
        tmp.put("moment_4", this.bin.moment(4, 0.0));
        tmp.put("moment_5", this.bin.moment(5, 0.0));
        tmp.put("moment_1_mean", this.bin.moment(0, m));
        tmp.put("moment_2_mean", this.bin.moment(2, m));
        tmp.put("moment_3_mean", this.bin.moment(3, m));
        tmp.put("moment_4_mean", this.bin.moment(4, m));
        tmp.put("moment_5_mean", this.bin.moment(5, m));
        return tmp;
    }

    public double moment(int k, double c) {
        if (this.bin == null) {
            System.out.println("Run first getStat() to evaluate sampling!");
            return -9999.0;
        }
        return this.bin.moment(k, c);
    }

    public double standardError() {
        if (this.bin == null) {
            System.out.println("Run first getStat() to evaluate sampling!");
            return -9999.0;
        }
        return this.bin.standardError();
    }

    public double skew() {
        if (this.bin == null) {
            System.out.println("Run first getStat() to evaluate sampling!");
            return -9999.0;
        }
        return this.bin.skew();
    }

    public double variance() {
        if (this.bin == null) {
            System.out.println("Run first getStat() to evaluate sampling!");
            return -9999.0;
        }
        return this.bin.variance();
    }

    public double stddeviation() {
        if (this.bin == null) {
            System.out.println("Run first getStat() to evaluate sampling!");
            return -9999.0;
        }
        return this.bin.standardDeviation();
    }

    public double covariance(P0D p0d) {
        return StatisticSample.covariance(this.getArray(), p0d.getArray());
    }

    public double correlation(P0D p0d) {
        return StatisticSample.correlation(this.getArray(), p0d.getArray());
    }

    public P0D func(F1D f1d) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, f1d.eval(this.getQuick(i)));
        }
        return this;
    }

    public P0D func(String title, F1D f1d) {
        this.title = title;
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, f1d.eval(this.getQuick(i)));
        }
        return this;
    }

    public int[] sortIndex() {
        Object[] clone = new Double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            clone[i] = this.getQuick(i);
        }
        int[] indeces = SortUtils.identity(this.size());
        SortUtils.sort(indeces, clone, this.cmp, true);
        return indeces;
    }

    public void toTable() {
        new HTable(this);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

