/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JLabel;
import javax.swing.Timer;
import jhplot.gui.HelpBrowser;

public class JHPlot {
    public static JLabel statusbar;
    public static boolean ReadFile;
    private static String BUILD_DATE;
    private static String BUILD_BY;
    private static String VERSION;
    private static String CREATED_BY;
    public static double Xpos;
    public static double Ypos;
    public static final int SECONDS = 3000;
    public static Timer timer;
    private static boolean firstTime;

    public static void init() {
        ReadFile = false;
        statusbar = new JLabel("jHPlot is ready");
        statusbar.setFont(new Font("Serif", 0, 12));
        JHPlot.readInfo();
        Xpos = 0.0;
        Ypos = 0.0;
    }

    public static void readInfo() {
        timer = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                timer.stop();
            }
        });
        timer.setRepeats(false);
        BUILD_DATE = "20070120";
        BUILD_BY = "S.Chekanov";
        VERSION = "1.0";
        CREATED_BY = "SUN 1.5";
        Thread t = new Thread(){

            @Override
            public void run() {
                if (firstTime) {
                    JHPlot.version();
                }
            }
        };
        t.start();
    }

    public static void showMouse(String message, double X, double Y, double Xndc, double Yndc, int Xpix, int Ypix) {
        Xpos = X;
        Ypos = Y;
        DecimalFormat dfb1 = new DecimalFormat("#.##E00");
        String s1 = dfb1.format(Xpos);
        String s2 = dfb1.format(Ypos);
        if (s1.endsWith("E00")) {
            s1 = s1.substring(0, s1.length() - 3);
        }
        if (s2.endsWith("E00")) {
            s2 = s2.substring(0, s2.length() - 3);
        }
        DecimalFormat dfb2 = new DecimalFormat("#.##");
        String ss1 = dfb2.format(Xndc);
        String ss2 = dfb2.format(Yndc);
        String user = "USER: (" + s1 + ",  " + s2 + ")";
        String ndc = "NDC: (" + ss1 + ",  " + ss2 + ")";
        String pix = "Pixels: (" + Integer.toString(Xpix) + ",  " + Integer.toString(Ypix) + ")";
        JHPlot.showStatusBarText(message + ": " + user + "  " + ndc + "  " + pix);
    }

    public static void showStatusBarText(String text) {
        statusbar.setText(text);
        if (timer.isRunning()) {
            timer.restart();
        } else {
            timer.start();
        }
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public static void showMessage(String text) {
        statusbar.setText(text);
    }

    public static void printVersion() {
        System.out.println("Author: " + BUILD_BY);
        System.out.println("Version: " + VERSION);
        System.out.println("Build: " + BUILD_DATE);
    }

    public static String getAuthor() {
        return BUILD_BY;
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getBuildTime() {
        return BUILD_DATE;
    }

    public static String getCreatedBy() {
        return CREATED_BY;
    }

    public static String[] getInfo() {
        String[] vv = new String[]{BUILD_BY, VERSION, BUILD_DATE};
        return vv;
    }

    private static void version() {
        BUILD_DATE = "20070120";
        BUILD_BY = "S.Chekanov";
        VERSION = "1.0";
        CREATED_BY = "SUN 1.5";
        String JARFILE = "jhplot.jar";
        String classpath = System.getProperty("java.class.path");
        String pathsep = System.getProperty("path.separator");
        StringTokenizer t = new StringTokenizer(classpath, pathsep, false);
        while (t.hasMoreElements()) {
            String path = t.nextToken();
            if (path.indexOf("jhplot.jar") <= -1) continue;
            try {
                JarFile jf = new JarFile(path);
                Manifest m = jf.getManifest();
                Attributes attribs = m.getMainAttributes();
                BUILD_DATE = attribs.getValue("Built-Date");
                BUILD_BY = attribs.getValue("Built-By");
                CREATED_BY = attribs.getValue("Created-By");
                VERSION = attribs.getValue("Version");
                firstTime = false;
                if (statusbar != null) {
                    JHPlot.showStatusBarText("version:" + VERSION + " build:" + BUILD_DATE);
                }
            }
            catch (IOException e) {
                System.out.println("Cannot read jar-file manifest: jhplot.jar");
            }
            return;
        }
    }

    static {
        ReadFile = false;
        firstTime = true;
    }
}

