/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JOptionPane;
import jhplot.FPR;
import jhplot.gui.GHFrame;
import jhplot.gui.HelpBrowser;
import jhplot.utils.HelpDialog;
import jplot3dp.MainComponent;

public class HPlot3DP
extends GHFrame {
    private static final long serialVersionUID = 1L;
    public boolean set = true;
    private MainComponent[][] jpp;
    private Thread1 m_Close;
    private int xsize;
    private int ysize;
    private final String help_file = "hplot3ds";

    public HPlot3DP(String title, int xsize, int ysize, int n1, int n2, boolean set) {
        super(title, xsize, ysize, n1, n2, set);
        this.xsize = xsize;
        this.ysize = ysize;
        if (set) {
            this.setGraph();
        }
    }

    @Override
    protected void clearFrame() {
    }

    @Override
    protected void refreshFrame() {
    }

    @Override
    protected void openWriteDialog() {
        this.jpp[N1][N2].saveToFile(false);
    }

    @Override
    protected void openReadDialog() {
        this.jpp[N1][N2].loadFromFile();
    }

    public void visible(boolean vs) {
        if (!vs) {
            this.mainFrame.setVisible(false);
            this.mainFrame.validate();
        }
        if (vs) {
            this.showIt();
        }
    }

    public void visible(int posX, int posY) {
        this.updateAll();
        this.mainFrame.setLocation(posX, posY);
        this.mainFrame.setVisible(true);
    }

    public void visible() {
        this.showIt();
    }

    private void showIt() {
        this.updateAll();
        this.mainFrame.setVisible(true);
    }

    public void destroy() {
        this.mainFrame.setVisible(false);
        this.close();
    }

    private void setGraph() {
        this.jpp = new MainComponent[this.N1final][this.N2final];
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                this.jpp[i1][i2] = new MainComponent(this.getFrame());
                this.mainPanel.add(this.jpp[i1][i2]);
            }
        }
    }

    public void resizePad(double widthScale, double heightScale) {
        Dimension dim = this.jpp[N1][N2].getSize();
        double h = dim.getHeight();
        double w = dim.getWidth();
        this.jpp[N1][N2].setPreferredSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.jpp[N1][N2].setMinimumSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.jpp[N1][N2].setSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.mainPanel.updateUI();
    }

    private void update(int n1, int n2) {
        this.jpp[n1][n2].update();
    }

    public void update() {
        this.update(N1, N2);
    }

    public void updateAll() {
        if (this.N1final == 0 && this.N2final == 0) {
            return;
        }
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.update(i1, i2);
            }
        }
    }

    public HPlot3DP(String title, int xs, int ys) {
        this(title, xs, ys, 1, 1, true);
        this.xsize = xs;
        this.ysize = ys;
    }

    public HPlot3DP(String title, int xs, int ys, int n1, int n2) {
        this(title, xs, ys, n1, n2, true);
        this.xsize = xs;
        this.ysize = ys;
    }

    public HPlot3DP(String title) {
        this(title, 600, 400, 1, 1, true);
        this.xsize = 600;
        this.ysize = 400;
    }

    public HPlot3DP() {
        this("Default", 600, 400, 1, 1, true);
    }

    public void clear() {
        this.clear(N1, N2);
    }

    public void clear(int i1, int i2) {
        this.setGTitle("");
        System.gc();
    }

    public void draw(FPR h) {
        if (h.getLabelX() != null && h.getLabelX().length() > 0) {
            this.setNameX(h.getLabelX());
        }
        if (h.getLabelY() != null && h.getLabelY().length() > 0) {
            this.setNameY(h.getLabelY());
        }
        this.jpp[N1][N2].setFunction(h);
    }

    public void draw(FPR[] f) {
        for (int i = 0; i < f.length; ++i) {
            this.draw(f[i]);
        }
    }

    public void setRangeX(double min, double max) {
        this.jpp[N1][N2].getModel().setRangeX(min, max);
    }

    public void setRangeY(double min, double max) {
        this.jpp[N1][N2].getModel().setRangeY(min, max);
    }

    public void setRangeZ(double min, double max) {
        this.jpp[N1][N2].getModel().setRangeZ(min, max);
    }

    public void setFov(double factor) {
        this.jpp[N1][N2].setFov(factor);
    }

    public double getFov() {
        return this.jpp[N1][N2].getFov();
    }

    public void setBackgColor(Color c) {
        this.jpp[N1][N2].setBackgroundFrame(c);
    }

    public void setEyePosition(double x, double y, double z) {
        this.jpp[N1][N2].getModel().setEyePosition(x, y, z);
    }

    public void setAxisArrows(boolean showArrows) {
        this.jpp[N1][N2].getModel().setAxisArrows(showArrows);
    }

    public double[] getEyePosition() {
        return this.jpp[N1][N2].getModel().getEyePosition();
    }

    public double getCameraPosition() {
        return this.jpp[N1][N2].getModel().getCameraPosition();
    }

    public void setCameraPosition(double d) {
        this.jpp[N1][N2].getModel().cameraForward(d);
    }

    public void setFog(boolean fogEnabled) {
        this.jpp[N1][N2].setFog(fogEnabled);
    }

    public void setAxes(boolean bShowAxes) {
        this.jpp[N1][N2].getModel().setShowAxes(bShowAxes, bShowAxes, bShowAxes);
    }

    public void setNameX(String name) {
        this.jpp[N1][N2].getModel().setNameX(name);
    }

    public void setNameY(String name) {
        this.jpp[N1][N2].getModel().setNameY(name);
    }

    public void setNameZ(String name) {
        this.jpp[N1][N2].getModel().setNameZ(name);
    }

    public void setLabelFont(Font font) {
        this.jpp[N1][N2].getModel().setLabelFont(font);
    }

    public void setLabelColor(Color color) {
        this.jpp[N1][N2].getModel().setLabelColor(color);
    }

    public void setAxesColor(Color c) {
        this.jpp[N1][N2].getModel().setAxesColor(c);
    }

    public void setFontValue(Font font) {
        this.jpp[N1][N2].getModel().setValueFont(font);
    }

    public void setAxes(boolean axisX, boolean axisY, boolean axisZ) {
        this.jpp[N1][N2].getModel().setShowAxes(axisX, axisY, axisZ);
    }

    public void setAxesArrows(boolean showArrows) {
        this.jpp[N1][N2].getModel().setAxisArrows(showArrows);
    }

    public void clearAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.clear(i1, i2);
            }
        }
        System.gc();
    }

    public void close() {
        this.mainFrame.setVisible(false);
        this.m_Close = new Thread1("Closing softly");
        if (!this.m_Close.Alive()) {
            this.m_Close.Start();
        }
    }

    public void quit() {
        this.doNotShowFrame();
        this.clearAll();
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.jpp[i1][i2] = null;
            }
        }
        this.jpp = null;
        this.removeFrame();
    }

    @Override
    protected void quitFrame() {
        this.close();
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    @Override
    protected void openReadDataDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for this canvas");
    }

    @Override
    protected void showHelp() {
        new HelpDialog((Component)this.getFrame(), "hplot3ds.html");
    }

    class Thread1
    implements Runnable {
        private Thread t = null;
        private String mess;

        Thread1(String s1) {
            this.mess = s1;
        }

        public boolean Alive() {
            boolean tt = false;
            if (this.t != null && this.t.isAlive()) {
                tt = true;
            }
            return tt;
        }

        public boolean Joint() {
            boolean tt = false;
            try {
                this.t.join();
                return true;
            }
            catch (InterruptedException interruptedException) {
                return tt;
            }
        }

        public void Start() {
            this.t = new Thread((Runnable)this, this.mess);
            this.t.start();
        }

        public void Stop() {
            this.t = null;
        }

        @Override
        public void run() {
            HPlot3DP.this.quit();
        }
    }
}

