/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.Histogram2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JOptionPane;
import jhplot.F2D;
import jhplot.H2D;
import jhplot.HLabel;
import jhplot.P1D;
import jhplot.gui.GHFrame;
import jhplot.gui.HelpBrowser;
import sgtplot.Attribute;
import sgtplot.Axis;
import sgtplot.ColorKey;
import sgtplot.ColorMap;
import sgtplot.ContourLevels;
import sgtplot.GridAttribute;
import sgtplot.IndexedColorMap;
import sgtplot.Layer;
import sgtplot.LinearTransform;
import sgtplot.PlainAxis;
import sgtplot.SGLabel;
import sgtplot.SgtContour;
import sgtplot.TestData;
import sgtplot.VectorAttribute;
import sgtplot.dm.Collection;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTMetaData;
import sgtplot.dm.SGTVector;
import sgtplot.dm.SimpleGrid;
import sgtplot.dm.SimplePoint;
import sgtplot.swing.JPlotLayout;
import sgtplot.util.Point2D;
import sgtplot.util.Range2D;

public class HPlot2D
extends GHFrame {
    private static final long serialVersionUID = 1L;
    private SgtContour[][] cp;
    private GridAttribute[][] gridAtt;
    private ContourLevels[][] clevels;
    private ColorMap[][] colormap;
    private int width = 600;
    private int height = 400;
    private String[][] titleG;
    private String[][] titleX;
    private String[][] titleY;
    private Range2D[][] xA;
    private Range2D[][] yA;
    private Range2D[][] levels;
    private boolean[][] autorangeX;
    private boolean[][] autorangeY;
    private boolean[][] autorangeZ;
    private int[][] style = new int[this.N1final][this.N2final];
    private Thread1 m_Close;

    public HPlot2D(String title, int xsize, int ysize, int n1, int n2, boolean set) {
        super(title, xsize, ysize, n1, n2, set);
        this.autorangeX = new boolean[this.N1final][this.N2final];
        this.autorangeY = new boolean[this.N1final][this.N2final];
        this.autorangeZ = new boolean[this.N1final][this.N2final];
        this.levels = new Range2D[this.N1final][this.N2final];
        this.cp = new SgtContour[this.N1final][this.N2final];
        this.gridAtt = new GridAttribute[this.N1final][this.N2final];
        this.clevels = new ContourLevels[this.N1final][this.N2final];
        this.colormap = new ColorMap[this.N1final][this.N2final];
        this.titleG = new String[this.N1final][this.N2final];
        this.titleX = new String[this.N1final][this.N2final];
        this.titleY = new String[this.N1final][this.N2final];
        this.xA = new Range2D[this.N1final][this.N2final];
        this.yA = new Range2D[this.N1final][this.N2final];
        Font fleg = new Font("Arial", 1, 12);
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                this.titleG[i1][i2] = "";
                this.titleX[i1][i2] = "X";
                this.titleY[i1][i2] = "Y";
                this.style[i1][i2] = 0;
                this.autorangeX[i1][i2] = true;
                this.autorangeY[i1][i2] = true;
                this.autorangeZ[i1][i2] = true;
                this.cp[i1][i2] = new SgtContour(this.width / this.N1final, this.height / this.N2final);
                this.levels[i1][i2] = new Range2D(0.0, 100.0, 20.0);
                this.colormap[i1][i2] = this.createColorMap(this.levels[i1][i2]);
                this.clevels[i1][i2] = ContourLevels.getDefault(this.levels[i1][i2]);
                this.gridAtt[i1][i2] = new GridAttribute(this.clevels[i1][i2]);
                this.gridAtt[i1][i2].setColorMap(this.colormap[i1][i2]);
                this.gridAtt[i1][i2].setStyle(3);
                this.xA[i1][i2] = new Range2D(0.0, 1.0, 0.02);
                this.yA[i1][i2] = new Range2D(0.0, 1.0, 0.02);
                this.cp[i1][i2].getPlot().getAxis(0).setLabelFont(fleg);
                this.cp[i1][i2].getPlot().getAxis(1).setLabelFont(fleg);
                this.cp[i1][i2].getPlot().getAxis(0).setLabelHeightP(0.04);
                this.cp[i1][i2].getPlot().getAxis(1).setLabelHeightP(0.04);
                if (!set) continue;
                this.mainPanel.add(this.cp[i1][i2]);
            }
        }
    }

    public void resizePad(double widthScale, double heightScale) {
        Dimension dim = this.cp[N1][N2].getSize();
        double h = dim.getHeight();
        double w = dim.getWidth();
        this.cp[N1][N2].setPreferredSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.cp[N1][N2].setMinimumSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.cp[N1][N2].setSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
    }

    public void resizePad(int n1, int n2, double widthScale, double heightScale) {
        Dimension dim = this.cp[n1][n2].getSize();
        double h = dim.getHeight();
        double w = dim.getWidth();
        this.cp[n1][n2].setPreferredSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.cp[n1][n2].setMinimumSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.cp[n1][n2].setSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
    }

    public void draw(Cloud2D c2d) {
        this.draw(new H2D(c2d, 100, 100));
    }

    public void draw(Histogram2D h1d) {
        this.draw(new H2D(h1d));
    }

    public void draw(H2D h) {
        double dx = 1.0;
        double dy = 1.0;
        if (h.getLabelX() != null && h.getLabelX().length() > 0) {
            this.setNameX(h.getLabelX());
        }
        if (h.getLabelY() != null && h.getLabelY().length() > 0) {
            this.setNameY(h.getLabelY());
        }
        Histogram2D h2d = h.get();
        double binHight = h2d.maxBinHeight();
        double Xmin = h2d.xAxis().lowerEdge();
        double Xmax = h2d.xAxis().upperEdge();
        int nx = h2d.xAxis().bins();
        double Ymin = h2d.yAxis().lowerEdge();
        double Ymax = h2d.yAxis().upperEdge();
        int ny = h2d.yAxis().bins();
        double X1 = this.xA[HPlot2D.N1][HPlot2D.N2].start;
        double X2 = this.xA[HPlot2D.N1][HPlot2D.N2].end;
        double Y1 = this.yA[HPlot2D.N1][HPlot2D.N2].start;
        double Y2 = this.yA[HPlot2D.N1][HPlot2D.N2].end;
        double[] x = new double[nx];
        double[] y = new double[ny];
        int[] xi = new int[nx];
        int[] yi = new int[ny];
        int count = 0;
        Ymin = Math.min(Ymin, Ymax);
        Xmin = Math.min(Xmin, Xmax);
        int NYY = 0;
        for (int j = 0; j < ny; ++j) {
            double yy = h2d.yAxis().binCenter(j + 1);
            boolean failedY = false;
            if (!this.autorangeY[N1][N2] && (yy < Y1 || yy > Y2)) {
                failedY = true;
            }
            if (failedY) continue;
            y[NYY] = yy;
            yi[NYY] = j;
            ++NYY;
        }
        int NXX = 0;
        for (int i = 0; i < nx; ++i) {
            double xx = h2d.xAxis().binCenter(i + 1);
            boolean failedX = false;
            if (!this.autorangeX[N1][N2] && (xx < X1 || xx > X2)) {
                failedX = true;
            }
            if (failedX) continue;
            x[NXX] = xx;
            xi[NXX] = i;
            ++NXX;
        }
        double[] grid = new double[NXX * NYY];
        double[] xx1 = new double[NXX];
        double[] yy1 = new double[NYY];
        count = 0;
        for (int j = 0; j < NYY; ++j) {
            yy1[j] = y[j];
            for (int i = 0; i < NXX; ++i) {
                xx1[i] = x[i];
                grid[count] = h2d.binHeight(xi[i] + 1, yi[j] + 1);
                ++count;
            }
        }
        this.drawer(grid, xx1, yy1, null, binHight);
    }

    public void add(HLabel label, double textHeight) {
        double x = label.getX();
        double y = label.getY();
        Layer layer = this.cp[N1][N2].getPlot().getFirstLayer();
        Point2D.Double pp = null;
        if (label.getPositionCoordinate() == 1) {
            pp = new Point2D.Double(x, y);
        } else if (label.getPositionCoordinate() == 2) {
            Range2D xR = this.cp[N1][N2].getPlot().getRange().getXRange();
            Range2D yR = this.cp[N1][N2].getPlot().getRange().getYRange();
            double xu = this.cp[N1][N2].getPlot().fromUserX(x, xR);
            double yu = this.cp[N1][N2].getPlot().fromUserY(y, yR);
            pp = new Point2D.Double(xu, yu);
        }
        SGLabel mainTitle = new SGLabel("Line Profile Title", "Profile Plot", textHeight, pp, 2, 1);
        mainTitle.setColor(label.getColor());
        mainTitle.setFont(label.getFont());
        mainTitle.setText(label.getText());
        layer.addChild(mainTitle);
    }

    public ColorKey getColorBar() {
        return this.cp[N1][N2].getPlot().getColorBar();
    }

    public void setColorBar(ColorKey k) {
        this.cp[N1][N2].getPlot().setColorBar(k);
    }

    private void drawer(Collection coll) {
    }

    private void drawer(double[] grid, double[] x, double[] y, String title, double Zmax) {
        SGLabel keyLabel = new SGLabel("Key Label", "", new Point2D.Double(0.0, 0.0));
        keyLabel.setHeightP(0.16);
        keyLabel.setText(this.titleG[N1][N2]);
        SGTMetaData xMeta = new SGTMetaData(this.titleX[N1][N2], "ms");
        SGTMetaData yMeta = new SGTMetaData(this.titleY[N1][N2], "ms");
        SimpleGrid sg = new SimpleGrid(grid, x, y, title);
        sg.setXMetaData(xMeta);
        sg.setYMetaData(yMeta);
        sg.setKeyTitle(keyLabel);
        if (this.autorangeZ[N1][N2]) {
            double d = Zmax * 1.1 / 7.0;
            this.levels[HPlot2D.N1][HPlot2D.N2] = new Range2D(0.0, Zmax * 1.1, d);
        }
        this.colormap[HPlot2D.N1][HPlot2D.N2] = this.createColorMap(this.levels[N1][N2]);
        this.clevels[HPlot2D.N1][HPlot2D.N2] = ContourLevels.getDefault(this.levels[N1][N2]);
        this.gridAtt[HPlot2D.N1][HPlot2D.N2] = new GridAttribute(this.clevels[N1][N2]);
        this.gridAtt[N1][N2].setColorMap(this.colormap[N1][N2]);
        if (this.style[N1][N2] == 0) {
            this.gridAtt[N1][N2].setStyle(0);
            this.cp[N1][N2].getPlot().setTitles("", "", "");
            this.cp[N1][N2].getPlot().addData(sg, (Attribute)this.gridAtt[N1][N2], title);
            this.cp[N1][N2].getPlot().getColorBar().setVisible(true);
            this.cp[N1][N2].buildPlot(true);
        } else if (this.style[N1][N2] == 1) {
            this.gridAtt[N1][N2].setStyle(2);
            this.cp[N1][N2].getPlot().addData(sg, (Attribute)this.gridAtt[N1][N2], title);
            this.cp[N1][N2].buildPlot(false);
            this.cp[N1][N2].getPlot().getColorBar().setVisible(false);
        } else if (this.style[N1][N2] == 2) {
            this.gridAtt[N1][N2].setStyle(3);
            this.cp[N1][N2].getPlot().setTitles(this.titleG[N1][N2], this.titleG[N1][N2], "");
            this.cp[N1][N2].getPlot().addData(sg, (Attribute)this.gridAtt[N1][N2], title);
            this.cp[N1][N2].getPlot().getColorBar().setVisible(true);
            this.cp[N1][N2].buildPlot(true);
        } else if (this.style[N1][N2] == 3) {
            this.gridAtt[N1][N2].setStyle(1);
            this.cp[N1][N2].getPlot().setTitles(this.titleG[N1][N2], this.titleG[N1][N2], "");
            this.cp[N1][N2].getPlot().addData(sg, (Attribute)this.gridAtt[N1][N2], title);
            this.cp[N1][N2].buildPlot(false);
        } else if (this.style[N1][N2] == 4) {
            this.gridAtt[N1][N2].setStyle(4);
            this.cp[N1][N2].getPlot().addData(sg, (Attribute)this.gridAtt[N1][N2], title);
            this.cp[N1][N2].buildPlot(false);
        } else if (this.style[N1][N2] == 5) {
            this.cp[N1][N2].buildVectors();
            SGTVector vector = new SGTVector(sg, sg);
            VectorAttribute vectorAttr = new VectorAttribute(0.0075, Color.red);
            vectorAttr.setHeadScale(0.5);
            this.cp[N1][N2].getPlot().setTitles(this.titleG[N1][N2], this.titleG[N1][N2], "");
            this.cp[N1][N2].getPlot().addData(vector, (Attribute)vectorAttr, title);
        }
        this.cp[N1][N2].revalidate();
        this.cp[N1][N2].repaint();
    }

    public void update() {
        this.cp[N1][N2].revalidate();
        this.cp[N1][N2].repaint();
    }

    public JPlotLayout getPlotCanvas() {
        return this.cp[N1][N2].getPlot();
    }

    public void draw(P1D h) {
        double Ymax;
        double Ymin;
        double Xmax;
        double Xmin;
        int nx = 1;
        int ny = 1;
        double dx = 1.0;
        double dy = 1.0;
        if (!this.autorangeX[N1][N2]) {
            Xmin = this.xA[HPlot2D.N1][HPlot2D.N2].start;
            Xmax = this.xA[HPlot2D.N1][HPlot2D.N2].end;
            nx = (int)((Xmax - Xmin) / this.xA[HPlot2D.N1][HPlot2D.N2].delta);
            dx = this.xA[HPlot2D.N1][HPlot2D.N2].delta;
        } else {
            Xmin = h.getMin(0);
            Xmax = h.getMax(0);
            nx = 60;
            dx = Math.abs(Xmax - Xmin) / (double)nx;
        }
        if (!this.autorangeY[N1][N2]) {
            Ymin = this.yA[HPlot2D.N1][HPlot2D.N2].start;
            Ymax = this.yA[HPlot2D.N1][HPlot2D.N2].end;
            ny = (int)((Ymax - Ymin) / this.yA[HPlot2D.N1][HPlot2D.N2].delta);
            dy = this.yA[HPlot2D.N1][HPlot2D.N2].delta;
        } else {
            Ymin = h.getMin(1);
            Ymax = h.getMax(1);
            ny = 60;
            dy = Math.abs(Ymax - Ymin) / (double)ny;
        }
        this.xA[HPlot2D.N1][HPlot2D.N2] = new Range2D(Xmin, Xmax, dx);
        this.yA[HPlot2D.N1][HPlot2D.N2] = new Range2D(Ymin, Ymax, dy);
        if (nx < 1) {
            nx = 1;
        }
        if (ny < 1) {
            ny = 1;
        }
        if (this.style[N1][N2] < 6) {
            double[] grid = new double[nx * ny];
            double[] x = new double[nx];
            double[] y = new double[ny];
            int count = 0;
            Ymin = Math.min(Ymin, Ymax);
            Xmin = Math.min(Xmin, Xmax);
            double max = -1.0E25;
            for (int j = 0; j < ny; ++j) {
                double y1 = Ymin + (double)j * dy;
                double y2 = Ymin + (double)(j + 1) * dy;
                y[j] = y1 + 0.5 * dy;
                for (int i = 0; i < nx; ++i) {
                    double x1 = Xmin + (double)i * dx;
                    double x2 = Xmin + (double)(i + 1) * dx;
                    x[i] = x1 + 0.5 * dx;
                    int con = 0;
                    for (int m = 0; m < h.size(); ++m) {
                        if (!(h.getX(m) > x1) || !(h.getX(m) < x2) || !(h.getY(m) > y1) || !(h.getY(m) < y2)) continue;
                        ++con;
                    }
                    grid[count] = con;
                    if ((double)con > max) {
                        max = con;
                    }
                    ++count;
                }
            }
            this.drawer(grid, x, y, null, max);
        } else if (this.style[N1][N2] == 6) {
            Collection coll = new Collection(h.getTitle(), h.size());
            for (int j = 0; j < h.size(); ++j) {
                SimplePoint sp = new SimplePoint(h.getX(j), h.getY(j), null);
                coll.addElement(sp);
            }
            this.drawer(coll);
        }
    }

    public void draw(F2D h) {
        double Ymax;
        double Ymin;
        double Xmax;
        double Xmin;
        if (h.getLabelX() != null && h.getLabelX().length() > 0) {
            this.setNameX(h.getLabelX());
        }
        if (h.getLabelY() != null && h.getLabelY().length() > 0) {
            this.setNameY(h.getLabelY());
        }
        int nx = 1;
        int ny = 1;
        double dx = 1.0;
        double dy = 1.0;
        if (!this.autorangeX[N1][N2]) {
            Xmin = this.xA[HPlot2D.N1][HPlot2D.N2].start;
            Xmax = this.xA[HPlot2D.N1][HPlot2D.N2].end;
            nx = (int)((Xmax - Xmin) / this.xA[HPlot2D.N1][HPlot2D.N2].delta);
            dx = this.xA[HPlot2D.N1][HPlot2D.N2].delta;
        } else {
            Xmin = 0.0;
            Xmax = 1.0;
            nx = 60;
            dx = Math.abs(Xmax - Xmin) / (double)nx;
        }
        if (!this.autorangeY[N1][N2]) {
            Ymin = this.yA[HPlot2D.N1][HPlot2D.N2].start;
            Ymax = this.yA[HPlot2D.N1][HPlot2D.N2].end;
            ny = (int)((Ymax - Ymin) / this.yA[HPlot2D.N1][HPlot2D.N2].delta);
            dy = this.yA[HPlot2D.N1][HPlot2D.N2].delta;
        } else {
            Ymin = 0.0;
            Ymax = 1.0;
            ny = 60;
            dy = Math.abs(Ymax - Ymin) / (double)ny;
        }
        this.xA[HPlot2D.N1][HPlot2D.N2] = new Range2D(Xmin, Xmax, dx);
        this.yA[HPlot2D.N1][HPlot2D.N2] = new Range2D(Ymin, Ymax, dy);
        if (nx < 1) {
            nx = 1;
        }
        if (ny < 1) {
            ny = 1;
        }
        double[] grid = new double[nx * ny];
        double[] x = new double[nx];
        double[] y = new double[ny];
        int count = 0;
        Ymin = Math.min(Ymin, Ymax);
        Xmin = Math.min(Xmin, Xmax);
        double max = -1.0E25;
        for (int j = 0; j < ny; ++j) {
            y[j] = Ymin + (double)j * dy + 0.5 * dy;
            for (int i = 0; i < nx; ++i) {
                x[i] = Xmin + (double)i * dx + 0.5 * dx;
                grid[count] = h.eval(x[i], y[j]);
                if (grid[count] > max) {
                    max = grid[count];
                }
                ++count;
            }
        }
        this.drawer(grid, x, y, null, max);
    }

    public void setAutoRange() {
        this.autorangeX[HPlot2D.N1][HPlot2D.N2] = true;
        this.autorangeY[HPlot2D.N1][HPlot2D.N2] = true;
        this.autorangeZ[HPlot2D.N1][HPlot2D.N2] = true;
        this.cp[N1][N2].getPlot().setXAutoRange(true);
        this.cp[N1][N2].getPlot().setYAutoRange(true);
    }

    public void setAutoRange(boolean autorange) {
        this.autorangeX[HPlot2D.N1][HPlot2D.N2] = autorange;
        this.autorangeY[HPlot2D.N1][HPlot2D.N2] = autorange;
        this.autorangeZ[HPlot2D.N1][HPlot2D.N2] = autorange;
        this.cp[N1][N2].getPlot().setXAutoRange(autorange);
        this.cp[N1][N2].getPlot().setYAutoRange(autorange);
    }

    public void setAutoRange(int axis, boolean autorange) {
        if (axis == 0) {
            this.autorangeX[HPlot2D.N1][HPlot2D.N2] = autorange;
            this.cp[N1][N2].getPlot().setXAutoRange(autorange);
        }
        if (axis == 1) {
            this.autorangeY[HPlot2D.N1][HPlot2D.N2] = autorange;
            this.cp[N1][N2].getPlot().setYAutoRange(autorange);
        }
        if (axis == 2) {
            this.autorangeZ[HPlot2D.N1][HPlot2D.N2] = autorange;
        }
    }

    public void setRange(int axis, double min, double max, int bins) {
        double d = (max - min) / (double)bins;
        if (axis == 0) {
            this.xA[HPlot2D.N1][HPlot2D.N2] = new Range2D(min, max, d);
            this.cp[N1][N2].getPlot().setXAutoRange(false);
            this.cp[N1][N2].getPlot().setXRange(this.xA[N1][N2]);
            this.autorangeX[HPlot2D.N1][HPlot2D.N2] = false;
        }
        if (axis == 1) {
            this.yA[HPlot2D.N1][HPlot2D.N2] = new Range2D(min, max, d);
            this.cp[N1][N2].getPlot().setYAutoRange(false);
            this.cp[N1][N2].getPlot().setYRange(this.yA[N1][N2]);
            this.autorangeY[HPlot2D.N1][HPlot2D.N2] = false;
        }
        if (axis == 2) {
            this.levels[HPlot2D.N1][HPlot2D.N2] = new Range2D(min, max, d);
            this.autorangeZ[HPlot2D.N1][HPlot2D.N2] = false;
        }
    }

    public void setAutoRangeAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.autorangeX[i1][i2] = true;
                this.autorangeY[i1][i2] = true;
                this.autorangeZ[i1][i2] = true;
            }
        }
    }

    public void setName(String title) {
        this.titleG[HPlot2D.N1][HPlot2D.N2] = title;
        this.cp[N1][N2].setName1(title);
    }

    public void setNameX(String s) {
        this.titleX[HPlot2D.N1][HPlot2D.N2] = s;
    }

    public void setNameY(String s) {
        this.titleY[HPlot2D.N1][HPlot2D.N2] = s;
    }

    public void setBackground(Color c) {
        this.getPlotCanvas().setBackground(c);
    }

    @Override
    public void setGTitle(String title) {
        this.titleG[HPlot2D.N1][HPlot2D.N2] = title;
    }

    public void visible(boolean vs) {
        this.mainFrame.setVisible(vs);
        if (!vs) {
            this.mainFrame.validate();
        }
    }

    public void visible() {
        this.mainFrame.setVisible(true);
    }

    public void visible(int posX, int posY) {
        this.mainFrame.setLocation(posX, posY);
        this.mainFrame.setVisible(true);
    }

    public HPlot2D(String title, int xs, int ys) {
        this(title, xs, ys, 1, 1, true);
    }

    public HPlot2D(String title, int xs, int ys, boolean set) {
        this(title, xs, ys, 1, 1, set);
    }

    public HPlot2D(String title, int xs, int ys, int n1, int n2) {
        this(title, xs, ys, n1, n2, true);
    }

    public HPlot2D(String title) {
        this(title, 600, 400, 1, 1, true);
    }

    public HPlot2D() {
        this("Default", 600, 400, 1, 1, true);
    }

    public void showTest() {
        Range2D xr = new Range2D(190.0, 250.0, 1.0);
        Range2D yr = new Range2D(0.0, 45.0, 1.0);
        TestData td = new TestData(5, xr, yr, 3, 12.0f, 30.0f, 5.0f);
        SGTData newData = td.getSGTData();
        this.colormap[HPlot2D.N1][HPlot2D.N2] = this.createColorMap(this.levels[N1][N2]);
        this.clevels[HPlot2D.N1][HPlot2D.N2] = ContourLevels.getDefault(this.levels[N1][N2]);
        this.gridAtt[HPlot2D.N1][HPlot2D.N2] = new GridAttribute(this.clevels[N1][N2]);
        this.gridAtt[N1][N2].setStyle(3);
        this.gridAtt[N1][N2].setColorMap(this.colormap[N1][N2]);
        this.cp[N1][N2].getPlot().addData(newData, (Attribute)this.gridAtt[N1][N2], "First Data");
    }

    public void setData() {
        double[] axis1 = new double[10];
        double[] axis2 = new double[10];
        double[] values = new double[100];
        int count = 0;
        for (int count1 = 0; count1 < 10; ++count1) {
            axis1[count1] = count1;
            for (int count2 = 0; count2 < 10; ++count2) {
                axis2[count2] = count2;
                values[count] = count1 * count * 2;
                ++count;
            }
        }
        SGLabel keyLabel = new SGLabel("Key Label", "", new Point2D.Double(0.0, 0.0));
        keyLabel.setHeightP(0.16);
        keyLabel.setText(this.titleG[N1][N2]);
        SGTMetaData xMeta = new SGTMetaData(this.titleX[N1][N2], "");
        SGTMetaData yMeta = new SGTMetaData(this.titleY[N1][N2], "");
        SimpleGrid sg = new SimpleGrid(values, axis1, axis2, "Test Series");
        sg.setXMetaData(xMeta);
        sg.setYMetaData(yMeta);
        sg.setKeyTitle(keyLabel);
        this.colormap[HPlot2D.N1][HPlot2D.N2] = this.createColorMap(this.levels[N1][N2]);
        this.clevels[HPlot2D.N1][HPlot2D.N2] = ContourLevels.getDefault(this.levels[N1][N2]);
        this.gridAtt[HPlot2D.N1][HPlot2D.N2] = new GridAttribute(this.clevels[N1][N2]);
        this.gridAtt[N1][N2].setColorMap(this.colormap[N1][N2]);
        this.cp[N1][N2].getPlot().addData(sg, (Attribute)this.gridAtt[N1][N2], "First Data");
    }

    public void setStyle(int style) {
        this.style[HPlot2D.N1][HPlot2D.N2] = style;
    }

    public Axis getAxis(int axis) {
        return this.cp[N1][N2].getPlot().getAxis(axis);
    }

    public void setAxis(int axis, Axis axisObject) {
        this.cp[N1][N2].getPlot().setAxis(axis, axisObject);
    }

    public void setAxis(int axis, boolean b) {
        PlainAxis ax = (PlainAxis)this.cp[N1][N2].getPlot().getAxis(axis);
        ax.setVisible(b);
    }

    public void setAxisLabelFont(Font fnt) {
        this.cp[N1][N2].getPlot().getAxis(0).setLabelFont(fnt);
        this.cp[N1][N2].getPlot().getAxis(1).setLabelFont(fnt);
    }

    public void setAxisLabelHeight(double lhgt) {
        this.cp[N1][N2].getPlot().getAxis(0).setLabelHeightP(lhgt);
        this.cp[N1][N2].getPlot().getAxis(1).setLabelHeightP(lhgt);
    }

    public void setSubTicLength(int axis, double length) {
        this.cp[N1][N2].getPlot().getAxis(0).setSmallTicHeightP(length);
        this.cp[N1][N2].getPlot().getAxis(1).setSmallTicHeightP(length);
    }

    public void setAxisPenTicWidth(int penWidth) {
        this.cp[N1][N2].getPlot().getAxis(0).setThickTicWidthP(penWidth);
        this.cp[N1][N2].getPlot().getAxis(1).setThickTicWidthP(penWidth);
    }

    public void setAxisLabelColor(Color color) {
        this.cp[N1][N2].getPlot().getAxis(0).setLabelColor(color);
        this.cp[N1][N2].getPlot().getAxis(1).setLabelColor(color);
    }

    public void setAxisNumberSubtics(int nstic) {
        this.cp[N1][N2].getPlot().getAxis(0).setNumberSmallTics(nstic);
        this.cp[N1][N2].getPlot().getAxis(1).setNumberSmallTics(nstic);
    }

    public void setAxisTicHeight(double lthgt) {
        this.cp[N1][N2].getPlot().getAxis(0).setLargeTicHeightP(lthgt);
        this.cp[N1][N2].getPlot().getAxis(1).setLargeTicHeightP(lthgt);
    }

    public void setAxisLabelPosition(int axis, int labp) {
        this.cp[N1][N2].getPlot().getAxis(0).setLabelPosition(labp);
        this.cp[N1][N2].getPlot().getAxis(1).setLabelPosition(labp);
    }

    public SGLabel getAxisTitle(int axis) {
        return this.cp[N1][N2].getPlot().getAxis(axis).getTitle();
    }

    public void setAxisTitle(int axis, SGLabel lab) {
        this.cp[N1][N2].getPlot().getAxis(axis).setTitle(lab);
    }

    public int getStyle() {
        return this.style[N1][N2];
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    @Override
    protected void clearFrame() {
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                this.cp[N1][N2].getPlot().clear();
                this.cp[N1][N2].repaint();
            }
        }
    }

    public void clearAll() {
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                this.cp[N1][N2].getPlot().clear();
                this.cp[N1][N2].repaint();
            }
        }
    }

    public void clear() {
        this.cp[N1][N2].getPlot().clear();
    }

    @Override
    protected void openReadDataDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for this canvas");
    }

    @Override
    protected void openReadDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for this canvas");
    }

    @Override
    protected void openWriteDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for this canvas");
    }

    @Override
    protected void refreshFrame() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for this canvas");
    }

    @Override
    protected void quitFrame() {
        this.distroy();
    }

    public void distroy() {
        this.mainFrame.setVisible(false);
        this.clearAll();
        this.removeFrame();
    }

    public void close() {
        this.mainFrame.setVisible(false);
        this.m_Close = new Thread1("Closing softly");
        if (!this.m_Close.Alive()) {
            this.m_Close.Start();
        }
    }

    public void quit() {
        this.doNotShowFrame();
        this.clear();
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.clear();
                this.cp[i1][i2] = null;
            }
        }
        this.cp = null;
        this.removeFrame();
    }

    @Override
    protected void showHelp() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for this canvas");
    }

    private ColorMap createColorMap(Range2D datar) {
        int[] red = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] green = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IndexedColorMap cmap = new IndexedColorMap(red, green, blue);
        cmap.setTransform(new LinearTransform(0.0, (double)red.length, datar.start, datar.end));
        return cmap;
    }

    class Thread1
    implements Runnable {
        private Thread t = null;
        private String mess;

        Thread1(String s1) {
            this.mess = s1;
        }

        public boolean Alive() {
            boolean tt = false;
            if (this.t != null && this.t.isAlive()) {
                tt = true;
            }
            return tt;
        }

        public boolean Joint() {
            boolean tt = false;
            try {
                this.t.join();
                return true;
            }
            catch (InterruptedException interruptedException) {
                return tt;
            }
        }

        public void Start() {
            this.t = new Thread((Runnable)this, this.mess);
            this.t.start();
        }

        public void Stop() {
            this.t = null;
        }

        @Override
        public void run() {
            HPlot2D.this.quit();
        }
    }
}

