/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import jhplot.gui.HelpBrowser;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class HLabelEq
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String text;
    protected int fontsize;
    protected Color color;
    protected Color back;
    protected double Xpos;
    protected double Ypos;
    protected int usePosition = 0;

    public HLabelEq(String s, int f, Color c) {
        this.text = s;
        this.fontsize = f;
        this.color = c;
        this.Xpos = 0.0;
        this.Ypos = 0.0;
        this.usePosition = 0;
        this.back = Color.white;
    }

    public HLabelEq(String s, int f) {
        this.text = s;
        this.fontsize = f;
        this.Xpos = 0.0;
        this.Ypos = 0.0;
        this.usePosition = 0;
        this.color = Color.black;
        this.back = Color.white;
    }

    public HLabelEq(String s) {
        this.fontsize = 16;
        this.text = s;
        this.Xpos = 0.0;
        this.Ypos = 0.0;
        this.usePosition = 0;
        this.color = Color.black;
        this.back = Color.white;
    }

    public HLabelEq(String s, double x, double y) {
        this.fontsize = 16;
        this.usePosition = 2;
        this.Xpos = x;
        this.Ypos = y;
        this.text = s;
        this.color = Color.black;
        this.back = Color.white;
    }

    public HLabelEq(String s, double x, double y, String howToSet) {
        this.fontsize = 16;
        this.usePosition = 2;
        if (howToSet.equalsIgnoreCase("USER")) {
            this.usePosition = 2;
        }
        if (howToSet.equalsIgnoreCase("NDC")) {
            this.usePosition = 1;
            if (x > 1.0) {
                x = 1.0;
            }
            if (y > 1.0) {
                y = 1.0;
            }
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
        }
        this.Xpos = x;
        this.Ypos = y;
        this.text = s;
        this.color = Color.black;
        this.back = Color.white;
    }

    public void setText(String s) {
        this.text = s;
    }

    public String getText() {
        return this.text;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setColorBackgroud(Color c) {
        this.back = c;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColorBackground() {
        return this.back;
    }

    public void setFontSize(int f) {
        this.fontsize = f;
    }

    public int getFontSize() {
        return this.fontsize;
    }

    public BufferedImage getImage() {
        String latex = this.getText();
        TeXFormula formula = new TeXFormula(latex);
        formula.setBackground(this.back);
        formula.setColor(this.color);
        TeXIcon icon = formula.createTeXIcon(0, this.fontsize);
        icon.setInsets(new Insets(5, 5, 5, 5));
        BufferedImage imeq = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2 = imeq.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
        JLabel jl = new JLabel();
        jl.setForeground(new Color(0, 0, 0));
        icon.paintIcon(jl, g2, 0, 0);
        return imeq;
    }

    public boolean getImageFile(String fileName) {
        File file = new File(fileName);
        int mid = fileName.lastIndexOf(".");
        String ext = fileName.substring(mid + 1, fileName.length());
        try {
            ImageIO.write((RenderedImage)this.getImage(), ext, file.getAbsoluteFile());
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public String toString() {
        String s1 = Double.toString(this.Xpos);
        String s2 = Double.toString(this.Xpos);
        String pos = " X1=" + s1 + "  Y1" + s2;
        return "Image of equation at : " + pos + " text=" + this.text;
    }

    public void setLocation(double x, double y) {
        this.usePosition = 2;
        this.Xpos = x;
        this.Ypos = y;
    }

    public void setLocation(double x, double y, String howToSet) {
        this.usePosition = 2;
        if (howToSet.equalsIgnoreCase("USER")) {
            this.usePosition = 2;
        }
        if (howToSet.equalsIgnoreCase("NDC")) {
            this.usePosition = 1;
            if (x > 1.0) {
                x = 1.0;
            }
            if (y > 1.0) {
                y = 1.0;
            }
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
        }
        this.Xpos = x;
        this.Ypos = y;
    }

    public int getPositionCoordinate() {
        return this.usePosition;
    }

    public double getX() {
        return this.Xpos;
    }

    public double getY() {
        return this.Ypos;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

