/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.zip.GZIPOutputStream;
import jhplot.gui.HelpBrowser;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;

public class HDiagram {
    private static final long serialVersionUID = 1L;
    private SourceStringReader reader;

    public HDiagram(String source) {
        this.reader = new SourceStringReader(source);
    }

    public HDiagram() {
    }

    public void fromString(String source) {
        this.reader = new SourceStringReader(source);
    }

    public void fromFile(String file) {
        try {
            String content = new String(Files.readAllBytes(Paths.get("file", new String[0])));
            this.reader = new SourceStringReader(content);
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    public SourceStringReader getReader() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String file) {
        block55: {
            int dot = file.lastIndexOf(46);
            String base = dot == -1 ? file : file.substring(0, dot);
            String fext = dot == -1 ? "" : file.substring(dot + 1);
            fext = fext.trim();
            boolean isSVGZ = false;
            if (fext.equalsIgnoreCase("svgz")) {
                isSVGZ = true;
            }
            boolean isEPS = false;
            if (fext.equalsIgnoreCase("eps")) {
                isEPS = true;
            }
            boolean isPDF = false;
            if (fext.equalsIgnoreCase("pdf")) {
                isPDF = true;
            }
            boolean isPNG = false;
            if (fext.equalsIgnoreCase("png")) {
                isPNG = true;
            }
            boolean isSVG = false;
            if (fext.equalsIgnoreCase("svg")) {
                isSVG = true;
            }
            boolean isJPG = false;
            if (fext.equalsIgnoreCase("jpg") || fext.equalsIgnoreCase("jpeg")) {
                isJPG = true;
            }
            boolean isHTML = false;
            if (fext.equalsIgnoreCase("html") || fext.equalsIgnoreCase("htm")) {
                isHTML = true;
            }
            if (!(isSVGZ || isEPS || isPDF || isPNG || isSVG || isJPG || isHTML)) {
                System.err.println("Unsuported format file!  Only svg, svgz, eps, pmg, jpeg, html, eps, pdf are supported");
                return;
            }
            try {
                if (isSVG) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    String desc = this.reader.generateImage((OutputStream)os, new FileFormatOption(FileFormat.SVG));
                    os.close();
                    String svg = new String(os.toByteArray(), Charset.forName("UTF-8"));
                    BufferedWriter writer = null;
                    try {
                        writer = new BufferedWriter(new FileWriter(file));
                        writer.write(svg);
                        break block55;
                    }
                    catch (IOException iOException) {
                        break block55;
                    }
                    finally {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (isSVGZ) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    String desc = this.reader.generateImage((OutputStream)os, new FileFormatOption(FileFormat.SVG));
                    os.close();
                    String svg = new String(os.toByteArray(), Charset.forName("UTF-8"));
                    try {
                        int len;
                        ByteArrayInputStream is = new ByteArrayInputStream(svg.getBytes());
                        GZIPOutputStream gzipOS = new GZIPOutputStream(new FileOutputStream(file));
                        byte[] buffer = new byte[1024];
                        while ((len = is.read(buffer)) != -1) {
                            gzipOS.write(buffer, 0, len);
                        }
                        gzipOS.close();
                        ((InputStream)is).close();
                    }
                    catch (IOException is) {}
                    break block55;
                }
                if (isPNG) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    String desc = this.reader.generateImage((OutputStream)os, new FileFormatOption(FileFormat.PNG));
                    os.close();
                    FileOutputStream fos = new FileOutputStream(new File(file));
                    os.writeTo(fos);
                    break block55;
                }
                if (isJPG) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    String desc = this.reader.generateImage((OutputStream)os, new FileFormatOption(FileFormat.MJPEG));
                    os.close();
                    FileOutputStream fos = new FileOutputStream(new File(file));
                    os.writeTo(fos);
                    break block55;
                }
                if (isPDF) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    String desc = this.reader.generateImage((OutputStream)os, new FileFormatOption(FileFormat.PDF));
                    os.close();
                    FileOutputStream fos = new FileOutputStream(new File(file));
                    os.writeTo(fos);
                    break block55;
                }
                if (isEPS) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    String desc = this.reader.generateImage((OutputStream)os, new FileFormatOption(FileFormat.EPS));
                    os.close();
                    String eps = new String(os.toByteArray(), Charset.forName("UTF-8"));
                    BufferedWriter writer = null;
                    try {
                        writer = new BufferedWriter(new FileWriter(file));
                        writer.write(eps);
                        break block55;
                    }
                    catch (IOException iOException) {
                        break block55;
                    }
                    finally {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (!isHTML) break block55;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                String desc = this.reader.generateImage((OutputStream)os, new FileFormatOption(FileFormat.HTML5));
                os.close();
                String eps = new String(os.toByteArray(), Charset.forName("UTF-8"));
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(file));
                    writer.write(eps);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
        }
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

