/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import cern.jet.random.AbstractDistribution;
import hep.aida.IAnalysisFactory;
import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.ref.histogram.Cloud1D;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.VariableAxis;
import hep.io.root.interfaces.TAxis;
import hep.io.root.interfaces.TH1;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import jhplot.DrawOptions;
import jhplot.F1D;
import jhplot.HTable;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.PND;
import jhplot.gui.HelpBrowser;
import jhplot.utils.SHisto;
import jhplot.utils.Util;
import jplot.LinePars;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import root.Converter;

public class H1D
extends DrawOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Histogram1D h1;
    private IAxis axis;
    private double min;
    private double max;
    private int bins;
    private double[] edges;

    public H1D() {
        this.setType(101);
        this.title = "NOT SET";
    }

    public H1D(String title, int bins, double min, double max) {
        this.setType(101);
        this.setStyle("h");
        this.setTitle(title);
        this.bins = bins;
        this.min = min;
        this.max = max;
        this.axis = new FixedAxis(this.bins, this.min, this.max);
        this.h1 = new Histogram1D(this.title, this.title, this.axis);
    }

    public H1D(String title, double[] edges) {
        this.setType(101);
        this.setStyle("h");
        this.setTitle(title);
        this.edges = edges;
        this.bins = edges.length - 1;
        this.min = edges[0];
        this.max = edges[edges.length - 1];
        this.axis = new VariableAxis(edges);
        this.h1 = new Histogram1D(this.title, this.title, this.axis);
    }

    public H1D(String title, IAxis axis) {
        this.setType(101);
        this.setStyle("h");
        this.setTitle(title);
        this.axis = axis;
        this.min = axis.lowerEdge();
        this.max = axis.upperEdge();
        this.bins = axis.bins();
        this.h1 = new Histogram1D(this.title, this.title, axis);
    }

    public H1D(Histogram1D h1) {
        this.setType(101);
        this.setStyle("h");
        this.h1 = h1;
        this.axis = h1.axis();
        this.min = this.axis.lowerEdge();
        this.max = this.axis.upperEdge();
        this.bins = this.axis.bins();
    }

    public H1D(Cloud1D c1d, int bins) {
        this.setType(101);
        this.setStyle("h");
        this.setTitle(c1d.title());
        this.min = c1d.lowerEdge();
        this.max = c1d.upperEdge();
        this.bins = bins;
        this.axis = new FixedAxis(this.bins, this.min, this.max);
        this.h1 = new Histogram1D(this.title, this.title, this.axis);
        this.fill(c1d);
    }

    public H1D(IHistogram1D h1) {
        this.setType(101);
        this.setStyle("h");
        this.h1 = (Histogram1D)h1;
        this.title = h1.title();
        this.axis = h1.axis();
        this.min = this.axis.lowerEdge();
        this.max = this.axis.upperEdge();
        this.bins = this.axis.bins();
    }

    public H1D(String title, H1D h1d) {
        LinePars lnew = this.copyLinePars(h1d.getLineParm());
        this.setDrawOption(lnew);
        this.title = title;
        this.axis = h1d.getAxis();
        this.min = this.axis.lowerEdge();
        this.max = this.axis.upperEdge();
        this.bins = this.axis.bins();
        this.h1 = h1d.get();
    }

    public void print() {
        DecimalFormat dfb = new DecimalFormat("##.#####E00");
        Date dat = new Date();
        String today = String.valueOf(dat);
        IAxis axis = this.h1.axis();
        System.out.println("");
        System.out.println("# DataMelt: output from H1D: " + this.title);
        System.out.println("# DataMelt: created at " + today);
        System.out.println("# x,  y,  error(upper),  error(lower)");
        System.out.println("#");
        for (int i = 0; i < axis.bins(); ++i) {
            String x = dfb.format(this.h1.binMean(i));
            String y = dfb.format(this.h1.binHeight(i));
            String y1 = dfb.format(this.h1.binError(i));
            String y2 = dfb.format(this.h1.binError(i));
            System.out.println(x + "    " + y + "    " + y1 + "    " + y2);
        }
    }

    public String toString() {
        String tmp = "";
        DecimalFormat dfb = new DecimalFormat("##.#####E00");
        Date dat = new Date();
        String today = String.valueOf(dat);
        IAxis axis = this.h1.axis();
        tmp = tmp + "# DataMelt: output from H1D: " + this.title + "\n";
        tmp = tmp + "# DataMelt: created at " + today + "\n";
        tmp = tmp + "# x,  y,  error(upper),  error(lower)\n";
        for (int i = 0; i < axis.bins(); ++i) {
            String x = dfb.format(this.h1.binMean(i));
            String y = dfb.format(this.h1.binHeight(i));
            String y1 = dfb.format(this.h1.binError(i));
            String y2 = dfb.format(this.h1.binError(i));
            tmp = tmp + x + "    " + y + "    " + y1 + "    " + y2 + "\n";
        }
        return tmp;
    }

    public void toTable() {
        new HTable(this);
    }

    public void fill(P0D p0d) {
        for (int i = 0; i < p0d.size(); ++i) {
            this.h1.fill(p0d.getQuick(i));
        }
    }

    public void fill(int TotNumber, AbstractDistribution random) {
        for (int i = 0; i < TotNumber; ++i) {
            this.h1.fill(random.nextDouble());
        }
    }

    public void fillGauss(int TotNumber, double mean, double sd) {
        Random random = new Random();
        for (int i = 0; i < TotNumber; ++i) {
            this.h1.fill(sd * random.nextGaussian() + mean);
        }
    }

    public void fillRnd(int TotNumber, double mean, double width) {
        Random random = new Random();
        for (int i = 0; i < TotNumber; ++i) {
            this.h1.fill(width * random.nextDouble() + mean);
        }
    }

    public void fill(P0I p0i) {
        for (int i = 0; i < p0i.size(); ++i) {
            this.h1.fill((double)p0i.get(i));
        }
    }

    public IAxis getAxis() {
        this.axis = this.h1.axis();
        return this.axis;
    }

    public double binCenter(int index) {
        this.axis = this.h1.axis();
        return this.axis.binCenter(index);
    }

    public double[] binCenters() {
        this.axis = this.h1.axis();
        double[] tmp = new double[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            tmp[i] = this.axis.binCenter(i);
        }
        return tmp;
    }

    public double binLowerEdge(int index) {
        this.axis = this.h1.axis();
        return this.axis.binLowerEdge(index);
    }

    public double[] binLowerEdges() {
        this.axis = this.h1.axis();
        double[] tmp = new double[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            tmp[i] = this.axis.binLowerEdge(i);
        }
        return tmp;
    }

    public double binUpperEdge(int index) {
        this.axis = this.h1.axis();
        return this.axis.binUpperEdge(index);
    }

    public double[] binUpperEdges() {
        this.axis = this.h1.axis();
        double[] tmp = new double[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            tmp[i] = this.axis.binUpperEdge(i);
        }
        return tmp;
    }

    public void toFile(String name) {
        DecimalFormat dfb = new DecimalFormat("##.#####E00");
        Date dat = new Date();
        String today = String.valueOf(dat);
        IAxis axis = this.h1.axis();
        try {
            FileOutputStream f1 = new FileOutputStream(new File(name));
            PrintStream tx = new PrintStream(f1);
            tx.println("# DataMelt: output from H1D " + this.title);
            tx.println("# DataMelt: created at " + today);
            tx.println("# x,  y,  error(upper),  error(lower)");
            tx.println("#");
            for (int i = 0; i < axis.bins(); ++i) {
                String x = dfb.format(this.h1.binMean(i));
                String y = dfb.format(this.h1.binHeight(i));
                String y1 = dfb.format(this.h1.binError(i));
                String y2 = dfb.format(this.h1.binError(i));
                tx.println(x + "    " + y + "    " + y1 + "    " + y2);
            }
            f1.close();
        }
        catch (IOException e) {
            this.ErrorMessage("Error in the output file");
            e.printStackTrace();
        }
    }

    public H1D(TH1 h1t) {
        this.title = h1t.getTitle();
        this.setTitle(this.title);
        TAxis axis = h1t.getXaxis();
        this.min = axis.getXmin();
        this.max = axis.getXmax();
        this.h1 = Converter.convert(h1t, this.title);
    }

    public void setHeights(double[] values) {
        int ibins = this.bins + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = this.getUnderflowHeight();
        newHeights[ibins - 1] = this.getOverflowlowHeight();
        for (int i = 0; i < ibins - 1; ++i) {
            newHeights[i + 1] = values[i];
            newErrors[i + 1] = this.h1.binError(i);
            newEntries[i + 1] = this.h1.binEntries(i);
            newMeans[i + 1] = this.h1.binMean(i);
            newRmss[i + 1] = this.h1.binRms(i);
        }
        this.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        this.setMeanAndRms(this.h1.mean(), this.h1.rms());
    }

    public void setErrors(double[] errors) {
        int ibins = this.bins + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = this.getUnderflowHeight();
        newHeights[ibins - 1] = this.getOverflowlowHeight();
        for (int i = 0; i < ibins - 1; ++i) {
            newHeights[i + 1] = this.h1.binHeight(i);
            newErrors[i + 1] = errors[i];
            newEntries[i + 1] = this.h1.binEntries(i);
            newMeans[i + 1] = this.h1.binMean(i);
            newRmss[i + 1] = this.h1.binRms(i);
        }
        this.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        this.setMeanAndRms(this.h1.mean(), this.h1.rms());
    }

    public void setContents(double[] values, double[] errors) {
        this.h1.setContents(values, errors, null, null, null);
    }

    public void setContents(double[] heights, double[] errors, int[] entries, double[] means, double[] rmss) {
        this.h1.setContents(heights, errors, entries, means, rmss);
    }

    public void setMeanAndRms(double mean, double rms) {
        this.h1.setMeanAndRms(mean, rms);
    }

    public void setNEntries(int entries) {
        this.h1.setNEntries(entries);
    }

    public void setValidEntries(int entries) {
        this.h1.setValidEntries(entries);
    }

    public Histogram1D get() {
        return this.h1;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMax() {
        return this.max;
    }

    public void setBins(int bins) {
        this.bins = bins;
    }

    public int getBins() {
        this.bins = this.h1.axis().bins();
        return this.bins;
    }

    public double getBinSize() {
        this.axis = this.h1.axis();
        this.bins = this.axis.bins();
        this.min = this.axis.lowerEdge();
        this.max = this.axis.upperEdge();
        return (this.max - this.min) / (double)this.bins;
    }

    public double getBinSize(int index) {
        this.axis = this.h1.axis();
        return this.axis.binWidth(index);
    }

    public void shift(double d) {
        int i;
        int ibins = this.h1.axis().bins() + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = this.getUnderflowHeight();
        newHeights[ibins - 1] = this.getOverflowlowHeight();
        for (i = 0; i < ibins - 1; ++i) {
            newHeights[i + 1] = this.h1.binHeight(i);
            newErrors[i + 1] = this.h1.binError(i);
            newEntries[i + 1] = this.h1.binEntries(i);
            newMeans[i + 1] = this.h1.binMean(i) + d;
            newRmss[i + 1] = this.h1.binRms(i);
        }
        if (this.axis.isFixedBinning()) {
            this.axis = new FixedAxis(this.bins, this.min + d, this.max + d);
        } else {
            for (i = 0; i < this.edges.length; ++i) {
                this.edges[i] = this.edges[i] + d;
                this.axis = new VariableAxis(this.edges);
            }
        }
        double m = this.h1.mean() + d;
        double r = this.h1.rms();
        this.h1 = new Histogram1D(this.title, this.title, this.axis);
        this.h1.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        this.setMeanAndRms(m, r);
    }

    public boolean isFixedBinning() {
        return this.axis.isFixedBinning();
    }

    public void fill(double value) {
        this.h1.fill(value);
    }

    public void fill(PND pnd) {
        for (int i = 0; i < pnd.size(); ++i) {
            double[] tt = pnd.get(i);
            for (int j = 0; j < tt.length; ++j) {
                this.h1.fill(tt[j]);
            }
        }
    }

    public void fill(PND pnd, PND weigths) {
        if (pnd.size() != weigths.size()) {
            System.out.println("Sizes of input and weight arrays are different!");
            return;
        }
        for (int i = 0; i < pnd.size(); ++i) {
            double[] tt = pnd.get(i);
            double[] ww = weigths.get(i);
            for (int j = 0; j < tt.length; ++j) {
                this.h1.fill(tt[j], ww[j]);
            }
        }
    }

    public void fill(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.h1.fill(values[i]);
        }
    }

    public void fill(Cloud1D c1d) {
        for (int i = 0; i < c1d.entries(); ++i) {
            this.h1.fill(c1d.value(i), c1d.weight(i));
        }
    }

    public void fill(double[] values, double[] weights) {
        for (int i = 0; i < values.length; ++i) {
            this.h1.fill(values[i], weights[i]);
        }
    }

    public void fill(int[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.h1.fill((double)values[i]);
        }
    }

    public void fill(double value, double weight) {
        this.h1.fill(value, weight);
    }

    public double mean() {
        return this.h1.mean();
    }

    public Map<String, Double> getStat() {
        HashMap<String, Double> tmp = new HashMap<String, Double>();
        IAxis axis = this.h1.axis();
        Histogram1D h = this.get();
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        for (int i = 0; i < axis.bins(); ++i) {
            double x = h.binMean(i);
            double y = h.binHeight(i);
            sum1 += y;
            sum2 += x * y;
            sum3 += x * x * y;
        }
        double mean = sum2 / sum1;
        double mean_square = sum3 / sum1;
        double rms = Math.sqrt(sum3 / sum1);
        double variance = mean_square - mean * mean;
        double stddev = Math.sqrt(variance);
        tmp.put("mean", mean);
        tmp.put("mean_error", stddev / Math.sqrt(sum1));
        tmp.put("rms", rms);
        tmp.put("variance", variance);
        tmp.put("standardDeviation", stddev);
        tmp.put("maxBinHeight", this.h1.maxBinHeight());
        tmp.put("minBinHeight", this.h1.minBinHeight());
        tmp.put("allEntries", Double.valueOf(this.h1.allEntries()));
        tmp.put("entries", Double.valueOf(this.h1.entries()));
        tmp.put("underflowBin", Double.valueOf(this.h1.binEntries(-2)));
        tmp.put("underflowHeight", this.h1.binHeight(-2));
        tmp.put("overflowBin", Double.valueOf(this.h1.binEntries(-1)));
        tmp.put("overflowHeight", this.h1.binHeight(-1));
        return tmp;
    }

    public double rms() {
        return this.h1.rms();
    }

    public int allEntries() {
        return this.h1.allEntries();
    }

    public int extraEntries() {
        return this.h1.extraEntries();
    }

    public int entries() {
        return this.h1.entries();
    }

    public int getUnderflow() {
        return this.h1.binEntries(-2);
    }

    public double getUnderflowHeight() {
        return this.h1.binHeight(-2);
    }

    public double getOverflowlowHeight() {
        return this.h1.binHeight(-1);
    }

    public int getOverflow() {
        return this.h1.binEntries(-1);
    }

    public void fillInvBinSizeWeight(double value) {
        int binNum = this.h1.axis().coordToIndex(value);
        this.h1.fill(value, 1.0 / this.h1.axis().binWidth(binNum));
    }

    public void scale(String title, double scaleFactor) {
        this.title = title;
        this.h1.scale(scaleFactor);
    }

    public H1D operScale(String title, double scaleFactor) {
        this.scale(title, scaleFactor);
        return this;
    }

    public void scale(double scaleFactor) {
        this.h1.scale(scaleFactor);
    }

    public H1D operSmooth(boolean isWeighted, int k) {
        SHisto sh = new SHisto(this.bins, this.min, this.max, 1);
        double[] hh = this.binHeights();
        double[] ee = this.binErrors();
        sh.setBins(hh);
        sh = sh.getSmoothed(isWeighted, k);
        double[] hh1 = new double[this.bins + 2];
        double[] ee1 = new double[this.bins + 2];
        hh1[0] = this.getUnderflowHeight();
        hh1[this.bins - 1] = this.getOverflowlowHeight();
        for (int i = 1; i < this.bins + 1; ++i) {
            hh1[i] = sh.getBinsFirstBand(i - 1);
            ee1[i] = ee[i - 1];
        }
        this.h1.setContents(hh1, ee1, null, null, null);
        return this;
    }

    public H1D operSmoothGauss(double standardDeviation) {
        SHisto sh = new SHisto(this.bins, this.min, this.max, 1);
        double[] hh = this.binHeights();
        double[] ee = this.binErrors();
        sh.setBins(hh);
        sh = sh.getGaussianSmoothed(standardDeviation);
        double[] hh1 = new double[this.bins + 2];
        double[] ee1 = new double[this.bins + 2];
        hh1[0] = this.getUnderflowHeight();
        hh1[this.bins - 1] = this.getOverflowlowHeight();
        for (int i = 1; i < this.bins + 1; ++i) {
            hh1[i] = sh.getBinsFirstBand(i - 1);
            ee1[i] = ee[i - 1];
        }
        this.h1.setContents(hh1, ee1, null, null, null);
        return this;
    }

    public double getEntropy() {
        SHisto sh = new SHisto(this.bins, this.min, this.max, 1);
        double[] hh = this.binHeights();
        sh.setBins(hh);
        double[] s = sh.getEntropy();
        return s[0];
    }

    public H1D copy() {
        return this.copy(this.title);
    }

    public void clear() {
        this.h1.reset();
    }

    public H1D rebin(int ngroup) {
        this.axis = this.h1.axis();
        if (!this.axis.isFixedBinning()) {
            this.ErrorMessage("Cannot rebin histogram with variable bins");
        }
        int nbins = (int)(1.0 * (double)this.axis.bins() / (double)ngroup);
        H1D hnew = new H1D(this.getTitle(), nbins, this.min, this.max);
        int ibins = nbins + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = this.getUnderflowHeight();
        newHeights[ibins - 1] = this.getOverflowlowHeight();
        for (int i = 0; i < ibins - 2; ++i) {
            int start;
            double h = 0.0;
            double e2 = 0.0;
            int t = 0;
            double m = 0.0;
            double rms = 0.0;
            for (int j = start = i * ngroup; j < start + ngroup; ++j) {
                h += this.h1.binHeight(j);
                t += this.h1.binEntries(j);
                e2 += this.h1.binError(j) * this.h1.binError(j);
                m += this.h1.binMean(j);
                rms += this.h1.binRms(j) * this.h1.binRms(j);
            }
            e2 = Math.sqrt(e2 / (double)ngroup);
            rms = Math.sqrt(rms / (double)ngroup);
            newHeights[i + 1] = h /= (double)ngroup;
            newErrors[i + 1] = e2;
            newEntries[i + 1] = t;
            newMeans[i + 1] = m /= (double)ngroup;
            newRmss[i + 1] = rms;
        }
        hnew.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        hnew.setMeanAndRms(this.h1.mean(), this.h1.rms());
        LinePars lnew = this.copyLinePars(this.lpp);
        hnew.setDrawOption(lnew);
        hnew.setNEntries(this.entries());
        return hnew;
    }

    public H1D copy(String newtitle) {
        int ibins = this.bins + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = this.getUnderflowHeight();
        newHeights[ibins - 1] = this.getOverflowlowHeight();
        for (int i = 0; i < ibins - 1; ++i) {
            newHeights[i + 1] = this.h1.binHeight(i);
            newErrors[i + 1] = this.h1.binError(i);
            newEntries[i + 1] = this.h1.binEntries(i);
            newMeans[i + 1] = this.h1.binMean(i);
            newRmss[i + 1] = this.h1.binRms(i);
        }
        H1D hnew = new H1D(newtitle, this.axis);
        hnew.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        hnew.setMeanAndRms(this.h1.mean(), this.h1.rms());
        LinePars lnew = this.copyLinePars(this.lpp);
        hnew.setDrawOption(lnew);
        hnew.setNEntries(this.entries());
        return hnew;
    }

    public H1D scaleErrors(double scale) {
        IAxis a = this.h1.axis();
        int ibins = a.bins() + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = this.getUnderflowHeight();
        newHeights[ibins - 1] = this.getOverflowlowHeight();
        for (int i = 0; i < ibins - 2; ++i) {
            newHeights[i + 1] = this.h1.binHeight(i);
            newErrors[i + 1] = this.h1.binError(i) * scale;
            newEntries[i + 1] = this.h1.binEntries(i);
            newMeans[i + 1] = this.h1.binMean(i);
            newRmss[i + 1] = this.h1.binRms(i);
        }
        H1D hnew = new H1D(this.getTitle(), this.axis);
        hnew.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        hnew.setMeanAndRms(this.h1.mean(), this.h1.rms());
        LinePars lnew = this.copyLinePars(this.lpp);
        hnew.setDrawOption(lnew);
        hnew.setNEntries(this.entries());
        hnew.setMeanAndRms(this.mean(), this.rms());
        return hnew;
    }

    public int binEntries(int index) {
        return this.h1.binEntries(index);
    }

    public int[] binEntries() {
        int[] hh = new int[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            hh[i] = this.h1.binEntries(i);
        }
        return hh;
    }

    public double binError(int index) {
        return this.h1.binError(index);
    }

    public double binHeight(int index) {
        return this.h1.binHeight(index);
    }

    public double[] binHeights() {
        this.bins = this.h1.axis().bins();
        double[] hh = new double[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            hh[i] = this.h1.binHeight(i);
        }
        return hh;
    }

    public double[] binErrors() {
        this.bins = this.h1.axis().bins();
        double[] hh = new double[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            hh[i] = this.h1.binError(i);
        }
        return hh;
    }

    public double binMean(int index) {
        return this.h1.binMean(index);
    }

    public double binRms(int index) {
        return this.h1.binRms(index);
    }

    public double maxBinHeight() {
        return this.h1.maxBinHeight();
    }

    public double minBinHeight() {
        return this.h1.minBinHeight();
    }

    public double sumAllBinHeights() {
        return this.h1.sumAllBinHeights();
    }

    public double integral() {
        IAxis a = this.h1.axis();
        int Nbins = a.bins();
        return this.integral(1, Nbins, true);
    }

    public int findBin(double x) {
        return this.h1.axis().coordToIndex(x);
    }

    public double integral(int BinMin, int BinMax, boolean timesBinWidth) {
        IAxis a = this.h1.axis();
        int Nbins = a.bins();
        if (BinMin > BinMax) {
            this.ErrorMessage("Wrong bin number!");
            return -1.0;
        }
        if (BinMin < 1 || BinMax > Nbins) {
            this.ErrorMessage("Wrong bin number!");
            return -1.0;
        }
        double sum = 0.0;
        if (!timesBinWidth) {
            for (int i = BinMin - 1; i < BinMax; ++i) {
                sum += this.h1.binHeight(i);
            }
        } else {
            for (int i = BinMin - 1; i < BinMax; ++i) {
                double w = a.binUpperEdge(i) - a.binLowerEdge(i);
                sum += this.h1.binHeight(i) * w;
            }
        }
        return sum;
    }

    public double integral(int BinMin, int BinMax) {
        return this.integral(BinMin, BinMax, false);
    }

    public double integralRegion(double xmin, double xmax, boolean timesBinWidth) {
        int xma;
        int Nbins = this.h1.axis().bins();
        int xmi = this.h1.axis().coordToIndex(xmin);
        if (xmi > (xma = this.h1.axis().coordToIndex(xmax))) {
            this.ErrorMessage("Wrong bin number!");
            return -1.0;
        }
        if (xmi < 1 || xma > Nbins) {
            this.ErrorMessage("Wrong bin number!");
            return -1.0;
        }
        return this.integral(xmi, xma, timesBinWidth);
    }

    public double integralRegion(double xmin, double xmax) {
        return this.integralRegion(xmin, xmax, false);
    }

    public H1D getProbability() {
        H1D h1d = this.copy();
        h1d.scale(1.0 / h1d.sumAllBinHeights());
        return h1d;
    }

    public H1D getDividedByBinWidth() {
        IAxis a = this.h1.axis();
        int ibins = a.bins() + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = this.getUnderflowHeight();
        newHeights[ibins - 1] = this.getOverflowlowHeight();
        for (int i = 0; i < ibins - 2; ++i) {
            double w = a.binUpperEdge(i) - a.binLowerEdge(i);
            newHeights[i + 1] = this.h1.binHeight(i) / w;
            newErrors[i + 1] = this.h1.binError(i) / w;
            newEntries[i + 1] = this.h1.binEntries(i);
            newMeans[i + 1] = this.h1.binMean(i);
            newRmss[i + 1] = this.h1.binRms(i);
        }
        H1D hnew = new H1D(this.getTitle(), this.axis);
        hnew.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        hnew.setMeanAndRms(this.h1.mean(), this.h1.rms());
        LinePars lnew = this.copyLinePars(this.lpp);
        hnew.setDrawOption(lnew);
        hnew.setNEntries(this.entries());
        hnew.setMeanAndRms(this.mean(), this.rms());
        return hnew;
    }

    public H1D getDensity() {
        IAxis a = this.h1.axis();
        int ibins = a.bins() + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = this.getUnderflowHeight();
        newHeights[ibins - 1] = this.getOverflowlowHeight();
        double sum = this.sumAllBinHeights();
        for (int i = 0; i < ibins - 2; ++i) {
            double w = sum * (a.binUpperEdge(i) - a.binLowerEdge(i));
            newHeights[i + 1] = this.h1.binHeight(i) / w;
            newErrors[i + 1] = this.h1.binError(i) / w;
            newEntries[i + 1] = this.h1.binEntries(i);
            newMeans[i + 1] = this.h1.binMean(i);
            newRmss[i + 1] = this.h1.binRms(i);
        }
        H1D hnew = new H1D(this.getTitle(), this.axis);
        hnew.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        hnew.setMeanAndRms(this.h1.mean(), this.h1.rms());
        LinePars lnew = this.copyLinePars(this.lpp);
        hnew.setDrawOption(lnew);
        hnew.setNEntries(this.entries());
        hnew.setMeanAndRms(this.mean(), this.rms());
        return hnew;
    }

    public Map<String, Double> compareChi2(F1D f1) {
        HashMap<String, Double> tmp = new HashMap<String, Double>();
        int bins1 = this.get().axis().bins();
        double sum1 = 0.0;
        double nDf = 0.0;
        for (int i = 0; i < bins1; ++i) {
            double bin1 = this.binHeight(i);
            double e1 = this.binError(i);
            double x1 = this.get().axis().binLowerEdge(i);
            double x2 = this.get().axis().binUpperEdge(i);
            double delta = x2 - x1;
            double x = x1 + 0.5 * delta;
            double ff = f1.eval(x);
            if (e1 == 0.0) continue;
            sum1 += (ff - bin1) * (ff - bin1) / (e1 * e1);
            nDf += 1.0;
        }
        double chi2 = sum1;
        tmp.put("chi2", chi2);
        tmp.put("ndf", nDf);
        ChiSquaredDistribution chi2Distribution = new ChiSquaredDistribution(nDf);
        double prob = chi2Distribution.cumulativeProbability(chi2);
        tmp.put("p-value", 1.0 - prob);
        return tmp;
    }

    public Map<String, Double> compareChi2(H1D h2) {
        double e2;
        double e1;
        double bin2;
        double bin1;
        int i;
        int bins2;
        HashMap<String, Double> tmp = new HashMap<String, Double>();
        int bins1 = this.get().axis().bins();
        if (bins1 != (bins2 = h2.get().axis().bins())) {
            System.out.println("Different histograms! Please use histograms with the same bin numbers");
            return tmp;
        }
        double chi2 = 0.0;
        int nDf = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sumw1 = 0.0;
        double sumw2 = 0.0;
        for (i = 0; i < bins1; ++i) {
            bin1 = this.binHeight(i);
            bin2 = h2.binHeight(i);
            e1 = this.binError(i);
            e2 = h2.binError(i);
            bin1 = e1 > 0.0 ? (bin1 *= bin1 / (e1 * e1)) : 0.0;
            bin2 = e2 > 0.0 ? (bin2 *= bin2 / (e2 * e2)) : 0.0;
            sum1 += bin1;
            sum2 += bin2;
            sumw1 += e1 * e1;
            sumw2 += e2 * e2;
        }
        if (sumw1 <= 0.0 || sumw2 <= 0.0) {
            System.out.println("Cannot compare histograms with all zero errors");
            return tmp;
        }
        if (sum1 == 0.0 || sum2 == 0.0) {
            System.out.println("One histogram is empty!");
            return tmp;
        }
        for (i = 0; i < bins1; ++i) {
            bin1 = this.binHeight(i);
            bin2 = h2.binHeight(i);
            e1 = this.binError(i);
            e2 = h2.binError(i);
            bin1 = e1 > 0.0 ? (bin1 *= bin1 / (e1 * e1)) : 0.0;
            bin2 = e2 > 0.0 ? (bin2 *= bin2 / (e2 * e2)) : 0.0;
            double binsum = bin1 + bin2;
            double delta = sum2 * bin1 - sum1 * bin2;
            if (!(binsum > 0.0)) continue;
            chi2 += delta * delta / binsum;
            ++nDf;
        }
        tmp.put("chi2", chi2 /= sum1 * sum2);
        tmp.put("ndf", Double.valueOf(nDf));
        ChiSquaredDistribution chi2Distribution = new ChiSquaredDistribution((double)nDf);
        double prob = chi2Distribution.cumulativeProbability(chi2);
        tmp.put("p-value", 1.0 - prob);
        return tmp;
    }

    public H1D oper(H1D a, String what) {
        return this.oper(a, this.getTitle(), what);
    }

    public double[][] getValues(int mode) {
        int i;
        double[][] nums = new double[3][];
        for (i = 0; i < 3; ++i) {
            nums[i] = new double[this.bins];
        }
        for (i = 0; i < this.bins; ++i) {
            nums[0][i] = this.binMean(i);
            if (mode == 1) {
                nums[0][i] = this.binCenter(i);
            }
            nums[1][i] = this.binHeight(i);
            nums[2][i] = this.binError(i);
        }
        return nums;
    }

    public H1D oper(H1D a, String title, String what) {
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory hf = af.createHistogramFactory(af.createTreeFactory().create());
        if (what.equals("+")) {
            IHistogram1D hnew = hf.add(title, (IHistogram1D)this.get(), (IHistogram1D)a.get());
            return new H1D(hnew);
        }
        if (what.equals("-")) {
            IHistogram1D hnew = hf.subtract(title, (IHistogram1D)this.get(), (IHistogram1D)a.get());
            return new H1D(hnew);
        }
        if (what.equals("*")) {
            IHistogram1D hnew = hf.multiply(title, (IHistogram1D)this.get(), (IHistogram1D)a.get());
            return new H1D(hnew);
        }
        if (what.equals("/")) {
            IHistogram1D hnew = hf.divide(title, (IHistogram1D)this.get(), (IHistogram1D)a.get());
            return new H1D(hnew);
        }
        this.ErrorMessage("Operation \"" + what + "\" is not implemented");
        return this;
    }

    public String[] getStatParameters() {
        double mean = this.h1.mean();
        double rms = this.h1.rms();
        DecimalFormat dfb = new DecimalFormat("##.###E00");
        String name = this.getTitle();
        String sentries = "Entries =" + Integer.toString(this.h1.entries());
        String smean = "Mean  =" + dfb.format(mean);
        String srms = "RMS =" + dfb.format(rms);
        String extra = "Under/Overflow =" + Integer.toString(this.h1.extraEntries());
        String[] s = new String[]{name, sentries, smean, srms, extra};
        return s;
    }

    private void ErrorMessage(String a) {
        Util.ErrorMessage(a);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

