/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Axis;
import graph.DataSet;
import graph.Gin;
import graph.Graph2D;
import graph.Range;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Rectangle;

public class G2Dint
extends Graph2D {
    protected boolean drag = false;
    protected boolean userlimits = false;
    private Gin cpgin = null;
    private Gin dpgin = null;
    private Range range = null;
    private int x0;
    private int y0;
    private int x1;
    private int y1;
    private int x1old;
    private int y1old;
    protected Axis xaxis;
    protected Axis yaxis;

    public Axis createXAxis() {
        this.xaxis = super.createAxis(5);
        return this.xaxis;
    }

    public Axis createYAxis() {
        this.yaxis = super.createAxis(2);
        return this.yaxis;
    }

    @Override
    public void attachAxis(Axis a) {
        if (a == null) {
            return;
        }
        super.attachAxis(a);
        if (a.getAxisPos() == 5 || a.getAxisPos() == 4) {
            this.xaxis = a;
        } else {
            this.yaxis = a;
        }
    }

    @Override
    public void update(Graphics g) {
        Rectangle r = this.bounds();
        Color c = g.getColor();
        r.x = 0;
        r.y = 0;
        if (this.drag) {
            g.setColor(this.DataBackground);
            float[] hsb = Color.RGBtoHSB(this.DataBackground.getRed(), this.DataBackground.getGreen(), this.DataBackground.getBlue(), null);
            if ((double)hsb[2] < 0.5) {
                g.setXORMode(Color.white);
            } else {
                g.setXORMode(Color.black);
            }
            g.drawLine(this.x0, this.y0, this.x1old, this.y0);
            g.drawLine(this.x1old, this.y0, this.x1old, this.y1old);
            g.drawLine(this.x1old, this.y1old, this.x0, this.y1old);
            g.drawLine(this.x0, this.y1old, this.x0, this.y0);
            g.drawLine(this.x0, this.y0, this.x1, this.y0);
            g.drawLine(this.x1, this.y0, this.x1, this.y1);
            g.drawLine(this.x1, this.y1, this.x0, this.y1);
            g.drawLine(this.x0, this.y1, this.x0, this.y0);
            g.setColor(c);
            this.x1old = this.x1;
            this.y1old = this.y1;
            return;
        }
        if (this.clearAll) {
            g.setColor(this.getBackground());
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(c);
        }
        if (this.paintAll) {
            this.paint(g);
        }
    }

    @Override
    public boolean keyDown(Event e, int key) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        switch (key) {
            case 82: {
                this.xaxis.resetRange();
                this.yaxis.resetRange();
                this.userlimits = false;
                this.repaint();
                return true;
            }
            case 114: {
                this.repaint();
                return true;
            }
            case 99: {
                if (this.cpgin == null) {
                    this.cpgin = new Gin("Position");
                }
                if (this.cpgin.isVisible()) {
                    this.cpgin.hide();
                } else {
                    this.cpgin.show();
                }
                return true;
            }
            case 68: {
                if (this.dpgin != null) {
                    this.dpgin.hide();
                }
                return true;
            }
            case 100: {
                if (this.dpgin == null) {
                    this.dpgin = new Gin("Data Point");
                }
                this.dpgin.show();
                double[] d = this.getClosestPoint(e.x, e.y);
                this.dpgin.setXlabel(d[0]);
                this.dpgin.setYlabel(d[1]);
                int ix = this.xaxis.getInteger(d[0]);
                int iy = this.yaxis.getInteger(d[1]);
                if (ix >= this.datarect.x && ix <= this.datarect.x + this.datarect.width && iy >= this.datarect.y && iy <= this.datarect.y + this.datarect.height) {
                    Graphics g = this.getGraphics();
                    g.fillOval(ix - 4, iy - 4, 8, 8);
                }
                return true;
            }
            case 109: {
                if (this.range == null) {
                    this.range = new Range(this);
                }
                this.range.show();
                this.range.requestFocus();
                this.userlimits = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseDown(Event e, int x, int y) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        this.requestFocus();
        this.x0 = x;
        this.y0 = y;
        this.drag = true;
        this.x1old = this.x0;
        this.y1old = this.y0;
        if (this.x0 < this.datarect.x) {
            this.x0 = this.datarect.x;
        } else if (this.x0 > this.datarect.x + this.datarect.width) {
            this.x0 = this.datarect.x + this.datarect.width;
        }
        if (this.y0 < this.datarect.y) {
            this.y0 = this.datarect.y;
        } else if (this.y0 > this.datarect.y + this.datarect.height) {
            this.y0 = this.datarect.y + this.datarect.height;
        }
        return true;
    }

    @Override
    public boolean mouseUp(Event e, int x, int y) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        this.x1 = x;
        this.y1 = y;
        if (this.drag) {
            this.userlimits = true;
        }
        this.drag = false;
        if (this.x1 < this.datarect.x) {
            this.x1 = this.datarect.x;
        } else if (this.x1 > this.datarect.x + this.datarect.width) {
            this.x1 = this.datarect.x + this.datarect.width;
        }
        if (this.y1 < this.datarect.y) {
            this.y1 = this.datarect.y;
        } else if (this.y1 > this.datarect.y + this.datarect.height) {
            this.y1 = this.datarect.y + this.datarect.height;
        }
        if (Math.abs(this.x0 - this.x1) > 5 && Math.abs(this.y0 - this.y1) > 5) {
            if (this.x0 < this.x1) {
                this.xaxis.minimum = this.xaxis.getDouble(this.x0);
                this.xaxis.maximum = this.xaxis.getDouble(this.x1);
            } else {
                this.xaxis.maximum = this.xaxis.getDouble(this.x0);
                this.xaxis.minimum = this.xaxis.getDouble(this.x1);
            }
            if (this.y0 > this.y1) {
                this.yaxis.minimum = this.yaxis.getDouble(this.y0);
                this.yaxis.maximum = this.yaxis.getDouble(this.y1);
            } else {
                this.yaxis.maximum = this.yaxis.getDouble(this.y0);
                this.yaxis.minimum = this.yaxis.getDouble(this.y1);
            }
            this.repaint();
        }
        return true;
    }

    @Override
    public boolean mouseDrag(Event e, int x, int y) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        this.x1 = x;
        this.y1 = y;
        if (this.drag) {
            if (this.x1 < this.datarect.x) {
                this.x1 = this.datarect.x;
            } else if (this.x1 > this.datarect.x + this.datarect.width) {
                this.x1 = this.datarect.x + this.datarect.width;
            }
            if (this.y1 < this.datarect.y) {
                this.y1 = this.datarect.y;
            } else if (this.y1 > this.datarect.y + this.datarect.height) {
                this.y1 = this.datarect.y + this.datarect.height;
            }
        }
        if (this.cpgin != null && this.cpgin.isVisible()) {
            this.cpgin.setXlabel(this.xaxis.getDouble(this.x1));
            this.cpgin.setYlabel(this.yaxis.getDouble(this.y1));
        }
        this.repaint();
        return true;
    }

    @Override
    public boolean mouseMove(Event e, int x, int y) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        this.x1 = e.x;
        this.y1 = e.y;
        if (this.cpgin != null && this.cpgin.isVisible()) {
            this.cpgin.setXlabel(this.xaxis.getDouble(this.x1));
            this.cpgin.setYlabel(this.yaxis.getDouble(this.y1));
        }
        return true;
    }

    @Override
    public boolean action(Event e, Object a) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        if (e.target instanceof Range && this.range != null) {
            double txmin = this.xaxis.minimum;
            double txmax = this.xaxis.maximum;
            double tymin = this.yaxis.minimum;
            double tymax = this.yaxis.maximum;
            Double d = this.range.getXmin();
            if (d != null) {
                txmin = d;
            }
            if ((d = this.range.getXmax()) != null) {
                txmax = d;
            }
            if ((d = this.range.getYmin()) != null) {
                tymin = d;
            }
            if ((d = this.range.getYmax()) != null) {
                tymax = d;
            }
            if (txmax > txmin && tymax > tymin) {
                this.xaxis.minimum = txmin;
                this.xaxis.maximum = txmax;
                this.yaxis.minimum = tymin;
                this.yaxis.maximum = tymax;
            }
            this.repaint();
            return true;
        }
        return false;
    }

    protected double[] getClosestPoint(int ix, int iy) {
        double[] a = new double[3];
        double distsq = -1.0;
        double[] data = new double[]{0.0, 0.0};
        double x = this.xaxis.getDouble(ix);
        double y = this.yaxis.getDouble(iy);
        for (int i = 0; i < this.dataset.size(); ++i) {
            DataSet ds = (DataSet)this.dataset.elementAt(i);
            a = ds.getClosestPoint(x, y);
            if (!(distsq < 0.0) && !(distsq > a[2])) continue;
            data[0] = a[0];
            data[1] = a[1];
            distsq = a[2];
        }
        return data;
    }
}

