/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.DataSet;
import graph.G2Dint;
import graph.IsoCurve;
import graph.TextLine;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;

public class Contour
extends G2Dint {
    static final int MINCELLS = 30;
    static final int NLEVELS = 12;
    protected int nx = 0;
    protected int ny = 0;
    protected Vector[] curves = null;
    protected boolean autoLevels = true;
    protected boolean logLevels = false;
    protected boolean gridLimits = false;
    protected double[] levels = new double[12];
    protected TextLine[] labels = new TextLine[12];
    protected Font labelfont = new Font("Helvetica", 0, 12);
    protected Color labelcolor = Color.blue;
    protected int labelStyle = 2;
    protected int labelPrecision = 2;
    protected int labelSignificant = 3;
    protected int labelLevels = 1;
    protected boolean drawlabels = true;
    protected boolean autoLabels = true;
    protected Color contourColor = null;
    protected Color labelledColor = null;
    protected double[] grid = null;
    protected double xmin = 0.0;
    protected double xmax = 0.0;
    protected double ymin = 0.0;
    protected double ymax = 0.0;
    protected double zmin = 0.0;
    protected double zmax = 0.0;
    public boolean noContours = false;

    public boolean loadGrid(URL file) {
        byte[] b = new byte[50];
        int nbytes = 0;
        int max = 100;
        int inc = 100;
        int n = 0;
        double[] data = new double[max];
        InputStream is = null;
        boolean comment = false;
        try {
            int c;
            is = file.openStream();
            block9: while ((c = is.read()) > -1) {
                switch (c) {
                    case 35: {
                        comment = true;
                        continue block9;
                    }
                    case 10: 
                    case 13: {
                        comment = false;
                    }
                    case 9: 
                    case 32: {
                        if (nbytes <= 0) continue block9;
                        String s = new String(b, 0, 0, nbytes);
                        data[n] = Double.valueOf(s);
                        if (++n >= max) {
                            double[] d = new double[max += inc];
                            System.arraycopy(data, 0, d, 0, n);
                            data = d;
                        }
                        nbytes = 0;
                        continue block9;
                    }
                }
                if (comment) continue;
                b[nbytes] = (byte)c;
                ++nbytes;
            }
            if (is != null) {
                is.close();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to load Grid from file ");
            e.printStackTrace();
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        if (n < 1) {
            System.out.println("Failed to load Grid from file ");
            return false;
        }
        this.nx = (int)(data[0] + 0.5);
        this.ny = (int)(data[1] + 0.5);
        if (n == this.nx * this.ny + 6) {
            this.xmin = data[2];
            this.xmax = data[3];
            this.ymin = data[4];
            this.ymax = data[5];
            this.grid = new double[this.nx * this.ny];
            System.arraycopy(data, 6, this.grid, 0, this.nx * this.ny);
        } else if (n == this.nx * this.ny + 2) {
            this.xmin = 1.0;
            this.xmax = this.nx;
            this.ymin = 1.0;
            this.ymax = this.ny;
            this.grid = new double[this.nx * this.ny];
            System.arraycopy(data, 2, this.grid, 0, this.nx * this.ny);
        } else {
            System.out.println("Error loading grid, Wrong number of points ");
            this.grid = null;
            return false;
        }
        this.zrange();
        this.calcLevels();
        this.detachCurves();
        this.curves = null;
        return true;
    }

    public void setRange(double xmin, double xmax, double ymin, double ymax) {
        if (xmin >= xmax || ymin >= ymax) {
            return;
        }
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public double[] getRange() {
        double[] d = new double[]{this.xmin, this.xmax, this.ymin, this.ymax};
        return d;
    }

    public int[] getDim() {
        int[] i = new int[]{this.nx, this.ny};
        return i;
    }

    public double[] getGrid() {
        return this.grid;
    }

    public void setLevels(double[] levels, int nl) {
        if (levels == null || nl <= 0) {
            return;
        }
        this.detachCurves();
        this.curves = null;
        this.autoLevels = false;
        this.levels = new double[nl];
        System.arraycopy(levels, 0, this.levels, 0, nl);
        this.labels = new TextLine[nl];
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new TextLine(String.valueOf((float)levels[i]));
        }
    }

    public void setLabels(TextLine[] labels, int nl) {
        if (labels == null || nl <= 0) {
            return;
        }
        this.autoLabels = false;
        this.labels = new TextLine[nl];
        System.arraycopy(labels, 0, this.labels, 0, nl);
    }

    public void setLabelFont(Font f) {
        this.labelfont = f;
    }

    public void setLabelColor(Color c) {
        this.labelcolor = c;
    }

    public void setGrid(double[] grid, int nx, int ny) {
        this.grid = grid;
        this.nx = nx;
        this.ny = ny;
        this.zrange();
        this.calcLevels();
    }

    public void deleteContours() {
        if (this.curves == null) {
            return;
        }
        this.detachCurves();
        this.curves = null;
    }

    public void detachContours() {
        if (this.curves == null) {
            return;
        }
        this.detachCurves();
    }

    public void attachContours() {
        if (this.curves == null) {
            return;
        }
        this.attachCurves();
    }

    public void setContourColor(Color c) {
        this.contourColor = c;
    }

    public void setLabelledContourColor(Color c) {
        this.labelledColor = c;
    }

    public double[] getLevels() {
        return this.levels;
    }

    public void setLimitsToGrid(boolean b) {
        this.gridLimits = b;
    }

    public void setLabelLevels(int i) {
        this.labelLevels = i <= 0 ? 0 : i;
    }

    public void setLogLevels(boolean b) {
        this.logLevels = b;
        if (this.zmin <= 0.0 || this.zmax <= 0.0) {
            this.logLevels = false;
        }
    }

    public void setNLevels(int l) {
        if (l <= 0) {
            return;
        }
        this.levels = new double[l];
        this.calcLevels();
        this.detachCurves();
        this.curves = null;
    }

    public void setAutoLevels(boolean b) {
        this.autoLevels = b;
    }

    public void setDrawLabels(boolean b) {
        this.drawlabels = b;
    }

    public void setLabelStyle(int s) {
        this.labelStyle = s;
        this.calcLabels();
    }

    public int getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelPrecision(int p) {
        this.labelPrecision = p;
        this.calcLabels();
    }

    public int getLabelPrecision() {
        return this.labelPrecision;
    }

    public void setLabelSignificance(int s) {
        this.labelSignificant = s;
        this.calcLabels();
    }

    public int getLabelSignificance() {
        return this.labelSignificant;
    }

    @Override
    public boolean keyDown(Event e, int key) {
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        if (super.keyDown(e, key)) {
            return true;
        }
        switch (key) {
            case 108: {
                this.drawlabels = false;
                this.repaint();
                return true;
            }
            case 76: {
                this.drawlabels = true;
                this.repaint();
                return true;
            }
        }
        return false;
    }

    private void calcLevels() {
        if (!this.autoLevels) {
            return;
        }
        if (this.levels == null) {
            this.levels = new double[12];
        }
        this.labels = new TextLine[this.levels.length];
        if (this.logLevels) {
            double inc = Math.log(this.zmax - this.zmin) / (double)(this.levels.length + 1);
            try {
                for (int i = 0; i < this.levels.length; ++i) {
                    this.levels[i] = this.zmin + Math.pow(Math.E, (double)(i + 1) * inc);
                }
            }
            catch (Exception e) {
                System.out.println("Error calculateing Log levels!");
                System.out.println("... calculating linear levels instead");
                this.logLevels = false;
                this.calcLevels();
            }
        } else {
            double inc = (this.zmax - this.zmin) / (double)(this.levels.length + 1);
            for (int i = 0; i < this.levels.length; ++i) {
                this.levels[i] = this.zmin + (double)(i + 1) * inc;
            }
        }
    }

    private void calcLabels() {
        if (!this.autoLabels) {
            return;
        }
        if (this.levels == null || this.levels.length <= 0) {
            return;
        }
        this.labels = new TextLine[this.levels.length];
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new TextLine();
            this.labels[i].parseDouble(this.levels[i], this.labelSignificant, this.labelPrecision, this.labelStyle);
        }
    }

    private void zrange() {
        this.zmin = this.grid[0];
        this.zmax = this.grid[1];
        for (int i = 0; i < this.grid.length; ++i) {
            this.zmin = Math.min(this.zmin, this.grid[i]);
            this.zmax = Math.max(this.zmax, this.grid[i]);
        }
        System.out.println("Data range: zmin=" + this.zmin + ", zmax=" + this.zmax);
        if (this.zmin == this.zmax) {
            System.out.println("Cannot produce contours of a constant surface!");
        }
        if (this.zmin <= 0.0 || this.zmax <= 0.0) {
            this.logLevels = false;
        }
    }

    @Override
    public void paintFirst(Graphics g, Rectangle r) {
        if (this.curves == null && !this.noContours) {
            this.calculateCurves();
            this.calcLabels();
        }
        this.setContourColors();
        if (this.gridLimits && !this.userlimits) {
            if (this.xaxis != null) {
                if (this.xaxis.minimum > this.xmin) {
                    this.xaxis.minimum = this.xmin;
                }
                if (this.xaxis.maximum < this.xmax) {
                    this.xaxis.maximum = this.xmax;
                }
            }
            if (this.yaxis != null) {
                if (this.yaxis.minimum > this.ymin) {
                    this.yaxis.minimum = this.ymin;
                }
                if (this.yaxis.maximum < this.ymax) {
                    this.yaxis.maximum = this.ymax;
                }
            }
        } else if (this.dataset.isEmpty()) {
            if (this.xaxis != null) {
                this.xaxis.minimum = this.xmin;
                this.xaxis.maximum = this.xmax;
            }
            if (this.yaxis != null) {
                this.yaxis.minimum = this.ymin;
                this.yaxis.maximum = this.ymax;
            }
        }
    }

    private void setContourColors() {
        int i;
        if (this.curves == null || this.contourColor == null && this.labelledColor == null) {
            return;
        }
        for (i = 0; i < this.curves.length; ++i) {
            this.setContourColors(this.curves[i], null);
        }
        if (this.contourColor != null) {
            for (i = 0; i < this.curves.length; ++i) {
                this.setContourColors(this.curves[i], this.contourColor);
            }
        }
        if (this.labelledColor != null) {
            for (i = 0; i < this.curves.length; ++i) {
                if (i % this.labelLevels != 0) continue;
                this.setContourColors(this.curves[i], this.labelledColor);
            }
        }
    }

    private void setContourColors(Vector v, Color c) {
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            DataSet d = (DataSet)v.elementAt(i);
            if (d == null) continue;
            d.linecolor = c;
        }
    }

    private void attachCurves() {
        if (this.curves == null) {
            return;
        }
        for (int i = 0; i < this.curves.length; ++i) {
            this.attachCurves(this.curves[i]);
        }
    }

    private void attachCurves(Vector v) {
        if (v == null) {
            return;
        }
        for (int j = 0; j < v.size(); ++j) {
            this.attachDataSet((DataSet)v.elementAt(j));
            if (this.xaxis != null) {
                this.xaxis.attachDataSet((DataSet)v.elementAt(j));
            }
            if (this.yaxis == null) continue;
            this.yaxis.attachDataSet((DataSet)v.elementAt(j));
        }
    }

    private void detachCurves() {
        if (this.curves == null) {
            return;
        }
        for (int i = 0; i < this.curves.length; ++i) {
            this.detachCurves(this.curves[i]);
        }
    }

    private void detachCurves(Vector v) {
        if (v == null) {
            return;
        }
        for (int j = 0; j < v.size(); ++j) {
            this.detachDataSet((DataSet)v.elementAt(j));
            if (this.xaxis != null) {
                this.xaxis.detachDataSet((DataSet)v.elementAt(j));
            }
            if (this.yaxis == null) continue;
            this.yaxis.detachDataSet((DataSet)v.elementAt(j));
        }
    }

    @Override
    public void paintLast(Graphics g, Rectangle rect) {
        double[] point = new double[2];
        Color current = g.getColor();
        Rectangle r = new Rectangle();
        if (this.xaxis == null || this.yaxis == null || this.labels == null || this.labelLevels == 0 || !this.drawlabels || this.curves == null) {
            super.paintLast(g, rect);
            return;
        }
        for (int i = 0; i < this.levels.length; ++i) {
            if (this.labels[i] == null || this.labels[i].isNull() || i % this.labelLevels != 0) continue;
            this.labels[i].setFont(this.labelfont);
            this.labels[i].setColor(this.labelcolor);
            Vector v = this.curves[i];
            for (int j = 0; j < v.size(); ++j) {
                DataSet ds = (DataSet)v.elementAt(j);
                int points = ds.dataPoints();
                int index = (int)(Math.random() * 30.0);
                while (points > 30) {
                    point = ds.getPoint(index);
                    int x = this.xaxis.getInteger(point[0]);
                    int y = this.yaxis.getInteger(point[1]);
                    r.width = this.labels[i].getWidth(g);
                    r.height = this.labels[i].getAscent(g);
                    r.x = x - r.width / 2;
                    r.y = y - r.height / 2;
                    g.setColor(this.DataBackground);
                    g.fillRect(r.x, r.y, r.width, r.height);
                    g.setColor(current);
                    this.labels[i].draw(g, r.x, r.y + r.height, 1);
                    points -= 30;
                    index += 30;
                }
            }
        }
        super.paintLast(g, rect);
    }

    protected void calculateCurves() {
        double xscale = (this.xmax - this.xmin) / (double)(this.nx - 1);
        double yscale = (this.ymax - this.ymin) / (double)(this.ny - 1);
        IsoCurve isocurve = new IsoCurve(this.grid, this.nx, this.ny);
        if (this.curves != null) {
            this.detachCurves();
            this.curves = null;
        }
        if (this.zmin == this.zmax) {
            return;
        }
        this.curves = new Vector[this.levels.length];
        for (int i = 0; i < this.levels.length; ++i) {
            double[] data;
            isocurve.setValue(this.levels[i]);
            this.curves[i] = new Vector();
            while ((data = isocurve.getCurve()) != null) {
                for (int j = 0; j < data.length; ++j) {
                    data[j] = this.xmin + data[j] * xscale;
                    data[++j] = this.ymin + data[j] * yscale;
                }
                try {
                    this.curves[i].addElement(new DataSet(data, data.length / 2));
                }
                catch (Exception e) {
                    System.out.println("Error loading contour into DataSet!");
                    System.out.println("...Contour Level " + this.levels[i]);
                }
            }
            this.attachCurves(this.curves[i]);
        }
    }
}

