/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.AstroOps;
import com.mhuss.AstroLib.LocationElements;
import com.mhuss.AstroLib.VsopData;
import com.mhuss.AstroLib.VsopSet;
import com.mhuss.AstroLib.VsopTerms;

public class Vsop {
    public static double calcLE(double t, int planet, int ltype) {
        double rval = 0.0;
        if (planet > 0 && planet < 9) {
            int i;
            t /= 10.0;
            double tPower = 1.0;
            VsopTerms[] pT = null;
            switch (planet) {
                case 1: {
                    switch (ltype) {
                        case 1: {
                            pT = VsopData.MercuryLonTerms;
                            break;
                        }
                        case 0: {
                            pT = VsopData.MercuryLatTerms;
                            break;
                        }
                        case 2: {
                            pT = VsopData.MercuryRadTerms;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (ltype) {
                        case 1: {
                            pT = VsopData.VenusLonTerms;
                            break;
                        }
                        case 0: {
                            pT = VsopData.VenusLatTerms;
                            break;
                        }
                        case 2: {
                            pT = VsopData.VenusRadTerms;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (ltype) {
                        case 1: {
                            pT = VsopData.EarthLonTerms;
                            break;
                        }
                        case 0: {
                            pT = VsopData.EarthLatTerms;
                            break;
                        }
                        case 2: {
                            pT = VsopData.EarthRadTerms;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (ltype) {
                        case 1: {
                            pT = VsopData.MarsLonTerms;
                            break;
                        }
                        case 0: {
                            pT = VsopData.MarsLatTerms;
                            break;
                        }
                        case 2: {
                            pT = VsopData.MarsRadTerms;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (ltype) {
                        case 1: {
                            pT = VsopData.JupiterLonTerms;
                            break;
                        }
                        case 0: {
                            pT = VsopData.JupiterLatTerms;
                            break;
                        }
                        case 2: {
                            pT = VsopData.JupiterRadTerms;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (ltype) {
                        case 1: {
                            pT = VsopData.SaturnLonTerms;
                            break;
                        }
                        case 0: {
                            pT = VsopData.SaturnLatTerms;
                            break;
                        }
                        case 2: {
                            pT = VsopData.SaturnRadTerms;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (ltype) {
                        case 1: {
                            pT = VsopData.UranusLonTerms;
                            break;
                        }
                        case 0: {
                            pT = VsopData.UranusLatTerms;
                            break;
                        }
                        case 2: {
                            pT = VsopData.UranusRadTerms;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (ltype) {
                        case 1: {
                            pT = VsopData.NeptuneLonTerms;
                            break;
                        }
                        case 0: {
                            pT = VsopData.NeptuneLatTerms;
                            break;
                        }
                        case 2: {
                            pT = VsopData.NeptuneRadTerms;
                        }
                    }
                    break;
                }
            }
            int j = 0;
            try {
                for (i = 0; i < 6; ++i) {
                    double sum = 0.0;
                    VsopSet[] pv = pT[i].pTerms;
                    for (j = 0; j < pT[i].rows; ++j) {
                        sum += pv[j].A * Math.cos(pv[j].B + pv[j].C * t);
                    }
                    rval += sum * tPower;
                    tPower *= t;
                }
            }
            catch (ArrayIndexOutOfBoundsException a) {
                System.err.println("Vsop.calcLE(): Array out of bounds\n  i=" + i + ", j=" + j + ", p=" + planet + ", type=" + ltype);
            }
            rval *= 1.0E-8;
            if (1 == ltype) {
                rval = AstroOps.normalizeRadians(rval);
            }
        }
        return rval;
    }

    public static void calcAllLEs(LocationElements loc, double jcen, int planet) {
        loc.set(Vsop.calcLE(jcen, planet, 0), Vsop.calcLE(jcen, planet, 1), Vsop.calcLE(jcen, planet, 2));
    }
}

