/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.DateOps;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class Nutation {
    private double m_t;
    private double m_dPhi;
    private double m_dEpsilon;
    private final double[] linearPart = new double[]{445267.11148, 35999.05034, 477198.867398, 483202.017538, -1934.136261};
    private final double[][] coefficients = new double[][]{{2.9785036E7, -19142.0, 189474.0}, {3.5752772E7, -1603.0, -300000.0}, {1.3496298E7, 86972.0, 56250.0}, {9327191.0, -36825.0, 327270.0}, {1.2504452E7, 20708.0, 450000.0}};
    private final int N_NUTATION_COEFFS = 62;
    private final int[][] args = new int[][]{{324, -13187, 5736}, {1574, -2274, 977}, {1564, 2062, -895}, {1687, 1426, 54}, {1587, 712, -7}, {449, -517, 224}, {1573, -386, 200}, {1599, -301, 129}, {199, 217, -95}, {337, -158, 0}, {323, 129, -70}, {1549, 123, -53}, {2812, 63, 0}, {1588, 63, -33}, {2799, -59, 26}, {1538, -58, 32}, {1598, -51, 27}, {362, 48, 0}, {1523, 46, -24}, {2824, -38, 16}, {1624, -31, 13}, {1612, 29, 0}, {349, 29, -12}, {1572, 26, 0}, {322, -22, 0}, {1548, 21, -10}, {1812, 17, 0}, {2788, 16, -8}, {574, -16, 7}, {1688, -15, 9}, {338, -13, 7}, {1438, -12, 6}, {1602, 11, 0}, {2798, -10, 5}, {2849, -8, 3}, {1699, 7, -3}, {462, -7, 0}, {1449, -7, 3}, {2823, -7, 3}, {2837, 6, 0}, {374, 6, -3}, {348, 6, -3}, {2763, -6, 3}, {2813, -6, 3}, {1462, 5, 0}, {198, -5, 3}, {313, -5, 3}, {1623, -5, 3}, {1524, -3, 0}, {363, 4, 0}, {448, 4, 0}, {1474, -3, 0}, {2674, -3, 0}, {1649, -3, 0}, {2699, -3, 0}, {837, -3, 0}, {962, -4, 0}, {437, -4, 0}, {1577, 4, 0}, {2187, -4, 0}, {1712, -3, 0}, {1597, 3, 0}};
    private final int[] timeDependent = new int[]{-16, -2, 2, -34, 1, 12, -4, 0, -5, 0, 1, 0, 0, 1, 0, -1, -31, -5, 5, -1, 0, -6, 0, -1, 3};

    public Nutation() {
        this.m_dEpsilon = 0.0;
        this.m_dPhi = 0.0;
        this.m_t = 0.0;
    }

    public Nutation(double t) {
        this.m_dEpsilon = 0.0;
        this.m_dPhi = 0.0;
        this.calc(t);
    }

    public Nutation(double t, double dP, double dE) {
        this.m_dPhi = dP;
        this.m_dEpsilon = dE;
        this.calc(t);
    }

    public double getDPhi() {
        return this.m_dPhi;
    }

    public double getDEpsilon() {
        return this.m_dEpsilon;
    }

    public void calc(double t) {
        int i;
        this.m_t = t;
        double[] terms = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double t2 = this.m_t * this.m_t;
        double t3 = t2 * this.m_t;
        for (i = 0; i < 5; ++i) {
            terms[i] = this.linearPart[i] * this.m_t + this.coefficients[i][0] / 100000.0;
            int n = i;
            terms[n] = terms[n] + t2 * this.coefficients[i][1] * 1.0E-7;
            int n2 = i;
            terms[n2] = terms[n2] + t3 / this.coefficients[i][2];
            terms[i] = Math.toRadians(terms[i]);
        }
        if (!(this.m_dPhi < 0.0)) {
            this.m_dPhi = (-171996.0 - 174.2 * this.m_t) * Math.sin(terms[4]);
        }
        if (!(this.m_dEpsilon < 0.0)) {
            this.m_dEpsilon = (92025.0 + 8.9 * this.m_t) * Math.cos(terms[4]);
        }
        for (i = 0; i < 62; ++i) {
            double totalArg = 0.0;
            int mult = this.args[i][0];
            for (int j = 4; j >= 0; --j) {
                if (mult % 5 != 2) {
                    totalArg += (double)(mult % 5 - 2) * terms[j];
                }
                mult /= 5;
            }
            double coeff = this.args[i][1];
            if (i < 16 && 0 != this.timeDependent[i]) {
                coeff += (double)this.timeDependent[i] * this.m_t / 10.0;
            } else if (26 == i || 28 == i) {
                coeff += (double)(27 - i) * this.m_t / 10.0;
            }
            if (!(this.m_dPhi < 0.0)) {
                this.m_dPhi += coeff * Math.sin(totalArg);
            }
            if (0 == this.args[i][2]) continue;
            coeff = this.args[i][2];
            if (i < 9 && 0 != this.timeDependent[i + 16]) {
                coeff += (double)this.timeDependent[i + 16] * this.m_t / 10.0;
            }
            if (this.m_dEpsilon < 0.0) continue;
            this.m_dEpsilon += coeff * Math.cos(totalArg);
        }
        this.m_dPhi *= 1.0E-4;
        this.m_dEpsilon *= 1.0E-4;
    }

    public void calcDeltaPhi(double t) {
        double temp = this.m_dEpsilon;
        this.m_dEpsilon = -1.0;
        this.m_dPhi = 0.0;
        this.calc(t);
        this.m_dEpsilon = temp;
    }

    public void calcDeltaEpsilon(double t) {
        double temp = this.m_dPhi;
        this.m_dEpsilon = -1.0;
        this.m_dEpsilon = 0.0;
        this.calc(t);
        this.m_dPhi = temp;
    }

    public static void main(String[] args) {
        System.out.println("Nutation Test");
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat df = new SimpleDateFormat();
        DecimalFormat dec = new DecimalFormat("0.0#");
        df.setCalendar(cal);
        double d = DateOps.dmyToDay(cal.get(5), cal.get(2) + 1, cal.get(1));
        Nutation n = new Nutation(d);
        System.out.println("dPhi=" + dec.format(n.getDPhi()) + ", dEpsilon=" + dec.format(n.getDEpsilon()));
    }
}

