/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.test;

import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import org.netlib.blas.Dgemm;
import org.netlib.blas.Dsyrk;
import org.netlib.lapack.Dlacpy;
import org.netlib.lapack.Dlange;
import org.netlib.lapack.Dlansy;

public class DgelsTest {
    public static void main(String[] args) {
        int n = 10;
        for (int i = 0; i < n; ++i) {
            DgelsTest.dgelsTest(args);
        }
    }

    public static void dgelsTest(String[] args) {
        int j;
        int i;
        if (args.length != 5) {
            System.out.println(" Proper Usage is : java edu.emory.mathcs.jplasma.test.DgelsTest M N LDA NRHS LDB with \n - M : number of rows of the matrix A \n - N : number of columns of the matrix A \n - LDA : leading dimension of the matrix A \n - NRHS : number of RHS \n - LDB : leading dimension of the matrix B");
            System.exit(1);
        }
        int M = Integer.parseInt(args[0]);
        int N = Integer.parseInt(args[1]);
        int LDA = Integer.parseInt(args[2]);
        int NRHS = Integer.parseInt(args[3]);
        int LDB = Integer.parseInt(args[4]);
        double[] A1 = new double[LDA * N];
        double[] A2 = new double[LDA * N];
        double[] Q = new double[M * M];
        double[] B1 = new double[LDB * NRHS];
        double[] B2 = new double[LDB * NRHS];
        Dplasma.plasma_Init(M, N, NRHS);
        for (i = 0; i < M; ++i) {
            for (j = 0; j < N; ++j) {
                double d = 0.5 - Math.random();
                A2[LDA * j + i] = d;
                A1[LDA * j + i] = d;
            }
        }
        for (i = 0; i < M; ++i) {
            Q[M * i + i] = 1.0;
        }
        for (i = 0; i < M; ++i) {
            for (j = 0; j < NRHS; ++j) {
                double d = 0.5 - Math.random();
                B2[LDB * j + i] = d;
                B1[LDB * j + i] = d;
            }
        }
        double[] T = Dplasma.plasma_Allocate_T(M, N);
        Dplasma.plasma_DGELS(111, M, N, NRHS, A2, 0, LDA, T, 0, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(M, N, NRHS);
        Dplasma.plasma_DORMQR(141, 111, M, M, N, A2, 0, LDA, T, 0, Q, 0, M);
        double eps = 1.0E-10;
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DGELS ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", M, N));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", eps));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int info_ortho = DgelsTest.check_orthogonality(M, Q, eps);
        int info_factorization = DgelsTest.check_factorization(M, N, A1, A2, LDA, Q, eps);
        int info_solution = DgelsTest.check_solution(M, N, NRHS, A1, LDA, B1, B2, LDB, eps);
        if (info_solution == 0 & info_factorization == 0 & info_ortho == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGELS .... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGELS .... FAILED !\n");
            System.out.print("************************************************\n");
        }
        for (i = 0; i < M; ++i) {
            for (j = 0; j < N; ++j) {
                double d = 0.5 - Math.random();
                A2[LDA * j + i] = d;
                A1[LDA * j + i] = d;
            }
        }
        Q = new double[M * M];
        for (i = 0; i < M; ++i) {
            Q[M * i + i] = 1.0;
        }
        for (i = 0; i < M; ++i) {
            for (j = 0; j < NRHS; ++j) {
                double d = 0.5 - Math.random();
                B2[LDB * j + i] = d;
                B1[LDB * j + i] = d;
            }
        }
        T = Dplasma.plasma_Allocate_T(M, N);
        Dplasma.plasma_DGEQRF(M, N, A2, 0, LDA, T, 0);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(M, N, NRHS);
        Dplasma.plasma_DORMQR(141, 111, M, M, N, A2, 0, LDA, T, 0, Q, 0, M);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(M, N, NRHS);
        Dplasma.plasma_DORMQR(141, 111, M, NRHS, N, A2, 0, LDA, T, 0, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(M, N, NRHS);
        Dplasma.plasma_DTRSM(141, 121, 111, 131, N, NRHS, A2, 0, LDA, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DGEQRF + DORMQR + DTRSM  ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", M, N));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", eps));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        info_ortho = DgelsTest.check_orthogonality(M, Q, eps);
        info_factorization = DgelsTest.check_factorization(M, N, A1, A2, LDA, Q, eps);
        info_solution = DgelsTest.check_solution(M, N, NRHS, A1, LDA, B1, B2, LDB, eps);
        if (info_solution == 0 & info_factorization == 0 & info_ortho == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGEQRF + DORMQR + DTRSM .... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGEQRF + DORMQR + DTRSM .... FAILED !\n");
            System.out.print("************************************************\n");
        }
    }

    private static int check_orthogonality(int M, double[] Q, double eps) {
        int info_ortho;
        String norm = "I";
        double[] work = new double[M];
        double alpha = 1.0;
        double beta = -1.0;
        double[] Id = new double[M * M];
        for (int i = 0; i < M; ++i) {
            Id[i * M + i] = 1.0;
        }
        Dsyrk.dsyrk((String)"U", (String)"N", (int)M, (int)M, (double)alpha, (double[])Q, (int)0, (int)M, (double)beta, (double[])Id, (int)0, (int)M);
        double normQ = Dlansy.dlansy((String)norm, (String)Dplasma.lapack_const(121), (int)M, (double[])Id, (int)0, (int)M, (double[])work, (int)0);
        System.out.print("============\n");
        System.out.print("Checking the orthogonality of Q \n");
        System.out.print(String.format("||Id-Q'*Q||_oo / (N*eps) = %e\n", normQ / ((double)M * eps)));
        if (normQ / ((double)M * eps) > 10.0) {
            System.out.print("-- Orthogonality is suspicious ! \n");
            info_ortho = 1;
        } else {
            System.out.print("-- Orthogonality is CORRECT ! \n");
            info_ortho = 0;
        }
        return info_ortho;
    }

    private static int check_factorization(int M, int N, double[] A1, double[] A2, int LDA, double[] Q, double eps) {
        int info_factorization;
        String norm = "I";
        double[] Ql = new double[M * N];
        double[] Residual = new double[M * N];
        double[] work = new double[M];
        double alpha = 1.0;
        double beta = 0.0;
        double[] R = new double[M * N];
        Dlacpy.dlacpy((String)"U", (int)M, (int)N, (double[])A2, (int)0, (int)LDA, (double[])R, (int)0, (int)M);
        Ql = new double[M * N];
        Dgemm.dgemm((String)"T", (String)"N", (int)M, (int)N, (int)M, (double)alpha, (double[])Q, (int)0, (int)M, (double[])R, (int)0, (int)M, (double)beta, (double[])Ql, (int)0, (int)M);
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < N; ++j) {
                Residual[j * M + i] = A1[j * LDA + i] - Ql[j * M + i];
            }
        }
        double Rnorm = Dlange.dlange((String)norm, (int)M, (int)N, (double[])Residual, (int)0, (int)M, (double[])work, (int)0);
        double Anorm = Dlange.dlange((String)norm, (int)M, (int)N, (double[])A2, (int)0, (int)LDA, (double[])work, (int)0);
        System.out.print("============\n");
        System.out.print("Checking the QR Factorization \n");
        System.out.print(String.format("-- ||A-QR||_oo/(||A||_oo.N.eps) = %e \n", Rnorm / (Anorm * (double)N * eps)));
        if (Rnorm / (Anorm * (double)N * eps) > 10.0) {
            System.out.print("-- Factorization is suspicious ! \n");
            info_factorization = 1;
        } else {
            System.out.print("-- Factorization is CORRECT ! \n");
            info_factorization = 0;
        }
        return info_factorization;
    }

    private static int check_solution(int M, int N, int NRHS, double[] A1, int LDA, double[] B1, double[] B2, int LDB, double eps) {
        int info_solution;
        String norm = "I";
        double[] work = new double[M];
        double alpha = 1.0;
        double beta = -1.0;
        double Anorm = Dlange.dlange((String)norm, (int)M, (int)N, (double[])A1, (int)0, (int)LDA, (double[])work, (int)0);
        double Xnorm = Dlange.dlange((String)norm, (int)M, (int)NRHS, (double[])B2, (int)0, (int)LDB, (double[])work, (int)0);
        double Bnorm = Dlange.dlange((String)norm, (int)M, (int)NRHS, (double[])B1, (int)0, (int)LDB, (double[])work, (int)0);
        Dgemm.dgemm((String)"N", (String)"N", (int)M, (int)NRHS, (int)N, (double)alpha, (double[])A1, (int)0, (int)LDA, (double[])B2, (int)0, (int)LDB, (double)beta, (double[])B1, (int)0, (int)LDB);
        double[] Residual = new double[M * NRHS];
        Dgemm.dgemm((String)"T", (String)"N", (int)N, (int)NRHS, (int)M, (double)alpha, (double[])A1, (int)0, (int)LDA, (double[])B1, (int)0, (int)LDB, (double)beta, (double[])Residual, (int)0, (int)M);
        double Rnorm = Dlange.dlange((String)norm, (int)M, (int)NRHS, (double[])Residual, (int)0, (int)M, (double[])work, (int)0);
        System.out.print("============\n");
        System.out.print("Checking the Residual of the solution \n");
        System.out.print(String.format("-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||)_oo.N.eps) = %e \n", Rnorm / ((Anorm * Xnorm + Bnorm) * (double)N * eps)));
        if (Rnorm / ((Anorm * Xnorm + Bnorm) * (double)N * eps) > 10.0) {
            System.out.print("-- The solution is suspicious ! \n");
            info_solution = 1;
        } else {
            System.out.print("-- The solution is CORRECT ! \n");
            info_solution = 0;
        }
        return info_solution;
    }
}

