/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.json;

import java.io.IOException;
import java.util.BitSet;

final class JsonOutput {
    private static final String[] REPLACE = new String[128];
    private final Appendable output;
    private final String indent;
    private final String newLine;
    private String currentIndent = "";
    private int commaDepth;
    private BitSet commaState = new BitSet(64);

    JsonOutput(Appendable output) {
        this(output, "", "");
    }

    JsonOutput(Appendable output, String indent, String newLine) {
        this.output = output;
        this.indent = indent;
        this.newLine = newLine;
    }

    void writeNull() throws IOException {
        this.output.append("null");
    }

    void writeBoolean(boolean value) throws IOException {
        if (value) {
            this.output.append("true");
        } else {
            this.output.append("false");
        }
    }

    void writeInt(int value) throws IOException {
        if ((value & 0xFFFFFFF8) == 0) {
            this.output.append((char)(value + 48));
        } else {
            this.output.append(Integer.toString(value));
        }
    }

    void writeLong(long value) throws IOException {
        this.output.append(Long.toString(value));
    }

    void writeFloat(float value) throws IOException {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            this.output.append('\"').append(Float.toString(value)).append('\"');
        } else {
            this.output.append(Float.toString(value));
        }
    }

    void writeDouble(double value) throws IOException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            this.output.append('\"').append(Double.toString(value)).append('\"');
        } else {
            this.output.append(Double.toString(value));
        }
    }

    void writeString(String value) throws IOException {
        this.output.append('\"');
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch < '\u0080') {
                String replace = REPLACE[ch];
                if (replace != null) {
                    this.output.append(replace);
                    continue;
                }
                this.output.append(ch);
                continue;
            }
            if (ch == '\u2028') {
                this.output.append("\\u2028");
                continue;
            }
            if (ch == '\u2029') {
                this.output.append("\\u2029");
                continue;
            }
            this.output.append(ch);
        }
        this.output.append('\"');
    }

    void writeArrayStart() throws IOException {
        this.output.append('[');
        ++this.commaDepth;
        this.commaState.clear(this.commaDepth);
    }

    void writeArrayItemStart() throws IOException {
        if (this.commaState.get(this.commaDepth)) {
            this.output.append(',');
            if (this.newLine.length() > 0) {
                this.output.append(' ');
            }
        } else {
            this.commaState.set(this.commaDepth);
        }
    }

    void writeArrayEnd() throws IOException {
        this.output.append(']');
        --this.commaDepth;
    }

    void writeObjectStart() throws IOException {
        this.output.append('{');
        this.currentIndent = this.currentIndent + this.indent;
        ++this.commaDepth;
        this.commaState.set(this.commaDepth, false);
    }

    void writeObjectKey(String key) throws IOException {
        if (this.commaState.get(this.commaDepth)) {
            this.output.append(',');
        } else {
            this.commaState.set(this.commaDepth, true);
        }
        this.output.append(this.newLine);
        this.output.append(this.currentIndent);
        this.writeString(key);
        this.output.append(':');
        if (this.newLine.length() > 0) {
            this.output.append(' ');
        }
    }

    void writeObjectKeyValue(String key, String value) throws IOException {
        this.writeObjectKey(key);
        this.writeString(value);
    }

    void writeObjectEnd() throws IOException {
        this.currentIndent = this.currentIndent.substring(0, this.currentIndent.length() - this.indent.length());
        if (this.commaState.get(this.commaDepth)) {
            this.output.append(this.newLine);
            this.output.append(this.currentIndent);
        }
        this.output.append('}');
        --this.commaDepth;
    }

    static {
        for (int i = 0; i < 32; ++i) {
            JsonOutput.REPLACE[i] = String.format("\\u%04x", i);
        }
        JsonOutput.REPLACE[8] = "\\b";
        JsonOutput.REPLACE[9] = "\\t";
        JsonOutput.REPLACE[10] = "\\n";
        JsonOutput.REPLACE[12] = "\\f";
        JsonOutput.REPLACE[13] = "\\r";
        JsonOutput.REPLACE[34] = "\\\"";
        JsonOutput.REPLACE[92] = "\\\\";
        JsonOutput.REPLACE[127] = "\\u007f";
    }
}

