/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.light;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.Property;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicMetaProperty;
import org.joda.beans.impl.BasicProperty;
import org.joda.beans.impl.light.PropertyGetter;

final class LightMetaProperty<P>
extends BasicMetaProperty<P> {
    private final MetaBean metaBean;
    private final Class<P> propertyType;
    private final Type propertyGenericType;
    private final List<Annotation> annotations;
    private final PropertyGetter getter;
    private final int constructorIndex;

    static <P> LightMetaProperty<P> of(MetaBean metaBean, final Field field, final String propertyName, int constructorIndex) {
        PropertyGetter getter = new PropertyGetter(){

            @Override
            public Object get(Bean bean) {
                try {
                    return field.get(bean);
                }
                catch (IllegalArgumentException ex) {
                    throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
                }
            }
        };
        return new LightMetaProperty(metaBean, propertyName, field.getType(), field.getGenericType(), Arrays.asList(field.getAnnotations()), getter, constructorIndex);
    }

    static <P> LightMetaProperty<P> of(MetaBean metaBean, Field field, final Method method, final String propertyName, int constructorIndex) {
        PropertyGetter getter = new PropertyGetter(){

            @Override
            public Object get(Bean bean) {
                try {
                    return method.invoke((Object)bean, new Object[0]);
                }
                catch (IllegalArgumentException ex) {
                    throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)ex.getCause();
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        Class<?> propertyType = field.getType();
        Type propertyGenericType = field.getGenericType();
        if (method.getReturnType().getName().contains("Optional")) {
            propertyType = method.getReturnType();
            propertyGenericType = method.getGenericReturnType();
        }
        return new LightMetaProperty(metaBean, propertyName, propertyType, propertyGenericType, Arrays.asList(field.getAnnotations()), getter, constructorIndex);
    }

    LightMetaProperty(MetaBean metaBean, String propertyName, Class<P> propertyType, Type propertyGenericType, List<Annotation> annotations, PropertyGetter getter, int constructorIndex) {
        super(propertyName);
        this.metaBean = metaBean;
        this.propertyType = propertyType;
        this.propertyGenericType = propertyGenericType;
        this.annotations = annotations;
        this.getter = getter;
        this.constructorIndex = constructorIndex;
    }

    @Override
    public Property<P> createProperty(Bean bean) {
        return BasicProperty.of(bean, this);
    }

    @Override
    public MetaBean metaBean() {
        return this.metaBean;
    }

    @Override
    public Class<?> declaringType() {
        return this.metaBean.beanType();
    }

    @Override
    public Class<P> propertyType() {
        return this.propertyType;
    }

    @Override
    public Type propertyGenericType() {
        return this.propertyGenericType;
    }

    @Override
    public PropertyStyle style() {
        return ImmutableBean.class.isAssignableFrom(this.metaBean.beanType()) ? PropertyStyle.IMMUTABLE : PropertyStyle.READ_WRITE;
    }

    @Override
    public List<Annotation> annotations() {
        return this.annotations;
    }

    @Override
    public P get(Bean bean) {
        return (P)this.getter.get(bean);
    }

    @Override
    public void set(Bean bean, Object value) {
        throw new UnsupportedOperationException("Property cannot be written: " + this.name());
    }

    int getConstructorIndex() {
        return this.constructorIndex;
    }
}

