/*
 * Decompiled with CFR 0.152.
 */
import jscl.math.numeric.Complex;
import jscl.math.numeric.JSCLDouble;
import jscl.text.ParseException;
import junit.framework.Test;
import junit.framework.TestSuite;

public class numericTest
extends test {
    public static Test suite() {
        return new TestSuite(numericTest.class);
    }

    public void test1() throws ParseException {
        numericTest.assertEquals((String)"3.141592653589793", (String)numericTest.numeric("pi"));
    }

    public void test2() throws ParseException {
        numericTest.assertEquals((String)"2.7182818284590455", (String)numericTest.numeric("exp(1)"));
    }

    public void test3() throws ParseException {
        numericTest.assertEquals((String)"2.0", (String)numericTest.numeric("1.+1."));
    }

    public void test4() throws ParseException {
        numericTest.assertEquals((String)"8.38905609893065", (String)numericTest.numeric("1.+exp(2.)"));
    }

    public void test5() throws ParseException {
        String s = "7.389056098930652";
        numericTest.assertEquals((String)s, (String)numericTest.numeric("2.7182818284590455^2"));
        numericTest.assertEquals((String)"0.7389056098930652", (String)numericTest.numeric(s + "e-1"));
        numericTest.assertEquals((String)"73.89056098930652", (String)numericTest.numeric(s + "e+1"));
    }

    public void test6() throws ParseException {
        numericTest.assertEquals((String)"Infinity", (String)numericTest.numeric("Infinity"));
    }

    public void test7() throws ParseException {
        numericTest.assertEquals((String)"Infinity", (String)numericTest.numeric("Infinity+Infinity"));
    }

    public void test8() throws ParseException {
        numericTest.assertEquals((String)"NaN", (String)numericTest.numeric("NaN"));
    }

    public void test9() throws ParseException {
        numericTest.assertEquals((String)"NaN", (String)numericTest.numeric("2*NaN"));
    }

    public void test10() throws ParseException {
        numericTest.assertEquals((String)"NaN", (String)numericTest.numeric("Infinity+(-Infinity)"));
    }

    public void test11() throws ParseException {
        numericTest.assertEquals((String)"-1.0", (String)numericTest.numeric("cos(pi)"));
    }

    public void test12() throws ParseException {
        String s = "cos(pi*(1+sqrt(-1)))";
        numericTest.assertEquals((String)"-11.591953275521519-1.414312668805276E-15*sqrt(-1)", (String)numericTest.numeric(s));
        numericTest.assertEquals((String)"-11.591953275521519", (String)numericTest.numeric(numericTest.simplify(numericTest.elementary(s))));
    }

    public void test13() throws ParseException {
        String s = "cos(pi+sqrt(-1))";
        numericTest.assertEquals((String)"-1.543080634815244-1.4392063801500302E-16*sqrt(-1)", (String)numericTest.numeric(s));
        numericTest.assertEquals((String)"-1.543080634815244", (String)numericTest.numeric(numericTest.simplify(numericTest.elementary(s))));
    }

    public void test14() throws ParseException {
        numericTest.assertEquals((String)"0.5403023058681398", (String)numericTest.numeric("cos(1)"));
    }

    public void test15() throws ParseException {
        String s = "cos(1+sqrt(-1))";
        numericTest.assertEquals((String)"0.8337300251311489-0.988897705762865*sqrt(-1)", (String)numericTest.numeric(s));
        numericTest.assertEquals((String)"0.8337300251311491-0.9888977057628654*sqrt(-1)", (String)numericTest.numeric(numericTest.simplify(numericTest.elementary(s))));
    }

    public void test16() throws ParseException {
        numericTest.assertEquals((String)"sqrt(-1)", (String)numericTest.numeric("sqrt(-1)"));
    }

    public void test17() throws ParseException {
        numericTest.assertEquals((String)"-sqrt(-1)", (String)numericTest.numeric("-sqrt(-1)"));
    }

    public void test18() throws ParseException {
        String s = "0.0+1.0*sqrt(-1)";
        numericTest.assertEquals((String)s, (String)numericTest.expand(s));
        numericTest.assertEquals((String)"sqrt(-1)", (String)numericTest.numeric(s));
    }

    public void test19() throws ParseException {
        numericTest.assertEquals((String)"0.0", (String)numericTest.numeric("0"));
    }

    public void test20() throws ParseException {
        numericTest.assertEquals((String)"1.0", (String)numericTest.numeric("1"));
    }

    public void test21() throws ParseException {
        numericTest.assertEquals((String)"1.0+sqrt(-1)", (String)numericTest.numeric("1.0+sqrt(-1)"));
    }

    public void test22() throws ParseException {
        numericTest.assertEquals((String)"Infinity", (String)numericTest.numeric("1/0"));
    }

    public void test23() throws ParseException {
        numericTest.assertEquals((String)"NaN", (String)numericTest.numeric("0/0"));
    }

    public void test24() throws ParseException {
        numericTest.assertEquals((String)"-Infinity", (String)numericTest.numeric("-1/0"));
    }

    public void test25() throws ParseException {
        numericTest.assertEquals((String)"{{0.42857142857142855, -0.2857142857142857},\n{0.2857142857142857, 0.14285714285714285}}", (String)numericTest.numeric("1/{{1,2},{-2,3}}"));
    }

    public void test26() throws ParseException {
        numericTest.assertEquals((String)"6.123233995736766E-17+sqrt(-1)", (String)numericTest.numeric("(-1)^(1/2)"));
    }

    public void test27() throws ParseException {
        numericTest.assertEquals((String)"NaN+NaN*sqrt(-1)", (String)numericTest.numeric("log(-1)*(1+sqrt(-1))"));
    }

    public void test28() throws ParseException {
        numericTest.assertEquals((Object)Complex.valueOf(0.0, 0.0), (Object)Complex.valueOf(0.0, 0.0).pow(JSCLDouble.valueOf(1.0)));
        numericTest.assertEquals((Object)JSCLDouble.valueOf(1.0), (Object)Complex.valueOf(0.0, 0.0).pow(JSCLDouble.valueOf(0.0)));
    }

    public void test29() throws ParseException {
        numericTest.assertEquals((String)"1.0", (String)numericTest.numeric("0^0.0"));
        numericTest.assertEquals((String)"0^0.0", (String)numericTest.expand("0^0.0"));
    }

    public void test30() throws ParseException {
        numericTest.assertEquals((String)"1.0", (String)numericTest.numeric("lt(0.1,0.2)"));
    }
}

