/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.MonomialIterator;

class MonomialDivisor
extends MonomialIterator {
    MonomialDivisor(Monomial beginning, Monomial monomial) {
        super(beginning, monomial);
        if (this.hasNext()) {
            this.seek();
        }
    }

    void seek() {
        int n = this.current.element.length;
        while (n > 0 && this.current.element[--n] <= this.monomial.element[n]) {
        }
        int p = n;
        while (n > 0) {
            int n2 = p;
            this.current.element[n2] = this.current.element[n2] + this.current.element[--n];
            this.current.element[n] = 0;
        }
        if (p < this.current.element.length && this.current.element[p] > this.monomial.element[p]) {
            this.increment();
        }
    }

    @Override
    void increment() {
        int n;
        int s = 0;
        for (n = 0; n < this.current.element.length && this.current.element[n] == 0; ++n) {
        }
        if (n < this.current.element.length) {
            s = this.current.element[n];
            this.current.element[n] = 0;
            ++n;
        }
        while (n < this.current.element.length && this.current.element[n] == this.monomial.element[n]) {
            s += this.current.element[n];
            this.current.element[n] = 0;
            ++n;
        }
        if (n < this.current.element.length) {
            int n2 = n;
            this.current.element[n2] = this.current.element[n2] + 1;
            this.fill(s - 1);
        } else {
            ++this.current.degree;
            this.fill(s + 1);
        }
    }

    private void fill(int s) {
        int i = 0;
        while (i < this.current.element.length) {
            int d = Math.min(this.monomial.element[i] - this.current.element[i], s);
            int n = i++;
            this.current.element[n] = this.current.element[n] + d;
            s -= d;
        }
    }
}

