/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.ArrayList;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Variable;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.groebner.Standard;
import jscl.util.ArrayUtils;

public class Basis {
    public static final int DATA_STRUCT = 3;
    public static final int ARRAY_DECLINED = 0;
    public static final int ARRAY = 1;
    public static final int TREE = 2;
    public static final int LIST = 3;
    public static final int DEGREE = 4;
    public static final int DEFINING_EQS = 8;
    public static final int POWER_SIZE = 48;
    public static final int POWER_32 = 0;
    public static final int POWER_8 = 16;
    public static final int POWER_2 = 32;
    public static final int POWER_2_DEFINED = 48;
    public static final int GEO_BUCKETS = 64;
    public static final int ALGORITHM = 384;
    public static final int BUCHBERGER = 0;
    public static final int F4 = 128;
    public static final int BLOCK = 256;
    public static final int INSTRUMENTED = 512;
    public static final int GM_SETTING = 1024;
    public static final int SUGAR = 2048;
    public static final int FUSSY = 4096;
    public static final int F4_SIMPLIFY = 8192;
    static final int DEFAULT = 3072;
    final Polynomial factory;
    final Generic[] element;

    public Basis(Generic[] element, Polynomial factory) {
        this.element = element;
        this.factory = factory;
    }

    public static Basis compute(Generic[] generic, Variable[] unknown) {
        return Basis.compute(generic, unknown, Monomial.lexicographic);
    }

    public static Basis compute(Generic[] generic, Variable[] unknown, Ordering ordering) {
        return Basis.compute(generic, unknown, ordering, 0);
    }

    public static Basis compute(Generic[] generic, Variable[] unknown, Ordering ordering, int modulo) {
        return Basis.compute(generic, unknown, ordering, modulo, 0);
    }

    public static Basis compute(Generic[] generic, Variable[] unknown, Ordering ordering, int modulo, int flags) {
        return Basis.compute(generic, unknown, ordering, modulo, flags, ((flags ^= 0xC00) & 4) > 0, (flags & 8) > 0);
    }

    static Basis compute(Generic[] generic, Variable[] unknown, Ordering ordering, int modulo, int flags, boolean degree, boolean defining) {
        if (degree) {
            return Basis.compute(Basis.compute(generic, unknown, Monomial.degreeReverseLexicographic, modulo, flags, false, defining).elements(), unknown, ordering, modulo, flags, false, defining);
        }
        return Standard.compute(new Basis(defining ? Basis.augment(Basis.defining(unknown, modulo), generic) : generic, Polynomial.factory(unknown, ordering, modulo, flags)), flags);
    }

    public Basis valueof(Generic[] generic) {
        return new Basis(generic, this.factory);
    }

    public Basis modulo(int modulo) {
        return new Basis(this.element, Polynomial.factory(this.factory, modulo));
    }

    public static Generic[] defining(Variable[] unknown, int modulo) {
        Generic[] a = new Generic[unknown.length];
        for (int i = 0; i < unknown.length; ++i) {
            Expression s = unknown[i].expressionValue();
            a[i] = ((Generic)s).subtract(s.pow(modulo));
        }
        return a;
    }

    public static boolean compatible(Generic[] generic) {
        return generic.length <= 0 || generic[0].compareTo(JSCLInteger.valueOf(1L)) != 0;
    }

    public static Generic[] augment(Generic[] element, Generic[] generic) {
        return (Generic[])ArrayUtils.concat(element, generic, new Generic[element.length + generic.length]);
    }

    public static Variable[] augmentUnknown(Variable[] unknown, Generic[] generic) {
        Variable[] va = Expression.variables(generic);
        ArrayList<Variable> l = new ArrayList<Variable>();
        for (int i = 0; i < unknown.length; ++i) {
            l.add(unknown[i]);
        }
        int n = 0;
        for (int i = 0; i < va.length; ++i) {
            Variable v = va[i];
            if (l.contains(v)) continue;
            l.add(n++, v);
        }
        return (Variable[])ArrayUtils.toArray(l, new Variable[l.size()]);
    }

    public Generic[] elements() {
        return this.element;
    }

    public Ordering ordering() {
        return this.factory.ordering();
    }

    public Polynomial polynomial(Generic generic) {
        return this.factory.valueof(generic).normalize().freeze();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (int i = 0; i < this.element.length; ++i) {
            buffer.append(this.polynomial(this.element[i])).append(i < this.element.length - 1 ? ", " : "");
        }
        buffer.append("}");
        buffer.append(", " + ArrayUtils.toString(this.factory.monomialFactory.unknown()));
        return buffer.toString();
    }
}

