/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.Variable;
import jscl.math.operator.Operator;
import jscl.mathml.MathML;

public class Derivative
extends Operator {
    public Derivative(Generic expression, Generic variable, Generic value, Generic order) {
        super("d", new Generic[]{expression, variable, value, order});
    }

    @Override
    public Generic compute() {
        Variable variable = this.parameter[1].variableValue();
        try {
            int n = this.parameter[3].integerValue().intValue();
            Generic a = this.parameter[0];
            for (int i = 0; i < n; ++i) {
                a = a.derivative(variable);
            }
            return a.substitute(variable, this.parameter[2]);
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int n = 4;
        if (this.parameter[3].compareTo(JSCLInteger.valueOf(1L)) == 0) {
            n = 3;
            if (this.parameter[2].compareTo(this.parameter[1]) == 0) {
                n = 2;
            }
        }
        buffer.append(this.name);
        buffer.append("(");
        for (int i = 0; i < n; ++i) {
            buffer.append(this.parameter[i]).append(i < n - 1 ? ", " : "");
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toMathML(MathML element, Object data) {
        MathML e1;
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.derivationToMathML(element, false);
        } else {
            e1 = element.element("msup");
            this.derivationToMathML(e1, true);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
        e1 = element.element("mfenced");
        this.parameter[0].toMathML(e1, null);
        if (this.parameter[2].compareTo(this.parameter[1]) != 0) {
            this.parameter[2].toMathML(e1, null);
        }
        element.appendChild(e1);
    }

    void derivationToMathML(MathML element, boolean fenced) {
        if (fenced) {
            MathML e1 = element.element("mfenced");
            this.derivationToMathML(e1);
            element.appendChild(e1);
        } else {
            this.derivationToMathML(element);
        }
    }

    void derivationToMathML(MathML element) {
        Variable v = this.parameter[1].variableValue();
        int n = 0;
        try {
            n = this.parameter[3].integerValue().intValue();
        }
        catch (NotIntegerException notIntegerException) {
            // empty catch block
        }
        if (n == 1) {
            MathML e1 = element.element("mfrac");
            MathML e2 = element.element("mo");
            e2.appendChild(element.text("d"));
            e1.appendChild(e2);
            e2 = element.element("mrow");
            MathML e3 = element.element("mo");
            e3.appendChild(element.text("d"));
            e2.appendChild(e3);
            v.toMathML(e2, null);
            e1.appendChild(e2);
            element.appendChild(e1);
        } else {
            MathML e1 = element.element("mfrac");
            MathML e2 = element.element("msup");
            MathML e3 = element.element("mo");
            e3.appendChild(element.text("d"));
            e2.appendChild(e3);
            this.parameter[3].toMathML(e2, null);
            e1.appendChild(e2);
            e2 = element.element("mrow");
            e3 = element.element("mo");
            e3.appendChild(element.text("d"));
            e2.appendChild(e3);
            e3 = element.element("msup");
            this.parameter[1].toMathML(e3, null);
            this.parameter[3].toMathML(e3, null);
            e2.appendChild(e3);
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    @Override
    protected Variable newinstance() {
        return new Derivative(null, null, null, null);
    }
}

