/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Frac;
import jscl.math.function.Function;
import jscl.math.function.Inv;
import jscl.math.function.Sqrt;

public class Log
extends Function {
    public Log(Generic generic) {
        super("log", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        throw new NotIntegrableException();
    }

    @Override
    public Generic derivative(int n) {
        return new Inv(this.parameter[0]).evaluate();
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return JSCLInteger.valueOf(0L);
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return this.evaluate();
    }

    @Override
    public Generic evalsimp() {
        try {
            JSCLInteger en = this.parameter[0].integerValue();
            if (en.signum() < 0) {
                return Constant.i.multiply(Constant.pi).add(new Log(en.negate()).evalsimp());
            }
            Generic a = en.factorize();
            Generic[] p = a.productValue();
            Generic s = JSCLInteger.valueOf(0L);
            for (int i = 0; i < p.length; ++i) {
                Power o = p[i].powerValue();
                s = ((Generic)s).add(JSCLInteger.valueOf(o.exponent()).multiply(new Log(o.value(true)).expressionValue()));
            }
            return s;
        }
        catch (NotIntegerException en) {
            try {
                Variable v = this.parameter[0].variableValue();
                if (v instanceof Sqrt) {
                    Generic[] g = ((Sqrt)v).parameters();
                    return Constant.half.multiply(new Log(g[0]).evalsimp());
                }
            }
            catch (NotVariableException v) {
                // empty catch block
            }
            Generic[] n = Frac.separateCoefficient(this.parameter[0]);
            if (n[0].compareTo(JSCLInteger.valueOf(1L)) != 0 || n[1].compareTo(JSCLInteger.valueOf(1L)) != 0) {
                return new Log(n[2]).evalsimp().add(new Log(n[0]).evalsimp()).subtract(new Log(n[1]).evalsimp());
            }
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).log();
    }

    @Override
    protected Variable newinstance() {
        return new Log(null);
    }
}

