/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.NotIntegrableException;
import jscl.math.function.Function;
import jscl.math.function.NotRootException;
import jscl.math.function.Root;
import jscl.mathml.MathML;

public abstract class Algebraic
extends Function {
    public Algebraic(String name, Generic[] parameter) {
        super(name, parameter);
    }

    public abstract Root rootValue() throws NotRootException;

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return null;
    }

    @Override
    public void toMathML(MathML element, Object data) {
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.bodyToMathML(element, false);
        } else {
            MathML e1 = element.element("msup");
            this.bodyToMathML(e1, true);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    abstract void bodyToMathML(MathML var1, boolean var2);
}

