/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Constraint;
import jscl.math.Debug;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.TechnicalVariable;
import jscl.math.Variable;
import jscl.math.function.Cubic;
import jscl.math.function.Frac;
import jscl.math.function.NotRootException;
import jscl.math.function.Pow;
import jscl.math.function.Root;
import jscl.math.function.Sqrt;
import jscl.math.polynomial.Basis;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.UnivariatePolynomial;

public class Simplification {
    Map cache = new TreeMap();
    Generic result;
    List constraint;
    boolean linear;

    Simplification() {
    }

    public static Generic compute(Generic generic) {
        Simplification s = new Simplification();
        s.computeValue(generic);
        return s.getValue();
    }

    void computeValue(Generic generic) {
        Debug.println("simplification");
        Debug.increment();
        TechnicalVariable t = new TechnicalVariable("t");
        this.linear = false;
        this.constraint = new ArrayList();
        this.process(new Constraint(t, t.expressionValue().subtract(generic), false));
        UnivariatePolynomial p = this.polynomial(t);
        switch (p.degree()) {
            case 0: {
                this.result = generic;
                break;
            }
            case 1: {
                this.result = new Root(p, 0).evalsimp();
                break;
            }
            default: {
                this.linear(generic);
            }
        }
        Debug.decrement();
    }

    void linear(Generic generic) {
        TechnicalVariable t = new TechnicalVariable("t");
        this.linear = true;
        this.constraint.clear();
        this.process(new Constraint(t, t.expressionValue().subtract(generic), false));
        UnivariatePolynomial p = this.polynomial(t);
        switch (p.degree()) {
            case 0: {
                this.result = generic;
                break;
            }
            default: {
                this.result = new Root(p, 0).evalsimp();
            }
        }
    }

    int branch(Generic generic, UnivariatePolynomial polynomial) {
        int n = polynomial.degree();
        TechnicalVariable t = new TechnicalVariable("t");
        this.linear = true;
        for (int i = 0; i < n; ++i) {
            this.constraint.clear();
            this.process(new Constraint(t, t.expressionValue().subtract(generic.subtract(new Root(polynomial, i).expressionValue())), false));
            Generic a = this.polynomial(t).solve();
            if (a == null || a.signum() != 0) continue;
            return i;
        }
        return n;
    }

    UnivariatePolynomial polynomial(Variable t) {
        Polynomial fact = Polynomial.factory(t);
        int n = this.constraint.size();
        Generic[] a = new Generic[n];
        Variable[] unk = new Variable[n];
        if (this.linear) {
            int i;
            int j = 0;
            for (int i2 = 0; i2 < n; ++i2) {
                Constraint c = (Constraint)this.constraint.get(i2);
                if (!c.reduce) continue;
                a[j] = c.generic;
                unk[j] = c.unknown;
                ++j;
            }
            int k = 0;
            for (i = 0; i < n; ++i) {
                Constraint c = (Constraint)this.constraint.get(i);
                if (c.reduce) continue;
                a[j] = c.generic;
                unk[j] = c.unknown;
                ++j;
                ++k;
            }
            a = this.solve(a, unk, k);
            for (i = 0; i < a.length; ++i) {
                UnivariatePolynomial p = (UnivariatePolynomial)fact.valueof(a[i]);
                if (p.degree() != 1) continue;
                return p;
            }
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Constraint c = (Constraint)this.constraint.get(i);
            a[i] = c.generic;
            unk[i] = c.unknown;
        }
        a = this.solve(a, unk, n);
        return (UnivariatePolynomial)fact.valueof(a[0]);
    }

    Generic[] solve(Generic[] generic, Variable[] unknown, int n) {
        Variable[] unk = Basis.augmentUnknown(unknown, generic);
        return Basis.compute(generic, unk, Monomial.kthElimination(n)).elements();
    }

    void process(Constraint co) {
        int n1 = 0;
        int n2 = 0;
        this.constraint.add(co);
        do {
            n1 = n2;
            n2 = this.constraint.size();
            for (int i = n1; i < n2; ++i) {
                co = (Constraint)this.constraint.get(i);
                this.subProcess(co);
            }
        } while (n1 < n2);
    }

    void subProcess(Constraint co) {
        Variable[] va = co.generic.variables();
        for (int i = 0; i < va.length; ++i) {
            int d;
            Root r;
            Generic[] g;
            Variable v = va[i];
            if (this.constraint.contains(new Constraint(v))) continue;
            co = null;
            if (v instanceof Frac) {
                g = ((Frac)v).parameters();
                co = new Constraint(v, v.expressionValue().multiply(g[1]).subtract(g[0]), false);
            } else if (v instanceof Sqrt) {
                g = ((Sqrt)v).parameters();
                if (this.linear) {
                    co = this.linearConstraint(v);
                }
                if (co == null) {
                    co = new Constraint(v, v.expressionValue().pow(2).subtract(g[0]), true);
                }
            } else if (v instanceof Cubic) {
                g = ((Cubic)v).parameters();
                if (this.linear) {
                    co = this.linearConstraint(v);
                }
                if (co == null) {
                    co = new Constraint(v, v.expressionValue().pow(3).subtract(g[0]), true);
                }
            } else if (v instanceof Pow) {
                try {
                    r = ((Pow)v).rootValue();
                    d = r.degree();
                    Generic[] g2 = r.parameters();
                    if (this.linear) {
                        co = this.linearConstraint(v);
                    }
                    if (co == null) {
                        co = new Constraint(v, v.expressionValue().pow(d).subtract(g2[0].negate()), d > 1);
                    }
                }
                catch (NotRootException e) {
                    co = this.linearConstraint(v);
                }
            } else if (v instanceof Root) {
                try {
                    r = (Root)v;
                    d = r.degree();
                    int n = r.subscript().integerValue().intValue();
                    Generic[] g3 = r.parameters();
                    if (this.linear) {
                        co = this.linearConstraint(v);
                    }
                    if (co == null) {
                        co = new Constraint(v, Root.sigma(g3, d - n).multiply(JSCLInteger.valueOf(-1L).pow(d - n)).multiply(g3[d]).subtract(g3[n]), d > 1);
                    }
                }
                catch (NotIntegerException e) {
                    co = this.linearConstraint(v);
                }
            } else {
                co = this.linearConstraint(v);
            }
            if (co == null) continue;
            this.constraint.add(co);
        }
    }

    Constraint linearConstraint(Variable v) {
        Generic s;
        Object o = this.cache.get(v);
        if (o != null) {
            s = (Generic)o;
        } else {
            s = v.simplify();
            this.cache.put(v, s);
        }
        Generic a = v.expressionValue().subtract(s);
        if (a.signum() != 0) {
            return new Constraint(v, a, false);
        }
        return null;
    }

    Generic getValue() {
        return this.result;
    }
}

