/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.math.BigInteger;
import jscl.math.Expression;
import jscl.math.Field;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.mathml.MathML;

public class ModularInteger
extends Generic
implements Field {
    public static final ModularInteger booleanFactory = new ModularInteger(0L, 2);
    final int modulo;
    final int content;

    public ModularInteger(long content, int modulo) {
        this.modulo = modulo;
        this.content = (int)(content % (long)modulo);
    }

    public int content() {
        return this.content;
    }

    public int modulo() {
        return this.modulo;
    }

    public ModularInteger add(ModularInteger integer) {
        return this.newinstance((long)this.content + (long)integer.content);
    }

    @Override
    public Generic add(Generic generic) {
        return this.add((ModularInteger)generic);
    }

    public ModularInteger subtract(ModularInteger integer) {
        return this.newinstance((long)this.content + (long)(this.modulo - integer.content));
    }

    @Override
    public Generic subtract(Generic generic) {
        return this.subtract((ModularInteger)generic);
    }

    public ModularInteger multiply(ModularInteger integer) {
        return this.newinstance((long)this.content * (long)integer.content);
    }

    @Override
    public Generic multiply(Generic generic) {
        return this.multiply((ModularInteger)generic);
    }

    @Override
    public Generic divide(Generic generic) throws ArithmeticException {
        return this.multiply(generic.inverse());
    }

    @Override
    public Generic inverse() {
        return this.newinstance(BigInteger.valueOf(this.content).modInverse(BigInteger.valueOf(this.modulo)).intValue());
    }

    @Override
    public Generic gcd(Generic generic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic gcd() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic pow(int exponent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic negate() {
        return this.newinstance(this.modulo - this.content);
    }

    @Override
    public int signum() {
        return this.content > 0 ? 1 : 0;
    }

    @Override
    public int degree() {
        return 0;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic derivative(Variable variable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic expand() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic factorize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic elementary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic simplify() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic numeric() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic valueof(Generic generic) {
        if (generic instanceof ModularInteger) {
            return this.newinstance(((ModularInteger)generic).content);
        }
        return this.newinstance(((JSCLInteger)generic).content().mod(BigInteger.valueOf(this.modulo)).intValue());
    }

    @Override
    public Generic[] sumValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic[] productValue() throws NotProductException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Power powerValue() throws NotPowerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression expressionValue() throws NotExpressionException {
        return Expression.valueOf(this.integerValue());
    }

    @Override
    public JSCLInteger integerValue() throws NotIntegerException {
        return JSCLInteger.valueOf(this.content);
    }

    @Override
    public Variable variableValue() throws NotVariableException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Variable[] variables() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPolynomial(Variable variable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConstant(Variable variable) {
        throw new UnsupportedOperationException();
    }

    public int compareTo(ModularInteger integer) {
        return this.content < integer.content ? -1 : (this.content > integer.content ? 1 : 0);
    }

    @Override
    public int compareTo(Generic generic) {
        if (generic instanceof ModularInteger) {
            return this.compareTo((ModularInteger)generic);
        }
        if (generic instanceof JSCLInteger) {
            return this.compareTo(this.valueof(generic));
        }
        throw new UnsupportedOperationException();
    }

    public static ModularInteger factory(int modulo) {
        return new ModularInteger(0L, modulo);
    }

    public String toString() {
        return "" + this.content;
    }

    @Override
    public String toJava() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toMathML(MathML element, Object data) {
        throw new UnsupportedOperationException();
    }

    protected ModularInteger newinstance(long content) {
        return new ModularInteger(content, this.modulo);
    }
}

