/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotDivisibleException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Pow;
import jscl.math.polynomial.Monomial;
import jscl.mathml.MathML;

public class Literal
implements Comparable {
    Variable[] variable;
    int[] power;
    int degree;
    int size;

    Literal() {
    }

    Literal(int size) {
        this.init(size);
    }

    public int size() {
        return this.size;
    }

    public Variable variable(int n) {
        return this.variable[n];
    }

    public int power(int n) {
        return this.power[n];
    }

    void init(int size) {
        this.variable = new Variable[size];
        this.power = new int[size];
        this.size = size;
    }

    void resize(int size) {
        if (size < this.variable.length) {
            Variable[] variable = new Variable[size];
            int[] power = new int[size];
            System.arraycopy(this.variable, 0, variable, 0, size);
            System.arraycopy(this.power, 0, power, 0, size);
            this.variable = variable;
            this.power = power;
            this.size = size;
        }
    }

    public Literal multiply(Literal literal) {
        Variable v2;
        Literal l = this.newinstance(this.size + literal.size);
        int i = 0;
        int i1 = 0;
        int i2 = 0;
        Variable v1 = i1 < this.size ? this.variable[i1] : null;
        Variable variable = v2 = i2 < literal.size ? literal.variable[i2] : null;
        while (v1 != null || v2 != null) {
            int s;
            int c;
            int n = v1 == null ? 1 : (c = v2 == null ? -1 : v1.compareTo(v2));
            if (c < 0) {
                s = this.power[i1];
                l.variable[i] = v1;
                l.power[i] = s;
                l.degree += s;
                ++i;
                v1 = ++i1 < this.size ? this.variable[i1] : null;
                continue;
            }
            if (c > 0) {
                s = literal.power[i2];
                l.variable[i] = v2;
                l.power[i] = s;
                l.degree += s;
                ++i;
                v2 = ++i2 < literal.size ? literal.variable[i2] : null;
                continue;
            }
            s = this.power[i1] + literal.power[i2];
            l.variable[i] = v1;
            l.power[i] = s;
            l.degree += s;
            ++i;
            v1 = ++i1 < this.size ? this.variable[i1] : null;
            v2 = i2 < literal.size ? literal.variable[++i2] : null;
        }
        l.resize(i);
        return l;
    }

    public Literal divide(Literal literal) throws ArithmeticException {
        Variable v2;
        Literal l = this.newinstance(this.size + literal.size);
        int i = 0;
        int i1 = 0;
        int i2 = 0;
        Variable v1 = i1 < this.size ? this.variable[i1] : null;
        Variable variable = v2 = i2 < literal.size ? literal.variable[i2] : null;
        while (v1 != null || v2 != null) {
            int s;
            int c;
            int n = v1 == null ? 1 : (c = v2 == null ? -1 : v1.compareTo(v2));
            if (c < 0) {
                s = this.power[i1];
                l.variable[i] = v1;
                l.power[i] = s;
                l.degree += s;
                ++i;
                v1 = ++i1 < this.size ? this.variable[i1] : null;
                continue;
            }
            if (c > 0) {
                throw new NotDivisibleException();
            }
            s = this.power[i1] - literal.power[i2];
            if (s < 0) {
                throw new NotDivisibleException();
            }
            if (s != 0) {
                l.variable[i] = v1;
                l.power[i] = s;
                l.degree += s;
                ++i;
            }
            v1 = ++i1 < this.size ? this.variable[i1] : null;
            v2 = i2 < literal.size ? literal.variable[++i2] : null;
        }
        l.resize(i);
        return l;
    }

    public Literal gcd(Literal literal) {
        Variable v2;
        Literal l = this.newinstance(Math.min(this.size, literal.size));
        int i = 0;
        int i1 = 0;
        int i2 = 0;
        Variable v1 = i1 < this.size ? this.variable[i1] : null;
        Variable variable = v2 = i2 < literal.size ? literal.variable[i2] : null;
        while (v1 != null || v2 != null) {
            int c;
            int n = v1 == null ? 1 : (c = v2 == null ? -1 : v1.compareTo(v2));
            if (c < 0) {
                v1 = ++i1 < this.size ? this.variable[i1] : null;
                continue;
            }
            if (c > 0) {
                v2 = ++i2 < literal.size ? literal.variable[i2] : null;
                continue;
            }
            int s = Math.min(this.power[i1], literal.power[i2]);
            l.variable[i] = v1;
            l.power[i] = s;
            l.degree += s;
            ++i;
            v1 = ++i1 < this.size ? this.variable[i1] : null;
            v2 = i2 < literal.size ? literal.variable[++i2] : null;
        }
        l.resize(i);
        return l;
    }

    public Literal scm(Literal literal) {
        Variable v2;
        Literal l = this.newinstance(this.size + literal.size);
        int i = 0;
        int i1 = 0;
        int i2 = 0;
        Variable v1 = i1 < this.size ? this.variable[i1] : null;
        Variable variable = v2 = i2 < literal.size ? literal.variable[i2] : null;
        while (v1 != null || v2 != null) {
            int s;
            int c;
            int n = v1 == null ? 1 : (c = v2 == null ? -1 : v1.compareTo(v2));
            if (c < 0) {
                s = this.power[i1];
                l.variable[i] = v1;
                l.power[i] = s;
                l.degree += s;
                ++i;
                v1 = ++i1 < this.size ? this.variable[i1] : null;
                continue;
            }
            if (c > 0) {
                s = literal.power[i2];
                l.variable[i] = v2;
                l.power[i] = s;
                l.degree += s;
                ++i;
                v2 = ++i2 < literal.size ? literal.variable[i2] : null;
                continue;
            }
            s = Math.max(this.power[i1], literal.power[i2]);
            l.variable[i] = v1;
            l.power[i] = s;
            l.degree += s;
            ++i;
            v1 = ++i1 < this.size ? this.variable[i1] : null;
            v2 = i2 < literal.size ? literal.variable[++i2] : null;
        }
        l.resize(i);
        return l;
    }

    public Generic[] productValue() throws NotProductException {
        Generic[] a = new Generic[this.size];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.variable[i].expressionValue().pow(this.power[i]);
        }
        return a;
    }

    public Power powerValue() throws NotPowerException {
        if (this.size == 0) {
            return new Power(JSCLInteger.valueOf(1L), 1);
        }
        if (this.size == 1) {
            Variable v = this.variable[0];
            int c = this.power[0];
            return new Power(v.expressionValue(), c);
        }
        throw new NotPowerException();
    }

    public Variable variableValue() throws NotVariableException {
        if (this.size == 0) {
            throw new NotVariableException();
        }
        if (this.size == 1) {
            Variable v = this.variable[0];
            int c = this.power[0];
            if (c == 1) {
                return v;
            }
            throw new NotVariableException();
        }
        throw new NotVariableException();
    }

    public Variable[] variables() {
        Variable[] va = new Variable[this.size];
        System.arraycopy(this.variable, 0, va, 0, this.size);
        return va;
    }

    public int degree() {
        return this.degree;
    }

    public int compareTo(Literal literal) {
        Variable v2;
        int i1 = this.size;
        int i2 = literal.size;
        Variable v1 = i1 == 0 ? null : this.variable[--i1];
        Variable variable = v2 = i2 == 0 ? null : literal.variable[--i2];
        while (v1 != null || v2 != null) {
            int c;
            int n = v1 == null ? -1 : (c = v2 == null ? 1 : v1.compareTo(v2));
            if (c < 0) {
                return -1;
            }
            if (c > 0) {
                return 1;
            }
            int c1 = this.power[i1];
            int c2 = literal.power[i2];
            if (c1 < c2) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            v1 = i1 == 0 ? null : this.variable[--i1];
            v2 = i2 == 0 ? null : literal.variable[--i2];
        }
        return 0;
    }

    public int compareTo(Object o) {
        return this.compareTo((Literal)o);
    }

    public static Literal valueOf() {
        return new Literal(0);
    }

    public static Literal valueOf(Variable variable) {
        return Literal.valueOf(variable, 1);
    }

    public static Literal valueOf(Variable variable, int power) {
        Literal l = new Literal();
        l.init(variable, power);
        return l;
    }

    void init(Variable var, int pow) {
        if (pow != 0) {
            this.init(1);
            this.variable[0] = var;
            this.power[0] = pow;
            this.degree = pow;
        } else {
            this.init(0);
        }
    }

    public static Literal valueOf(Monomial monomial) {
        Literal l = new Literal();
        l.init(monomial);
        return l;
    }

    void init(Monomial monomial) {
        TreeMap<Variable, Integer> map = new TreeMap<Variable, Integer>();
        Variable[] unk = monomial.unknown();
        for (int i = 0; i < unk.length; ++i) {
            int c = monomial.element(i);
            if (c <= 0) continue;
            map.put(unk[i], new Integer(c));
        }
        this.init(map.size());
        Iterator it = map.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Variable v = (Variable)e.getKey();
            int c = (Integer)e.getValue();
            this.variable[i] = v;
            this.power[i] = c;
            this.degree += c;
            ++i;
        }
    }

    Map content() {
        TreeMap<Variable, Integer> map = new TreeMap<Variable, Integer>();
        for (int i = 0; i < this.size; ++i) {
            map.put(this.variable[i], new Integer(this.power[i]));
        }
        return map;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.degree == 0) {
            buffer.append("1");
        }
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                buffer.append("*");
            }
            Variable v = this.variable[i];
            int c = this.power[i];
            if (c == 1) {
                buffer.append(v);
                continue;
            }
            if (v instanceof Frac || v instanceof Pow) {
                buffer.append("(").append(v).append(")");
            } else {
                buffer.append(v);
            }
            buffer.append("^").append(c);
        }
        return buffer.toString();
    }

    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        if (this.degree == 0) {
            buffer.append("JSCLDouble.valueOf(1)");
        }
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                buffer.append(".multiply(");
            }
            Variable v = this.variable[i];
            int c = this.power[i];
            buffer.append(v.toJava());
            if (c != 1) {
                buffer.append(".pow(").append(c).append(")");
            }
            if (i <= 0) continue;
            buffer.append(")");
        }
        return buffer.toString();
    }

    public void toMathML(MathML element, Object data) {
        if (this.degree == 0) {
            MathML e1 = element.element("mn");
            e1.appendChild(element.text("1"));
            element.appendChild(e1);
        }
        for (int i = 0; i < this.size; ++i) {
            Variable v = this.variable[i];
            int c = this.power[i];
            v.toMathML(element, new Integer(c));
        }
    }

    protected Literal newinstance(int n) {
        return new Literal(n);
    }
}

