/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.collections;

import info.monitorenter.util.collections.IComparableProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class TreeSetGreedy<T extends IComparableProperty>
extends TreeSet<T>
implements Set<T> {
    private static final long serialVersionUID = 3258130237048173623L;

    private static Number createDecreasedNumber(Number n) {
        Number result;
        Class<?> c = n.getClass();
        if (c == Integer.class) {
            result = new Integer(n.intValue() - 1);
        } else if (c == Double.class) {
            result = new Double(n.doubleValue() - 1.0);
        } else if (c == Float.class) {
            result = new Float(n.floatValue() - 1.0f);
        } else if (c == Short.class) {
            result = new Short((short)(n.shortValue() - 1));
        } else if (c == Byte.class) {
            result = new Byte((byte)(n.byteValue() - 1));
        } else if (c == Long.class) {
            result = new Long(n.longValue() - 1L);
        } else if (c == BigDecimal.class) {
            BigDecimal bd = new BigDecimal(n.toString());
            bd = bd.subtract(new BigDecimal(1));
            result = bd;
        } else {
            BigInteger bi = new BigInteger(n.toString());
            bi = bi.subtract(new BigInteger("1"));
            result = bi;
        }
        return result;
    }

    public TreeSetGreedy() {
        super(new NumberPropertyComparator());
    }

    @Override
    public synchronized boolean add(T o) {
        boolean ret = this.addInternal(o);
        return ret;
    }

    private boolean addInternal(T o) {
        boolean alreadyThrere;
        if (!this.isEmpty() && (alreadyThrere = this.contains(o))) {
            IComparableProperty first = (IComparableProperty)this.first();
            o.setComparableProperty(TreeSetGreedy.createDecreasedNumber(first.getComparableProperty()));
        }
        boolean ret = super.add(o);
        return ret;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        return result;
    }

    private static final class NumberPropertyComparator<T extends IComparableProperty>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 2279828650090806643L;

        @Override
        public int compare(T o1, T o2) throws ClassCastException {
            double i2;
            double i1;
            int result = o1 == o2 ? 0 : ((i1 = o1.getComparableProperty().doubleValue()) < (i2 = o2.getComparableProperty().doubleValue()) ? -1 : (i1 == i2 ? 0 : 1));
            return result;
        }
    }
}

