/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.util;

import info.monitorenter.gui.util.HSBColor;
import info.monitorenter.gui.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ColorIterator
implements Iterator<Color> {
    private boolean m_ascendingDirection = true;
    private boolean m_hasnext = true;
    private boolean m_firstTime = true;
    protected HSBColor m_iterate;
    private final ISteppingModel m_resetModel;
    protected HSBColor m_startColor;
    private ISteppingModel m_stepModel;

    public static void main(String[] args) {
        JFrame frame = new JFrame(Messages.getString("ColorIterator.0"));
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 3258408422146715703L;
            private final ColorIterator m_color = new ColorIterator();
            {
                int wdt = 0;
                while (this.m_color.hasNext()) {
                    ++wdt;
                    this.m_color.next();
                }
                System.out.println(Messages.getString("ColorIterator.1") + wdt + Messages.getString("ColorIterator.2"));
                System.out.println(Messages.getString("ColorIterator.3") + wdt);
                this.setSize(wdt, 100);
                this.setPreferredSize(new Dimension(wdt, 100));
                this.setMinimumSize(new Dimension(wdt, 100));
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                this.m_color.reset();
                int width = this.getWidth();
                int height = this.getHeight();
                for (int pxdrawn = 0; this.m_color.hasNext() && pxdrawn != width; ++pxdrawn) {
                    g.setColor(this.m_color.next());
                    g.drawLine(pxdrawn, 0, pxdrawn, height);
                }
            }
        };
        JScrollPane scroll = new JScrollPane(panel);
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)scroll, "Center");
        frame.setLocation(200, 200);
        frame.setSize(new Dimension(400, 100));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setResizable(true);
        frame.setVisible(true);
    }

    public ColorIterator() {
        this(Color.RED, new HueStepper(1000));
    }

    public ColorIterator(Color startColor, ISteppingModel stepper) {
        this.setStartColor(startColor);
        this.m_stepModel = stepper;
        this.m_resetModel = (ISteppingModel)this.m_stepModel.clone();
        this.m_firstTime = true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorIterator other = (ColorIterator)obj;
        if (this.m_ascendingDirection != other.m_ascendingDirection) {
            return false;
        }
        if (this.m_firstTime != other.m_firstTime) {
            return false;
        }
        if (this.m_hasnext != other.m_hasnext) {
            return false;
        }
        if (this.m_iterate == null ? other.m_iterate != null : !this.m_iterate.equals(other.m_iterate)) {
            return false;
        }
        if (this.m_resetModel == null ? other.m_resetModel != null : !this.m_resetModel.equals(other.m_resetModel)) {
            return false;
        }
        if (this.m_startColor == null ? other.m_startColor != null : !this.m_startColor.equals(other.m_startColor)) {
            return false;
        }
        return !(this.m_stepModel == null ? other.m_stepModel != null : !this.m_stepModel.equals(other.m_stepModel));
    }

    public final Color getStartColor() {
        return this.m_startColor.getRGBColor();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_ascendingDirection ? 1231 : 1237);
        result = 31 * result + (this.m_firstTime ? 1231 : 1237);
        result = 31 * result + (this.m_hasnext ? 1231 : 1237);
        result = 31 * result + (this.m_iterate == null ? 0 : this.m_iterate.hashCode());
        result = 31 * result + (this.m_resetModel == null ? 0 : this.m_resetModel.hashCode());
        result = 31 * result + (this.m_startColor == null ? 0 : this.m_startColor.hashCode());
        result = 31 * result + (this.m_stepModel == null ? 0 : this.m_stepModel.hashCode());
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.m_hasnext;
    }

    public final boolean isAscendingDirection() {
        return this.m_ascendingDirection;
    }

    @Override
    public Color next() throws NoSuchElementException {
        if (!this.m_hasnext) {
            throw new NoSuchElementException(Messages.getString("ColorIterator.4"));
        }
        if (!this.m_firstTime) {
            this.m_stepModel.doStep(this);
            if (this.m_iterate.equals(this.m_startColor)) {
                this.m_hasnext = false;
            }
        } else {
            this.m_firstTime = false;
        }
        return this.m_iterate.getRGBColor();
    }

    @Override
    public void remove() {
    }

    public void reset() {
        this.m_iterate = (HSBColor)this.m_startColor.clone();
        this.m_stepModel = (ISteppingModel)this.m_resetModel.clone();
        this.m_hasnext = true;
        this.m_firstTime = true;
    }

    public final void setAscendingDirection(boolean ascendingDirection) {
        this.m_ascendingDirection = ascendingDirection;
    }

    public final void setStartColor(Color startColor) {
        this.m_startColor = HSBColor.rgbToHSB(startColor);
        this.m_iterate = (HSBColor)this.m_startColor.clone();
    }

    public void setSteps(int steps) {
        this.m_resetModel.setSteps(steps);
        this.m_stepModel.setSteps(steps);
    }

    public static class SaturationStepper
    extends ADefaultStepping {
        public SaturationStepper() {
        }

        public SaturationStepper(int steps) {
            super(steps);
        }

        @Override
        public void doStep(ColorIterator tostep) {
            double increment = tostep.m_iterate.m_sat;
            double bound = tostep.m_startColor.m_sat;
            if (tostep.isAscendingDirection()) {
                increment += this.m_stepping;
                if (tostep.m_iterate.m_sat < bound && increment > bound) {
                    increment = bound;
                } else if (increment > 1.0 && (increment -= 1.0) > bound) {
                    increment = bound;
                }
            } else {
                increment -= this.m_stepping;
                if (tostep.m_iterate.m_sat > bound && increment < bound) {
                    increment = bound;
                } else if (increment < 0.0 && (increment += 1.0) < bound) {
                    increment = bound;
                }
            }
            tostep.m_iterate.m_sat = increment;
        }
    }

    public static class LuminanceStepper
    extends ADefaultStepping {
        public LuminanceStepper() {
        }

        public LuminanceStepper(int steps) {
            super(steps);
        }

        @Override
        public void doStep(ColorIterator tostep) {
            double increment = tostep.m_iterate.m_lum;
            double bound = tostep.m_startColor.m_lum;
            if (tostep.isAscendingDirection()) {
                increment += this.m_stepping;
                if (tostep.m_iterate.m_lum < bound && increment > bound) {
                    increment = bound;
                } else if (increment > 1.0 && (increment -= 1.0) > bound) {
                    increment = bound;
                }
            } else {
                increment -= this.m_stepping;
                if (tostep.m_iterate.m_lum > bound && increment < bound) {
                    increment = bound;
                } else if (increment < 0.0 && (increment += 1.0) < bound) {
                    increment = bound;
                }
            }
            tostep.m_iterate.m_lum = increment;
        }
    }

    public static interface ISteppingModel
    extends Cloneable {
        public Object clone();

        public void doStep(ColorIterator var1);

        public void setSteps(int var1);
    }

    public static class HueStepper
    extends ADefaultStepping {
        public HueStepper() {
        }

        public HueStepper(int steps) {
            super(steps);
        }

        @Override
        public void doStep(ColorIterator tostep) {
            double increment = tostep.m_iterate.m_hue;
            double bound = tostep.m_startColor.m_hue;
            if (tostep.isAscendingDirection()) {
                increment += this.m_stepping;
                if (tostep.m_iterate.m_hue < bound && increment > bound) {
                    increment = bound;
                } else if (increment > 1.0 && (increment -= 1.0) > bound) {
                    increment = bound;
                }
            } else {
                increment -= this.m_stepping;
                if (tostep.m_iterate.m_hue > bound && increment < bound) {
                    increment = bound;
                } else if (increment < 0.0 && (increment += 1.0) < bound) {
                    increment = bound;
                }
            }
            tostep.m_iterate.m_hue = increment;
        }
    }

    public static class HSStepper
    extends APiggyBackStepper {
        @Override
        public void doStep(ColorIterator tostep) {
            this.m_huestep.doStep(tostep);
            if (tostep.m_iterate.m_hue == tostep.m_startColor.m_hue) {
                this.m_satstep.doStep(tostep);
            }
        }
    }

    public static class HSBStepper
    extends APiggyBackStepper {
        @Override
        public void doStep(ColorIterator tostep) {
            this.m_huestep.doStep(tostep);
            if (tostep.m_iterate.m_hue == tostep.m_startColor.m_hue) {
                this.m_satstep.doStep(tostep);
                if (tostep.m_iterate.m_sat == tostep.m_startColor.m_sat) {
                    this.m_lumstep.doStep(tostep);
                }
            }
        }
    }

    public static abstract class APiggyBackStepper
    implements ISteppingModel {
        protected HueStepper m_huestep;
        protected LuminanceStepper m_lumstep;
        protected SaturationStepper m_satstep;

        public APiggyBackStepper() {
            this(100, 100, 100);
        }

        public APiggyBackStepper(int hueSteps, int satSteps, int lumSteps) {
            this.m_huestep = new HueStepper(hueSteps);
            this.m_satstep = new SaturationStepper(satSteps);
            this.m_lumstep = new LuminanceStepper(lumSteps);
        }

        @Override
        public Object clone() {
            try {
                APiggyBackStepper ret = (APiggyBackStepper)super.clone();
                ret.m_huestep = (HueStepper)this.m_huestep.clone();
                ret.m_satstep = (SaturationStepper)this.m_satstep.clone();
                ret.m_lumstep = (LuminanceStepper)this.m_lumstep.clone();
                return ret;
            }
            catch (CloneNotSupportedException cne) {
                cne.printStackTrace(System.err);
                throw new RuntimeException(cne);
            }
        }

        @Override
        public void setSteps(int steps) {
            this.m_huestep.setSteps(steps);
            this.m_lumstep.setSteps(steps);
            this.m_satstep.setSteps(steps);
        }
    }

    public static class AlphaStepper
    extends ADefaultStepping {
        public AlphaStepper() {
        }

        public AlphaStepper(int steps) {
            super(steps);
        }

        @Override
        public void doStep(ColorIterator tostep) {
            double increment = tostep.m_iterate.m_alpha;
            double bound = tostep.m_startColor.m_alpha;
            if (tostep.isAscendingDirection()) {
                increment += this.m_stepping;
                if (tostep.m_iterate.m_alpha < bound && increment > bound) {
                    increment = bound;
                } else if (increment > 255.0 && (increment -= 255.0) > bound) {
                    increment = bound;
                }
            } else {
                increment -= this.m_stepping;
                if (tostep.m_iterate.m_alpha > bound && increment < bound) {
                    increment = bound;
                } else if (increment < 0.0 && (increment += 255.0) < bound) {
                    increment = bound;
                }
            }
            tostep.m_iterate.m_alpha = increment;
        }

        @Override
        public void setSteps(int steps) {
            this.m_stepping = 255.0 / (double)steps;
        }
    }

    public static abstract class ADefaultStepping
    implements ISteppingModel {
        protected double m_stepping;

        public ADefaultStepping() {
            this(100);
        }

        public ADefaultStepping(int steps) {
            this.setSteps(steps);
        }

        @Override
        public Object clone() {
            ADefaultStepping result = null;
            try {
                result = (ADefaultStepping)super.clone();
                result.m_stepping = this.m_stepping;
            }
            catch (Throwable f) {
                f.printStackTrace();
            }
            return result;
        }

        @Override
        public void setSteps(int steps) {
            this.m_stepping = 1.0 / (double)steps;
        }
    }
}

