/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.pointpainters;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.pointpainters.APointPainter;
import java.awt.Graphics;

public class PointPainterVerticalBar
extends APointPainter<PointPainterVerticalBar> {
    private static final long serialVersionUID = 659897369391828199L;
    private final Chart2D m_chart;
    private int m_halfWidth;

    public PointPainterVerticalBar(Chart2D chart) {
        this(4, chart);
    }

    public PointPainterVerticalBar(int barWidth, Chart2D chart) {
        this.setBarWidth(barWidth);
        this.m_chart = chart;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointPainterVerticalBar other = (PointPainterVerticalBar)obj;
        if (this.m_chart == null ? other.m_chart != null : !this.m_chart.equals(other.m_chart)) {
            return false;
        }
        return this.m_halfWidth == other.m_halfWidth;
    }

    public int getBarWidth() {
        return this.m_halfWidth;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_chart == null ? 0 : this.m_chart.hashCode());
        result = 31 * result + this.m_halfWidth;
        return result;
    }

    @Override
    public void paintPoint(int absoluteX, int absoluteY, int nextX, int nextY, Graphics g, ITracePoint2D original) {
        g.fillRect(absoluteX - this.m_halfWidth, absoluteY, 2 * this.m_halfWidth, this.m_chart.getYChartStart() - absoluteY);
    }

    public void setBarWidth(int barWidth) {
        this.m_halfWidth = barWidth / 2;
    }
}

