/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.events.AJComponentAction;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JColorChooser;
import javax.swing.JComponent;

public final class JComponentActionSetCustomForegroundSingleton
extends AJComponentAction {
    private static final long serialVersionUID = 3904680491952451890L;
    private Color m_lastChosenColor;
    private static Map<String, JComponentActionSetCustomForegroundSingleton> instances = new HashMap<String, JComponentActionSetCustomForegroundSingleton>();

    public static JComponentActionSetCustomForegroundSingleton getInstance(JComponent component, String description) {
        JComponentActionSetCustomForegroundSingleton result = instances.get(JComponentActionSetCustomForegroundSingleton.key(component));
        if (result == null) {
            result = new JComponentActionSetCustomForegroundSingleton(component, description);
            instances.put(JComponentActionSetCustomForegroundSingleton.key(component), result);
        }
        return result;
    }

    private static String key(JComponent component) {
        return component.getClass().getName() + component.hashCode();
    }

    private JComponentActionSetCustomForegroundSingleton(JComponent component, String description) {
        super(component, description);
        component.addPropertyChangeListener("foreground", this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color chosen = JColorChooser.showDialog(this.m_component, "choose background color for " + this.m_component.getName(), this.m_component.getBackground());
        if (chosen != null) {
            this.m_lastChosenColor = chosen;
            this.m_component.setForeground(chosen);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (property.equals("foreground")) {
            Color newColor = (Color)evt.getNewValue();
            if (newColor.equals(this.m_lastChosenColor)) {
                this.firePropertyChange("", new Boolean(false), new Boolean(true));
            } else {
                this.firePropertyChange("", new Boolean(true), new Boolean(false));
            }
        }
    }
}

